/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Collection;
import javax.swing.Action;
import org.apache.commons.io.FilenameUtils;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.RunFdsActions;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.io.fds.INIWriter;
import pyrosim.io.fds.SMVReader;
import pyrosim.io.fds.v6.renderers.FDS6Renderer;
import thunderheadeng.geometry.AABox;
import thunderheadeng.gui.guiAction;
import thunderheadeng.io.FilenameManager;

public class ExportSmokeINIFileAction
extends guiAction {
    private static final long serialVersionUID = -4705790355070523899L;

    public ExportSmokeINIFileAction() {
        super(Intl.intl("Smokeview INI..."));
        this.putValue("ShortDescription", Intl.intl("Writes the Smokeview INI file"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        PyroSim app = PyroSim.getApp();
        PyroMod domain = PyroSim.getApp().getMediator();
        File defFile = null;
        boolean ge1Exists = false;
        Action action = app.getFDSRunDropdown().getSelectedAction();
        if (action instanceof RunFdsActions.ARunFDSAction && app.getFilename() != null) {
            File fdsFile = ((RunFdsActions.ARunFDSAction)action).getFdsInputFile(new File(app.getFilename()), domain);
            String chid = FilenameUtils.removeExtension(fdsFile.getName());
            FDSRenderer.Filenames filenames = new FDSRenderer.Filenames(fdsFile.getParentFile(), chid);
            defFile = new File(filenames.dir, filenames.ini);
            ge1Exists = new File(filenames.dir, filenames.ge1).exists();
        }
        if (defFile == null) {
            defFile = app.suggestFile("ini");
        }
        if ((file = PyroSim.getFilenames().getSaveFile((Component)PyroSim.getApp().getMainFrame(), Intl.intl("Choose a Location to Save the INI File"), defFile, "ini", Intl.intl("Smokeview INI Files"))) == null) {
            return;
        }
        File smvFile = new File(FilenameManager.changeExtension(file.getAbsolutePath(), "smv"));
        app.beginWaitCursor();
        try {
            Throwable throwable;
            FDS6Renderer renderer = new FDS6Renderer(domain, app.getFDSRenderProps(), FDSRenderer.RENDER_ORIGIN.DEFAULT);
            Collection<IPyroObject> objs = renderer.collectPyroObjects();
            AABox meshBounds = null;
            try {
                throwable = null;
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(smvFile));){
                    SMVReader smv = new SMVReader();
                    SMVReader.SMVInfo si = smv.read(in);
                    if (!si.meshes.isEmpty()) {
                        meshBounds = new AABox();
                        for (SMVReader.MeshInfo mi : si.meshes) {
                            meshBounds.add(mi.bounds);
                        }
                        System.out.printf("Using mesh bounds in SMV file, %s%n%s%n", smvFile.getAbsolutePath(), meshBounds);
                    }
                }
                catch (Throwable smv) {
                    throwable = smv;
                    throw smv;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                meshBounds = null;
            }
            if (meshBounds == null) {
                meshBounds = new AABox();
                for (Grid g : Hierarchy.flatten(objs, Grid.class)) {
                    meshBounds.add(g.getBounds());
                }
                meshBounds.ensureValidSize(5.0, 5.0);
            }
            throwable = null;
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                INIWriter writer = new INIWriter(meshBounds);
                writer.write(out, ge1Exists, PyroPrefs.getBoolean(PyroPrefs.RESULTS_DISPLAYGE1), !PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEVIEWS), objs);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable exc) {
            PyroGuiUtil.showError(PyroSim.getApp(), Intl.intl("File Error"), Intl.intl("Could not write INI file"), exc);
        }
        finally {
            app.endWaitCursor();
        }
    }
}

