/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import pyrosim.PyroPrefs;
import pyrosim.gui.CloudFDSDlg;

public class CloudFDSUtil {
    private static final CloseableHttpClient HTTP_CLIENT = HttpClients.createDefault();
    private static final Logger LOGGER = Logger.getLogger(CloudFDSUtil.class.getName());
    public static final String API_VERSION = "v1";

    public static FDS_FEA_STATUS getStatusFromCode(long code) {
        for (FDS_FEA_STATUS status : FDS_FEA_STATUS.values()) {
            if ((long)status.code != code) continue;
            return status;
        }
        assert (false);
        return null;
    }

    public static String getFolderName(File outfile) {
        return outfile.getName() + '_' + System.currentTimeMillis();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getUploadLocation(File outfile, String CFDFEAFolder, CloudFDSDlg.CFD_FEA_Params params) throws HttpException, IOException, ParseException {
        HttpPost request = new HttpPost(params.uri + "/api/v1/storage/upload/url");
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Accept", "application/json");
        request.addHeader("api-key", params.apiKey);
        JSONObject data = new JSONObject();
        data.put("dirname", CFDFEAFolder);
        data.put("basename", outfile.getName());
        data.put("contentType", "application/octet-stream");
        JSONObject payload = new JSONObject();
        payload.put("data", data);
        try {
            StringEntity jsonEntity = new StringEntity(payload.toString());
            request.setEntity(jsonEntity);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
            throw e;
        }
        try (CloseableHttpResponse response = HTTP_CLIENT.execute(request);){
            String GCFolder;
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new HttpException(response.getStatusLine().toString());
            }
            JSONParser parser = new JSONParser();
            JSONObject jsonRes = (JSONObject)parser.parse(EntityUtils.toString(response.getEntity()));
            String string = GCFolder = jsonRes.get("url").toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
            throw e;
        }
    }

    public static void uploadFile(String gfcFolder, File outFile) throws HttpException, IOException {
        HttpPut request = new HttpPut(gfcFolder);
        request.addHeader("Content-Type", "application/octet-stream");
        request.setEntity(new FileEntity(outFile));
        try (CloseableHttpResponse uploadFileRes = HTTP_CLIENT.execute(request);){
            if (uploadFileRes.getStatusLine().getStatusCode() != 200) {
                throw new HttpException(uploadFileRes.getStatusLine().toString());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject getDownloadMetadata(long id) throws IOException, HttpException, ParseException {
        String apiKey = PyroPrefs.getString(PyroPrefs.FDSFEA_ApiKey);
        if (apiKey.isEmpty()) {
            throw new HttpException("No valid CFD FEA API key.");
        }
        HttpGet request = new HttpGet(String.format("%s/api/v1/storage/%d/download/url", CLOUD_PROVIDERS.CFD_FEA.URI, id));
        request.addHeader("api-key", apiKey);
        try (CloseableHttpResponse response = HTTP_CLIENT.execute(request);){
            String responseString = EntityUtils.toString(response.getEntity());
            JSONParser jsonParser = new JSONParser();
            JSONObject jSONObject = (JSONObject)jsonParser.parse(responseString);
            return jSONObject;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject getSimulationResults(String folderName) throws IOException, HttpException, ParseException {
        String apiKey = PyroPrefs.getString(PyroPrefs.FDSFEA_ApiKey);
        if (apiKey.isEmpty()) {
            return null;
        }
        HttpPost request = new HttpPost(CLOUD_PROVIDERS.CFD_FEA.URI + "/api/v1/storage/view");
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Accept", "application/json");
        request.addHeader("api-key", apiKey);
        JSONObject data = new JSONObject();
        JSONObject payload = new JSONObject();
        data.put("path", folderName + "\\FDS.tar.gz");
        payload.put("data", data);
        StringEntity jsonEntity = new StringEntity(payload.toJSONString());
        request.setEntity(jsonEntity);
        try (CloseableHttpResponse response = HTTP_CLIENT.execute(request);){
            String responseString = EntityUtils.toString(response.getEntity());
            JSONParser jsonParser = new JSONParser();
            JSONObject jSONObject = (JSONObject)jsonParser.parse(responseString);
            return jSONObject;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JSONObject getSimulationData(CloudFDSDlg.CFD_FEA_Params params, int id) throws IOException, HttpException, ParseException {
        HttpGet request = new HttpGet(params.uri + "/api/v1/simulation/" + id);
        request.addHeader("Accept", "application/json");
        request.addHeader("api-key", params.apiKey);
        try (CloseableHttpResponse response = HTTP_CLIENT.execute(request);){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new HttpException(response.getStatusLine().toString());
            }
            String responseString = EntityUtils.toString(response.getEntity());
            JSONParser jsonParser = new JSONParser();
            JSONObject jSONObject = (JSONObject)jsonParser.parse(responseString);
            return jSONObject;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int startSim(String CFDFEAFolder, CloudFDSDlg.CFD_FEA_Params params) throws IOException, ParseException, HttpException {
        HttpPost request = new HttpPost(params.uri + "/api/v1/simulation");
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Accept", "application/json");
        request.addHeader("api-key", params.apiKey.trim());
        JSONObject data = new JSONObject();
        data.put("cpu", String.valueOf(params.numCores));
        data.put("ram", params.ramOpts.value);
        data.put("folder", CFDFEAFolder);
        data.put("script", params.version.value);
        data.put("source", "pyrosim_" + "2022.2.0803".replace(".", "-"));
        JSONObject payload = new JSONObject();
        payload.put("data", data);
        StringEntity jsonEntity = new StringEntity(payload.toJSONString());
        request.setEntity(jsonEntity);
        try (CloseableHttpResponse response = HTTP_CLIENT.execute(request);){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new HttpException(response.getStatusLine().toString());
            }
            int n = Integer.decode(EntityUtils.toString(response.getEntity()));
            return n;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
            throw e;
        }
    }

    public static void stopSim(CloudFDSDlg.CFD_FEA_Params params, int id, boolean force) {
        HttpPut request = new HttpPut(params.uri + "/api/v1/simulation/" + id + "/stop");
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Accept", "application/json");
        request.addHeader("api-key", params.apiKey);
        JSONObject data = new JSONObject();
        data.put("signal", force ? "SIGINT" : "SIGTSTP");
        JSONObject payload = new JSONObject();
        payload.put("data", data);
        try {
            StringEntity jsonEntity = new StringEntity(payload.toJSONString());
            request.setEntity(jsonEntity);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
        }
        try (CloseableHttpResponse response = HTTP_CLIENT.execute(request);){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new HttpException(response.getStatusLine().toString());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONArray getSimsList(CLOUD_PROVIDERS provider, String apiKey) throws HttpException, ParseException, IOException {
        HttpGet request = new HttpGet(String.format("%s/api/%s/simulation", provider.URI, API_VERSION));
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Accept", "application/json");
        request.addHeader("api-key", apiKey);
        try (CloseableHttpResponse response = HTTP_CLIENT.execute(request);){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new HttpException(response.getStatusLine().toString());
            }
            String responseString = EntityUtils.toString(response.getEntity());
            JSONParser jsonParser = new JSONParser();
            JSONArray jSONArray = (JSONArray)jsonParser.parse(responseString);
            return jSONArray;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
            throw e;
        }
    }

    public static enum FDS_FEA_STATUS {
        COMPLETED(10),
        ERROR(60),
        PENDING(20),
        RUNNING(30),
        STOPPING(40),
        STOPPED(50);

        public final int code;

        private FDS_FEA_STATUS(int code) {
            this.code = code;
        }
    }

    public static enum CLOUD_PROVIDERS {
        CFD_FEA("CFD FEA", "https://cloud.cfdfeaservice.it");

        public final String name;
        public final String URI;

        private CLOUD_PROVIDERS(String serviceName, String URI2) {
            this.name = serviceName;
            this.URI = URI2;
        }

        public String toString() {
            return this.name;
        }
    }
}

