/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.scenario;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.scenario.ActivateAction;
import pyrosim.domain.scenario.Scenario;
import pyrosim.domain.scenario.ScenariosListModel;

public class ScenarioGui {
    private static final Component SIZER = new JLabel("MMMMMMMMMMMMM");

    public static JComboBox<?> createScenariosBox(PyroMod pyMod) {
        ScenariosListModel boxModel = new ScenariosListModel(pyMod);
        JComboBox<Scenario> box = new JComboBox<Scenario>(boxModel);
        box.setRenderer(new ScenariosBoxRenderer());
        box.setPreferredSize(new Dimension(ScenarioGui.SIZER.getPreferredSize().width, box.getPreferredSize().height));
        box.setMaximumSize(new Dimension(ScenarioGui.SIZER.getPreferredSize().width, box.getPreferredSize().height));
        box.setSelectedItem(new ActivateAction(pyMod.getScenarios().getActive()));
        box.setToolTipText(Intl.intl("Change the active Scenario"));
        pyMod.getEvents().addObserver(boxModel);
        return box;
    }

    private static class ScenariosBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private ScenariosBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setText(((Scenario)value).getName());
            String desc = ((Scenario)value).getDescription();
            int maxlen = 30;
            if (desc.length() > maxlen) {
                desc = desc.substring(0, maxlen) + "...";
            }
            list.setToolTipText(desc);
            return this;
        }
    }
}

