/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.scenario;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.output.Boundaries;

public class Scenario
extends NamedPyroObject {
    private static final long serialVersionUID = 1L;
    private static Collection<Class<?>> DO_NOT_TRACK = Arrays.asList(Boundaries.class);
    private Set<IPyroObject> d_disabled = new HashSet<IPyroObject>();
    private String d_description = "";

    public Scenario(String name) {
        super(name);
    }

    public Scenario(Scenario basedOn) {
        this(basedOn.getName());
        this.d_disabled = new HashSet<IPyroObject>(basedOn.d_disabled);
        this.d_description = basedOn.d_description;
    }

    public void setDescription(String description) {
        if (!Objects.equals(this.d_description, description)) {
            this.d_description = description;
            this.changedEvt(new Object[0]);
        }
    }

    public String getDescription() {
        return this.d_description;
    }

    public Set<IPyroObject> getDisabledObjs() {
        return Collections.unmodifiableSet(this.d_disabled);
    }

    public void recordStatus(Collection<IPyroObject> objs) {
        for (IPyroObject o : objs) {
            this.recordStatus(o);
        }
    }

    public void recordStatus(IPyroObject obj) {
        if (DO_NOT_TRACK.stream().anyMatch(ignore -> ignore.isAssignableFrom(obj.getClass()))) {
            return;
        }
        if (obj.isEnabled()) {
            this.d_disabled.remove(obj);
        } else {
            this.d_disabled.add(obj);
        }
    }

    public void removeDeletedObjs(Collection<IPyroObject> deletedObjs) {
        this.d_disabled.removeAll(deletedObjs);
    }

    public static Scenario activate(Scenario from, Scenario to) {
        if (from != null) {
            HashSet<IPyroObject> toEnable = new HashSet<IPyroObject>(from.d_disabled);
            toEnable.removeAll(to.d_disabled);
            toEnable.forEach(obj -> obj.setEnabled(true));
        }
        to.d_disabled.forEach(obj -> obj.setEnabled(false));
        return to;
    }

    @Override
    public String toString() {
        return String.format("%s@%s [getName()=%s, d_disabled=%s]", this.getClass().getSimpleName(), Integer.toHexString(this.hashCode()), this.getName(), this.d_disabled.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_disabled.removeIf(obj -> DO_NOT_TRACK.stream().anyMatch(ignore -> ignore.isAssignableFrom(obj.getClass())));
        if (this.d_description == null) {
            this.d_description = "";
        }
    }

    public boolean objsAreEnabled(Collection<IPyroObject> objs) {
        return this.d_disabled.stream().noneMatch(o1 -> objs.stream().anyMatch(o2 -> Objects.equals(o1, o2)));
    }

    public boolean objsAreDisabled(Collection<IPyroObject> objs) {
        return this.d_disabled.containsAll(objs);
    }
}

