/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.util.ArrayList;
import pyrosim.domain.output.AMeasurementSet;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class Boundaries
extends AMeasurementSet {
    static final long serialVersionUID = 1L;
    private UnitDouble d_pressCoeffCharVel = this.getQuantities().contains(Quantity.PRESSURE_COEFFICIENT.create()) ? SIUS.newud(1.0, 8) : null;
    private UnitDouble d_gaugeTemperature = null;
    private double d_gaugeEmissivity = 0.9;

    public Boundaries(IQuantity ... measurements) {
        super(measurements);
    }

    @Override
    public long getOutputType() {
        return 16L;
    }

    public UnitDouble getPressCoeffCharVel() {
        return this.d_pressCoeffCharVel;
    }

    public void setPressCoeffCharVel(UnitDouble charVel) {
        this.d_pressCoeffCharVel = charVel;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getGaugeTemperature() {
        return this.d_gaugeTemperature;
    }

    public void setGaugeTemperature(UnitDouble gaugeTemp) {
        this.d_gaugeTemperature = gaugeTemp;
        this.changedEvt(new Object[0]);
    }

    public double getGaugeEmissivity() {
        return this.d_gaugeEmissivity;
    }

    public void setGaugeEmissivty(double gaugeEmissivty) {
        this.d_gaugeEmissivity = gaugeEmissivty;
        this.changedEvt(new Object[0]);
    }

    public static Boundaries mergeBoundaries(Boundaries b1, Boundaries b2) {
        Boundaries newBounds = new Boundaries(new IQuantity[0]);
        if (!Boundaries.consumeBounds(newBounds, b1)) {
            return null;
        }
        if (!Boundaries.consumeBounds(newBounds, b2)) {
            return null;
        }
        return newBounds;
    }

    private static boolean consumeBounds(Boundaries target, Boundaries provider) {
        ArrayList<IQuantity> targetQuants = new ArrayList<IQuantity>(target.getQuantities());
        for (IQuantity q : provider.getQuantities()) {
            if (q.get().equals((Object)Quantity.PRESSURE_COEFFICIENT)) {
                if (targetQuants.contains(q)) {
                    if (theUtil.equal(target.getPressCoeffCharVel(), provider.getPressCoeffCharVel())) continue;
                    return false;
                }
                targetQuants.add(q);
                target.setPressCoeffCharVel(provider.getPressCoeffCharVel());
                continue;
            }
            if (q.get().equals((Object)Quantity.GAUGE_HEAT_FLUX)) {
                if (targetQuants.contains(q)) {
                    if (!theUtil.equal(target.getGaugeTemperature(), provider.getGaugeTemperature())) {
                        return false;
                    }
                    if (theUtil.eq(target.getGaugeEmissivity(), provider.getGaugeEmissivity(), 1.0E-6)) continue;
                    continue;
                }
                targetQuants.add(q);
                target.setGaugeTemperature(provider.getGaugeTemperature());
                target.setGaugeEmissivty(provider.getGaugeEmissivity());
                continue;
            }
            if (targetQuants.contains(q)) continue;
            targetQuants.add(q);
        }
        target.setQuantities(targetQuants);
        return true;
    }
}

