/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.StatGeom;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityReplacer;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.BlockGeom;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public abstract class AMsrStat
extends NamedPyroObject
implements IMeasurementStat,
IDirectDependent {
    static final long serialVersionUID = 1L;
    private IQuantity d_msr;
    private Set<Long> d_stats;
    private IGeom d_geom;
    private boolean d_visible;
    private CustomFDSProps d_customProps;
    private static final Color s_boxColor = new Color(0.2f, 0.2f, 1.0f, 0.3f);
    private static final Color s_pointColor = new Color(0.2f, 0.2f, 1.0f, 1.0f);

    public abstract Predicate<Quantity> getQuantityFilter();

    public AMsrStat(String name, IQuantity msr, Collection<Long> stats, IGeom geom) {
        super(name);
        this.d_msr = msr;
        this.d_stats = new HashSet<Long>(stats);
        assert (AMsrStat.isValidGeom(geom));
        this.d_geom = geom;
        this.d_visible = true;
        this.d_customProps = CustomFDSProps.EMPTY;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_customProps == null) {
            this.d_customProps = CustomFDSProps.EMPTY;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AMsrStat)) {
            return false;
        }
        AMsrStat stat = (AMsrStat)obj;
        return this.d_msr.equals(stat.d_msr) && this.d_stats.equals(stat.d_stats) && this.d_geom.equals(stat.d_geom) && this.d_customProps.equals(stat.d_customProps);
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String recType) {
        return this.d_customProps;
    }

    @Override
    public void setCustomFDSProps(String recType, CustomFDSProps props) {
        if (this.d_customProps == props) {
            return;
        }
        this.d_customProps = props;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Object clone() {
        AMsrStat clone = (AMsrStat)super.clone();
        clone.d_stats = new HashSet<Long>(this.d_stats);
        return clone;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible == visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(PyroMod.EVT_VISIBILITY_CHANGED);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public IQuantity getQuantity() {
        return this.d_msr;
    }

    @Override
    public void setStats(Collection<Long> stats) {
        this.d_stats.clear();
        this.d_stats.addAll(stats);
        this.changedEvt(new Object[0]);
    }

    @Override
    public Set<Long> getStats() {
        return Collections.unmodifiableSet(this.d_stats);
    }

    public static boolean isValidGeom(IGeom geom) {
        return geom instanceof Point || geom instanceof AABoxGeom || geom instanceof AARectangle || geom instanceof StatGeom.GridGeom || geom instanceof StatGeom.LinearArrayGeom;
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getMsrGeom());
    }

    @Override
    public IGeom getMsrGeom() {
        if (this.d_geom instanceof BlockGeom) {
            return this.d_geom;
        }
        if (this.d_geom instanceof AABoxGeom) {
            AABoxGeom g = (AABoxGeom)this.d_geom;
            return new BlockGeom(g.min, g.max, g.swizzle);
        }
        if (this.d_geom instanceof RestrictedRect) {
            return this.d_geom;
        }
        if (this.d_geom instanceof AARectangle) {
            return new RestrictedRect((AARectangle)this.d_geom);
        }
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (AMsrStat.isValidGeom(geom)) {
            this.d_geom = geom;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        IPrimProps.AProps props;
        Color c = this.d_geom instanceof Point ? s_pointColor : s_boxColor;
        IPrimProps.AProps aProps = props = this.d_geom instanceof Point || this.d_geom instanceof LineSeg ? new IPrimProps.Vertex(c, 10.0) : new IPrimProps.Face(c, null, 2);
        if (this.d_geom instanceof StatGeom.LinearVolumeArrayGeom) {
            return GeomUtil.generateLinearVolumeArrayDisplayGeom((StatGeom.LinearVolumeArrayGeom)this.d_geom, new IPrimProps.Face(c, null, 2));
        }
        if (this.d_geom instanceof StatGeom.LinearPointArrayGeom) {
            return GeomUtil.generateLinearArrayDisplayGeom((StatGeom.LinearPointArrayGeom)this.d_geom, props);
        }
        return new DisplayGeom(this.getGeom(), (IPrimProps)props);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        QuantityUtil.takeDepSnapshot(deps, DLink.STRONG, this.d_msr);
        if (this.d_geom instanceof StatGeom.GridGeom) {
            deps.add(DLink.STRONG, (IPyroObject)((StatGeom.GridGeom)this.d_geom).grid);
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (QuantityUtil.isQuantityRef(old, this.d_msr)) {
            Util.keepOnlyNull(objs);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (QuantityUtil.isQuantityRef(old, this.d_msr)) {
            assert (old.equals(replacement));
            QuantReplacer replacer = new QuantReplacer();
            return replacer.taskReplaceDep(old, replacement, this.d_msr);
        }
        if (old instanceof Grid) {
            assert (replacement != null);
            return new AReplaceRefTask<Grid>((Object)old, (Object)replacement){

                @Override
                protected void set(Grid obj) {
                    AMsrStat.this.setGeom(GeomNodeUtil.newNode(new StatGeom.GridGeom(obj)));
                }
            };
        }
        return EmptyTask.INSTANCE;
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        if (dep instanceof Grid) {
            return GeomUtil.taskChanged(this);
        }
        return EmptyTask.INSTANCE;
    }

    static {
        TVEntryPoint.registerReferencedUpdateTypes(Grid.class);
    }

    protected class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)AMsrStat.this.getDomain());
        }

        @Override
        protected boolean canReplaceQuant(IQuantity old, IQuantity repl) {
            return old.equals(repl);
        }

        @Override
        protected Task taskReplaceQuant(IQuantity oldMsr, IQuantity newMsr) {
            assert (newMsr != null);
            return new AReplaceRefTask<IQuantity>((Object)AMsrStat.this.d_msr, (Object)newMsr){

                @Override
                protected void set(IQuantity obj) {
                    AMsrStat.this.d_msr = obj;
                    AMsrStat.this.changedEvt(new Object[0]);
                }
            };
        }
    }

    public static class RestrictedRect
    extends AARectangle {
        static final long serialVersionUID = 1L;

        public RestrictedRect(AARectangle baseRect) {
            super(baseRect.d_plane, baseRect.d_planeVal, baseRect.d_minx, baseRect.d_miny, baseRect.d_maxx, baseRect.d_maxy, baseRect.flipped);
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }
    }
}

