/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.detectors;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.detectors.APointDetector;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.util.Util;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public class HeatDetector
extends APointDetector
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    private HeatLinkModel d_link;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(Color.RED, 10.0);

    public HeatDetector(String name, HeatLinkModel link, FreePointLoc loc) {
        super(name, loc);
        this.d_link = link;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof HeatDetector && super.equals(obj) && this.d_link.equals(((HeatDetector)obj).d_link);
    }

    @Override
    protected IQuantity getQuantity() {
        return Quantity.LINK_TEMPERATURE.create();
    }

    public HeatLinkModel getModel() {
        return this.d_link;
    }

    public void setModel(HeatLinkModel link) {
        assert (link != null);
        this.d_link = link;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        assert (this.d_link != null) : "A Heat Detector must have a link";
        deps.add(DLink.STRONG, (IPyroObject)this.d_link);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        Util.keepIfNullOr(objs, HeatLinkModel.class);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old == this.getModel()) {
            assert (replacement != null);
            return new AReplaceRefTask<HeatLinkModel>((Object)old, (Object)replacement){

                @Override
                public void set(HeatLinkModel obj) {
                    HeatDetector.this.setModel(obj);
                }
            };
        }
        return null;
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    @Override
    protected IPrimProps getPrimProps() {
        return s_primProps;
    }
}

