/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.geom.FreePointLoc;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.CancelObjectPicking;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class FreePointGeom
implements IGeom,
IManipulatable {
    private static final long serialVersionUID = 8277755820854432148L;
    public final FreePointLoc loc;

    public FreePointGeom(FreePointLoc loc) {
        this.loc = loc;
    }

    @Override
    public FreePointGeom optimize(IPointOptimizer pool) {
        return this;
    }

    @Override
    public IGeom transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        FreePointLoc newLoc = this.loc.transform(ti.getMatrix());
        return new FreePointGeom(newLoc);
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        return this.loc.d_geom.getBoundingBox(aabb);
    }

    @Override
    public boolean getBakeTransform() {
        return true;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public boolean isAxisAlignedBlock(TransformInfo parentXform) {
        return false;
    }

    @Override
    public boolean isShell() {
        return true;
    }

    @Override
    public int getNumPrims(int types) {
        if ((types & 4) == 4) {
            return 1;
        }
        return 0;
    }

    @Override
    public Iterator<Byte> iteratePrimTypes(int offset) {
        return theUtil.iterate((byte)4, 1);
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> prims) {
        prims.add(this.getGeom());
        return prims;
    }

    private IGeom getGeom() {
        return this.loc.d_geom;
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, IElemSource<Boolean> creases, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
        this.getGeom().pickPoints(isects, filter, source, creases, rayBegin, rayDirN, maxDist, tester);
    }

    @Override
    public void pickBox(Object source, IElemSource<Boolean> visFaceEdges, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelObjectPicking {
        this.getGeom().pickBox(source, visFaceEdges, filter, region, isects);
    }

    @Override
    public void find(ITest<AABox> test, IResult<? super IPrimitive> result) {
        this.getGeom().find(test, result);
    }

    @Override
    public void getAll(IResult<? super IPrimitive> result) {
        this.getGeom().getAll(result);
    }

    @Override
    public void generateManipHandles(Consumer<? super IHandle> handles) {
        IGeom geom = this.getGeom();
        if (geom instanceof IManipulatable) {
            ((IManipulatable)((Object)geom)).generateManipHandles(handle -> handles.accept(new Handle(this, (IHandle)handle)));
        }
    }

    private static class Handle
    implements IHandle {
        private FreePointGeom d_geom;
        private IHandle d_geomHandle;

        public Handle(FreePointGeom geom, IHandle handle) {
            this.d_geom = geom;
            this.d_geomHandle = handle;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Handle)) {
                return false;
            }
            Handle hand = (Handle)obj;
            return this.d_geomHandle.equals(hand.d_geomHandle);
        }

        @Override
        public IGeomNode getGeom() {
            return this.d_geomHandle.getGeom();
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return this.d_geomHandle.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return this.d_geomHandle.getConstraint(handleLoc);
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            this.d_geomHandle.begin(handleLoc, constraint);
        }

        @Override
        public Object modify(Point3d newLoc) throws ManipException {
            Object handleMod = this.d_geomHandle.modify(newLoc);
            if (handleMod instanceof IGeom) {
                FreePointLoc newFreeLoc = new FreePointLoc((IGeom)handleMod, this.d_geom.loc.d_orientation, this.d_geom.loc.d_rotation);
                this.d_geom = new FreePointGeom(newFreeLoc);
            }
            return this.d_geom;
        }

        @Override
        public Object end() {
            Object handleEnd = this.d_geomHandle.end();
            if (handleEnd instanceof IGeom) {
                FreePointLoc newFreeLoc = new FreePointLoc((IGeom)handleEnd, this.d_geom.loc.d_orientation, this.d_geom.loc.d_rotation);
                this.d_geom = new FreePointGeom(newFreeLoc);
            }
            return this.d_geom;
        }
    }
}

