/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.DefaultSurface;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.SurfDescStatic;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.io.PyroSimObjectInputStream;

public class SurfaceManager
extends Composite<Surface> {
    static final long serialVersionUID = 1L;
    private DefaultSurface d_defaultSurfaceObj;

    public SurfaceManager() {
        this(Intl.intl("Surfaces"));
    }

    public SurfaceManager(String name) {
        super(name, Surface.class);
    }

    public void addPredefined() {
        this.addDefault(new Surface(PredefSurf.INERT.name, new Color(255, 204, 102), null, new SurfDescStatic.Inert()));
        this.addDefault(new Surface(PredefSurf.ADIABATIC.name, new Color(0.8f, 0.8f, 0.8f), null, new SurfDescStatic.Adiabatic()));
        this.addDefault(new Surface(PredefSurf.OPEN.name, new Color(0.0f, 1.0f, 1.0f), null, new SurfDescStatic.Open()));
        this.addDefault(new Surface(PredefSurf.MIRROR.name, new Color(0.0f, 1.0f, 1.0f), null, new SurfDescStatic.Mirror()));
        this.addDefault(new Surface(PredefSurf.HVAC.name, new Color(0.75f, 0.58f, 0.89f), null, new SurfDescStatic.Hvac()));
        this.addDefault(new Surface(PredefSurf.PERIODIC.name, new Color(0, 255, 105), null, new SurfDescStatic.Periodic()));
        this.addDefault(new Surface(PredefSurf.PERIODIC_FLOW_ONLY.name, new Color(0, 200, 200), null, new SurfDescStatic.PeriodicFlowOnly()));
        this.d_defaultSurfaceObj = new DefaultSurface(new SurfDescStatic.Default());
    }

    @Override
    protected void addToDomain(PyroMod domain, IPyroObject parent) {
        super.addToDomain(domain, parent);
        if (this.d_defaultSurfaceObj != null) {
            this.d_defaultSurfaceObj.setDomain(domain, this);
        }
    }

    @Override
    public void setDomain(PyroMod domain, IPyroObject parent) {
        super.setDomain(domain, parent);
        if (this.d_defaultSurfaceObj != null) {
            this.d_defaultSurfaceObj.setDomain(domain, this);
        }
    }

    public DefaultSurface getDefaultSurfaceObj() {
        return this.d_defaultSurfaceObj;
    }

    public boolean refreshDefaultSurface(PyroMod domain) {
        if (domain == this.getDomain() && domain.getSurfaceMgr() == this && this.d_defaultSurfaceObj == null) {
            this.d_defaultSurfaceObj = new DefaultSurface(new SurfDescStatic.Default());
            return true;
        }
        return false;
    }

    public Surface get(PredefSurf pSurf) {
        return (Surface)this.get(pSurf.name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (in instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)in).getVersion() < 140) {
            this.addDefault(new Surface(PredefSurf.PERIODIC_FLOW_ONLY.name, new Color(0, 200, 200), null, new SurfDescStatic.PeriodicFlowOnly()));
        }
    }
}

