/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.APyroObject;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.DefaultSurface;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.domain.evac.Pers;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityReplacer;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.domain.variant.ConstProfile;
import pyrosim.domain.variant.DefRampProfile;
import pyrosim.domain.variant.DefaultProfile;
import pyrosim.domain.variant.FractionalRampProfile;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.variant.VariantProfile;
import pyrosim.geom.Geometry;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class SimParams
extends APyroObject
implements ICustomFDSPropsContainer {
    static final long serialVersionUID = 1L;
    private String d_jobTitle = "";
    private Time d_time = new Time();
    private Calculations d_calcs = new Calculations();
    private Environment d_env = new Environment();
    private RadiationTransport d_radi = new RadiationTransport();
    private FileOutput d_fileOutput = new FileOutput();
    private Particles d_particles = new Particles();
    private Misc d_misc;
    private OpenMp d_openMp;
    private Wind d_wind;
    @SkipDep
    private Pers d_persGlobals;
    private Map<String, CustomFDSProps> d_customProps;

    public SimParams(SurfaceManager surfMgr) {
        this.d_misc = new Misc(surfMgr);
        this.d_persGlobals = SimParams.initPers();
        this.d_openMp = new OpenMp();
        this.d_wind = new Wind();
        this.d_customProps = SimParams.createCustomPropsMap();
    }

    private static Map<String, CustomFDSProps> createCustomPropsMap() {
        LinkedHashMap<String, CustomFDSProps> props = new LinkedHashMap<String, CustomFDSProps>();
        props.put("CLIP", CustomFDSProps.EMPTY);
        props.put("COMB", CustomFDSProps.EMPTY);
        props.put("DUMP", CustomFDSProps.EMPTY);
        props.put("MISC", CustomFDSProps.EMPTY);
        props.put("PRES", CustomFDSProps.EMPTY);
        props.put("RADI", CustomFDSProps.EMPTY);
        props.put("TIME", CustomFDSProps.EMPTY);
        props.put("WIND", CustomFDSProps.EMPTY);
        return props;
    }

    @Override
    public void getCustomFDSTypes(Collection<String> types) {
        types.addAll(this.d_customProps.keySet());
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String recordType) {
        return this.d_customProps.get(recordType);
    }

    @Override
    public void setCustomFDSProps(String recordType, CustomFDSProps props) {
        assert (this.d_customProps.containsKey(recordType));
        this.d_customProps.put(recordType, props);
        this.changedEvt(new Object[0]);
    }

    @Override
    protected void removeFromDomain(PyroMod domain) {
        super.removeFromDomain(domain);
        this.d_time.setDomain(null, null);
        this.d_calcs.setDomain(null, null);
        this.d_env.setDomain(null, null);
        this.d_radi.setDomain(null, null);
        this.d_fileOutput.setDomain(null, null);
        this.d_particles.setDomain(null, null);
        this.d_misc.setDomain(null, null);
        this.d_persGlobals.setDomain(null, null);
        this.d_openMp.setDomain(null, null);
        this.d_wind.setDomain(null, null);
    }

    @Override
    protected void addToDomain(PyroMod domain, IPyroObject parent) {
        super.addToDomain(domain, parent);
        this.d_time.setDomain(domain, this);
        this.d_calcs.setDomain(domain, this);
        this.d_env.setDomain(domain, this);
        this.d_radi.setDomain(domain, this);
        this.d_fileOutput.setDomain(domain, this);
        this.d_particles.setDomain(domain, this);
        this.d_misc.setDomain(domain, this);
        this.d_persGlobals.setDomain(domain, this);
        this.d_openMp.setDomain(domain, this);
        this.d_wind.setDomain(domain, this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SimParams)) {
            return false;
        }
        SimParams params = (SimParams)obj;
        return params.d_time.equals(this.d_time) && params.d_calcs.equals(this.d_calcs) && params.d_env.equals(this.d_env) && params.d_radi.equals(this.d_radi) && params.d_fileOutput.equals(this.d_fileOutput) && params.d_particles.equals(this.d_particles) && params.d_misc.equals(this.d_misc) && params.d_openMp.equals(this.d_openMp) && params.d_wind.equals(this.d_wind) && params.d_persGlobals.equals(this.d_persGlobals) && params.d_customProps.equals(this.d_customProps);
    }

    @Override
    public boolean isEquiv(Object obj) {
        if (!(obj instanceof SimParams)) {
            return false;
        }
        SimParams params = (SimParams)obj;
        return params.d_time.equals(this.d_time) && params.d_calcs.equals(this.d_calcs) && params.d_env.equals(this.d_env) && params.d_radi.equals(this.d_radi) && params.d_fileOutput.equals(this.d_fileOutput) && params.d_particles.equals(this.d_particles) && params.d_misc.equals(this.d_misc) && params.d_openMp.equals(this.d_openMp) && params.d_wind.equals(this.d_wind) && params.d_persGlobals.equals(this.d_persGlobals) && params.d_customProps.equals(this.d_customProps);
    }

    @Override
    public Object clone() {
        SimParams sp = (SimParams)super.clone();
        sp.d_time = (Time)this.d_time.clone();
        sp.d_calcs = (Calculations)this.d_calcs.clone();
        sp.d_env = (Environment)this.d_env.clone();
        sp.d_radi = (RadiationTransport)this.d_radi.clone();
        sp.d_fileOutput = (FileOutput)this.d_fileOutput.clone();
        sp.d_particles = (Particles)this.d_particles.clone();
        sp.d_misc = (Misc)this.d_misc.clone();
        sp.d_openMp = (OpenMp)this.d_openMp.clone();
        sp.d_wind = this.d_wind.clone();
        sp.d_persGlobals = (Pers)this.d_persGlobals.clone();
        sp.d_customProps = new LinkedHashMap<String, CustomFDSProps>();
        sp.d_customProps.putAll(this.d_customProps);
        return sp;
    }

    private static Pers initPers() {
        return new Pers("globals");
    }

    public void clearPers() {
        this.d_persGlobals = SimParams.initPers();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (PyroSimObjectInputStream.getVersion(in) < 31) {
            this.d_persGlobals = SimParams.initPers();
        }
        if (PyroSimObjectInputStream.getVersion(in) < 61) {
            this.d_openMp = new OpenMp();
        }
        if (this.d_customProps == null) {
            this.d_customProps = SimParams.createCustomPropsMap();
        }
        if (PyroSimObjectInputStream.getVersion(in) < 98) {
            this.d_customProps.put("PRES", CustomFDSProps.EMPTY);
        }
        if (PyroSimObjectInputStream.getVersion(in) < 113) {
            this.d_wind = new Wind();
            this.d_customProps.put("WIND", CustomFDSProps.EMPTY);
            UnitPoint3D ambVel = this.d_env.d_ambVel;
            if (ambVel != null && !ambVel.equals(new UnitPoint3D(0.0, 0.0, 0.0, SIUS.unit(8)))) {
                this.d_wind.set(Wind.INITSPEEDOPT, Wind.InitSpeedOptions.UV);
                this.d_wind.set(Wind.U0, ambVel.xu());
                this.d_wind.set(Wind.V0, ambVel.yu());
                this.d_wind.set(Wind.W0, ambVel.zu());
            }
            this.d_env.d_ambVel = null;
            if (this.d_env.d_atmLapseRate != null) {
                this.d_wind.set(Wind.LAPSE_RATE, this.d_env.d_atmLapseRate);
                this.d_env.d_atmLapseRate = null;
            }
        }
        if (PyroSimObjectInputStream.getVersion(in) >= 113 && PyroSimObjectInputStream.getVersion(in) < 116) {
            this.d_wind = new Wind();
        }
        if (PyroSimObjectInputStream.getVersion(in) < 124) {
            this.d_customProps.put("COMB", CustomFDSProps.EMPTY);
        }
        if (PyroSimObjectInputStream.getVersion(in) < 129) {
            this.d_customProps.put("CLIP", CustomFDSProps.EMPTY);
        }
        if (PyroSimObjectInputStream.getVersion(in) < 146 && this.d_env.d_groundLevel != null) {
            this.d_wind.set(Wind.GROUND_LEVEL, this.d_env.d_groundLevel);
            this.d_env.d_groundLevel = null;
        }
    }

    public String getJobTitle() {
        return this.d_jobTitle;
    }

    public void setJobTitle(String title) {
        this.d_jobTitle = title;
        this.changedEvt(new Object[0]);
    }

    public Time getTime() {
        return this.d_time;
    }

    public Calculations getCalculations() {
        return this.d_calcs;
    }

    public Environment getEnvironment() {
        return this.d_env;
    }

    public RadiationTransport getRadiTransport() {
        return this.d_radi;
    }

    public FileOutput getFileOutput() {
        return this.d_fileOutput;
    }

    public Particles getParticles() {
        return this.d_particles;
    }

    public Misc getMisc() {
        return this.d_misc;
    }

    public Pers getPersGlobals() {
        return this.d_persGlobals;
    }

    public OpenMp getOpenMp() {
        return this.d_openMp;
    }

    public Wind getWind() {
        return this.d_wind;
    }

    public static class Wind
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        private static final VariantProfile FRACTION_TIME_RAMP_PROFILE = new VariantProfile(new DefaultProfile(Intl.intl("Default")), new DefRampProfile(Intl.intl("Custom"), 28, DefRampProfile.Input.TIME));
        private static final VariantProfile FRACTION_Z_RAMP_PROFILE = new VariantProfile(new DefaultProfile(Intl.intl("Default")), new DefRampProfile(Intl.intl("Custom"), 28, DefRampProfile.Input.ZPOS));
        public static final VariantProfile DIRECTION_RAMP_PROFILE = new VariantProfile(new DefaultProfile(Intl.intl("Default")), new DefRampProfile(Intl.intl("Custom"), 29, DefRampProfile.Input.TIME));
        public static final VariantProfile SPEED_TIME_RAMP_PROFILE = FRACTION_TIME_RAMP_PROFILE;
        public static final VariantProfile SPEED_Z_RAMP_PROFILE = FRACTION_Z_RAMP_PROFILE;
        public static final VariantProfile TMP0_Z_RAMP_PROFILE = FRACTION_Z_RAMP_PROFILE;
        public static final VariantProfile FORCE_PROFILE = new VariantProfile(new DefaultProfile("Default"), new ConstProfile(Intl.intl("Constant"), 92, new UnitDouble(0.0, SI.PASCAL.divide(SI.METER))), new FractionalRampProfile(Intl.intl("Custom"), 92, new UnitDouble(0.0, SI.PASCAL.divide(SI.METER)), 28, DefRampProfile.Input.TIME));
        public static final IPropertySet.Prop<Variant> DIRECTION_RAMP_T = new IPropertySet.Prop<Variant>(0, DIRECTION_RAMP_PROFILE.getDefault());
        public static final IPropertySet.Prop<UnitDouble> SPEED = new IPropertySet.Prop<UnitDouble>(1, SIUS.newud(0.0, 8));
        public static final IPropertySet.Prop<UnitDouble> U0 = new IPropertySet.Prop<UnitDouble>(2, SIUS.newud(0.0, 8));
        public static final IPropertySet.Prop<UnitDouble> V0 = new IPropertySet.Prop<UnitDouble>(3, SIUS.newud(0.0, 8));
        public static final IPropertySet.Prop<UnitDouble> W0 = new IPropertySet.Prop<UnitDouble>(4, SIUS.newud(0.0, 8));
        public static final IPropertySet.Prop<Variant> U0T = new IPropertySet.Prop<Variant>(5, SPEED_TIME_RAMP_PROFILE.getDefault());
        public static final IPropertySet.Prop<Variant> V0T = new IPropertySet.Prop<Variant>(6, SPEED_TIME_RAMP_PROFILE.getDefault());
        public static final IPropertySet.Prop<Variant> W0T = new IPropertySet.Prop<Variant>(7, SPEED_TIME_RAMP_PROFILE.getDefault());
        public static final IPropertySet.Prop<Variant> SPEED_RAMP_T = new IPropertySet.Prop<Variant>(8, SPEED_TIME_RAMP_PROFILE.getDefault());
        public static final IPropertySet.Prop<Variant> U0Z = new IPropertySet.Prop<Variant>(9, SPEED_Z_RAMP_PROFILE.getDefault());
        public static final IPropertySet.Prop<Variant> V0Z = new IPropertySet.Prop<Variant>(10, SPEED_Z_RAMP_PROFILE.getDefault());
        public static final IPropertySet.Prop<Variant> W0Z = new IPropertySet.Prop<Variant>(11, SPEED_Z_RAMP_PROFILE.getDefault());
        public static final IPropertySet.Prop<UnitDouble> ZREF = new IPropertySet.Prop<UnitDouble>(12, new UnitDouble(2.0, SI.METER));
        public static final IPropertySet.Prop<UnitDouble> Z0 = new IPropertySet.Prop<UnitDouble>(13, new UnitDouble(0.03, SI.METER));
        public static final IPropertySet.Prop<UnitDouble> L = new IPropertySet.Prop<UnitDouble>(14, new UnitDouble(0.0, SI.METER));
        public static final IPropertySet.Prop<UnitDouble> THETASTAR = new IPropertySet.Prop<Object>(15, null);
        public static final IPropertySet.Prop<UnitDouble> USTAR = new IPropertySet.Prop<Object>(16, null);
        public static final IPropertySet.Prop<Variant> FORCEX = new IPropertySet.Prop<Variant>(17, FORCE_PROFILE.getDefault());
        public static final IPropertySet.Prop<Variant> FORCEY = new IPropertySet.Prop<Variant>(18, FORCE_PROFILE.getDefault());
        public static final IPropertySet.Prop<Variant> FORCEZ = new IPropertySet.Prop<Variant>(19, FORCE_PROFILE.getDefault());
        public static final IPropertySet.Prop<InitSpeedOptions> INITSPEEDOPT = new IPropertySet.Prop<InitSpeedOptions>(20, InitSpeedOptions.SPEED);
        public static final IPropertySet.Prop<UnitDouble> LAPSE_RATE = new IPropertySet.Prop<UnitDouble>(21, SIUS.newud(0.0, 5));
        public static final IPropertySet.Prop<Variant> TMP0Z_RAMP = new IPropertySet.Prop<Variant>(22, TMP0_Z_RAMP_PROFILE.getDefault());
        public static final IPropertySet.Prop<UnitDouble> GROUND_LEVEL = new IPropertySet.Prop<UnitDouble>(23, SIUS.newud(0.0, 0));
        public static final IPropertySet.Prop<UnitDouble> DIRECTION = new IPropertySet.Prop<UnitDouble>(24, new UnitDouble(270.0, NonSI.DEGREE_ANGLE));
        public static final List<IPropertySet.Prop<?>> ALL_PROPS = IPropertySet.getAllDeclaredPublicStaticProps(Wind.class);
        private IPropertySet d_props = new PropertySet();

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.d_props == null) {
                this.d_props = new PropertySet();
            }
        }

        @Override
        public Wind clone() {
            Wind wind = (Wind)super.clone();
            wind.d_props = new PropertySet();
            wind.copyVals(this);
            return wind;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            Wind wind = (Wind)obj;
            return this.d_props.compare(wind.d_props, ALL_PROPS);
        }

        public void copyVals(Wind wind) {
            this.d_props.merge(wind.d_props, ALL_PROPS);
        }

        public <T> void set(IPropertySet.Prop<T> prop, T value) {
            if (!Objects.equals(this.d_props.get(prop), value)) {
                this.d_props.set(prop, value);
                this.changedEvt(new Object[0]);
            }
        }

        public <T> void setNoCheck(IPropertySet.Prop<T> prop, T value) {
            this.d_props.set(prop, value);
            this.changedEvt(new Object[0]);
        }

        public <T> T get(IPropertySet.Prop<T> prop) {
            return this.d_props.get(prop);
        }

        @Override
        public boolean isEquiv(Object obj) {
            return obj == this;
        }

        public boolean isDefault() {
            return this.d_props.compare((IPropertySet)new PropertySet(), ALL_PROPS);
        }

        public static enum InitSpeedOptions {
            SPEED,
            UV;

        }
    }

    public static class OpenMp
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        private boolean d_ompNumThreadsFlag = true;
        private String d_ompNumThreads;
        private boolean d_ompNumThreadsMPIFlag;
        private String d_ompNumThreadsMPI;
        private boolean d_ompStacksizeFlag;
        private String d_ompStacksize;

        public OpenMp() {
            int nprocs = Runtime.getRuntime().availableProcessors();
            int ompDefault = Math.min(nprocs / 2, 4);
            this.d_ompNumThreads = Integer.toString(ompDefault);
            this.d_ompNumThreadsMPIFlag = true;
            this.d_ompNumThreadsMPI = "1";
            this.d_ompStacksizeFlag = true;
            this.d_ompStacksize = "16M";
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.d_ompNumThreadsMPI == null) {
                this.d_ompNumThreadsMPI = "1";
            }
        }

        public boolean getOmpNumThreadsFlag() {
            return this.d_ompNumThreadsFlag;
        }

        public void setOmpNumThreadsFlag(boolean flag) {
            this.d_ompNumThreadsFlag = flag;
            this.changedEvt(new Object[0]);
        }

        public String getOmpNumThreads() {
            return this.d_ompNumThreads;
        }

        public void setOmpNumThreads(String value) {
            this.d_ompNumThreads = value;
            this.changedEvt(new Object[0]);
        }

        public boolean getOmpNumThreadsMPIFlag() {
            return this.d_ompNumThreadsMPIFlag;
        }

        public void setOmpNumThreadsMPIFlag(boolean flag) {
            this.d_ompNumThreadsMPIFlag = flag;
            this.changedEvt(new Object[0]);
        }

        public String getOmpNumThreadsMPI() {
            return this.d_ompNumThreadsMPI;
        }

        public void setOmpNumThreadsMPI(String value) {
            this.d_ompNumThreadsMPI = value;
            this.changedEvt(new Object[0]);
        }

        public boolean getOmpStacksizeFlag() {
            return this.d_ompStacksizeFlag;
        }

        public void setOmpStacksizeFlag(boolean flag) {
            this.d_ompStacksizeFlag = flag;
            this.changedEvt(new Object[0]);
        }

        public String getOmpStacksize() {
            return this.d_ompStacksize;
        }

        public void setOmpStacksize(String value) {
            this.d_ompStacksize = value;
            this.changedEvt(new Object[0]);
        }

        @Override
        public boolean isEquiv(Object obj) {
            return this == obj;
        }
    }

    public static class Misc
    extends APyroObject
    implements IDirectDependent,
    Serializable {
        static final long serialVersionUID = 1L;
        private Surface d_surfDefault;
        private SurfaceManager d_surfManager;
        private UnitPoint3D d_textureOrigin;
        private SUPPRESSION d_suppression;
        private boolean d_predictCOProd;
        private Map<String, Object> d_evacProps;
        private transient boolean d_resume = false;
        private boolean d_forceMixFrac;

        public Misc(SurfaceManager surfMgr) {
            this.d_surfManager = surfMgr;
            this.d_surfDefault = surfMgr.get(PredefSurf.INERT);
            this.d_textureOrigin = Geometry.UP3D_ZERO;
            this.d_suppression = SUPPRESSION.AUTO;
            this.d_predictCOProd = false;
            this.initEvacProps(surfMgr);
        }

        @Override
        public Object clone() {
            Misc clone = (Misc)super.clone();
            clone.d_evacProps = new HashMap<String, Object>(this.d_evacProps);
            return clone;
        }

        public void initEvacProps(SurfaceManager surfMgr) {
            this.d_evacProps = new HashMap<String, Object>();
            this.d_evacProps.put("EVACUATION_MC_MODE", false);
            this.d_evacProps.put("EVAC_PRESSURE_ITERATIONS", 50);
            this.d_evacProps.put("EVAC_TIME_ITERATIONS", 50);
            this.d_evacProps.put("EVAC_SURF_DEFAULT", surfMgr.get(PredefSurf.INERT));
        }

        public void setResume(boolean val) {
            this.d_resume = val;
        }

        public boolean getAndClearResume() {
            boolean resume = this.d_resume;
            this.d_resume = false;
            return resume;
        }

        @Override
        public void takeDepSnapshot(DepList deps) {
            Surface evacSurf = (Surface)this.getEvacProp("EVAC_SURF_DEFAULT");
            deps.add(DLink.REQUIRED, (IPyroObject)this.d_surfDefault);
            deps.add(DLink.WEAK, (IPyroObject)evacSurf);
        }

        @Override
        public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
            AUndoableTask t2;
            Task t1 = old == this.getSurfDefault() ? this.taskSetSurfDefault((Surface)replacement) : null;
            AUndoableTask aUndoableTask = t2 = old == this.getEvacProp("EVAC_SURF_DEFAULT") ? new AUndoableTask(){

                @Override
                public void run() {
                    this.setEvacProp("EVAC_SURF_DEFAULT", replacement);
                }

                @Override
                public void undo() {
                    this.setEvacProp("EVAC_SURF_DEFAULT", old);
                }
            } : null;
            if (t1 != null && t2 != null) {
                CompositeTask t = new CompositeTask(this.getDomain());
                t.addTask(t1);
                t.addTask(t2);
                return t;
            }
            if (t1 != null) {
                return t1;
            }
            if (t2 != null) {
                return t2;
            }
            return EmptyTask.INSTANCE;
        }

        @Override
        public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
            return EmptyTask.INSTANCE;
        }

        public boolean predictCOProd() {
            return this.d_predictCOProd;
        }

        public Surface getSurfDefault() {
            return this.d_surfDefault;
        }

        public void setSurfDefault(Surface surfDefault, DefaultSurface surfDefaultDefault) {
            this.d_surfDefault = surfDefault;
            this.d_surfManager.getDefaultSurfaceObj().restoreFrom(this.d_surfDefault);
            this.changedEvt(new Object[0]);
        }

        public void setSurfaceManager(SurfaceManager surfaceManager) {
            this.d_surfManager = surfaceManager;
        }

        public void setSurfDefault(Surface surfDefault) {
            this.d_surfDefault = surfDefault;
            this.d_surfManager.getDefaultSurfaceObj().restoreFrom(this.d_surfDefault);
            this.changedEvt(new Object[0]);
        }

        public SUPPRESSION getSuppression() {
            return this.d_suppression;
        }

        public void setSuppression(SUPPRESSION suppress) {
            this.d_suppression = suppress;
            this.changedEvt(new Object[0]);
        }

        public UnitPoint3D getTextureOrigin() {
            return this.d_textureOrigin;
        }

        public void setTextureOrigin(UnitPoint3D textureOrigin) {
            this.d_textureOrigin = textureOrigin;
            this.changedEvt(new Object[0]);
        }

        public void setEvacProp(String key, Object value) {
            if (this.d_evacProps.get(key) != value) {
                this.d_evacProps.put(key, value);
                this.changedEvt(new Object[0]);
            }
        }

        public Object getEvacProp(String key) {
            return this.d_evacProps.get(key);
        }

        @Override
        public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
            Util.keepIfNullOr(objs, Surface.class);
        }

        public Task taskSetSurfDefault(Surface surfDefault) {
            return new AReplaceRefTask<Surface>((Object)this.d_surfDefault, (Object)surfDefault){

                @Override
                protected void set(Surface obj) {
                    this.setSurfDefault(obj);
                }
            };
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (PyroSimObjectInputStream.getVersion(in) < 118) {
                this.d_suppression = SUPPRESSION.AUTO;
            }
        }

        @Override
        public boolean isEquiv(Object obj) {
            return this == obj;
        }

        static {
            TVEntryPoint.registerReferencedUpdateTypes(DefaultSurface.class);
        }

        public static enum SUPPRESSION {
            AUTO(Intl.intl("Auto")),
            TRUE(Intl.intl("True")),
            FALSE(Intl.intl("False"));

            public final String dispName;

            private SUPPRESSION(String dispName) {
                this.dispName = dispName;
            }
        }
    }

    public static class Particles
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final IntVR MAX_PARTICLES_PER_MESH = IntVR.above(0, false);
        private boolean d_porousFloor = true;
        private boolean d_allowUndersideDroplets = false;
        private int d_maxParticlesPerMesh = 500000;

        @Override
        public Object clone() {
            return super.clone();
        }

        public boolean isPourousFloor() {
            return this.d_porousFloor;
        }

        public void setPourousFloor(boolean pourousFloor) {
            this.d_porousFloor = pourousFloor;
            this.changedEvt(new Object[0]);
        }

        public boolean getAllowUndersideDroplets() {
            return this.d_allowUndersideDroplets;
        }

        public void setAllowUndersideDroplets(boolean allowUndersideDroplets) {
            this.d_allowUndersideDroplets = allowUndersideDroplets;
            this.changedEvt(new Object[0]);
        }

        public int getMaxParticlesPerMesh() {
            return this.d_maxParticlesPerMesh;
        }

        public void setMaxParticlesPerMesh(int maxParticlesPerMesh) {
            this.d_maxParticlesPerMesh = maxParticlesPerMesh;
            this.changedEvt(new Object[0]);
        }

        @Override
        public boolean isEquiv(Object obj) {
            return this == obj;
        }
    }

    public static class FileOutput
    extends APyroObject
    implements Serializable,
    IDirectDependent {
        static final long serialVersionUID = 1L;
        public static final UnitDoubleVR TIME_RANGE_FILE_OUT = UnitDoubleVR.above(0.0, SIUS.getInstance().getTimeUnit(), true);
        public static final IntVR NUM_FRAMES_RANGE = IntVR.above(1, true);
        private boolean d_suppressDiagnostics = false;
        private boolean d_limitCSVColumns = false;
        private UnitDouble d_dtBoundaryFile = null;
        private UnitDouble d_dtDeviceFiles = null;
        private UnitDouble d_dtHeatReleaseRateFiles = null;
        private UnitDouble d_dtIsofFiles = null;
        private UnitDouble d_dtParticleFiles = null;
        private UnitDouble d_dtProfileDumpInterval = null;
        private UnitDouble d_dtRestartFile = new UnitDouble(300.0, SI.SECOND);
        private UnitDouble d_dtSliceFiles = null;
        private UnitDouble d_dtSlice3dFiles = new UnitDouble(0.25, SI.SECOND);
        private int d_numOutputFrames = 1000;
        private boolean d_visualize3dSmoke = true;
        private IQuantity d_smokeQuantity = null;
        private boolean d_hrrGasOnly = false;
        private ExSpec d_smokeSpec;
        private boolean d_writeSpeciesMassFile = false;
        private UnitDouble d_dtMassFiles = null;
        private UnitDouble d_dtPlot3dFile = null;

        @Override
        public Object clone() {
            return super.clone();
        }

        public boolean isSuppressDiagnostics() {
            return this.d_suppressDiagnostics;
        }

        public void setSuppressDiagnostics(boolean suppress) {
            this.d_suppressDiagnostics = suppress;
            this.changedEvt(new Object[0]);
        }

        public boolean isLimitCSVColumns() {
            return this.d_limitCSVColumns;
        }

        public void setLimitCSVColumns(boolean limitCSVColumns) {
            this.d_limitCSVColumns = limitCSVColumns;
            this.changedEvt(new Object[0]);
        }

        public boolean isHrrGasOnly() {
            return this.d_hrrGasOnly;
        }

        public void setHrrGasOnly(boolean hrrGasOnly) {
            this.d_hrrGasOnly = hrrGasOnly;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtBoundaryFile() {
            return this.d_dtBoundaryFile;
        }

        public void setDtBoundaryFile(UnitDouble dtBoundaryFile) {
            this.d_dtBoundaryFile = dtBoundaryFile;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtDeviceFiles() {
            return this.d_dtDeviceFiles;
        }

        public void setDtDeviceFiles(UnitDouble dtDeviceFiles) {
            this.d_dtDeviceFiles = dtDeviceFiles;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtHeatReleaseRateFiles() {
            return this.d_dtHeatReleaseRateFiles;
        }

        public void setDtHeatReleaseRateFiles(UnitDouble dtHeatReleaseRateFiles) {
            this.d_dtHeatReleaseRateFiles = dtHeatReleaseRateFiles;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtIsofFiles() {
            return this.d_dtIsofFiles;
        }

        public void setDtIsofFiles(UnitDouble dtIsofFiles) {
            this.d_dtIsofFiles = dtIsofFiles;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtParticleFiles() {
            return this.d_dtParticleFiles;
        }

        public void setDtParticleFiles(UnitDouble dtParticleFiles) {
            this.d_dtParticleFiles = dtParticleFiles;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtRestartFile() {
            return this.d_dtRestartFile;
        }

        public void setDtRestartFile(UnitDouble dtRestartFile) {
            this.d_dtRestartFile = dtRestartFile;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtSliceFiles() {
            return this.d_dtSliceFiles;
        }

        public void setDtSliceFiles(UnitDouble dtSliceFiles) {
            this.d_dtSliceFiles = dtSliceFiles;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtSlice3dFiles() {
            return this.d_dtSlice3dFiles;
        }

        public void setDtSlice3dFiles(UnitDouble dtSlice3dFiles) {
            this.d_dtSlice3dFiles = dtSlice3dFiles;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtMassFiles() {
            return this.d_dtMassFiles;
        }

        public void setDtMassFiles(UnitDouble dtMassFiles) {
            this.d_dtMassFiles = dtMassFiles;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtPlot3dFile() {
            return this.d_dtPlot3dFile;
        }

        public void setDtPlot3dFile(UnitDouble dtPlot3dFile) {
            this.d_dtPlot3dFile = dtPlot3dFile;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtProfileDumpInterval() {
            return this.d_dtProfileDumpInterval;
        }

        public void setDtProfileDumpInterval(UnitDouble dtProfileDumpInterval) {
            this.d_dtProfileDumpInterval = dtProfileDumpInterval;
            this.changedEvt(new Object[0]);
        }

        public int getNumOutputFrames() {
            return this.d_numOutputFrames;
        }

        public void setNumOutputFrames(int numOutputFrames) {
            this.d_numOutputFrames = numOutputFrames;
            this.changedEvt(new Object[0]);
        }

        public boolean isVisualize3dSmoke() {
            return this.d_visualize3dSmoke;
        }

        public void setVisualize3dSmoke(boolean visualize3dSmoke) {
            this.d_visualize3dSmoke = visualize3dSmoke;
            this.changedEvt(new Object[0]);
        }

        public IQuantity getSmokeQuantity() {
            return this.d_smokeQuantity;
        }

        public void setSmokeQuantity(IQuantity msr) {
            this.d_smokeQuantity = msr;
            this.changedEvt(new Object[0]);
        }

        public static boolean isValidSmokeQuantity(Quantity msr) {
            return QuantityUtil.isSpecMassFraction(msr);
        }

        public static Predicate<Quantity> getSmokeQuantityFilter() {
            return new Predicate<Quantity>(){

                @Override
                public boolean test(Quantity o) {
                    return FileOutput.isValidSmokeQuantity(o);
                }
            };
        }

        public void convertPre28SpecToQuantity() {
            if (this.d_smokeSpec != null) {
                this.d_smokeQuantity = Quantity.SPEC_MASS_FRACTION.create(this.d_smokeSpec);
                this.d_smokeSpec = null;
            }
        }

        public boolean isWriteSpeciesMassFile() {
            return this.d_writeSpeciesMassFile;
        }

        public void setWriteSpeciesMassFile(boolean writeSpeciesMassFile) {
            this.d_writeSpeciesMassFile = writeSpeciesMassFile;
            this.changedEvt(new Object[0]);
        }

        @Override
        public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
            SmokeQuantReplacer repl = new SmokeQuantReplacer((PyroMod)this.getDomain());
            repl.removeInvalidReplacements(old, objs, this.d_smokeQuantity);
        }

        @Override
        public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
            SmokeQuantReplacer repl = new SmokeQuantReplacer((PyroMod)this.getDomain());
            return repl.taskReplaceDep(old, replacement, this.d_smokeQuantity);
        }

        @Override
        public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
            return EmptyTask.INSTANCE;
        }

        @Override
        public void takeDepSnapshot(DepList deps) {
            QuantityUtil.takeDepSnapshot(deps, DLink.WEAK, this.d_smokeQuantity);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (in instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)in).getVersion() < 86) {
                this.d_suppressDiagnostics = false;
            }
        }

        @Override
        public boolean isEquiv(Object obj) {
            return this == obj;
        }

        private class SmokeQuantReplacer
        extends QuantityReplacer {
            public SmokeQuantReplacer(PyroMod domain) {
                super(domain);
            }

            @Override
            protected boolean canReplaceQuant(IQuantity old, IQuantity repl) {
                return FileOutput.isValidSmokeQuantity(repl.get());
            }

            @Override
            protected Task taskReplaceQuant(IQuantity oldMsr, IQuantity newMsr) {
                return new AReplaceRefTask<IQuantity>((Object)oldMsr, (Object)newMsr){

                    @Override
                    protected void set(IQuantity obj) {
                        FileOutput.this.setSmokeQuantity(obj);
                    }
                };
            }
        }
    }

    public static class RadiationTransport
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final UnitDoubleVR TEMPERATURE_RANGE = UnitDoubleVR.above(0.0, SI.KELVIN, true);
        public static final IntVR ANGLE_NUM_RANGE = IntVR.above(0, true);
        public static final IntVR TIME_STEP_RANGE = IntVR.above(1, true);
        public static final IntVR ANGLE_INCREMENT_RANGE = IntVR.above(1, true);
        public static final DoubleVR RADIATIVE_FRACTION_RANGE = DoubleVR.between(0.0, 1.0, true, true);
        private boolean d_radiationOn = true;
        private int d_angleIncrement = 5;
        private UnitDouble d_constAbsorptionCoef = new UnitDouble(0.0, SI.METER.pow(-1));
        private int d_numPolarAngles = 15;
        private int d_numSolidAngles = 100;
        private UnitDouble d_radCalcPathLen = new UnitDouble(0.1, SI.METER);
        private UnitDouble d_assumedRadSourceTemp = new UnitDouble(900.0, SI.CELSIUS);
        private int d_timeStepInc = 3;
        private boolean d_nonGrayGasAssumption = false;
        private double d_radiativeLossFraction = 0.35;

        @Override
        public Object clone() {
            return super.clone();
        }

        @Override
        public boolean isEquiv(Object obj) {
            if (!(obj instanceof RadiationTransport)) {
                return false;
            }
            RadiationTransport radi = (RadiationTransport)obj;
            return this.d_radiationOn == radi.d_radiationOn && this.d_angleIncrement == radi.d_angleIncrement && this.d_constAbsorptionCoef.equals(radi.d_constAbsorptionCoef) && this.d_numPolarAngles == radi.d_numPolarAngles && this.d_numSolidAngles == radi.d_numSolidAngles && theUtil.equal(this.d_radCalcPathLen, radi.d_radCalcPathLen) && theUtil.equal(this.d_assumedRadSourceTemp, radi.d_assumedRadSourceTemp) && this.d_timeStepInc == radi.d_timeStepInc && this.d_nonGrayGasAssumption == radi.d_nonGrayGasAssumption;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof RadiationTransport)) {
                return false;
            }
            RadiationTransport radi = (RadiationTransport)obj;
            return this.d_radiationOn == radi.d_radiationOn && this.d_angleIncrement == radi.d_angleIncrement && this.d_constAbsorptionCoef.equals(radi.d_constAbsorptionCoef) && this.d_numPolarAngles == radi.d_numPolarAngles && this.d_numSolidAngles == radi.d_numSolidAngles && theUtil.equal(this.d_radCalcPathLen, radi.d_radCalcPathLen) && theUtil.equal(this.d_assumedRadSourceTemp, radi.d_assumedRadSourceTemp) && this.d_timeStepInc == radi.d_timeStepInc && this.d_nonGrayGasAssumption == radi.d_nonGrayGasAssumption;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.d_radCalcPathLen == null) {
                this.d_radCalcPathLen = new UnitDouble(0.1, SI.METER);
            }
        }

        public boolean isRadiationOn() {
            return this.d_radiationOn;
        }

        public void setRadiationOn(boolean radiationOn) {
            this.d_radiationOn = radiationOn;
            this.changedEvt(new Object[0]);
        }

        public int getAngleIncrement() {
            return this.d_angleIncrement;
        }

        public void setAngleIncrement(int angleIncrement) {
            this.d_angleIncrement = angleIncrement;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getConstAbsorptionCoef() {
            return this.d_constAbsorptionCoef;
        }

        public void setConstAbsorptionCoef(UnitDouble constAbsorptionCoef) {
            this.d_constAbsorptionCoef = constAbsorptionCoef;
            this.changedEvt(new Object[0]);
        }

        public int getNumPolarAngles() {
            return this.d_numPolarAngles;
        }

        public void setNumPolarAngles(int numPolarAngles) {
            this.d_numPolarAngles = numPolarAngles;
            this.changedEvt(new Object[0]);
        }

        public int getNumSolidAngles() {
            return this.d_numSolidAngles;
        }

        public void setNumSolidAngles(int numSolidAngles) {
            this.d_numSolidAngles = numSolidAngles;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getRadCalcPathLen() {
            return this.d_radCalcPathLen;
        }

        public void setRadCalcPathLen(UnitDouble radCalcPathLen) {
            this.d_radCalcPathLen = radCalcPathLen;
            this.changedEvt(new Object[0]);
        }

        @Deprecated
        public double getRadiativeLossFraction() {
            return this.d_radiativeLossFraction;
        }

        @Deprecated
        public void setRadiativeLossFraction(double radiativeLossFraction) {
            this.d_radiativeLossFraction = radiativeLossFraction;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getAssumedRadSourceTemp() {
            return this.d_assumedRadSourceTemp;
        }

        public void setAssumedRadSourceTemp(UnitDouble assumedRadSourceTemp) {
            this.d_assumedRadSourceTemp = assumedRadSourceTemp;
            this.changedEvt(new Object[0]);
        }

        public int getTimeStepInc() {
            return this.d_timeStepInc;
        }

        public void setTimeStepInc(int timeStepInc) {
            this.d_timeStepInc = timeStepInc;
            this.changedEvt(new Object[0]);
        }

        public boolean isNonGrayGasAssumption() {
            return this.d_nonGrayGasAssumption;
        }

        public void setNonGrayGasAssumption(boolean nonGrayGasAssumption) {
            this.d_nonGrayGasAssumption = nonGrayGasAssumption;
            this.changedEvt(new Object[0]);
        }
    }

    public static class Environment
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final UnitDoubleVR RELATIVE_HUMIDITY_RANGE = UnitDoubleVR.between(0.0, 100.0, NonSI.PERCENT, true, true);
        public static final UnitDoubleVR AMBIENT_PRESSURE_RANGE = UnitDoubleVR.above(0.0, SI.PASCAL, true);
        public static final UnitDoubleVR TEMPERATURE_RANGE = UnitDoubleVR.above(0.0, SI.KELVIN, true);
        public static final VariantProfile GRAVX_PROFILE = Environment.newGravProfile(0.0);
        public static final VariantProfile GRAVY_PROFILE = Environment.newGravProfile(0.0);
        public static final VariantProfile GRAVZ_PROFILE = Environment.newGravProfile(-9.81);
        private double d_relHumidity = 40.0;
        private UnitDouble d_ambTemp;
        private UnitDouble d_ambPressure;
        private UnitDouble d_ambMFO2;
        private UnitDouble d_ambMFCO2;
        @Deprecated
        private UnitDouble d_atmLapseRate;
        @Deprecated
        private UnitDouble d_groundLevel;
        private UnitDouble d_maxVis;
        private double d_visFactor;
        private Variant d_gravityX;
        private Variant d_gravityY;
        private Variant d_gravityZ;
        @Deprecated
        private UnitPoint3D d_ambVel;

        public Environment() {
            SIUS si = SIUS.getInstance();
            this.d_ambTemp = new UnitDouble(20.0, si.getTempUnit());
            this.d_ambPressure = new UnitDouble(101325.0, SI.PASCAL);
            this.d_ambMFO2 = new UnitDouble(0.232378, si.getMassFractionUnit());
            this.d_ambMFCO2 = new UnitDouble(5.95E-4, si.getMassFractionUnit());
            this.d_maxVis = new UnitDouble(30.0, si.getLengthUnit());
            this.d_visFactor = 3.0;
            this.d_gravityX = GRAVX_PROFILE.getDefault();
            this.d_gravityY = GRAVY_PROFILE.getDefault();
            this.d_gravityZ = GRAVZ_PROFILE.getDefault();
        }

        private static VariantProfile newGravProfile(double initVal) {
            return new VariantProfile(new ConstProfile(Intl.intl("Constant"), 6, SIUS.newud(initVal, 6)), new DefRampProfile(Intl.intl("From Table"), 6, DefRampProfile.Input.TIME, DefRampProfile.Input.XPOS));
        }

        @Override
        public Object clone() {
            return super.clone();
        }

        public UnitDouble getRelHumidity() {
            return new UnitDouble(this.d_relHumidity, NonSI.PERCENT);
        }

        public void setRelHumidity(UnitDouble relHumidity) {
            this.d_relHumidity = relHumidity.get(NonSI.PERCENT);
            this.changedEvt(new Object[0]);
        }

        public void setGravityAccel(Variant xVar, Variant yVar, Variant zVar) {
            this.d_gravityX = xVar;
            this.d_gravityY = yVar;
            this.d_gravityZ = zVar;
            this.changedEvt(new Object[0]);
        }

        public Variant getGravityX() {
            return this.d_gravityX;
        }

        public Variant getGravityY() {
            return this.d_gravityY;
        }

        public Variant getGravityZ() {
            return this.d_gravityZ;
        }

        public UnitDouble getAmbPressure() {
            return this.d_ambPressure;
        }

        public void setAmbPressure(UnitDouble ambPressure) {
            this.d_ambPressure = ambPressure;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getAmbTemp() {
            return this.d_ambTemp;
        }

        public void setAmbTemp(UnitDouble ambTemp) {
            this.d_ambTemp = ambTemp;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getAmbMFO2() {
            return this.d_ambMFO2;
        }

        public void setAmbMFO2(UnitDouble ambMFO2) {
            this.d_ambMFO2 = ambMFO2;
        }

        public UnitDouble getAmbMFCO2() {
            return this.d_ambMFCO2;
        }

        public void setAmbMFCO2(UnitDouble ambMFCO2) {
            this.d_ambMFCO2 = ambMFCO2;
        }

        public UnitDouble getMaxVisibility() {
            return this.d_maxVis;
        }

        public void setMaxVisibility(UnitDouble maxVis) {
            this.d_maxVis = maxVis;
        }

        public double getVisibilityFactor() {
            return this.d_visFactor;
        }

        public void setVisibilityFactor(double visFactor) {
            this.d_visFactor = visFactor;
        }

        @Override
        public boolean isEquiv(Object obj) {
            return this == obj;
        }
    }

    public static class Calculations
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final DoubleVR SC_RANGE = DoubleVR.UNBOUNDED;
        public static final DoubleVR PR_RANGE = DoubleVR.UNBOUNDED;
        public static final DoubleVR CSMAG_RANGE = DoubleVR.UNBOUNDED;
        private SimulationMode d_simMode = SimulationMode.VLES;
        private BaroclinicState d_baroclinic = BaroclinicState.AUTO;
        private double d_cflMin = 0.8;
        private double d_cflMax = 1.0;
        private double d_vnMin = 0.8;
        private double d_vnMax = 1.0;
        private double d_csmag = 0.2;
        private double d_prandtlNum = 0.5;
        private double d_schmidtNum = 0.5;
        private double d_initUnmixedFraction = 1.0;
        @Deprecated
        private boolean d_calcDNS = false;
        @Deprecated
        private boolean d_correctBaroclinicTorque = true;

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            if (!(stream instanceof PyroSimObjectInputStream)) {
                return;
            }
            PyroSimObjectInputStream ps = (PyroSimObjectInputStream)stream;
            if (ps.getVersion() < 55) {
                this.d_initUnmixedFraction = 1.0;
            }
            if (ps.getVersion() < 123) {
                if (this.d_calcDNS) {
                    this.d_simMode = SimulationMode.DNS;
                    this.d_baroclinic = BaroclinicState.AUTO;
                } else {
                    this.d_simMode = SimulationMode.VLES;
                    this.d_baroclinic = this.d_correctBaroclinicTorque ? BaroclinicState.AUTO : BaroclinicState.FALSE;
                }
            }
        }

        @Override
        public Object clone() {
            return super.clone();
        }

        @Deprecated
        public boolean calcDNS() {
            return this.d_calcDNS;
        }

        @Deprecated
        public void setCalcDNS(boolean calcDNS) {
            this.d_calcDNS = calcDNS;
            this.changedEvt(new Object[0]);
        }

        public SimulationMode getSimMode() {
            return this.d_simMode;
        }

        public void setSimMode(SimulationMode mode) {
            this.d_simMode = mode;
        }

        public double[] getCflRange() {
            return new double[]{this.d_cflMin, this.d_cflMax};
        }

        public void setCflRange(double cflMin, double cflMax) {
            this.d_cflMin = cflMin;
            this.d_cflMax = cflMax;
            this.changedEvt(new Object[0]);
        }

        public BaroclinicState getBaroclinicState() {
            return this.d_baroclinic;
        }

        public void setBaroclinicState(BaroclinicState baroclinic) {
            this.d_baroclinic = baroclinic;
            this.changedEvt(new Object[0]);
        }

        @Deprecated
        public boolean isCorrectBaroclinicTorque() {
            return this.d_correctBaroclinicTorque;
        }

        @Deprecated
        public void setCorrectBaroclinicTorque(boolean correctBaroclinicTorque) {
            this.d_correctBaroclinicTorque = correctBaroclinicTorque;
            this.changedEvt(new Object[0]);
        }

        public double getCsmag() {
            return this.d_csmag;
        }

        public void setCsmag(double csmag) {
            this.d_csmag = csmag;
            this.changedEvt(new Object[0]);
        }

        public double getPrandtlNum() {
            return this.d_prandtlNum;
        }

        public void setPrandtlNum(double prandtlNum) {
            this.d_prandtlNum = prandtlNum;
            this.changedEvt(new Object[0]);
        }

        public double getSchmidtNum() {
            return this.d_schmidtNum;
        }

        public void setSchmidtNum(double schmidtNum) {
            this.d_schmidtNum = schmidtNum;
            this.changedEvt(new Object[0]);
        }

        public double getInitUnmixedFraction() {
            return this.d_initUnmixedFraction;
        }

        public void setInitUnmixedFraction(double initUnmixedFraction) {
            this.d_initUnmixedFraction = initUnmixedFraction;
            this.changedEvt(new Object[0]);
        }

        public double[] getVnRange() {
            return new double[]{this.d_vnMin, this.d_vnMax};
        }

        public void setVnRange(double vnMin, double vnMax) {
            this.d_vnMin = vnMin;
            this.d_vnMax = vnMax;
            this.changedEvt(new Object[0]);
        }

        @Override
        public boolean isEquiv(Object obj) {
            return this == obj;
        }

        public static enum BaroclinicState {
            AUTO(Intl.intl("AUTO")),
            TRUE(Intl.intl("TRUE")),
            FALSE(Intl.intl("FALSE"));

            public final String displayName;

            private BaroclinicState(String displayName) {
                this.displayName = displayName;
            }

            public boolean getFDSRepresentation(SimulationMode mode) {
                if (this.equals((Object)TRUE)) {
                    return true;
                }
                if (this.equals((Object)FALSE)) {
                    return false;
                }
                return mode.baroclinic;
            }
        }

        public static enum SimulationMode {
            DNS("DNS", Intl.intl("Direct Numerical"), true, 1, true, false, 10, true),
            LES("LES", Intl.intl("Large-Eddy"), true, 2, true, false, 10, true),
            VLES("VLES", Intl.intl("Very Large-Eddy"), true, 0, true, false, 10, false),
            SVLES("SVLES", Intl.intl("Simple Very Large-Eddy"), false, 3, false, true, 3, false);

            public final String simpleName;
            public final String detailName;
            public final boolean baroclinic;
            public final boolean checkVN;
            public final boolean constSpecHeatRatio;
            public final boolean projection;
            public final int clfVelNorm;
            public final int maxPressureIter;

            private SimulationMode(String simpleName, String detailName, boolean baroclinic, int cflVelNorm, boolean checkVN, boolean constSpecHeatRatio, int maxPressureIter, boolean projection) {
                this.simpleName = simpleName;
                this.detailName = detailName;
                this.baroclinic = baroclinic;
                this.clfVelNorm = cflVelNorm;
                this.checkVN = checkVN;
                this.constSpecHeatRatio = constSpecHeatRatio;
                this.maxPressureIter = maxPressureIter;
                this.projection = projection;
            }

            public String getDisplayName() {
                return String.format(Intl.intl("%s (%s)"), this.detailName, this.simpleName);
            }
        }
    }

    public static class Time
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final UnitDoubleVR TIME_STEP_RANGE = UnitDoubleVR.above(0.0, SIUS.getInstance().getTimeUnit(), false);
        public static final IntVR WALL_INC_RANGE = IntVR.above(1, true);
        private UnitDouble d_startTime = new UnitDouble(0.0, SI.SECOND);
        private UnitDouble d_stopTime = new UnitDouble(10.0, SI.SECOND);
        private UnitDouble d_dt = null;
        @Deprecated
        private UnitDouble d_dtHvac = null;
        private int d_wallIncrement = 2;
        private boolean d_lockTimeStep = false;
        private boolean d_restrictTimeStep = true;
        private Map<String, Object> d_evacProps = Time.initEvacProps();

        @Override
        public Object clone() {
            Time clone = (Time)super.clone();
            clone.d_evacProps = new HashMap<String, Object>(this.d_evacProps);
            return clone;
        }

        public static Map<String, Object> initEvacProps() {
            HashMap<String, Object> evacProps = new HashMap<String, Object>();
            evacProps.put("EVAC_DT_FLOWFIELD", new UnitDouble(0.01, SI.SECOND));
            evacProps.put("EVAC_DT_STEADY_STATE", new UnitDouble(0.05, SI.SECOND));
            return evacProps;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (in instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)in).getVersion() < 31) {
                this.d_restrictTimeStep = true;
                this.d_evacProps = Time.initEvacProps();
            }
            if (in instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)in).getVersion() < 86) {
                this.d_dtHvac = null;
            }
        }

        public void setTimeStepLocks(boolean lock, boolean restrict) {
            this.d_lockTimeStep = lock;
            this.d_restrictTimeStep = restrict;
            this.changedEvt(new Object[0]);
        }

        public boolean lockTimeSteps() {
            return this.d_lockTimeStep;
        }

        public boolean restrictTimeSteps() {
            return this.d_restrictTimeStep;
        }

        public int getWallIncrement() {
            return this.d_wallIncrement;
        }

        public void setWallIncrement(int wallIncrement) {
            this.d_wallIncrement = wallIncrement;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getStartTime() {
            return this.d_startTime;
        }

        public void setStartTime(UnitDouble startTime) {
            this.d_startTime = startTime;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getStopTime() {
            return this.d_stopTime;
        }

        public void setStopTime(UnitDouble stopTime) {
            this.d_stopTime = stopTime;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getInitTimeStep() {
            return this.d_dt;
        }

        public void setInitTimeStep(UnitDouble timeStep) {
            this.d_dt = timeStep;
            this.changedEvt(new Object[0]);
        }

        @Deprecated
        public UnitDouble getHvacTimeStep() {
            return this.d_dtHvac;
        }

        @Deprecated
        public void setHvacTimeStep(UnitDouble timeStep) {
            this.d_dtHvac = timeStep;
            this.changedEvt(new Object[0]);
        }

        public void setEvacProps(Map<String, Object> props) {
            this.d_evacProps = props;
        }

        public void setEvacProp(String key, Object prop) {
            if (this.d_evacProps.get(key) != prop) {
                this.d_evacProps.put(key, prop);
                this.changedEvt(new Object[0]);
            }
        }

        public Object getEvacProp(String key) {
            return this.d_evacProps.get(key);
        }

        public Map<String, Object> getEvacProps() {
            return this.d_evacProps;
        }

        @Override
        public boolean isEquiv(Object obj) {
            return this == obj;
        }
    }
}

