/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.output.AMeasurementSet;
import pyrosim.gui.actions.Actions;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.thunderheadeng.util.Warning;
import pyrosim.mv.ModelView;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.util.WarningReport;

public class OpenModel {
    public static final int SUCCEEDED = 0;
    public static final int CANCELLED = 1;
    public static final int TOO_OLD = 2;
    public static final int TOO_NEW = 3;
    public static final int FAILED = 4;
    public static final int UNSUPPORTED = 5;
    public static final int NO_EXIST = 6;

    private static InputStream createFileStream(File f) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(f));
    }

    public static int openModel(pyrosim.PyroMod pyroMod, File f, boolean showWarnings, Callbacks cb) {
        System.out.println(String.format("Opening file: %s", f.getPath()));
        if (!f.exists()) {
            return 6;
        }
        try {
            String[] infoDescriptions = new String[]{Intl.intl("Record"), Intl.intl("Action")};
            WarningReport<thunderheadeng.util.Warning> warnings = new WarningReport<thunderheadeng.util.Warning>(thunderheadeng.util.Warning.class, thunderheadeng.util.Warning.getWarningInfoTypes(), infoDescriptions, 0);
            int result = OpenModel.openCurrentModel(pyroMod, OpenModel.createFileStream(f), f, warnings, showWarnings, cb);
            if (result == 2 && (result = OpenModel.openLegacyModel_2012_1(pyroMod, OpenModel.createFileStream(f), f, warnings, showWarnings, cb)) == 2) {
                result = OpenModel.openLegacyModel_2006_2(pyroMod, OpenModel.createFileStream(f), f, warnings, showWarnings, cb);
            }
            if (!warnings.isEmpty()) {
                if (showWarnings) {
                    WarningDlg<thunderheadeng.util.Warning> warnDlg = new WarningDlg<thunderheadeng.util.Warning>((Window)PyroSim.getApp().getActiveFrame(), Intl.intl("File Conversion Warnings"), Intl.intl("Please review the following items in your updated model to verify proper conversion."), warnings);
                    warnDlg.doModal();
                } else {
                    System.out.println("Warnings:\n" + warnings.prepareReport());
                }
            }
            return result;
        }
        catch (Throwable t) {
            cb.setError(t);
            System.err.println(t.getMessage());
            if (t instanceof NullPointerException) {
                t.printStackTrace();
            }
            return 4;
        }
    }

    private static int openCurrentModel(pyrosim.PyroMod pyroMod, InputStream psmInputStream, File file, WarningReport warnings, boolean showWarnings, Callbacks cb) throws Throwable {
        ObjectInputStream ois = null;
        try {
            ois = new PyroSimObjectInputStream(psmInputStream, false, Optional.of(file));
            if (!((PyroSimObjectInputStream)ois).canOpenVersion()) {
                int n = 2;
                return n;
            }
            if (((PyroSimObjectInputStream)ois).isNewer()) {
                int n = 3;
                return n;
            }
            if (!((PyroSimObjectInputStream)ois).isSupported() && !cb.confirmOpenUnsupported(((PyroSimObjectInputStream)ois).getVersion())) {
                int n = 5;
                return n;
            }
            pyroMod.openModel((PyroSimObjectInputStream)ois, !showWarnings);
            OpenModel.postRead(ois, ((PyroSimObjectInputStream)ois).getVersion(), cb);
            int n = 0;
            return n;
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private static int openLegacyModel_2006_2(pyrosim.PyroMod pyroMod, InputStream psmInputStream, File f, WarningReport warnings, boolean showWarnings, Callbacks cb) throws Throwable {
        pyrosim.legacy_2006_2.PyroSimObjectInputStream ois = null;
        try {
            ois = new pyrosim.legacy_2006_2.PyroSimObjectInputStream(psmInputStream);
            if (!ois.canOpenVersion()) {
                int n = 3;
                return n;
            }
            if (!cb.doBackup()) {
                int n = 1;
                return n;
            }
            System.out.println("Reading legacy 2006.2 file...");
            pyrosim.legacy_2006_2.PyroMod data = new pyrosim.legacy_2006_2.PyroMod();
            data.openModel(ois, showWarnings);
            System.out.println("Converting legacy 2006.2 file...");
            File dbDir = null;
            if (Application.getApp() != null) {
                dbDir = new File(Application.getApp().getInstallDir(), "fds");
            }
            for (thunderheadeng.util.Warning warn : ois.getWarnings().getWarnings()) {
                warnings.addWarning(warn);
            }
            pyroMod.fromLegacy(f, dbDir, data, (WarningReport<thunderheadeng.util.Warning>)warnings);
            OpenModel.postRead(ois, ois.getVersion(), cb);
            int n = 0;
            return n;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private static int openLegacyModel_2012_1(pyrosim.PyroMod pyroMod, InputStream psmInputStream, File file, WarningReport warnings, boolean showWarnings, Callbacks cb) throws Throwable {
        ObjectInputStream ois = null;
        try {
            HashSet<String> appearanceNames = new HashSet<String>();
            for (Material mat : pyroMod.getAppearances().flatten()) {
                appearanceNames.add(mat.getName());
            }
            ois = new pyrosim.legacy_2012_1.io.PyroSimObjectInputStream(psmInputStream, appearanceNames);
            if (!((pyrosim.legacy_2012_1.io.PyroSimObjectInputStream)ois).canOpenVersion()) {
                int n = 2;
                return n;
            }
            if (((pyrosim.legacy_2012_1.io.PyroSimObjectInputStream)ois).isNewer()) {
                int n = 3;
                return n;
            }
            if (!cb.doBackup()) {
                int n = 1;
                return n;
            }
            System.out.println("Reading legacy 2012.1 file...");
            PyroMod data = new PyroMod();
            data.openModel((pyrosim.legacy_2012_1.io.PyroSimObjectInputStream)ois, !showWarnings);
            for (Warning warn : ((pyrosim.legacy_2012_1.io.PyroSimObjectInputStream)ois).getWarnings().getWarnings()) {
                warnings.addWarning(new thunderheadeng.util.Warning(warn.getWarning(), warn.getActionTaken()));
            }
            System.out.println("Converting legacy 2012.1 file...");
            File dbDir = Application.getApp() != null ? new File(Application.getApp().getInstallDir(), "fds") : null;
            pyrosim.PyroMod tempMod = new pyrosim.PyroMod(false);
            tempMod.fromLegacy(file, dbDir, data, (WarningReport<thunderheadeng.util.Warning>)warnings);
            OpenModel.validateDisabledStatus(tempMod, warnings);
            pyroMod.setSerialized(tempMod);
            OpenModel.postRead(ois, ((pyrosim.legacy_2012_1.io.PyroSimObjectInputStream)ois).getVersion(), cb);
            int n = 0;
            return n;
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private static void validateDisabledStatus(pyrosim.PyroMod pyMod, WarningReport warnings) {
        Predicate<IPyroObject> disabledOnly = new Predicate<IPyroObject>(){

            @Override
            public boolean test(IPyroObject o) {
                return !o.isEnabled() && !(o instanceof AMeasurementSet);
            }
        };
        Collection<IPyroObject> disabledObjs = Hierarchy.flatten(pyMod.getMembers(), IPyroObject.class, disabledOnly);
        DepSnapshot deps = pyMod.getDependencies(new IPyroObject[0]);
        for (IPyroObject obj : disabledObjs) {
            if (!Actions.isObjectInUse(pyMod, Arrays.asList(obj), deps)) continue;
            String helpfulName = obj instanceof NamedPyroObject ? "\"" + ((NamedPyroObject)obj).getName() + "\"" : "" + obj.hashCode();
            String msg = String.format(Intl.intl("%s: %s is disabled, but is also in use."), obj.getClass().getSimpleName(), helpfulName);
            warnings.addWarning(new thunderheadeng.util.Warning(msg, Intl.intl("Object enabled.")));
            obj.setEnabled(true);
        }
    }

    private static void postRead(ObjectInputStream ois, int ver, Callbacks cb) throws IOException, ClassNotFoundException {
        if (ver >= 7) {
            double snapSpacing = ois.readDouble();
            cb.setSnapToSpacing(snapSpacing);
        }
        boolean showBgImagesIsSelected = true;
        if (ver >= 11) {
            showBgImagesIsSelected = ois.readBoolean();
        }
        cb.setShowBgImagesSelected(showBgImagesIsSelected);
        int snapper = 1;
        if (ver >= 18 && ois instanceof pyrosim.legacy_2006_2.PyroSimObjectInputStream) {
            pyrosim.legacy_2006_2.domain.Grid snappingGrid = (pyrosim.legacy_2006_2.domain.Grid)ois.readObject();
            int n = snapper = snappingGrid == null ? 1 : 2;
        }
        if (ver > 19) {
            Grid legGrid;
            snapper = ois instanceof pyrosim.legacy_2012_1.io.PyroSimObjectInputStream && ((pyrosim.legacy_2012_1.io.PyroSimObjectInputStream)ois).getVersion() < 29 ? ((legGrid = (Grid)ois.readObject()) == null ? 1 : 2) : ois.readInt();
        }
        cb.setActiveSnapper(snapper);
        ModelView.ModelViewFilterProps mvFilters = new ModelView.ModelViewFilterProps();
        if (ver > 92 && ois instanceof PyroSimObjectInputStream) {
            mvFilters = (ModelView.ModelViewFilterProps)ois.readObject();
        }
        if (ver < 137) {
            // empty if block
        }
        cb.setModelViewFilters(mvFilters);
    }

    public static interface Callbacks {
        public void setError(Throwable var1);

        public boolean doBackup();

        public void setSnapToSpacing(double var1);

        public void setShowBgImagesSelected(boolean var1);

        public void setActiveSnapper(int var1);

        public void setModelViewFilters(ModelView.ModelViewFilterProps var1);

        public boolean confirmOpenUnsupported(int var1);
    }
}

