/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.registry;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import sun.rmi.registry.RegistryImpl;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.UnicastRef2;
import sun.rmi.server.Util;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.tcp.TCPEndpoint;

public final class LocateRegistry {
    private LocateRegistry() {
    }

    public static Registry getRegistry() throws RemoteException {
        return LocateRegistry.getRegistry(null, 1099);
    }

    public static Registry getRegistry(int n) throws RemoteException {
        return LocateRegistry.getRegistry(null, n);
    }

    public static Registry getRegistry(String string) throws RemoteException {
        return LocateRegistry.getRegistry(string, 1099);
    }

    public static Registry getRegistry(String string, int n) throws RemoteException {
        return LocateRegistry.getRegistry(string, n, null);
    }

    public static Registry getRegistry(String string, int n, RMIClientSocketFactory rMIClientSocketFactory) throws RemoteException {
        Object var3_3 = null;
        if (n <= 0) {
            n = 1099;
        }
        if (string == null || string.length() == 0) {
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                string = "";
            }
        }
        LiveRef liveRef = new LiveRef(new ObjID(0), new TCPEndpoint(string, n, rMIClientSocketFactory, null), false);
        UnicastRef unicastRef = rMIClientSocketFactory == null ? new UnicastRef(liveRef) : new UnicastRef2(liveRef);
        return (Registry)Util.createProxy(RegistryImpl.class, unicastRef, false);
    }

    public static Registry createRegistry(int n) throws RemoteException {
        return new RegistryImpl(n);
    }

    public static Registry createRegistry(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        return new RegistryImpl(n, rMIClientSocketFactory, rMIServerSocketFactory);
    }
}

