/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.treeview;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Semaphore;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.treeview.PyroTreeModel;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;

public class PyroTreeSelectionHandler
implements TreeSelectionListener {
    private final PyroMod d_pyMod;
    private final TreeSelectionModel d_tsm;
    private final PyroTreeModel d_ptm;
    private final Semaphore d_sema;

    public PyroTreeSelectionHandler(PyroMod mediator, TreeSelectionModel tsm, PyroTreeModel ptm) {
        this.d_pyMod = mediator;
        this.d_tsm = tsm;
        this.d_ptm = ptm;
        this.d_sema = new Semaphore(1);
        tsm.addTreeSelectionListener(this);
    }

    public boolean lock() {
        return this.d_sema.tryAcquire();
    }

    public void unlock() {
        this.d_sema.release();
    }

    private boolean containsSelEvents(Events events) {
        for (EventChannel<Object> channel : events.getAffectedChannels(Object.class, new Class[0])) {
            if (!channel.hasAddedObjs() && !channel.hasRemovedObjs() && !channel.containsChange(PyroMod.EVT_SEL) && !channel.containsChange(PyroMod.EVT_MODEL_CHANGED)) continue;
            return true;
        }
        return false;
    }

    public void preUpdate(Events events) {
        if (!this.containsSelEvents(events) || !this.lock()) {
            return;
        }
        this.d_tsm.clearSelection();
        this.unlock();
    }

    public void update(Events events) {
        if (!this.containsSelEvents(events) || !this.lock()) {
            return;
        }
        Set<?> sel = this.d_pyMod.getSelectionModel().getSelection();
        ArrayList<TreePath> newSel = new ArrayList<TreePath>(sel.size());
        for (Object o : sel) {
            TreePath path = this.d_ptm.pathForObject(o);
            if (path == null) continue;
            newSel.add(path);
        }
        this.d_tsm.setSelectionPaths(newSel.toArray(new TreePath[newSel.size()]));
        this.unlock();
    }

    private boolean objectInModel(Object obj) {
        TVEntryPoint<Object> ep = TVEntryPoints.ep(obj);
        if (ep == null) {
            return false;
        }
        return ep.objectInModel(this.d_pyMod, obj);
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        Object treeObj;
        int i;
        if (this.d_ptm.isDragging()) {
            return;
        }
        if (!this.lock()) {
            return;
        }
        TreePath[] changedNodes = evt.getPaths();
        if (changedNodes.length == 0) {
            this.unlock();
            return;
        }
        if (!this.objectInModel(changedNodes[0].getLastPathComponent())) {
            this.d_tsm.clearSelection();
            this.unlock();
            return;
        }
        this.d_pyMod.pauseUpdates();
        for (i = 0; i < changedNodes.length; ++i) {
            assert (changedNodes[i] != null);
            treeObj = changedNodes[i].getLastPathComponent();
            if (evt.isAddedPath(i)) continue;
            if (treeObj instanceof IPyroObject) {
                if (this.objectsParentIsSelected((IPyroObject)treeObj)) continue;
                this.d_pyMod.getSelectionModel().deselect(treeObj);
                continue;
            }
            this.d_pyMod.getSelectionModel().deselect(treeObj);
        }
        for (i = 0; i < changedNodes.length; ++i) {
            assert (changedNodes[i] != null);
            treeObj = changedNodes[i].getLastPathComponent();
            if (!evt.isAddedPath(i)) continue;
            this.d_pyMod.getSelectionModel().select(treeObj);
        }
        this.d_pyMod.resumeUpdates();
        this.unlock();
    }

    private boolean objectsParentIsSelected(IPyroObject obj) {
        IPyroObject parent = obj.getParent();
        if (parent == null) {
            return false;
        }
        return this.d_pyMod.getSelectionModel().isSelected(parent);
    }
}

