/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.treeview;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import pyrosim.PyroMod;
import pyrosim.treeview.PyroTreeCellRenderer;
import pyrosim.treeview.PyroTreeModel;
import pyrosim.treeview.PyroTreeView;
import pyrosim.treeview.TVEntryPoint;

public class PyroTreeCellEditor
extends DefaultTreeCellEditor
implements TreeCellEditor {
    private final PyroMod d_mediator;
    private Object d_curVal;

    public PyroTreeCellEditor(PyroMod domain, PyroTreeView tree, PyroTreeCellRenderer ren) {
        super(tree, ren);
        this.d_mediator = domain;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        TVEntryPoint<Object> ep = ((PyroTreeModel)tree.getModel()).ep(value);
        if (ep == null) {
            return null;
        }
        String name = ep.getName(value);
        Component c = super.getTreeCellEditorComponent(tree, name, isSelected, expanded, leaf, row);
        Icon[] icons = ep.getIcons(this.d_mediator, value);
        this.editingIcon = !c.isEnabled() && icons[1] != null ? icons[1] : icons[0];
        return c;
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        PyroTreeView t = (PyroTreeView)this.tree;
        if (t.getSelectionCount() != 1) {
            return false;
        }
        Object sel = t.getSelectionPath().getLastPathComponent();
        TVEntryPoint<Object> ep = ((PyroTreeModel)t.getModel()).ep(sel);
        return super.isCellEditable(evt) && ep != null && ep.canRename(this.d_mediator, sel);
    }

    private Object objectFor(EventObject evt) {
        MouseEvent mEvt;
        TreePath hitPath;
        if (evt instanceof MouseEvent && (hitPath = this.tree.getPathForLocation((mEvt = (MouseEvent)evt).getX(), mEvt.getY())) != null) {
            return hitPath.getLastPathComponent();
        }
        return null;
    }
}

