/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JMenu;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.gui.MenuBuilder;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.mv.gui.ColorUtil;
import pyrosim.mv.tools.DrawProps;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.Util;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.ColorIcon;
import thunderheadeng.gui.colorscheme.ColorHistory;
import thunderheadeng.gui.colorscheme.SimpleColorChooser;
import thunderheadeng.gui.guiAction;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public class ToolUtil {
    public static void addSurfSubmenu(PyroMod domain, DrawProps props, Predicate<Surface> surfFilter, MenuBuilder builder) {
        IFilteredCollection<Surface> surfs = theUtil.filter(domain.getSurfaceMgr().flatten(), surfFilter);
        List<Surface> sortedSurfs = Util.sort(surfs);
        ArrayList<SurfaceAction> surfActions = new ArrayList<SurfaceAction>();
        for (Surface surf : sortedSurfs) {
            surfActions.add(new SurfaceAction(domain, props, surf));
        }
        JMenu surfMenu = new JMenu(Intl.intl("Surface"));
        PyroGuiUtil.addMEMenuItems(surfMenu, surfActions);
        builder.add(surfMenu);
    }

    public static void addColorSubmenu(PyroMod domain, DrawProps props, MenuBuilder builder) {
        int historySize = 5;
        JMenu colorMenu = new JMenu(Intl.intl("Color"));
        ArrayList<ColorAction> colorActions = new ArrayList<ColorAction>();
        colorActions.add(new ColorAction(props, null));
        Color currColor = props.get(DrawProps.COLOR);
        if (currColor != null) {
            colorActions.add(new ColorAction(props, currColor));
        }
        ArrayList<Color> history = new ArrayList<Color>(ColorHistory.get());
        history.remove(currColor);
        int numColors = Math.min(history.size(), 5);
        for (int m = history.size() - 1; m >= history.size() - numColors; --m) {
            colorActions.add(new ColorAction(props, (Color)history.get(m)));
        }
        PyroGuiUtil.addMEMenuItems(colorMenu, colorActions);
        colorMenu.addSeparator();
        colorMenu.add(new ChooseColorAction(props));
        builder.add(colorMenu);
    }

    public static <T extends Enum<T>> T nextVal(T currVal) {
        Enum[] all = (Enum[])currVal.getDeclaringClass().getEnumConstants();
        return (T)all[(currVal.ordinal() + 1) % all.length];
    }

    public static class ChooseColorAction
    extends guiAction {
        private static final long serialVersionUID = 2128157030543995315L;
        private final DrawProps d_props;

        public ChooseColorAction(DrawProps props) {
            super(Intl.intl("Choose..."));
            this.d_props = props;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleColorChooser chooser = new SimpleColorChooser((Window)PyroSim.getApp().getActiveFrame(), Intl.intl("Choose Color"), 0);
            Color defColor = this.d_props.get(DrawProps.COLOR);
            if (defColor != null) {
                chooser.setColor(defColor);
            }
            if (chooser.doModal() == 1) {
                this.d_props.set(DrawProps.COLOR, chooser.getColor());
                this.d_props.fireStateChanged();
            }
        }
    }

    public static class ColorAction
    extends BooleanAction {
        private static final long serialVersionUID = 6873831908343298640L;
        private final DrawProps d_props;
        private final Color d_color;

        public ColorAction(DrawProps props, Color color) {
            super(ColorUtil.format(color), theUtil.equal(props.get(DrawProps.COLOR), color), color != null ? new ColorIcon(color, 16, 16, 3) : null);
            this.d_props = props;
            this.d_color = color;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                this.d_props.set(DrawProps.COLOR, this.d_color);
                this.d_props.fireStateChanged();
            }
        }
    }

    public static class SurfaceAction
    extends BooleanAction {
        private static final long serialVersionUID = 686439224217139673L;
        private final DrawProps d_props;
        private final Surface d_surf;

        public SurfaceAction(PyroMod domain, DrawProps props, Surface surf) {
            super(surf.getName(), props.get(DrawProps.SURFACE) == surf, TVEntryPoints.ep(surf).getIcons(domain, surf)[0]);
            this.setDisabledIcon(TVEntryPoints.ep(surf).getIcons(domain, surf)[1]);
            this.d_surf = surf;
            this.d_props = props;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                this.d_props.set(DrawProps.SURFACE, this.d_surf);
                this.d_props.fireStateChanged();
            }
        }
    }
}

