/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.mv.ModelView;
import pyrosim.mv.manip.TransformMgr;
import pyrosim.mv.tools.ATransformTool;
import pyrosim.mv.tools.DrawProps;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.tools.MouseHistory;

public class MirrorTool
extends ATransformTool {
    public MirrorTool(ModelView mv, TransformMgr xformMgr, ModelScene toolScene, DrawProps props) {
        super(mv, xformMgr, toolScene, props);
    }

    protected ITransform getXform(Point3d p1, Point3d p2) {
        Plane3d workingPlane = this.getWorkingPlane();
        Vector3d u = workingPlane.getNormal();
        Vector3d v = Util3D.vector(p1, p2);
        Vector3d normal = Util3D.cross(u, v);
        normal.normalize();
        Plane3d plane = new Plane3d(normal, p1);
        return TransformUtil.mirror(plane);
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
        TransformInfo ti;
        List<Point3d> points = history.getAllPoints();
        ArrayList<APrimitive> geoms = new ArrayList<APrimitive>();
        PropsBuilder props = new PropsBuilder();
        if (points.size() > 1) {
            Vector3d dir = Util3D.vector(points.get(0), points.get(1));
            Point3d p1 = this.projectToFrustum(points.get(0), dir);
            dir.negate();
            Point3d p2 = this.projectToFrustum(points.get(0), dir);
            geoms.add(new LineSeg(p1, p2));
            props.add(new IPrimProps.Edge(Color.RED, 3.0, IPrimProps.DEF_STIPPLE, 0));
            geoms.add(new Point(points.get(1)));
            props.add(new IPrimProps.Vertex(Color.RED, 10.0));
        }
        if (points.size() > 0) {
            geoms.add(new Point(points.get(0)));
            props.add(new IPrimProps.Vertex(Color.RED, 10.0));
        }
        this.updateToolDisplay(GeomNodeUtil.newNode(new GeomGroup(geoms)), props.finalizeProps());
        ITransform newXform = TransformUtil.IDENTITY;
        if (points.size() > 1 && (ti = this.getXform(points.get(0), points.get(1)).getInfo()).isAccepted(this.getXformMgr().getDOF())) {
            newXform = ti.xform;
        }
        this.getXformMgr().modify(newXform);
        if (history.committedSize() == 2) {
            this.finish();
        }
        this.repaintSurface();
    }
}

