/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.gui.MenuBuilder;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HoverWindow;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.gui.guiAction;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.units.UnitDouble;

public class MeasureTool
extends ADrawTool {
    private MeasureWindow d_popupWindow;

    public MeasureTool(IToolController mv, DrawProps toolProps) {
        super(mv, toolProps, DrawProps.GeomSpace.S1D);
        this.setSnapInfo(SnapMode.ANY, null);
        this.getClickHistory().setDuplicatesAllowed(true);
    }

    @Override
    protected boolean getSnapToWorkingPlane() {
        return false;
    }

    protected MeasureWindow getPopupWindow() {
        if (this.d_popupWindow == null) {
            this.d_popupWindow = new MeasureWindow();
        }
        return this.d_popupWindow;
    }

    @Override
    public Class<? extends IGeom> getGeomType() {
        return IGeom.class;
    }

    @Override
    protected void initValueEditor(ValueEditor editor) {
    }

    @Override
    public void activate() {
        super.activate();
        this.getPopupWindow().attach();
    }

    @Override
    public void deactivate() {
        this.getPopupWindow().detach();
        super.deactivate();
    }

    @Override
    public Point3d getAngledSnapBasis() {
        return this.getClickHistory().getLastCommitted();
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
        this.getPopupWindow().update(history);
        if (p.committed && p.dragged && history.committedSize() == 2) {
            int option;
            double dist = this.getLastSegDist(this.getClickHistory().getCommittedPoints());
            if (dist > 0.0 && (option = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this.getAttachedComponent()), Intl.intl("Would you like to copy the distance to the clipboard?"), Intl.intl("Copy to Clipboard?"), 0)) == 0) {
                this.copyToClipboard(dist);
            }
            this.finish();
        } else {
            this.updateDisplay();
            this.repaintSurface();
        }
    }

    protected void updateDisplay() {
        ArrayList<LineSeg> geoms = new ArrayList<LineSeg>();
        PropsBuilder props = new PropsBuilder();
        IPrimProps.Edge eprops = new IPrimProps.Edge(Color.GREEN, 3.0, IPrimProps.DEF_STIPPLE, 0);
        List<Point3d> points = this.getClickHistory().getAllPoints();
        for (int m = 0; m < points.size() - 1; ++m) {
            Point3d p1 = points.get(m);
            Point3d p2 = points.get(m + 1);
            geoms.add(new LineSeg(p1, p2));
            props.add(eprops);
        }
        this.fireUpdate(0, GeomNodeUtil.newNode(GeomUtil.group(geoms)), props.finalizeProps());
    }

    @Override
    protected void addContextMenuActions(MenuBuilder builder) {
        super.addContextMenuActions(builder);
        List<Point3d> points = this.getClickHistory().getAllPoints();
        double lastSeg = this.getLastSegDist(points);
        double tot = this.getTotalDist(points);
        if (tot > 0.0) {
            String msg = tot > lastSeg ? Intl.intl("Copy total distance to clipboard") : Intl.intl("Copy distance to clipboard");
            CopyAction action = new CopyAction(msg, tot);
            builder.add(action);
        }
        builder.addSeparator();
    }

    private void copyToClipboard(double dist) {
        try {
            Unit[] lengthUnits = this.getModelView().getLengthUnits();
            double valu = UnitDouble.convert(dist, lengthUnits[0], lengthUnits[1]);
            String sval = Double.toString(valu) + " " + lengthUnits[1].toString();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(sval), null);
        }
        catch (Exception e) {
            System.err.println("[23498f] Could not copy to clipboard");
            e.printStackTrace();
        }
    }

    public double getLastSegDist(List<Point3d> history) {
        if (history.size() < 2) {
            return 0.0;
        }
        Point3d last = history.get(history.size() - 1);
        Point3d nextLast = history.get(history.size() - 2);
        return nextLast.distance(last);
    }

    public double getTotalDist(List<Point3d> history) {
        double totDist = 0.0;
        for (int m = 0; m < history.size() - 1; ++m) {
            Point3d p1 = history.get(m);
            Point3d p2 = history.get(m + 1);
            totDist += p1.distance(p2);
        }
        return totDist;
    }

    private class CopyAction
    extends guiAction {
        private static final long serialVersionUID = 6997068062523459877L;
        private final double d_dist;

        public CopyAction(String title, double dist) {
            super(title);
            this.d_dist = dist;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MeasureTool.this.copyToClipboard(this.d_dist);
            MeasureTool.this.finish();
        }
    }

    private class MeasureWindow
    extends HoverWindow {
        private static final long serialVersionUID = 5006700539880599966L;

        public MeasureWindow() {
            super(MeasureTool.this.getAttachedComponent());
        }

        public void update(MouseHistory mhistory) {
            String msg2;
            List<Point3d> history = mhistory.getAllPoints();
            if (history.isEmpty()) {
                this.setVisible(false);
                return;
            }
            this.getContentPane().removeAll();
            ArrayList<String> messages = new ArrayList<String>();
            Point3d lastLoc = history.get(history.size() - 1);
            messages.add(String.format(Intl.intl("<b>Location:</b> %s"), MeasureTool.this.toString(lastLoc)));
            if (history.size() > 1) {
                double dist = MeasureTool.this.getLastSegDist(history);
                msg2 = history.size() > 2 ? String.format(Intl.intl("<b>Current Segment Distance:</b> %s"), MeasureTool.this.toString(dist)) : String.format(Intl.intl("<b>Distance:</b> %s"), MeasureTool.this.toString(dist));
                messages.add(msg2);
            }
            if (history.size() > 2) {
                double totDist = MeasureTool.this.getTotalDist(history);
                msg2 = String.format(Intl.intl("<b>Total Distance:</b> %s"), MeasureTool.this.toString(totDist));
                messages.add(msg2);
            }
            GridBagHelper gb = new GridBagHelper(this.getContentPane());
            gb.d_rowSpace = 1;
            for (String msg2 : messages) {
                msg2 = "<html>" + msg2 + "</html>";
                gb.addRow(msg2, 0);
            }
            gb.finalizeRows();
            this.pack();
            this.setVisible(true);
            this.repaint();
        }
    }
}

