/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.util.Collection;
import java.util.Collections;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import pyrosim.geom.Geometry;
import pyrosim.mv.tools.DrawAABoxGeomTool;
import pyrosim.mv.tools.DrawProps;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.units.UnitDouble;

public class DrawGridGeomTool
extends DrawAABoxGeomTool {
    public DrawGridGeomTool(IToolController controller, DrawProps toolProps) {
        super(controller, toolProps);
    }

    @Override
    protected CursorTool.SnapInfo snapPoint(CursorTool.SnapInfo si) {
        if (this.getProps().get(DrawProps.CELL_TYPE) == DrawProps.MeshCellType.FIXED_SIZE && this.getClickHistory().committedSize() == 1) {
            MouseHistory.Point first = this.getClickHistory().getHistory().getFirst();
            UnitDouble[] sizesud = this.getProps().get(DrawProps.CELL_SIZE);
            double[] sizes = new double[]{sizesud[0].getValue(Geometry.LU), sizesud[1].getValue(Geometry.LU), sizesud[2].getValue(Geometry.LU)};
            Point3d p = si.constrained.getLast();
            double multx = Math.round((p.x - first.p.x) / sizes[0]);
            double multy = Math.round((p.y - first.p.y) / sizes[1]);
            double multz = Math.round((p.z - first.p.z) / sizes[2]);
            Point3d newp = new Point3d(first.p.x + sizes[0] * multx, first.p.y + sizes[1] * multy, first.p.z + sizes[2] * multz);
            Point2d p2d = this.toScreen(newp);
            return new CursorTool.SnapInfo(si.timestamp, p2d, newp, (Collection<IsectInfo>)Collections.EMPTY_LIST, newp);
        }
        return si;
    }
}

