/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Deque;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.gui.MenuBuilder;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.mv.tools.IToggleListener;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.ACurve;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.gui.guiAction;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class DrawExtrudedPolyTool
extends ADrawTool
implements MouseHistory.IListener,
ValueEditor.IListener {
    private IGeom d_geom;

    public DrawExtrudedPolyTool(IToolController mv, DrawProps toolProps) {
        super(mv, toolProps, DrawProps.GeomSpace.S3D);
        this.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IPyroTool tool) {
                DrawExtrudedPolyTool.this.setExtrusion(DrawExtrudedPolyTool.this.getProps().get(DrawProps.THICKNESS).negate());
            }
        });
    }

    public Class getGeomType() {
        return ExtrudedPoly.class;
    }

    @Override
    protected void addContextMenuActions(MenuBuilder builder) {
        if (this.canComplete()) {
            builder.add(new FinishAction());
            builder.addSeparator();
        }
        builder.addMutuallyExclusive(new ChangeExtrusion(true), new ChangeExtrusion(false));
        super.addContextMenuActions(builder);
    }

    protected boolean canComplete() {
        return this.getClickHistory().committedSize() >= 3;
    }

    private void finishIfClosed() {
        Deque<MouseHistory.Point> refPoints = this.getClickHistory().getHistory();
        if (refPoints.size() >= 3 && refPoints.peekFirst().equals(refPoints.peekLast())) {
            this.finish();
        }
    }

    @Override
    public void finish() {
        this.getClickHistory().finalizePoints();
        this.update(true);
        this.fireFinish(this.d_geom != null);
        super.finish();
    }

    @Override
    public void reset() {
        this.fireRemove(0);
        this.d_geom = null;
        super.reset();
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
        this.update(false);
        if (p.dragged && p.committed && this.d_geom instanceof AABoxGeom) {
            this.finish();
        } else if (p.committed) {
            this.finishIfClosed();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.pauseRepaint();
        super.keyPressed(e);
        switch (e.getKeyCode()) {
            case 10: {
                this.finish();
            }
        }
        this.resumeRepaint(true);
    }

    protected void setExtrusion(UnitDouble newVal) {
        this.getProps().set(DrawProps.THICKNESS, newVal);
        this.update(false);
    }

    private void update(boolean finalVersion) {
        Pair<IGeom, IPropsSrc> geom = this.construct(finalVersion);
        this.d_geom = (IGeom)geom.v1;
        if (this.d_geom != null) {
            this.fireUpdate(0, GeomNodeUtil.newNode(this.d_geom), (IPropsSrc)geom.v2);
        } else {
            this.fireRemove(0);
        }
        this.updateStatusMessage();
        this.repaintSurface();
    }

    private Pair<IGeom, IPropsSrc> construct(boolean finalVersion) {
        DrawProps props = this.getProps();
        if (this.getClickHistory().size() <= 1) {
            return new Pair<Object, Object>(null, null);
        }
        Deque<MouseHistory.Point> refPoints = this.getClickHistory().getHistory();
        ArrayList<Point3d> points = new ArrayList<Point3d>(refPoints.size());
        for (MouseHistory.Point p : refPoints) {
            points.add(p.p);
        }
        Vector3d dir = this.getWorkingPlane().getNormal();
        dir.scale(props.get(DrawProps.THICKNESS).getValue(Geometry.LU));
        if (points.size() == 2 && refPoints.peekLast().dragged) {
            AABox box = new AABox();
            box.add((Point3d)points.get(0), (Point3d)points.get(1), Util3D.add((Point3d)points.get(0), (Tuple3d)dir));
            return new Pair<AABoxGeom, Object>(new AABoxGeom(box), null);
        }
        if (points.size() > 1 && !finalVersion) {
            ACurve curve = null;
            curve = points.size() == 2 ? new LineSeg((Point3d)points.get(0), (Point3d)points.get(1)) : new PolyLine(theUtil.toArray(points, Point3d.class));
            ArrayList<APrimitive> geoms = new ArrayList<APrimitive>();
            geoms.add(curve);
            for (int m = 0; m < curve.getNumVerts() - 1; ++m) {
                Point3d p1 = curve.getVert(m);
                Point3d p2 = curve.getVert(m + 1);
                Point3d p1a = Util3D.add(p1, (Tuple3d)dir);
                Point3d p2a = Util3D.add(p2, (Tuple3d)dir);
                geoms.add(new Quad(p1, p2, p2a, p1a));
            }
            PropsBuilder pbuilder = new PropsBuilder();
            pbuilder.add(new IPrimProps.Edge(Color.GREEN, 3.0, IPrimProps.DEF_STIPPLE, 0));
            pbuilder.add(new IPrimProps.Face(new Color(0, 255, 0, 100), null, 0), geoms.size() - 1);
            GeomGroup geom = new GeomGroup(geoms);
            return new Pair<IGeom, IPropsSrc>(geom, pbuilder.finalizeProps());
        }
        if (points.size() >= 3) {
            if (((Point3d)points.get(points.size() - 1)).equals((Tuple3d)points.get(0))) {
                points.remove(points.size() - 1);
            }
            if (points.size() >= 3) {
                IPolygon poly = PolyUtil.newPoly(theUtil.toArray(points, Point3d.class));
                ExtrudedPoly geom = new ExtrudedPoly(poly, dir);
                return new Pair<ExtrudedPoly, Object>(geom, null);
            }
        }
        return new Pair<Object, Object>(null, null);
    }

    protected class ChangeExtrusion
    extends BooleanAction {
        private static final long serialVersionUID = 8878100424558803667L;
        private boolean d_positive;

        public ChangeExtrusion(boolean positive) {
            super(positive ? Intl.intl("Use positive extrusion") : Intl.intl("Use negative extrusion"), positive == Math.signum(DrawExtrudedPolyTool.this.getProps().get(DrawProps.THICKNESS).getValueNoUnit()) >= 0.0);
            this.d_positive = positive;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                UnitDouble val = DrawExtrudedPolyTool.this.getProps().get(DrawProps.THICKNESS).abs();
                if (!this.d_positive) {
                    val = val.negate();
                }
                DrawExtrudedPolyTool.this.setExtrusion(val);
            }
        }
    }

    protected class FinishAction
    extends guiAction {
        private static final long serialVersionUID = -2300000097007388501L;

        public FinishAction() {
            super(Intl.intl("Close"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DrawExtrudedPolyTool.this.finish();
        }
    }
}

