/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.mv.gui.ValueEditorUtil;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.util.Pair;

public class DrawAARectangleTool
extends ADrawTool {
    private AARectangle d_rect = null;

    public DrawAARectangleTool(IToolController mv, DrawProps toolProps) {
        super(mv, toolProps, DrawProps.GeomSpace.S2D);
    }

    @Override
    public Class<? extends IGeom> getGeomType() {
        return AARectangle.class;
    }

    @Override
    protected void initValueEditor(ValueEditor editor) {
        ValueEditorUtil.configureLocation(editor, Intl.intl("First Point (x,y,z)"));
        ValueEditorUtil.configureOffset(editor, null, Intl.intl("Dimensions (L,W,H)"), Intl.intl("Second Point (x,y,z)"));
    }

    @Override
    protected boolean getSnapToWorkingPlane() {
        return false;
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
        this.updateRect();
        if (history.committedSize() == 2) {
            this.finish();
        }
        this.repaintSurface();
    }

    @Override
    public void finish() {
        this.fireFinish(this.d_rect != null);
        super.finish();
    }

    @Override
    public void reset() {
        this.fireRemove(0);
        this.d_rect = null;
        super.reset();
    }

    @Override
    protected CursorTool.SnapInfo nextEditorPoint(Point3d p) {
        CursorTool.SnapInfo si = super.nextEditorPoint(p);
        return si;
    }

    private void updateRect() {
        this.d_rect = this.construct();
        if (this.d_rect != null) {
            this.fireUpdate(0, GeomNodeUtil.newNode(this.d_rect), null);
        } else {
            this.fireRemove(0);
        }
    }

    private AARectangle construct() {
        if (this.getClickHistory().size() < 2) {
            return null;
        }
        Deque<MouseHistory.Point> history = this.getClickHistory().getHistory();
        MouseHistory.Point p1 = history.getFirst();
        MouseHistory.Point p2 = history.getLast();
        if (this.getView().getCamera() instanceof PerspectiveCamera) {
            Pair<Vector3d, Point3d> planeInfo = this.getDrawingPlane(p1, p2);
            Plane3d rectPlane = DrawAARectangleTool.alignToAxis((Vector3d)planeInfo.v1, (Point3d)planeInfo.v2);
            Point3d ptA = p1.p;
            Point3d ptB = rectPlane.projectOntoPlane(p2.p);
            return AARectangle.construct(ptA, ptB, 1.0E-9, false);
        }
        return AARectangle.construct(p1.p, p2.p, 1.0E-9, false);
    }

    private static Plane3d alignToAxis(Vector3d normal, Point3d p) {
        switch (Util3D.getClosestAxis(normal)) {
            case 0: {
                normal = new Vector3d(1.0, 0.0, 0.0);
                break;
            }
            case 1: {
                normal = new Vector3d(0.0, 1.0, 0.0);
                break;
            }
            default: {
                normal = new Vector3d(0.0, 0.0, 1.0);
            }
        }
        return new Plane3d(normal, p);
    }

    private Pair<Vector3d, Point3d> getDrawingPlane(MouseHistory.Point hp1, MouseHistory.Point hp2) {
        Collection<IsectInfo> p1Isects = hp1.snap.snaps;
        Collection<IsectInfo> p2Isects = hp2.snap.snaps;
        List<Plane3d> p1Planes = this.getFacePlanes(p1Isects);
        List<Plane3d> p2Planes = this.getFacePlanes(p2Isects);
        Point3d p0 = hp1.p;
        Point3d p1 = hp2.p;
        if (!p1Planes.isEmpty() && !p2Planes.isEmpty()) {
            ArrayList<Plane3d> sharedPlanes = new ArrayList<Plane3d>();
            for (Plane3d plane1 : p1Planes) {
                for (Plane3d plane2 : p2Planes) {
                    if (!plane1.epsilonEquals(plane2, 1.0E-6) && !plane1.epsilonEquals(plane2.negate(), 1.0E-6)) continue;
                    sharedPlanes.add(plane1);
                }
            }
            if (sharedPlanes.size() > 1) {
                double maxDot = 0.0;
                Plane3d bestPlane = null;
                Vector3d[] dirs = new Vector3d[]{GeomConstants.VEC3D_XPOS, GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZPOS};
                for (Plane3d plane : sharedPlanes) {
                    for (Vector3d dir : dirs) {
                        double dot = Math.abs(dir.dot(plane.getNormal()));
                        if (!(dot > maxDot)) continue;
                        maxDot = dot;
                        bestPlane = plane;
                    }
                }
                if (bestPlane != null) {
                    return new Pair<Vector3d, Point3d>(bestPlane.getNormal(), p0);
                }
            }
            if (!sharedPlanes.isEmpty()) {
                Plane3d plane = (Plane3d)sharedPlanes.get(0);
                return new Pair<Vector3d, Point3d>(plane.getNormal(), p0);
            }
        }
        double dx = Math.abs(p0.x - p1.x);
        double dy = Math.abs(p0.y - p1.y);
        double dz = Math.abs(p0.z - p1.z);
        Vector3d axis = dx <= dy && dx <= dz ? new Vector3d(1.0, 0.0, 0.0) : (dy <= dx && dy <= dz ? new Vector3d(0.0, 1.0, 0.0) : new Vector3d(0.0, 0.0, 1.0));
        return new Pair<Vector3d, Point3d>(axis, p0);
    }

    private List<Plane3d> getFacePlanes(Collection<IsectInfo> isects) {
        ArrayList<Plane3d> planes = new ArrayList<Plane3d>();
        IsectInfo prevIsect = null;
        for (IsectInfo isect : isects) {
            IPrimitive prim;
            if (isect.getPrim == null || !((prim = isect.getPrim.get()) instanceof IPolygon)) continue;
            if (prevIsect != null && isect.prox.compareTo(prevIsect.prox) > 0) break;
            Vector3d normal = ((IPolygon)prim).getNormal(true);
            planes.add(new Plane3d(normal, isect.isectPoint));
            prevIsect = isect;
        }
        return planes;
    }
}

