/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JSeparator;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.INamed;
import pyrosim.domain.Property;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.devices.IAttachedPointDevice;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreePointDevice;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.geom.Geometry;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.ParticleComboBox;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.comboboxes.SurfaceComboBox;
import pyrosim.gui.devices.DevcEditorFactory;
import pyrosim.gui.devices.DevicePnl;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.geom.InitEditor;
import pyrosim.gui.geom.PartCloudEditor;
import pyrosim.mv.tools.DrawProps;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.Util;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.theUtil;

public class ToolPropertiesDlg
extends guiDialog {
    private static final long serialVersionUID = 5542101197693312041L;
    private static final String COLOR_FROM_SURF = Intl.intl("From Surface");
    private static final String COLOR_SPECIFY = Intl.intl("Specify");
    private guiTextField d_nameFld;
    private ValueField<UnitDouble> d_location;
    private ValueField<UnitDouble> d_thick;
    private ValueField<UnitDouble> d_height;
    private guiCheckBox d_cbSpecifySurf;
    private SurfaceComboBox d_surfCombo;
    private ParticleComboBox d_partCombo;
    private JButton d_editPartButton;
    private guiCheckBox d_cbSpecifyColor;
    private guiComboBox<String> d_cbColorSpec;
    private ColorButton d_cbColor;
    private guiCheckBox d_cbThicken = new guiCheckBox(Intl.intl("Thicken"), false);
    private guiCheckBox d_cbPermitHoles = new guiCheckBox(Intl.intl("Permit Holes"), true);
    private guiComboBox<DevicePnl<? extends IDevice>> d_devcTypeCB;
    private guiComboBox<Geometry.Axis> d_axisCB;
    private QuantityComboBox d_sliceQuantityCB;
    private guiCheckBox d_sliceVectorCB;
    private guiCheckBox d_sliceCenteredCB;
    private guiRadioButton d_fixedCellSizeRB;
    private guiRadioButton d_fixedCellCountRB;
    private ValueField<UnitDouble> d_cellSizeX;
    private ValueField<UnitDouble> d_cellSizeY;
    private ValueField<UnitDouble> d_cellSizeZ;
    private ValueField<Integer> d_cellCountX;
    private ValueField<Integer> d_cellCountY;
    private ValueField<Integer> d_cellCountZ;
    private PartCloudEditor.InsertionPanel d_massDensPanel;
    private TitleSeparator d_movementTitle;
    private PartCloudEditor.DropletCountPanel d_dropCountPanel;
    private InitEditor d_initEditor;
    private final Set<DrawProps.Prop<?>> d_propTypes;
    private final DrawProps d_props;
    private final String d_nameKey;
    private final int d_axis;

    public ToolPropertiesDlg(JFrame parent, PyroMod mediator, Camera cam, String nameKey, String thicknessDesc, Predicate<Surface> surfFilter, DrawProps props, Collection<DrawProps.Prop<?>> propTypes) {
        super((Window)parent, Intl.intl("Tool Properties"), 9);
        JComponent lblComp;
        String locStr;
        this.d_props = props;
        this.d_nameKey = nameKey;
        this.d_propTypes = propTypes instanceof Set ? (Set<Object>)propTypes : new HashSet(propTypes);
        this.d_axis = cam instanceof OrthoCamera ? Util.getClosestAxis(cam.getViewVector()) : 2;
        switch (this.d_axis) {
            case 0: {
                locStr = Intl.intl("X Location:");
                break;
            }
            case 1: {
                locStr = Intl.intl("Y Location:");
                break;
            }
            case 2: {
                locStr = Intl.intl("Z Location:");
                break;
            }
            default: {
                assert (false);
                locStr = null;
            }
        }
        guiPanel dlgPane = this.getDialogPane();
        dlgPane.setLayout(new GridBagLayout());
        GridBagHelper gb = new GridBagHelper(dlgPane);
        if (this.propsAffected(DrawProps.NAME)) {
            this.d_nameFld = new guiTextField((String)props.get(new DrawProps.Prop(nameKey)));
            gb.addRow(Intl.intl("Name:"), this.d_nameFld, 1.0, 0);
        }
        if (this.propsAffected(DrawProps.LOCATION)) {
            this.d_location = ValueFields.udFld(props.get(DrawProps.LOCATION), UnitSystem.getSource(0));
            gb.addRow(locStr, this.d_location, 0);
        }
        if (this.propsAffected(DrawProps.HEIGHT)) {
            UnitDouble height = props.get(DrawProps.HEIGHT);
            this.d_height = ValueFields.udFld(height.getValueNoUnit(), DoubleVR.above(0.0, true), height.getUnit(), UnitSystem.getSource(0));
            gb.addRow(Intl.intl("Height:"), this.d_height, 0);
        }
        if (this.propsAffected(DrawProps.THICKNESS)) {
            this.d_thick = ValueFields.udFld(props.get(DrawProps.THICKNESS), UnitSystem.getSource(0));
            gb.addRow(thicknessDesc + ":", this.d_thick, 0);
        }
        if (this.propsAffected(DrawProps.SURFACE)) {
            this.d_surfCombo = new SurfaceComboBox(mediator.getSurfaceMgr(), props.get(DrawProps.SURFACE));
            this.d_surfCombo.setFilter(surfFilter);
            if (this.propsAffected(DrawProps.SPECIFY_SURFACE)) {
                this.d_cbSpecifySurf = new guiCheckBox(Intl.intl("Apply Surface"), (boolean)props.get(DrawProps.SPECIFY_SURFACE));
                LinkStatus.link((AbstractButton)this.d_cbSpecifySurf, this.d_surfCombo);
            }
            lblComp = this.d_cbSpecifySurf != null ? this.d_cbSpecifySurf : new guiLabel(Intl.intl("Surface:"));
            gb.addRow(lblComp, this.d_surfCombo, 0);
        } else if (this.propsAffected(DrawProps.SPECIFY_SURFACE)) {
            this.d_cbSpecifySurf = new guiCheckBox(Intl.intl("Pick Surface"), (boolean)props.get(DrawProps.SPECIFY_SURFACE));
            gb.addRow(this.d_cbSpecifySurf, 0);
        }
        if (this.propsAffected(DrawProps.COLOR)) {
            this.d_cbColorSpec = new guiComboBox<Object>((T[])new Object[]{COLOR_FROM_SURF, COLOR_SPECIFY});
            this.d_cbColorSpec.setSelectedItem(props.get(DrawProps.COLOR) == null ? COLOR_FROM_SURF : COLOR_SPECIFY);
            this.d_cbColor = new ColorButton();
            this.d_cbColor.setVisible(props.get(DrawProps.COLOR) != null);
            if (props.get(DrawProps.COLOR) != null) {
                this.d_cbColor.setColor(props.get(DrawProps.COLOR));
            }
            this.d_cbColorSpec.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ToolPropertiesDlg.this.d_cbColor.setVisible(((String)ToolPropertiesDlg.this.d_cbColorSpec.getSelectedItem()).equals(COLOR_SPECIFY));
                        if (ToolPropertiesDlg.this.d_cbColor.isVisible()) {
                            ToolPropertiesDlg.this.d_cbColor.editColor();
                            ToolPropertiesDlg.this.pack();
                        }
                    }
                }
            });
            if (this.propsAffected(DrawProps.SPECIFY_COLOR)) {
                this.d_cbSpecifyColor = new guiCheckBox(Intl.intl("Apply Color"), (boolean)props.get(DrawProps.SPECIFY_COLOR));
                LinkStatus.link((AbstractButton)this.d_cbSpecifyColor, this.d_cbColorSpec, this.d_cbColor);
            }
            lblComp = this.d_cbSpecifyColor != null ? this.d_cbSpecifyColor : new guiLabel(Intl.intl("Color:"));
            gb.addRow(lblComp, this.d_cbColorSpec, this.d_cbColor);
        } else if (this.propsAffected(DrawProps.SPECIFY_COLOR)) {
            this.d_cbSpecifyColor = new guiCheckBox(Intl.intl("Pick Color"), (boolean)props.get(DrawProps.SPECIFY_COLOR));
            this.d_cbColor = new ColorButton();
            LinkStatus.link((AbstractButton)this.d_cbSpecifyColor, this.d_cbColor);
            gb.addRow(this.d_cbSpecifyColor, this.d_cbColor, 0);
        }
        if (this.propsAffected(DrawProps.THICKEN)) {
            this.d_cbThicken.setSelected(props.get(DrawProps.THICKEN));
            gb.addRow(this.d_cbThicken);
        }
        if (this.propsAffected(DrawProps.PERMIT_HOLES)) {
            this.d_cbPermitHoles.setSelected(props.get(DrawProps.PERMIT_HOLES));
            gb.addRow(this.d_cbPermitHoles);
        }
        if (this.propsAffected(DrawProps.PARTICLES)) {
            this.d_editPartButton = new JButton(Intl.intl("Edit Particles") + "...");
            this.d_editPartButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Actions.editParticles((Particle)ToolPropertiesDlg.this.d_partCombo.getSelectedItem());
                    if (ToolPropertiesDlg.this.d_partCombo.getSelectedItem() == null && ToolPropertiesDlg.this.d_partCombo.getItemCount() > 0) {
                        ToolPropertiesDlg.this.d_partCombo.setSelectedIndex(0);
                    }
                    ToolPropertiesDlg.this.updatePartCloudFields();
                }
            });
            this.d_partCombo = new ParticleComboBox(mediator.getPartList(), props.get(DrawProps.PARTICLES), null);
            this.d_partCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    ToolPropertiesDlg.this.updatePartCloudFields();
                }
            });
            if (this.d_partCombo.getSelectedItem() == null && this.d_partCombo.getItemCount() > 0) {
                this.d_partCombo.setSelectedIndex(0);
            }
            gb.addRow(Intl.intl("Particle:"), this.d_partCombo, 1.0, this.d_editPartButton, 0);
        }
        if (this.propsAffected(DrawProps.DROP_COUNT)) {
            this.d_dropCountPanel = new PartCloudEditor.DropletCountPanel(false);
            this.d_dropCountPanel.loadData(Property.of(props.get(DrawProps.DROP_COUNT)));
            gb.addFilledRow(new TitleSeparator(Intl.intl("Droplet Count")));
            gb.addIdentRow(this.d_dropCountPanel, 0, 1.0);
        }
        if (this.propsAffected(DrawProps.INSERTION)) {
            this.d_massDensPanel = new PartCloudEditor.InsertionPanel(mediator, objStream -> Stream.of(this.d_nameFld.getText()), false);
            this.d_massDensPanel.loadData((PartCloud.IInsertion)props.get(DrawProps.INSERTION).v1, (ControlBridge)props.get(DrawProps.INSERTION).v2);
            gb.addFilledRow(new TitleSeparator(Intl.intl("Insertion")));
            gb.addIdentRow(this.d_massDensPanel, 0, 1.0);
        }
        if (this.propsAffected(DrawProps.INIT)) {
            this.d_initEditor = new InitEditor(mediator);
            this.d_initEditor.load(PyroSim.getApp().getMediator(), (Collection<? extends InitRegion>)Arrays.asList(this.d_props.get(DrawProps.INIT)));
            this.d_initEditor.add(gb);
        }
        if (this.propsAffected(DrawProps.DEVC)) {
            List<DevicePnl<? extends IDevice>> panels = ToolPropertiesDlg.getDevicePanels(mediator, props);
            final CardLayout devcPnlCards = new CardLayout();
            final guiPanel devcPnl = new guiPanel(devcPnlCards);
            for (DevicePnl<? extends IDevice> devicePnl : panels) {
                devcPnl.add(devicePnl, devicePnl.getDevcType().getName());
                devicePnl.setEnabled(false);
            }
            this.d_devcTypeCB = new guiComboBox<DevicePnl<? extends IDevice>>((Collection<DevicePnl<? extends IDevice>>)panels);
            this.d_devcTypeCB.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = -1242870236787131484L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    DevicePnl pnl = (DevicePnl)value;
                    this.setText(pnl.getDevcEditor().getDesc());
                    return this;
                }
            });
            this.d_devcTypeCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean enabled;
                    boolean bl = enabled = e.getStateChange() == 1;
                    if (e.getItem() != null) {
                        ((DevicePnl)e.getItem()).setEnabled(enabled);
                    }
                    if (e.getStateChange() == 1) {
                        DevicePnl pnl = (DevicePnl)ToolPropertiesDlg.this.d_devcTypeCB.getSelectedItem();
                        devcPnlCards.show(devcPnl, pnl.getDevcType().getName());
                    }
                }
            });
            IDevice template = props.get(DrawProps.DEVC);
            if (template != null) {
                for (DevicePnl<? extends IDevice> devicePnl : panels) {
                    if (!devicePnl.getDevcType().isInstance(template)) continue;
                    devicePnl.load(template);
                    this.d_devcTypeCB.setSelectedItem(devicePnl);
                    break;
                }
            }
            gb.addRow(Intl.intl("Device Type:"), this.d_devcTypeCB, 0);
            gb.addFilledRow(new JSeparator());
            gb.addFilledRow(devcPnl);
        }
        if (this.propsAffected(DrawProps.CELL_TYPE, DrawProps.CELL_SIZE, DrawProps.CELL_COUNT)) {
            this.d_fixedCellCountRB = new guiRadioButton(Intl.intl("Fixed Count:"));
            this.d_fixedCellSizeRB = new guiRadioButton(Intl.intl("Fixed Size:"));
            this.d_cellCountX = ValueFields.intFld(props.get(DrawProps.CELL_COUNT)[0], IntVR.above(0, false));
            this.d_cellCountY = ValueFields.intFld(props.get(DrawProps.CELL_COUNT)[1], IntVR.above(0, false));
            this.d_cellCountZ = ValueFields.intFld(props.get(DrawProps.CELL_COUNT)[2], IntVR.above(0, false));
            this.d_cellSizeX = ValueFields.udFld(props.get(DrawProps.CELL_SIZE)[0], UnitDoubleVR.above(0.0, SI.METER, false), UnitSystem.getSource(0));
            this.d_cellSizeY = ValueFields.udFld(props.get(DrawProps.CELL_SIZE)[1], UnitDoubleVR.above(0.0, SI.METER, false), UnitSystem.getSource(0));
            this.d_cellSizeZ = ValueFields.udFld(props.get(DrawProps.CELL_SIZE)[2], UnitDoubleVR.above(0.0, SI.METER, false), UnitSystem.getSource(0));
            guiLabel cx = new guiLabel(Intl.intl("X:"));
            guiLabel cy = new guiLabel(Intl.intl("Y:"));
            guiLabel cz = new guiLabel(Intl.intl("Z:"));
            guiLabel sx = new guiLabel(Intl.intl("X:"));
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Y:"));
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Z:"));
            new guiButtonGroup(this.d_fixedCellCountRB, this.d_fixedCellSizeRB);
            LinkStatus.link((AbstractButton)this.d_fixedCellCountRB, cx, this.d_cellCountX, cy, this.d_cellCountY, cz, this.d_cellCountZ);
            LinkStatus.link((AbstractButton)this.d_fixedCellSizeRB, sx, this.d_cellSizeX, guiLabel2, this.d_cellSizeY, guiLabel3, this.d_cellSizeZ);
            guiPanel gridPanel = new guiPanel();
            GridBagHelper gb2 = new GridBagHelper(gridPanel);
            gb2.addFilledRow(new TitleSeparator(Intl.intl("Cells")));
            gb2.addIdentRow(this.d_fixedCellSizeRB, sx, this.d_cellSizeX, guiLabel2, this.d_cellSizeY, guiLabel3, this.d_cellSizeZ, 0);
            gb2.addIdentRow(this.d_fixedCellCountRB, cx, this.d_cellCountX, cy, this.d_cellCountY, cz, this.d_cellCountZ, 0);
            gb2.finalizeRows();
            gb.addFilledRow(gridPanel);
            if (props.get(DrawProps.CELL_TYPE) == DrawProps.MeshCellType.FIXED_COUNT) {
                this.d_fixedCellCountRB.setSelected(true);
            } else {
                this.d_fixedCellSizeRB.setSelected(true);
            }
        }
        if (this.propsAffected(DrawProps.AXIS)) {
            ArrayList<Geometry.Axis> axes = new ArrayList<Geometry.Axis>();
            axes.add(null);
            axes.addAll(Arrays.asList(Geometry.Axis.values()));
            this.d_axisCB = new guiComboBox(axes);
            this.d_axisCB.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = -5308765187220589086L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value == null) {
                        this.setText(Intl.intl("Automatic"));
                    }
                    return this;
                }
            });
            gb.addRow(Intl.intl("Axis:"), this.d_axisCB, 0);
            this.d_axisCB.setSelectedItem((Object)props.get(DrawProps.AXIS));
        }
        if (this.propsAffected(DrawProps.SLICE_QUANTITY)) {
            this.d_sliceQuantityCB = new QuantityComboBox(128L, new QuantityType[0]);
            this.d_sliceQuantityCB.setSelectedItem(props.get(DrawProps.SLICE_QUANTITY));
            gb.addRow(Intl.intl("Quantity:"), this.d_sliceQuantityCB, 0);
        }
        if (this.propsAffected(DrawProps.SLICE_VECTOR)) {
            this.d_sliceVectorCB = new guiCheckBox(Intl.intl("Include Vectors"), (boolean)props.get(DrawProps.SLICE_VECTOR));
            gb.addRow(this.d_sliceVectorCB, 0);
        }
        if (this.propsAffected(DrawProps.SLICE_CENTERED)) {
            this.d_sliceCenteredCB = new guiCheckBox(Intl.intl("Cell Centered"), (boolean)props.get(DrawProps.SLICE_CENTERED));
            gb.addRow(this.d_sliceCenteredCB, 0);
        }
        gb.finalizeRows();
        if (this.d_partCombo != null) {
            this.updatePartCloudFields();
        }
    }

    private boolean isBurnAway(SurfaceComboBox box) {
        Surface surf = (Surface)box.getSelectedItem();
        if (surf != null && surf.getSurfDesc() instanceof LayeredSurfDesc) {
            LayeredSurfDesc desc = (LayeredSurfDesc)surf.getSurfDesc();
            return desc.d_burnAway;
        }
        return false;
    }

    private static List<DevicePnl<? extends IDevice>> getDevicePanels(PyroMod pyMod, DrawProps props) {
        ArrayList<DevicePnl<? extends IDevice>> panels = new ArrayList<DevicePnl<? extends IDevice>>();
        for (Class<? extends IDevice> devcType : ToolPropertiesDlg.getPointDevcTypes(pyMod)) {
            IDevcEditor<? extends IDevice> editor = DevcEditorFactory.create(pyMod, devcType, IDevcEditor.Mode.CREATE, 0);
            if (editor == null) continue;
            DevicePnl<? extends IDevice> pnl = new DevicePnl<IDevice>(pyMod, devcType, editor, 0);
            panels.add(pnl);
        }
        Collections.sort(panels, new Comparator<DevicePnl<? extends IDevice>>(){

            @Override
            public int compare(DevicePnl<? extends IDevice> o1, DevicePnl<? extends IDevice> o2) {
                return o1.getDevcEditor().getDesc().compareToIgnoreCase(o2.getDevcEditor().getDesc());
            }
        });
        return panels;
    }

    protected static Collection<Class<? extends IDevice>> getPointDevcTypes(PyroMod domain) {
        return theUtil.filter(DevcEditorFactory.getAllDevcTypes(), Class.class, new Predicate<Class>(){

            @Override
            public boolean test(Class o) {
                return IFreePointDevice.class.isAssignableFrom(o) || IAttachedPointDevice.class.isAssignableFrom(o);
            }
        });
    }

    private boolean propsAffected(DrawProps.Prop ... props) {
        return this.d_propTypes.containsAll(Arrays.asList(props));
    }

    protected void updatePartCloudFields() {
        boolean geom3d;
        boolean massless = this.d_partCombo.getSelectedItem() != null && ((Particle)this.d_partCombo.getSelectedItem()).isType(Particle.Type.TRACER);
        boolean bl = geom3d = this.d_props.get(DrawProps.GEOM_SPACE) == DrawProps.GeomSpace.S3D;
        if (this.d_massDensPanel != null) {
            this.d_massDensPanel.updateEnabled(Property.of(massless), Property.of(geom3d));
        }
        if (this.d_dropCountPanel != null) {
            this.d_dropCountPanel.updateEnabled(Property.of(massless), Property.of(geom3d));
        }
        if (this.d_movementTitle != null) {
            this.d_movementTitle.setEnabled(!massless);
        }
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.propsAffected(DrawProps.NAME) && this.d_nameFld.getText().trim().isEmpty()) {
            if (showWarn) {
                this.showMessageBox(Intl.intl("The name must not be empty."));
            }
            if (allowModify) {
                this.d_nameFld.selectAll();
                this.d_nameFld.requestFocus();
            }
            return false;
        }
        if (this.propsAffected(DrawProps.PARTICLES) && this.d_partCombo.getSelectedItem() == null) {
            this.showMessageBox(Intl.intl("A particle must be chosen."));
            return false;
        }
        return true;
    }

    public void saveProps() {
        if (this.propsAffected(DrawProps.NAME)) {
            this.d_props.set(new DrawProps.Prop(this.d_nameKey), this.d_nameFld.getText());
        }
        if (this.propsAffected(DrawProps.LOCATION)) {
            this.d_props.set(DrawProps.LOCATION, this.d_location.getValue());
        }
        if (this.propsAffected(DrawProps.HEIGHT)) {
            this.d_props.set(DrawProps.HEIGHT, this.d_height.getValue());
        }
        if (this.propsAffected(DrawProps.THICKNESS)) {
            this.d_props.set(DrawProps.THICKNESS, this.d_thick.getValue());
        }
        if (this.propsAffected(DrawProps.SPECIFY_SURFACE)) {
            this.d_props.set(DrawProps.SPECIFY_SURFACE, this.d_cbSpecifySurf.isSelected());
        }
        if (this.propsAffected(DrawProps.SURFACE)) {
            this.d_props.set(DrawProps.SURFACE, this.d_surfCombo.getSelectedItem());
        }
        if (this.propsAffected(DrawProps.SPECIFY_COLOR)) {
            this.d_props.set(DrawProps.SPECIFY_COLOR, this.d_cbSpecifyColor.isSelected());
            if (this.d_cbSpecifyColor.isSelected()) {
                this.d_props.set(DrawProps.COLOR, this.d_cbColor.getColor());
            } else {
                this.d_props.set(DrawProps.COLOR, null);
            }
        }
        if (this.propsAffected(DrawProps.COLOR)) {
            if (this.d_cbColorSpec.getSelectedItem() == COLOR_FROM_SURF) {
                this.d_props.set(DrawProps.COLOR, null);
            } else {
                this.d_props.set(DrawProps.COLOR, this.d_cbColor.getColor());
            }
        }
        if (this.propsAffected(DrawProps.THICKEN)) {
            this.d_props.set(DrawProps.THICKEN, this.d_cbThicken.isSelected());
        }
        if (this.propsAffected(DrawProps.PERMIT_HOLES)) {
            this.d_props.set(DrawProps.PERMIT_HOLES, this.d_cbPermitHoles.isSelected());
        }
        if (this.propsAffected(DrawProps.PARTICLES)) {
            this.d_props.set(DrawProps.PARTICLES, this.d_partCombo.getSelectedItem());
        }
        if (this.propsAffected(DrawProps.INSERTION)) {
            this.d_props.set(DrawProps.INSERTION, this.d_massDensPanel.saveData());
        }
        if (this.propsAffected(DrawProps.DROP_COUNT)) {
            this.d_props.set(DrawProps.DROP_COUNT, this.d_dropCountPanel.saveData().get());
        }
        if (this.propsAffected(DrawProps.INIT)) {
            this.d_initEditor.save(PyroSim.getApp().getMediator(), (Collection<? extends InitRegion>)Arrays.asList(this.d_props.get(DrawProps.INIT)));
        }
        if (this.propsAffected(DrawProps.DEVC)) {
            DevicePnl<? extends IDevice> pnl = this.d_devcTypeCB.getSelectedItem();
            INamed protoDevc = pnl.save(null);
            protoDevc.setName(pnl.getDevcEditor().getDefName());
            this.d_props.set(DrawProps.DEVC, protoDevc);
        }
        if (this.propsAffected(DrawProps.CELL_TYPE, DrawProps.CELL_SIZE, DrawProps.CELL_COUNT)) {
            DrawProps.MeshCellType cellType = this.d_fixedCellCountRB.isSelected() ? DrawProps.MeshCellType.FIXED_COUNT : DrawProps.MeshCellType.FIXED_SIZE;
            this.d_props.set(DrawProps.CELL_TYPE, cellType);
            if (cellType == DrawProps.MeshCellType.FIXED_COUNT) {
                int[] counts = new int[]{(Integer)this.d_cellCountX.getValue(), (Integer)this.d_cellCountY.getValue(), (Integer)this.d_cellCountZ.getValue()};
                this.d_props.set(DrawProps.CELL_COUNT, counts);
            } else {
                UnitDouble[] sizes = new UnitDouble[]{(UnitDouble)this.d_cellSizeX.getValue(), (UnitDouble)this.d_cellSizeY.getValue(), (UnitDouble)this.d_cellSizeZ.getValue()};
                this.d_props.set(DrawProps.CELL_SIZE, sizes);
            }
        }
        if (this.propsAffected(DrawProps.AXIS)) {
            this.d_props.set(DrawProps.AXIS, this.d_axisCB.getSelectedItem());
        }
        if (this.propsAffected(DrawProps.SLICE_QUANTITY)) {
            this.d_props.set(DrawProps.SLICE_QUANTITY, this.d_sliceQuantityCB.getSelectedItem());
        }
        if (this.propsAffected(DrawProps.SLICE_VECTOR)) {
            this.d_props.set(DrawProps.SLICE_VECTOR, this.d_sliceVectorCB.isSelected());
        }
        if (this.propsAffected(DrawProps.SLICE_CENTERED)) {
            this.d_props.set(DrawProps.SLICE_CENTERED, this.d_sliceCenteredCB.isSelected());
        }
    }
}

