/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.awt.Color;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.mv.PyroDrawProps;
import pyrosim.mv.displays.APyroDisplayMgr;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.GeomDisplayMgr;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.ModelScene;

public class HandleDispMgr
extends APyroDisplayMgr<IHandle, GeomDisplayMgr.CapDisplay> {
    public HandleDispMgr(PyroMod mod, ModelScene scene, DisplayFilter filter) {
        super(mod, null, HandleDispMgr.newSceneMap(scene), IHandle.class, filter);
    }

    @Override
    public void addAll() {
    }

    @Override
    protected GeomDisplayMgr.CapDisplay createDisplay(IHandle obj, boolean visible, boolean selected) {
        PyroDrawProps dispProps = PyroSim.getApp().getModelView().getDrawProps();
        DisplayableHandle dh = new DisplayableHandle(obj);
        GeomDisplayMgr.CapDisplay disp = new GeomDisplayMgr.CapDisplay(dispProps, dh, false, false);
        disp.setSelected(selected);
        disp.setVisible(visible);
        return disp;
    }

    public void updateSelected(IHandle obj, boolean selected) {
        GeomDisplayMgr.CapDisplay disp = (GeomDisplayMgr.CapDisplay)this.getDisplay(obj);
        if (disp != null) {
            disp.setSelected(selected);
        }
    }

    @Override
    protected boolean isVisible(IHandle obj) {
        return !this.isFiltered(obj);
    }

    public static class DisplayableHandle
    implements IDisplayableGeomSrc {
        private final IHandle d_handle;
        private boolean d_visible;

        public DisplayableHandle(IHandle handle) {
            this.d_handle = handle;
            this.d_visible = true;
        }

        public IHandle getHandle() {
            return this.d_handle;
        }

        @Override
        public AABox getBounds() {
            return this.d_handle.getGeom().getBoundingBox(new AABox());
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps props) {
            IGeomNode geom = this.d_handle.getGeom();
            int alpha = 255;
            if (geom.getNumPrims(1) > 0) {
                alpha = 50;
            }
            IPrimProps.GenericProps dprops = new IPrimProps.GenericProps(new Color(0, 0, 255, alpha), null, 3.0, IPrimProps.DEF_STIPPLE, 7.0, 0);
            return new DisplayGeom(geom, (IPrimProps)dprops);
        }

        @Override
        public boolean isVisible() {
            return this.d_visible;
        }

        @Override
        public void setVisible(boolean visible) {
            this.d_visible = visible;
        }
    }
}

