/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Accelerators;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.PyroSimColors;
import pyrosim.PyroSimSelectionModel;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.Floor;
import pyrosim.domain.FloorManager;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.ModelImage;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreePointDevice;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.IHvacGeomComp;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.Slice;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.domain.tasks.ViewPropTask;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewMgr;
import pyrosim.domain.view.ViewMode;
import pyrosim.domain.zones.Zone;
import pyrosim.geom.Geometry;
import pyrosim.gui.FloorBGImageEditor;
import pyrosim.gui.ManageFloorsDlg;
import pyrosim.gui.MenuBuilder;
import pyrosim.gui.MouseSelectionLogic;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.comboboxes.CompositeComboBox;
import pyrosim.gui.tasks.ManageFloorsTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Sets;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagHelper;
import pyrosim.mv.GridVis;
import pyrosim.mv.PyroDrawProps;
import pyrosim.mv.PyroNativeProps;
import pyrosim.mv.PyroPickRoot;
import pyrosim.mv.displays.ClippingManager;
import pyrosim.mv.displays.DisplayManager;
import pyrosim.mv.displays.EventResult;
import pyrosim.mv.displays.LabelMgr;
import pyrosim.mv.gui.EditSnapToGridDlg;
import pyrosim.mv.gui.ToolPropertiesDlg;
import pyrosim.mv.manip.ManipHook;
import pyrosim.mv.manip.TransformMgr;
import pyrosim.mv.snappers.CompositeModelGridSnapper;
import pyrosim.mv.snappers.IGridSnapper;
import pyrosim.mv.snappers.OriginSnapper;
import pyrosim.mv.snappers.SnapToGrid;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DefaultIsectFilter;
import pyrosim.mv.tools.DrawAABoxGeomTool;
import pyrosim.mv.tools.DrawAARectangleTool;
import pyrosim.mv.tools.DrawExtrudedPolyTool;
import pyrosim.mv.tools.DrawGridCellTool;
import pyrosim.mv.tools.DrawGridGeomTool;
import pyrosim.mv.tools.DrawHvacDuctTool;
import pyrosim.mv.tools.DrawPlaneGeomTool;
import pyrosim.mv.tools.DrawPointTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.DrawRoomTool;
import pyrosim.mv.tools.DrawToolBridge;
import pyrosim.mv.tools.DrawWallGeomTool;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.mv.tools.IToggleListener;
import pyrosim.mv.tools.ManipFunc;
import pyrosim.mv.tools.MeasureTool;
import pyrosim.mv.tools.MeshAutoAxisChooser;
import pyrosim.mv.tools.MirrorTool;
import pyrosim.mv.tools.Pyro3DSelector;
import pyrosim.mv.tools.RotateTool;
import pyrosim.mv.tools.SmokeViewNavigationFunc;
import pyrosim.mv.tools.SurfacePainterTool;
import pyrosim.mv.tools.SurfacePickerTool;
import pyrosim.mv.tools.SwitchingToolFunc;
import pyrosim.mv.tools.ToolMeta;
import pyrosim.mv.tools.ToolNames;
import pyrosim.mv.tools.ToolUtil;
import pyrosim.mv.tools.TranslateTool;
import pyrosim.mv.tools.constraint.IConstraintGen;
import pyrosim.mv.tools.constraint.NoConstraintGen;
import pyrosim.mv.tools.constraint.OffsetPointConstraint;
import pyrosim.mv.tools.constraint.WorkingPlaneConstraintGen;
import pyrosim.mv.tools.popupmenu.CameraMenuBuilder;
import pyrosim.mv.tools.popupmenu.IPopupMenuBuilder;
import pyrosim.mv.tools.popupmenu.SnapConstraintMenuBuilder;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.Util;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.animate.SwingAnimSession;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.BGImageXform;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.gui.AbstractComponentListener;
import thunderheadeng.gui.ActionGroup;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.DropDownButton;
import thunderheadeng.gui.MutuallyExclusiveAction;
import thunderheadeng.gui.SelectableAction;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.colorscheme.ColorChangedEvent;
import thunderheadeng.gui.colorscheme.ColorChangedListener;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiStatusBar;
import thunderheadeng.gui.guiStatusMessage;
import thunderheadeng.gui.tool.IDeviceManager;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.gui.tool.ToolManager;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.image.ImageManager;
import thunderheadeng.scene3d.IntermediateGraphicsXfer;
import thunderheadeng.scene3d.gui.BGImageDlg;
import thunderheadeng.scene3d.gui.RenderPrefs;
import thunderheadeng.scene3d.manip.ManipMgr;
import thunderheadeng.scene3d.nativebuffered.AxesScene;
import thunderheadeng.scene3d.nativebuffered.BoundsCalculator;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.ClearableBackground;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.IRenderable;
import thunderheadeng.scene3d.nativebuffered.ISceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.MultiSceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.Object3D;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.OverlayLayout;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.nativebuffered.QuickSaveRestoreLayer;
import thunderheadeng.scene3d.nativebuffered.RenderComponent;
import thunderheadeng.scene3d.nativebuffered.RenderFile;
import thunderheadeng.scene3d.nativebuffered.SceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.SceneRenderer;
import thunderheadeng.scene3d.nativebuffered.SurfaceProps;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.navtools.CompositeFunc;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.DragFunc;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.MultiFunc;
import thunderheadeng.scene3d.navtools.NavtoolUtil;
import thunderheadeng.scene3d.navtools.OrbitFunc;
import thunderheadeng.scene3d.navtools.RoamFunc;
import thunderheadeng.scene3d.navtools.SelectionFunc;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.navtools.ZoomBoxFunc;
import thunderheadeng.scene3d.navtools.ZoomFunc;
import thunderheadeng.scene3d.picking.GeomPicker;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.ATask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.DisposableObject;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Task;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;

public class ModelView
implements ColorChangedListener,
IEventObserver,
IToolController {
    public static final UnitDouble DEFAULT_FOV = new UnitDouble(45.0, NonSI.DEGREE_ANGLE);
    public static final int SNAPPER_NONE = 0;
    public static final int SNAPPER_SKETCH_GRID = 1;
    public static final int SNAPPER_MODEL_GRIDS = 2;
    public static final int FILTER_FDSPREVIEW = 0;
    public static final int FILTER_OBSTRUCTIONS = 1;
    public static final int FILTER_HOLES = 2;
    public static final int FILTER_VENTS = 3;
    public static final int FILTER_INIT = 4;
    public static final int FILTER_PARTCLOUDS = 5;
    public static final int FILTER_DEVICES = 6;
    public static final int FILTER_HVAC = 7;
    public static final int FILTER_ZONES = 9;
    public static final int FILTER_STATISTICS = 10;
    public static final int FILTER_SLICES = 11;
    public static final int FILTER_LABELS = 13;
    public static final int FILTER_CAD = 14;
    public static final int FILTER_CAMERAS = 16;
    private final AxesScene d_axes = new AxesScene();
    private final ClearableBackground d_colorLayer = new ClearableBackground(true, true);
    private final ModelScene d_backgroundScene = new ModelScene();
    private final ModelScene d_gridScene = new ModelScene();
    private final ModelScene d_originScene = new ModelScene();
    private final GeomScenes d_mainScenes = new GeomScenes();
    private final ModelScene d_manipScene = new ModelScene();
    private final GeomScenes d_xformScenes = new GeomScenes();
    private final ModelScene d_manipToolScene = new ModelScene();
    private final SceneRenderer d_toolLayer = new SceneRenderer();
    private final RenderComponent d_renderComp;
    private final RenderFile d_renderFile;
    private final View d_mainView;
    private final MouseSelectionLogic d_selLogic;
    private final ClippingManager d_clipMgr;
    private final SwingAnimSession d_animSession = new SwingAnimSession();
    private final PyroMod d_mediator;
    private final PyroSimColors d_colors;
    private final OriginSnapper d_origin = new OriginSnapper();
    private final SnapToGrid d_sketchGrid;
    private final CompositeModelGridSnapper d_modelGridSnapper;
    private IGridSnapper d_currentSnapper;
    private Floor d_currentFloor;
    private Floor d_allFloorsFloor = new Floor(Intl.intl("All Floors"));
    private final BooleanAction d_showGridDivsAction;
    private final BooleanAction d_showGridBoundaryAction;
    private final BooleanAction d_showGridOutlinesAction;
    private final BooleanAction d_showGuidesAction;
    private final BooleanAction d_showPointerAction;
    private final EditSnapSize d_editGridSizeAction;
    private final BooleanAction d_showOriginAction;
    private final BooleanAction d_showBackgroundImages;
    private final ConfigureBGImageAction d_configureBGImageAction;
    private final ManageFloorsAction d_manageFloorsAction;
    private final BooleanAction d_useSVNavAction;
    private final ResetToAllObjectsAction d_resetToAllAction;
    private final ResetToSelectedObjectsAction d_resetToSelectedAction;
    private final FillViewAction d_fillViewAction;
    private final ShowSolidOutlinesAction d_solidOutlinesAction;
    private final ShowRealisticAction d_realisticAction;
    private final ShowRealisticOutlinesAction d_realisticOutlinesAction;
    private final UseWireframeAction d_wireframeAction;
    private final UseWireframeAction d_solidAction;
    private final CutHolesAction d_cutHolesAction;
    private final MutuallyExclusiveAction d_noSnapperAction;
    private final MutuallyExclusiveAction d_sketchGridAction;
    private final MutuallyExclusiveAction d_modelGridsAction;
    private final FilterActionInfo[] d_clipFilterActions;
    private final FilterActionInfo[] d_filterActions;
    private final FilterActionInfo[] d_gridFilterActions;
    private JPanel d_3DPanel;
    private JPanel d_3DTopPanel;
    private final JToolBar d_viewOptionsToolbar;
    private final JToolBar d_floorToolbar;
    private final JToolBar d_editClipPlanesToolbar;
    private final JToolBar d_groupToolbar;
    private final JToolBar d_editToolbar;
    private final JToolBar d_createToolbar;
    private final JToolBar d_filterToolbar;
    private final guiStatusBar d_statusBar;
    private final guiLabel d_statusSelection;
    private final guiStatusMessage d_statusMessage;
    private final JComboBox d_floorBox;
    private final CompositeComboBox<IModelObj> d_groupBox;
    private final guiComboBox<Action> d_appearanceBox;
    private final ToolManager d_tools;
    private final ToolPropsAction d_toolPropsAction;
    private final GeomPicker d_snapper;
    private final ManipMgr d_manipMgr;
    private final ManipHook d_manipListener;
    private final GeomPicker d_manipSnapper;
    private final TransformMgr d_xformMgr;
    private final NavToolInfo d_orbitTool;
    private final NavToolInfo d_modGameRoamTool;
    private final NavToolInfo d_dragTool;
    private final NavToolInfo d_zoomTool;
    private final NavToolInfo d_zoomBoxTool;
    private final DrawToolBridge d_drawToolBridge;
    private final ADrawTool d_newSlabObstTool;
    private final ADrawTool d_newSlabHoleTool;
    private final ADrawTool d_newWallObstTool;
    private final ADrawTool d_newWallHoleTool;
    private final ADrawTool d_newGridObstTool;
    private final ADrawTool d_newGridHoleTool;
    private final ADrawTool d_gridSplitterTool;
    private final ADrawTool d_newRoomTool;
    private final ADrawTool d_newVentTool;
    private final ADrawTool d_newZoneTool;
    private final ADrawTool d_newPartCloudTool;
    private final ADrawTool d_newPartLocTool;
    private final ADrawTool d_newDevcTool;
    private final ADrawTool d_newInitTool;
    private final ADrawTool d_newGridTool;
    private final ADrawTool d_draw3dSliceTool;
    private final ADrawTool d_drawPlanarSliceTool;
    private final ADrawTool d_newHvacNodeTool;
    private final ADrawTool d_newHvacDuctTool;
    private final SurfacePainterTool d_surfPainterTool;
    private final SurfacePickerTool d_surfPickerTool;
    private final MeasureTool d_measureTool;
    private final NavToolInfo d_manipTool3D;
    private final NavToolInfo d_manipTool2D;
    private final CursorTool d_translateTool;
    private final CursorTool d_rotateTool;
    private final CursorTool d_mirrorTool;
    private final DrawProps d_paintProps;
    private final DrawProps d_wallProps;
    private final DrawProps d_holeProps;
    private final DrawProps d_gridProps;
    private final DrawProps d_blockProps;
    private final DrawProps d_partLocProps;
    private final DrawProps d_slabProps;
    private final DrawProps d_ventProps;
    private final DrawProps d_devcProps;
    private final DrawProps d_hvacNodeProps;
    private final DrawProps d_hvacDuctProps;
    private final DrawProps[] d_allProps;
    private final ViewMode3D d_mode3d;
    private final ViewMode2D d_mode2d;
    private IViewMode d_currViewMode;
    private final PyroNativeProps d_nDrawProps;
    private final PyroDrawProps d_drawProps;
    private final ViewModifiedListener d_cameraModifiedListener;
    private Set<CameraChangeListener> d_cameraChangeListeners;
    private DisplayManager d_dispMgr;
    private static final List<NavToolInfo> NAV_TOOLS = new ArrayList<NavToolInfo>();
    private static final Icon s_lbOnIcon = PyroGuiUtil.loadPyroSimIcon("lightbulb16.png", 8);
    private static final Icon s_lbOffIcon = PyroGuiUtil.loadPyroSimIcon("lightbulb_off16.png", 8);
    private static final PerspectiveCamera s_perspCam = new PerspectiveCamera(new Point3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), 0.1, 10000.0, DEFAULT_FOV.get(NonSI.DEGREE_ANGLE));

    public ModelView(PyroMod mediator, PyroSimColors colors) {
        IPopupMenuBuilder holeMenuBuilder;
        this.d_mediator = mediator;
        this.d_colors = colors;
        SurfaceProps sprops = RenderPrefs.getDefaultSurfaceProps(PyroPrefs.instance());
        this.d_renderComp = new RenderComponent(sprops);
        this.d_renderFile = new RenderFile(this.d_renderComp);
        this.d_mainView = new View((IRenderSurface)this.d_renderComp, this.d_mainScenes.scene);
        this.d_3DPanel = new JPanel(new BorderLayout());
        this.d_3DTopPanel = new JPanel(new BorderLayout());
        this.d_3DTopPanel.add((Component)this.d_renderComp, "Center");
        this.d_3DPanel.add((Component)this.d_3DTopPanel, "Center");
        boolean cutHoles = PyroPrefs.getBoolean(PyroPrefs.PREF_CUT_HOLES);
        this.d_nDrawProps = new PyroNativeProps();
        this.d_drawProps = new PyroDrawProps(this.d_nDrawProps, () -> this.d_dispMgr.getMergedGrids());
        this.d_drawProps.setCutHoles(cutHoles);
        this.d_mode2d = new ViewMode2D(this);
        this.d_mode3d = new ViewMode3D(this);
        this.d_currViewMode = null;
        this.initDisplayManagers();
        this.d_clipMgr = new ClippingManager(mediator, this, this.d_dispMgr.d_dispFilter);
        this.d_cameraChangeListeners = new LinkedIdentityHashSet<CameraChangeListener>();
        this.d_cameraModifiedListener = new ViewModifiedListener();
        PyroPickRoot pickRoot = new PyroPickRoot(this.d_mediator, this);
        this.d_snapper = new GeomPicker(pickRoot, this.d_mainView);
        this.d_manipSnapper = new GeomPicker(pickRoot, this.d_mainView);
        this.d_manipSnapper.setOcclusionFilteringEnabled(false);
        this.d_selLogic = new MouseSelectionLogic(this.d_mediator, this.d_renderComp);
        this.d_manipMgr = new ManipMgr(this.d_dispMgr);
        this.d_manipListener = new ManipHook(this.d_mediator, this, this.d_manipMgr, this.d_manipToolScene, this.d_dispMgr.d_dispFilter);
        this.d_paintProps = new DrawProps(this.d_mediator);
        this.d_wallProps = new DrawProps(this.d_mediator);
        this.d_holeProps = new DrawProps(this.d_mediator);
        this.d_gridProps = new DrawProps(this.d_mediator);
        this.d_blockProps = new DrawProps(this.d_mediator);
        this.d_partLocProps = new DrawProps(this.d_mediator);
        this.d_partLocProps.set(DrawProps.DROP_COUNT, new PartCloud.ConstDropletCount(1));
        this.d_slabProps = new DrawProps(this.d_mediator);
        this.d_ventProps = new DrawProps(this.d_mediator);
        this.d_devcProps = new DrawProps(this.d_mediator);
        this.d_hvacNodeProps = new DrawProps(this.d_mediator);
        this.d_hvacDuctProps = new DrawProps(this.d_mediator);
        this.d_allProps = new DrawProps[]{this.d_paintProps, this.d_wallProps, this.d_holeProps, this.d_gridProps, this.d_blockProps, this.d_slabProps, this.d_ventProps, this.d_devcProps, this.d_hvacNodeProps, this.d_hvacDuctProps, this.d_partLocProps};
        this.d_sketchGrid = new SnapToGrid(this.d_mainView, PyroPrefs.getDouble(PyroPrefs.DefaultSnapSpacing));
        this.d_modelGridSnapper = new CompositeModelGridSnapper(this.d_dispMgr.d_gridDispMan);
        this.d_currentSnapper = this.d_sketchGrid;
        this.d_mediator.getGeomLocator().add(this.d_modelGridSnapper);
        this.d_mediator.getGeomLocator().add(this.d_sketchGrid);
        this.d_mediator.getGeomLocator().add(this.d_origin);
        this.d_showGridDivsAction = new FilterAction<GridVis.Divisions>(Intl.intl("Show Mesh Divisions"), (Icon)PyroGuiUtil.loadPyroSimIcon("gridlines16.png"), GridVis.Divisions.class, PyroPrefs.ShowGridProp);
        this.d_showGridBoundaryAction = new FilterAction<GridVis.Boundary>(Intl.intl("Show Mesh Boundaries"), (Icon)PyroGuiUtil.loadPyroSimIcon("3dgrid_smooth16.gif"), GridVis.Boundary.class, PyroPrefs.ShowBoundaryProp);
        this.d_showGridOutlinesAction = new FilterAction<GridVis.Outline>(Intl.intl("Show Mesh Outlines"), (Icon)PyroGuiUtil.loadPyroSimIcon("boundary16.gif"), GridVis.Outline.class, PyroPrefs.ShowBoundaryLinesProp);
        this.d_showGuidesAction = new ShowGuidesAction(PyroPrefs.getBoolean(PyroPrefs.ShowGuidesProp));
        this.d_showPointerAction = new ShowSystemMouseAction(PyroPrefs.getBoolean(PyroPrefs.ShowSystemMouseProp));
        this.d_editGridSizeAction = new EditSnapSize();
        this.d_showOriginAction = new ShowOriginAction(PyroPrefs.getBoolean(PyroPrefs.ShowOriginProp));
        this.d_showBackgroundImages = new FilterAction<ModelImage>(Intl.intl("Show Background Images"), (Icon)PyroGuiUtil.loadPyroSimIcon("ConfigureBackgroundImage16.gif"), ModelImage.class, true);
        this.d_configureBGImageAction = new ConfigureBGImageAction();
        this.d_manageFloorsAction = new ManageFloorsAction();
        this.d_useSVNavAction = new UseSVNavigationAction(PyroPrefs.getBoolean(PyroPrefs.UseSVNavProp));
        this.d_resetToAllAction = new ResetToAllObjectsAction();
        this.d_resetToSelectedAction = new ResetToSelectedObjectsAction();
        this.d_fillViewAction = new FillViewAction();
        this.d_solidOutlinesAction = new ShowSolidOutlinesAction(false);
        this.d_realisticAction = new ShowRealisticAction(false);
        this.d_realisticOutlinesAction = new ShowRealisticOutlinesAction(false);
        this.d_wireframeAction = new UseWireframeAction(Intl.intl("Wireframe Rendering"), Intl.intl("Show Object Outlines Only"), false, "pyrosim/icons/wireframe.png", true);
        this.d_solidAction = new UseWireframeAction(Intl.intl("Solid Rendering"), Intl.intl("Show Objects as Solids"), true, "pyrosim/icons/solid.png", false);
        this.d_noSnapperAction = new SelectGridAction(0, false);
        this.d_sketchGridAction = new SelectGridAction(1, true);
        this.d_modelGridsAction = new SelectGridAction(2, false);
        ActionGroup gridGroup = new ActionGroup();
        gridGroup.add(this.d_noSnapperAction);
        gridGroup.add(this.d_sketchGridAction);
        gridGroup.add(this.d_modelGridsAction);
        this.d_cutHolesAction = new CutHolesAction();
        this.d_filterActions = new FilterActionInfo[]{new FilterActionInfo(new FDSPreviewAction()), new FilterActionInfo(new FilterAction<IObstruction>(Intl.intl("Show Obstructions"), (Icon)TVEntryPoints.ModelObjEP.ABLOCK_ICON, IObstruction.class, true)), new FilterActionInfo(new FilterAction<IHole>(Intl.intl("Show Holes"), (Icon)TVEntryPoints.ModelObjEP.AHOLE_ICON, IHole.class, true)), new FilterActionInfo(new FilterAction<Vent>(Intl.intl("Show Vents"), (Icon)TVEntryPoints.ModelObjEP.VENT_ICON, Vent.class, true)), new FilterActionInfo(new FilterAction<InitRegion>(Intl.intl("Show Init Regions"), (Icon)TVEntryPoints.ModelObjEP.INIT_REGION_ICON, InitRegion.class, true)), new FilterActionInfo(new FilterAction<PartCloud>(Intl.intl("Show Particle Clouds"), (Icon)TVEntryPoints.ModelObjEP.PART_CLOUD_ICON, PartCloud.class, true)), new FilterActionInfo(new FilterAction<IDevice>(Intl.intl("Show Devices"), (Icon)PyroGuiUtil.loadPyroSimIcon("sprk3.gif"), IDevice.class, true)), new FilterActionInfo(new FilterAction<IHvacGeomComp>(Intl.intl("Show HVAC Components"), (Icon)PyroGuiUtil.loadPyroSimIcon("hvac_fan16.png"), IHvacGeomComp.class, true)), null, new FilterActionInfo(new FilterAction<Zone>(Intl.intl("Show Zones"), (Icon)PyroGuiUtil.loadPyroSimIcon("zones16.png"), Zone.class, false)), new FilterActionInfo(new FilterAction<IMeasurementStat>(Intl.intl("Show Statistics Regions"), (Icon)PyroGuiUtil.loadPyroSimIcon("stat16.png"), IMeasurementStat.class, false)), new FilterActionInfo(new FilterAction<Slice>(Intl.intl("Show Slices"), (Icon)PyroGuiUtil.loadPyroSimIcon("slices16.png"), Slice.class, true)), null, new FilterActionInfo(new FilterAction<LabelMgr.Filter>(Intl.intl("Show Labels"), Intl.intl("LBL"), LabelMgr.Filter.class, true)), new FilterActionInfo(new FilterAction<GenericGeomSrc>(Intl.intl("Show Imported CAD Lines"), Intl.intl("CAD"), GenericGeomSrc.class, true)), null, new FilterActionInfo(new FilterAction<CameraState>(Intl.intl("Show Cameras"), TVEntryPoints.CameraStateEP.ICON, CameraState.class, Predicates.alwaysFalse(), cs -> this.d_mediator.getViews().getActiveView() != cs.getParent(), events -> events.getEvents(ViewMgr.class, new Class[0]).hasChangedObjs(ViewMgr.EVT_ACTIVE_VIEW) || events.getEvents(pyrosim.domain.view.View.class, new Class[0]).hasChangedObjs(pyrosim.domain.view.View.PROP_CAMERA) || events.getEvents(CameraState.class, new Class[0]).isModified(), false))};
        this.d_gridFilterActions = new FilterActionInfo[]{new FilterActionInfo(this.d_showGridDivsAction), new FilterActionInfo(this.d_showGridBoundaryAction), new FilterActionInfo(this.d_showGridOutlinesAction)};
        this.d_clipFilterActions = new FilterActionInfo[]{new FilterActionInfo(new FilterAction<ClippingManager.EnableClipping>(Intl.intl("Enable Section Boxes"), (Icon)null, ClippingManager.EnableClipping.class, true)), new FilterActionInfo(new FilterAction<SectionBox>(Intl.intl("Show Section Boxes"), null, SectionBox.class, Predicates.alwaysFalse(), sbox -> this.d_mediator.getViews().getActiveView() == sbox.getParent(), events -> events.getEvents(ViewMgr.class, new Class[0]).hasChangedObjs(ViewMgr.EVT_ACTIVE_VIEW), true))};
        this.d_clipFilterActions[0].action.putValue("AcceleratorKey", Accelerators.ENABLE_SECTION_BOXES);
        this.d_clipFilterActions[1].action.putValue("AcceleratorKey", Accelerators.SHOW_SECTION_BOXES);
        this.d_statusBar = new guiStatusBar();
        this.d_statusMessage = new guiStatusMessage();
        this.d_statusBar.setStatusMessage(this.d_statusMessage);
        this.d_statusSelection = new guiLabel("");
        this.d_statusBar.addNextPane(this.d_statusSelection, 0.0);
        this.d_statusBar.togglePane(1, false);
        this.d_floorBox = new JComboBox();
        this.d_floorBox.setRenderer(new FloorBoxRenderer());
        this.d_floorBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedFloor = ModelView.this.d_floorBox.getSelectedItem();
                if (selectedFloor != null && selectedFloor != ModelView.this.d_currentFloor) {
                    if (selectedFloor.equals(ModelView.this.d_allFloorsFloor)) {
                        ModelView.this.setFloor(null);
                    } else {
                        ModelView.this.setFloor((Floor)selectedFloor);
                    }
                    ModelView.this.d_renderComp.repaint();
                }
            }
        });
        this.d_floorBox.setLightWeightPopupEnabled(false);
        this.d_floorBox.setToolTipText(Intl.intl("Change the Floor View"));
        this.d_groupBox = new CompositeComboBox<IModelObj>(this.d_mediator.getObstructions());
        this.d_groupBox.setLightWeightPopupEnabled(false);
        this.d_groupBox.setToolTipText(Intl.intl("Change the group that new objects are added to"));
        this.d_appearanceBox = new guiComboBox<Action>((T[])new Action[]{this.d_wireframeAction, this.d_solidAction, this.d_solidOutlinesAction, this.d_realisticAction, this.d_realisticOutlinesAction});
        this.d_appearanceBox.setRenderer(new PyroGuiUtil.ActionCellRenderer());
        this.d_appearanceBox.setToolTipText(Intl.intl("Change how the model is rendered"));
        this.d_appearanceBox.addActionListener(e -> this.d_appearanceBox.getSelectedItem().actionPerformed(e));
        this.d_tools = new ToolManager(this.getRenderComponent());
        this.d_drawToolBridge = new DrawToolBridge(this.d_mediator, this, this.d_dispMgr, this.d_tools);
        this.d_toolPropsAction = new ToolPropsAction();
        IPopupMenuBuilder gridMenuBuilder = holeMenuBuilder = new IPopupMenuBuilder(){

            @Override
            public void buildMenu(IPyroTool tool, MenuBuilder menuBuilder) {
                menuBuilder.addSeparator();
                ToolUtil.addColorSubmenu(ModelView.this.d_mediator, tool.getProps(), menuBuilder);
                menuBuilder.addSeparator();
            }
        };
        IPopupMenuBuilder obstMenuBuilder = new IPopupMenuBuilder(){

            @Override
            public void buildMenu(IPyroTool tool, MenuBuilder menuBuilder) {
                menuBuilder.addSeparator();
                ToolUtil.addSurfSubmenu(ModelView.this.d_mediator, tool.getProps(), Obstruction.getSurfaceFilter(), menuBuilder);
                ToolUtil.addColorSubmenu(ModelView.this.d_mediator, tool.getProps(), menuBuilder);
                menuBuilder.addSeparator();
            }
        };
        IPopupMenuBuilder ventMenuBuilder = new IPopupMenuBuilder(){

            @Override
            public void buildMenu(IPyroTool tool, MenuBuilder menuBuilder) {
                menuBuilder.addSeparator();
                ToolUtil.addSurfSubmenu(ModelView.this.d_mediator, tool.getProps(), Vent.getSurfaceFilter(), menuBuilder);
                ToolUtil.addColorSubmenu(ModelView.this.d_mediator, tool.getProps(), menuBuilder);
                menuBuilder.addSeparator();
            }
        };
        this.d_newGridTool = new DrawGridGeomTool((IToolController)this, this.d_gridProps);
        this.d_newGridTool.setMenuBuilder(gridMenuBuilder);
        this.d_tools.addTool(this.d_newGridTool, ToolNames.NEW_MESH, Intl.intl("Draw a Mesh"), PyroGuiUtil.loadPyroSimIcon("3dgrid_smooth16.gif"), true, new ToolMeta(true, DrawProps.ObjType.MESH));
        this.d_newWallObstTool = new DrawWallGeomTool((IToolController)this, this.d_wallProps);
        this.d_newWallObstTool.setMenuBuilder(obstMenuBuilder);
        this.d_tools.addTool(this.d_newWallObstTool, ToolNames.NEW_WALL, Intl.intl("Draw a Wall Obstruction"), PyroGuiUtil.loadPyroSimIcon("block16_2.gif"), true, new ToolMeta(true, DrawProps.ObjType.OBSTRUCTION));
        this.d_newWallHoleTool = new DrawWallGeomTool((IToolController)this, this.d_holeProps);
        this.d_newWallHoleTool.setMenuBuilder(holeMenuBuilder);
        this.d_tools.addTool(this.d_newWallHoleTool, ToolNames.NEW_WALL_HOLE, Intl.intl("Draw a Wall Hole"), PyroGuiUtil.loadPyroSimIcon("wall_hole16.png"), true, new ToolMeta(true, DrawProps.ObjType.HOLE));
        this.d_newGridObstTool = new DrawGridCellTool(this, this.d_blockProps);
        this.d_newGridObstTool.setMenuBuilder(obstMenuBuilder);
        this.d_tools.addTool(this.d_newGridObstTool, ToolNames.NEW_BLOCK, Intl.intl("Draw a Block Obstruction"), PyroGuiUtil.loadPyroSimIcon("cube16.png"), true, new ToolMeta(true, DrawProps.ObjType.OBSTRUCTION));
        this.d_newGridHoleTool = new DrawGridCellTool(this, this.d_blockProps);
        this.d_newGridHoleTool.setMenuBuilder(holeMenuBuilder);
        this.d_tools.addTool(this.d_newGridHoleTool, ToolNames.NEW_BLOCK_HOLE, Intl.intl("Draw a Block Hole"), PyroGuiUtil.loadPyroSimIcon("hole16.gif"), true, new ToolMeta(true, DrawProps.ObjType.HOLE));
        this.d_newSlabObstTool = new DrawExtrudedPolyTool((IToolController)this, this.d_slabProps);
        this.d_newSlabObstTool.setMenuBuilder(obstMenuBuilder);
        this.d_tools.addTool(this.d_newSlabObstTool, ToolNames.NEW_SLAB, Intl.intl("Draw a Slab Obstruction"), PyroGuiUtil.loadPyroSimIcon("floor16.png"), true, new ToolMeta(true, DrawProps.ObjType.OBSTRUCTION));
        this.d_newSlabHoleTool = new DrawExtrudedPolyTool((IToolController)this, this.d_slabProps);
        this.d_newSlabHoleTool.setMenuBuilder(holeMenuBuilder);
        this.d_tools.addTool(this.d_newSlabHoleTool, ToolNames.NEW_SLAB_HOLE, Intl.intl("Draw a Slab Hole"), PyroGuiUtil.loadPyroSimIcon("floor_hole.png"), true, new ToolMeta(true, DrawProps.ObjType.HOLE));
        this.d_newRoomTool = new DrawRoomTool((IToolController)this, this.d_wallProps);
        this.d_newRoomTool.setMenuBuilder(obstMenuBuilder);
        this.d_tools.addTool(this.d_newRoomTool, ToolNames.NEW_ROOM, Intl.intl("Draw a Room"), PyroGuiUtil.loadPyroSimIcon("room16_2.png"), true, new ToolMeta(true, DrawProps.ObjType.OBSTRUCTION));
        this.d_newZoneTool = new DrawAABoxGeomTool((IToolController)this, this.d_blockProps);
        this.d_tools.addTool(this.d_newZoneTool, ToolNames.NEW_ZONE, Intl.intl("Draw a Zone"), PyroGuiUtil.loadPyroSimIcon("zones16.png"), true, new ToolMeta(true, DrawProps.ObjType.ZONE));
        this.d_newVentTool = new DrawAARectangleTool((IToolController)this, this.d_ventProps);
        this.d_newVentTool.setMenuBuilder(ventMenuBuilder);
        DefaultIsectFilter drawVentFilter = DrawAARectangleTool.getDefaultFilter();
        drawVentFilter.geomType = DefaultIsectFilter.acceptGeomTypes(GeomType.FACE, GeomType.FACE_EDGE, GeomType.FACE_VERTEX);
        this.d_newVentTool.setSnapInfo(SnapMode.FILTERED_TWO_PASS, drawVentFilter);
        this.d_tools.addTool(this.d_newVentTool, ToolNames.NEW_VENT, Intl.intl("Draw a Vent"), PyroGuiUtil.loadPyroSimIcon("vent16.gif"), true, new ToolMeta(true, DrawProps.ObjType.VENT));
        this.d_newPartCloudTool = new DrawAABoxGeomTool((IToolController)this, this.d_blockProps);
        this.d_tools.addTool(this.d_newPartCloudTool, ToolNames.NEW_PARTICLE_CLOUD, Intl.intl("Draw a Particle Cloud"), PyroGuiUtil.loadPyroSimIcon("partCloud16.gif"), true, new ToolMeta(true, DrawProps.ObjType.PART_CLOUD));
        this.d_newPartLocTool = new DrawPointTool((IToolController)this, this.d_partLocProps);
        this.initPointTool(this.d_newPartLocTool, null, null);
        this.d_tools.addTool(this.d_newPartLocTool, ToolNames.NEW_PARTICLE_LOCATION, Intl.intl("Draw Particles at a Point"), PyroGuiUtil.loadPyroSimIcon("single_part16.gif"), true, new ToolMeta(true, DrawProps.ObjType.PART_CLOUD));
        this.d_draw3dSliceTool = new DrawAABoxGeomTool((IToolController)this, this.d_blockProps);
        this.d_tools.addTool(this.d_draw3dSliceTool, ToolNames.NEW_3D_SLICE, Intl.intl("Draw a 3D Slice"), PyroGuiUtil.loadPyroSimIcon("slices3d.png"), true, new ToolMeta(true, DrawProps.ObjType.SLICE3D));
        this.d_newInitTool = new DrawAABoxGeomTool((IToolController)this, this.d_blockProps);
        this.d_tools.addTool(this.d_newInitTool, ToolNames.NEW_INIT, Intl.intl("Draw an Init Region"), PyroGuiUtil.loadPyroSimIcon("init16.png"), true, new ToolMeta(true, DrawProps.ObjType.INIT_REGION));
        this.d_newDevcTool = new DrawPointTool((IToolController)this, this.d_devcProps);
        this.initDeviceToolMenuBuilder(this.d_newDevcTool);
        this.d_tools.addTool(this.d_newDevcTool, ToolNames.NEW_DEVICE, Intl.intl("Draw a Device"), PyroGuiUtil.loadPyroSimIcon("sprk3.gif"), true, new ToolMeta(true, DrawProps.ObjType.POINT_DEVC));
        this.d_newHvacNodeTool = new DrawPointTool((IToolController)this, this.d_hvacNodeProps);
        this.initPointTool(this.d_newHvacNodeTool, null, null);
        this.d_tools.addTool(this.d_newHvacNodeTool, ToolNames.NEW_HVAC_NODE, Intl.intl("Draw an HVAC Node"), PyroGuiUtil.loadPyroSimIcon("hvac_node16.png"), true, new ToolMeta(true, DrawProps.ObjType.HVAC_NODE));
        this.d_newHvacDuctTool = new DrawHvacDuctTool((IToolController)this, this.d_hvacDuctProps);
        this.d_tools.addTool(this.d_newHvacDuctTool, ToolNames.NEW_HVAC_DUCT, Intl.intl("Draw an HVAC Duct"), PyroGuiUtil.loadPyroSimIcon("hvac_duct16.png"), true, new ToolMeta(true, DrawProps.ObjType.HVAC_DUCT));
        this.d_surfPainterTool = new SurfacePainterTool(this.d_mediator, this, this.d_dispMgr, this.d_paintProps);
        this.d_tools.addTool(this.d_surfPainterTool, ToolNames.SURFACE_PAINTER, Intl.intl("Paint Obstruction Surfaces"), PyroGuiUtil.loadPyroSimIcon("paint_bucket16.png"), true, new ToolMeta(true, null));
        this.d_surfPickerTool = new SurfacePickerTool(this.d_mediator, this, this.d_paintProps, this.d_paintProps, this.d_gridProps, this.d_devcProps, this.d_wallProps, this.d_blockProps, this.d_ventProps, this.d_slabProps, this.d_partLocProps);
        this.d_tools.addTool(this.d_surfPickerTool, ToolNames.SURFACE_PICKER, Intl.intl("Pick a Surface from an Obstruction"), PyroGuiUtil.loadPyroSimIcon("eye_dropper16.png"), true, new ToolMeta(true, null));
        this.d_drawPlanarSliceTool = new DrawPlaneGeomTool(this, this.d_blockProps, false, true, new MeshAutoAxisChooser(mediator, false));
        this.d_tools.addTool(this.d_drawPlanarSliceTool, ToolNames.NEW_PLANAR_SLICE, Intl.intl("Draw a Planar Slice"), PyroGuiUtil.loadPyroSimIcon("slices16.png"), true, new ToolMeta(true, DrawProps.ObjType.SLICE));
        this.d_gridSplitterTool = new DrawPlaneGeomTool(this, this.d_wallProps, true, true, new MeshAutoAxisChooser(mediator, true));
        this.d_tools.addTool(this.d_gridSplitterTool, ToolNames.SPLIT_MESH, Intl.intl("Split selected meshes along a grid division"), PyroGuiUtil.loadPyroSimIcon("splitmesh3_16.png"), true, new ToolMeta(false, DrawProps.ObjType.MESH_SPLIT));
        this.d_measureTool = new MeasureTool((IToolController)this, this.d_blockProps);
        this.d_tools.addTool(this.d_measureTool, ToolNames.MEASURE, Intl.intl("Measure"), PyroGuiUtil.loadPyroSimIcon("ruler16.png"), true, new ToolMeta(false, null));
        OrbitFunc orbit = new OrbitFunc();
        DragFunc drag = new DragFunc();
        ZoomFunc zoom = new ZoomFunc();
        ZoomBoxFunc zoomBox = new ZoomBoxFunc();
        ManipFunc manipFunc = new ManipFunc(this, this.d_manipMgr, this.d_manipSnapper, this.d_manipToolScene);
        SelectionFunc selFunc = new SelectionFunc(this.d_snapper, new Pyro3DSelector(this.d_selLogic));
        Function<IToolFunction, CursorTool> createTool = tf -> new CursorTool(this, (IToolFunction)tf);
        this.d_xformMgr = new TransformMgr(this.d_mediator, this.d_dispMgr, new DisplayManager(mediator, this, this.d_xformScenes.scene, null, this.d_xformScenes.patch, this.d_backgroundScene, this.d_gridScene, this.d_xformScenes.noclip, this.d_xformScenes.excludedNoClip));
        this.d_translateTool = new TranslateTool(this, this.d_xformMgr, this.d_manipToolScene, this.d_slabProps);
        this.d_tools.addTool(this.d_translateTool, ToolNames.MOVE, Intl.intl("Move Objects"), PyroGuiUtil.loadPyroSimIcon("move.png"), true, new ToolMeta(false, null));
        this.d_rotateTool = new RotateTool(this, this.d_xformMgr, this.d_manipToolScene, this.d_slabProps);
        this.d_tools.addTool(this.d_rotateTool, ToolNames.ROTATE, Intl.intl("Rotate Objects"), PyroGuiUtil.loadPyroSimIcon("rotateObj.png"), true, new ToolMeta(false, null));
        this.d_mirrorTool = new MirrorTool(this, this.d_xformMgr, this.d_manipToolScene, this.d_slabProps);
        this.d_tools.addTool(this.d_mirrorTool, ToolNames.MIRROR, Intl.intl("Mirror Objects"), PyroGuiUtil.loadPyroSimIcon("mirror16.png"), true, new ToolMeta(false, null));
        MultiFunc pickFunc3d = new MultiFunc(manipFunc, selFunc, orbit, drag);
        this.d_manipTool3D = new NavToolInfo(createTool.apply(pickFunc3d), View.NavTool.SELECT);
        this.d_tools.addTool(this.d_manipTool3D.tool, ToolNames.SELECT, Intl.intl("Select and Manipulate Objects"), PyroGuiUtil.loadTeciIcon("pointer16.gif"));
        MultiFunc pickFunc2d = new MultiFunc(manipFunc, selFunc, drag, drag);
        this.d_manipTool2D = new NavToolInfo(createTool.apply(pickFunc2d), View.NavTool.SELECT);
        this.d_tools.addTool(this.d_manipTool2D.tool, ToolNames.SELECT, Intl.intl("Select and Manipulate Objects"), PyroGuiUtil.loadTeciIcon("pointer16.gif"));
        RoamFunc<CursorTool> roamFunc = new RoamFunc<CursorTool>(selFunc);
        this.d_modGameRoamTool = new NavToolInfo(createTool.apply(roamFunc), View.NavTool.ROAM);
        this.d_tools.addTool(this.d_modGameRoamTool.tool, ToolNames.ROAM, Intl.intl("Roam"), RoamFunc.ICON);
        this.d_dragTool = new NavToolInfo(createTool.apply(drag), View.NavTool.PAN);
        this.d_tools.addTool(this.d_dragTool.tool, ToolNames.PAN, Intl.intl("Pan View"), DragFunc.ICON);
        this.d_zoomTool = new NavToolInfo(createTool.apply(zoom), View.NavTool.ZOOM);
        this.d_tools.addTool(this.d_zoomTool.tool, ToolNames.ZOOM, Intl.intl("Zoom"), ZoomFunc.ICON);
        this.d_zoomBoxTool = new NavToolInfo(createTool.apply(zoomBox), View.NavTool.ZOOM_BOX);
        this.d_tools.addTool(this.d_zoomBoxTool.tool, ToolNames.ZOOM_BOX, Intl.intl("Zoom Box"), ZoomBoxFunc.ICON);
        IToolFunction<CursorTool> svNav = ModelView.makeSVNavFunc(selFunc);
        CompositeFunc compFunc3d = NavtoolUtil.newCompositeNav3DTool(orbit, zoom, drag, selFunc);
        this.d_orbitTool = new NavToolInfo(createTool.apply(new SwitchingToolFunc(0, compFunc3d, svNav)), View.NavTool.ORBIT);
        this.d_tools.addTool(this.d_orbitTool.tool, ToolNames.ORBIT, Intl.intl("3D Orbit Navigation"), OrbitFunc.ICON);
        this.d_tools.addToolChangeListener((oldTool, newTool) -> {
            Object meta;
            this.updateCurrentTool();
            if (newTool != null && (meta = this.d_tools.getProps((Tool)newTool).meta) instanceof ToolMeta && ((ToolMeta)meta).clearSelection) {
                EventQueue.invokeLater(() -> this.d_mediator.getSelectionModel().clearSelection());
            }
        });
        ((SwitchingToolFunc)this.d_orbitTool.tool.getFunction()).setCurrentFunc(this.d_useSVNavAction.isSelected() ? 1 : 0);
        this.d_floorToolbar = this.createFloorToolbar();
        this.d_editClipPlanesToolbar = this.createClipToolbar();
        this.d_groupToolbar = this.createGroupToolbar();
        this.d_editToolbar = this.createEditToolbar();
        this.d_createToolbar = this.createCreationToolbar();
        this.d_viewOptionsToolbar = this.createViewOptionsToolbar();
        this.d_filterToolbar = this.createFilterToolbar();
        this.d_tools.getToolbarButton(this.d_newPartCloudTool).setEnabled(this.d_mediator.getPartList().flatten().size() > 0);
        this.d_tools.getToolbarButton(this.d_newPartLocTool).setEnabled(this.d_mediator.getPartList().flatten().size() > 0);
        this.updateColors();
        this.setMode(ViewMode.MV_3D);
        this.resetFloorBox(true);
        this.updateGroupBox();
        this.updatePrefs();
        this.updateToolsThatTargetSelectedObjects();
        this.d_gridScene.addRenderableObjects(this.d_sketchGrid);
        this.d_originScene.addRenderableObjects(this.d_origin);
        this.d_renderComp.addComponentListener(new AbstractComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                ModelView.this.d_renderComp.removeComponentListener(this);
                AABox bounds = ModelView.this.getModelSceneBounds();
                ModelView.this.d_mode2d.resetAllCameras(ModelView.this, bounds, true);
                ModelView.this.d_mode3d.resetAllCameras(ModelView.this, bounds, true);
                ModelView.this.d_renderComp.repaint();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                ModelView.this.d_tools.getCurrentTool().activate();
            }
        });
        this.d_colors.addColorChangedListener(this);
        this.d_mediator.getEvents().addObserver(this);
        this.d_renderComp.addKeyListener(new GCListener());
        this.d_renderComp.addResourceInitListener(comp -> this.detectVideoAdapter());
    }

    private static <T> boolean test(TypedProp<T> prop) {
        return PyroPrefs.instance().containsKey(prop.key);
    }

    private static boolean getRetestGraphics() {
        return !ModelView.test(RenderPrefs.PREF_USEVERTEXBUFFERS) || !ModelView.test(RenderPrefs.PREF_SCENESHADERS);
    }

    private void detectVideoAdapter() {
        if (PyroSim.getApp().isSafeMode()) {
            return;
        }
        IRenderSurface.Adapter adapter = this.d_renderComp.getAdapter();
        PyroPrefs.Version ver = PyroPrefs.getVersion();
        boolean forceRedetect = ModelView.getRetestGraphics() || ver.ordinal() < PyroPrefs.Version.VER_0001.ordinal() && adapter == IRenderSurface.Adapter.INTEL;
        TeciProps tprops = (TeciProps)PyroPrefs.instance().clone();
        if (RenderPrefs.detectVideoAdapter(tprops, PyroSim.getApp().isSafeMode(), this.d_renderComp, forceRedetect, ModelView::getLocalDefaultPrefs)) {
            PyroSim.setPrefs(tprops, true);
        }
    }

    private static void getLocalDefaultPrefs(TeciProps props, IRenderSurface.SurfPrefs caps) {
        props.set(PyroPrefs.PREF_DRAWCOLORBUFFER, Boolean.valueOf(true));
    }

    public TeciProps getDefaultPrefs() {
        return RenderPrefs.getDefaultPrefs(this.d_renderComp, ModelView::getLocalDefaultPrefs);
    }

    public void showIntelWarning() {
        RenderPrefs.showIntelWarning("PyroSim", this.d_renderComp, PyroPrefs.instance());
    }

    protected void initDeviceToolMenuBuilder(IPyroTool devcTool) {
        final WorkingZConstraintGen fixedPlaneConstraint = new WorkingZConstraintGen();
        IConstraintGen autoConstraint = new IConstraintGen(){

            @Override
            public ISnapConstraint getConstraint(IPyroTool tool) {
                if (tool.getProps().get(DrawProps.DEVC) instanceof IFreePointDevice) {
                    return fixedPlaneConstraint.getConstraint(tool);
                }
                return null;
            }
        };
        this.initPointTool(devcTool, Intl.intl("Lock Z by device type"), autoConstraint);
    }

    protected void initPointTool(final IPyroTool tool, Object autoConstraintName, IConstraintGen autoConstraint) {
        WorkingZConstraintGen fixedPlaneConstraint = new WorkingZConstraintGen();
        OffsetConstraintGen offsetConstraint = new OffsetConstraintGen();
        ArrayList<Pair<Object, IConstraintGen>> constraints = new ArrayList<Pair<Object, IConstraintGen>>();
        if (autoConstraint != null) {
            constraints.add(new Pair<Object, IConstraintGen>(autoConstraintName, autoConstraint));
        }
        constraints.add(new Pair<String, WorkingZConstraintGen>(Intl.intl("Lock Z to drawing plane"), fixedPlaneConstraint));
        constraints.add(new Pair<String, NoConstraintGen>(Intl.intl("Lock Z to snap location"), NoConstraintGen.INSTANCE));
        constraints.add(new Pair<String, OffsetConstraintGen>(Intl.intl("Offset Z from snap location"), offsetConstraint));
        final SnapConstraintMenuBuilder perspMenuBuilder = new SnapConstraintMenuBuilder(constraints);
        CameraMenuBuilder menuBuilder = new CameraMenuBuilder(null, perspMenuBuilder);
        tool.setMenuBuilder(menuBuilder);
        final IConstraintGen defPerspConstraint = (IConstraintGen)((Pair)constraints.get((int)0)).v2;
        tool.setConstraintGen(defPerspConstraint);
        tool.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IPyroTool tool) {
                if (!ModelView.isOrtho(tool.getView().getCamera())) {
                    perspMenuBuilder.toggleCurrentConstraint(tool);
                }
            }
        });
        this.addCameraChangeListener(new CameraChangeListener(){
            private IConstraintGen d_perspConstraint;
            {
                this.d_perspConstraint = defPerspConstraint;
            }

            @Override
            public void cameraChanged(Camera oldCamera, Camera newCamera) {
                if (ModelView.isOrtho(newCamera) && !ModelView.isOrtho(oldCamera)) {
                    this.d_perspConstraint = tool.getConstraintGen();
                    tool.setConstraintGen(WorkingPlaneConstraintGen.INSTANCE);
                } else if (!ModelView.isOrtho(newCamera) && ModelView.isOrtho(oldCamera)) {
                    assert (this.d_perspConstraint != null);
                    tool.setConstraintGen(this.d_perspConstraint);
                    this.d_perspConstraint = null;
                }
            }
        });
    }

    private static boolean isOrtho(Camera c) {
        return c instanceof OrthoCamera;
    }

    public JPanel getViewComponent() {
        return this.d_3DPanel;
    }

    public ToolManager getToolManager() {
        return this.d_tools;
    }

    public void cancelCurrentTool() {
        this.d_tools.cancelCurrentTool();
    }

    public ManipMgr getManipMgr() {
        return this.d_manipMgr;
    }

    public TransformMgr getTransformMgr() {
        return this.d_xformMgr;
    }

    public double getSketchGridSpacing() {
        return this.d_sketchGrid.getSpacing();
    }

    public void setSketchGridSpacing(double spacing) {
        this.d_sketchGrid.setSpacing(spacing);
    }

    public SnapToGrid getSketchGrid() {
        return this.d_sketchGrid;
    }

    @Override
    public ModelScene[] getToolScenes() {
        return new ModelScene[]{this.d_manipScene, null};
    }

    @Override
    public GeomPicker getSnapper() {
        return this.d_snapper;
    }

    private static QuickSaveRestoreLayer createQuickRestoreLayout() {
        PyroSim app = PyroSim.getApp();
        boolean colorEnabled = app.getPrefs().getBoolean(PyroPrefs.PREF_DRAWCOLORBUFFER);
        boolean depthEnabled = app.getPrefs().getBoolean(PyroPrefs.PREF_DRAWDEPTHBUFFER);
        QuickSaveRestoreLayer layer = new QuickSaveRestoreLayer();
        layer.setColorEnabled(colorEnabled);
        layer.setDepthEnabled(depthEnabled);
        return layer;
    }

    private void initLayouts(IViewMode mode) {
        OverlayLayout mainLayout = new OverlayLayout();
        OverlayLayout screenshotLayout = new OverlayLayout();
        mode.initLayout(this, mainLayout, true);
        mode.initLayout(this, screenshotLayout, false);
        mainLayout.add(this.d_axes, 13, 0.15f, 0.15f);
        mainLayout.add(this.d_toolLayer);
        this.d_renderComp.getRootPanel().setLayoutManager(mainLayout);
        this.d_renderFile.getRootPanel().setLayoutManager(screenshotLayout);
    }

    private static IToolFunction<CursorTool> makeSVNavFunc(SelectionFunc sel) {
        CompositeFunc<CursorTool> tool = new CompositeFunc<CursorTool>();
        tool.setToolEvents(new SmokeViewNavigationFunc(), 0, 1, 4);
        tool.setToolEvents(sel, 2, 8, 5);
        return tool;
    }

    private void updateToolsThatTargetSelectedObjects() {
        PyroSimSelectionModel sel = this.d_mediator.getSelectionModel();
        Collection<IPyroGeomSrc> selObjs = sel.flatten(IPyroGeomSrc.class);
        boolean enable = !selObjs.isEmpty();
        this.d_resetToSelectedAction.setEnabled(enable);
        this.d_tools.getToolAction(this.d_translateTool).setEnabled(enable);
        this.d_tools.getToolAction(this.d_rotateTool).setEnabled(enable);
        this.d_tools.getToolAction(this.d_mirrorTool).setEnabled(enable);
        this.d_tools.getToolbarButton(this.d_gridSplitterTool).setEnabled(!sel.flatten(Grid.class).isEmpty());
    }

    private void initActiveView() {
        ViewMode mode = this.d_mediator.getViews().getActiveView().getViewMode().orElse(ViewMode.getDefault());
        this.updateActiveViewMode(mode);
        this.updateActiveViewCam();
    }

    private void updateActiveView() {
        this.d_mediator.getViews().getActiveView().getViewMode().ifPresent(vm -> {
            this.updateActiveViewMode((ViewMode)((Object)vm));
            this.updateActiveViewCam();
        });
    }

    public void setView(CameraState camera, View.NavTool navTool) {
        this.updateActiveViewMode(camera.getViewMode());
        this.setCameraState(camera);
        if (navTool != null) {
            this.setNavTool(navTool);
        }
    }

    public Task taskSaveViewState(PyroMod mod, List<pyrosim.domain.view.View> views) {
        ViewMode mode = this.d_currViewMode == this.d_mode2d ? ViewMode.MV_2D : ViewMode.MV_3D;
        return this.taskSaveViewState(mod, views, mode);
    }

    public Task taskSaveViewState(PyroMod mod, List<pyrosim.domain.view.View> views, ViewMode mode) {
        AViewMode vmode;
        switch (mode) {
            case MV_2D: {
                vmode = this.d_mode2d;
                break;
            }
            default: {
                vmode = this.d_mode3d;
            }
        }
        CameraRecord rec = vmode.getCamera(this).capture();
        Tool navTool = vmode.getNavTool(this);
        NavToolInfo nti = NAV_TOOLS.stream().filter(t -> t.tool == navTool).findFirst().orElse(this.d_orbitTool);
        View.NavTool type = nti.type;
        CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(mod);
        task.addTask(ViewPropTask.set(views, pyrosim.domain.view.View.PROP_CAMERA, (v, i) -> new CameraState(rec)));
        task.addTask(ViewPropTask.set(views, pyrosim.domain.view.View.PROP_NAV_TOOL, (v, i) -> type));
        return task;
    }

    private void updateActiveViewCam() {
        pyrosim.domain.view.View aview = this.d_mediator.getViews().getActiveView();
        CameraState cstate = aview.get(pyrosim.domain.view.View.PROP_CAMERA);
        if (cstate != null) {
            this.setCameraState(cstate);
            View.NavTool ntool = aview.get(pyrosim.domain.view.View.PROP_NAV_TOOL);
            if (ntool != null) {
                this.setNavTool(ntool);
            }
        }
    }

    private void setCameraState(CameraState cstate) {
        if (((CameraRecord)cstate.get()).frustum instanceof OrthoCamera.FrustumRecord) {
            PredefCam cam2d = null;
            for (PredefCam cam : PredefCam.values()) {
                if (!cam.is2D()) continue;
                Vector3d cup = ((CameraRecord)cstate.get()).up;
                Vector3d cview = Util3D.vectorN(((CameraRecord)cstate.get()).loc, ((CameraRecord)cstate.get()).ref);
                Vector3d pup = cam.cam.getUpVector();
                Vector3d pview = cam.cam.getViewVector();
                pview.normalize();
                if (!cup.epsilonEquals(pup, 1.0E-6) || !cview.epsilonEquals(pview, 1.0E-6)) continue;
                cam2d = cam;
                break;
            }
            if (cam2d != null) {
                this.d_mode2d.setCamera(this, cam2d);
            }
        }
        this.d_mainView.getCamera().apply((CameraRecord)cstate.get());
    }

    public void setNavTool(View.NavTool ntool) {
        NavToolInfo newTool = null;
        Predicate<Tool> toolFilter = this.getCurrentViewMode().getToolFilter(this);
        for (NavToolInfo navTool : NAV_TOOLS) {
            if (navTool.type != ntool || !toolFilter.test(navTool.tool)) continue;
            newTool = navTool;
            break;
        }
        if (newTool != null) {
            this.d_tools.setCurrentTool(newTool.tool);
        }
    }

    private void updateActiveViewMode(ViewMode mode) {
        AViewMode vmode;
        switch (mode) {
            case MV_2D: {
                vmode = this.d_mode2d;
                break;
            }
            default: {
                vmode = this.d_mode3d;
            }
        }
        if (this.d_currViewMode != vmode) {
            this.cancelCurrentTool();
            if (this.d_currViewMode != null) {
                this.d_currViewMode.deactivate(this);
            }
            this.d_currViewMode = vmode;
            this.d_currViewMode.activate(this);
            this.d_renderComp.requestFocus();
        }
        this.clear3dPanels();
        JToolBar toolbar1 = new JToolBar();
        toolbar1.setFloatable(false);
        toolbar1.add(this.getViewToolbar());
        toolbar1.addSeparator();
        toolbar1.add(this.getViewOptionsToolbar());
        toolbar1.addSeparator();
        toolbar1.add(this.getEditToolbar());
        toolbar1.addSeparator();
        toolbar1.add(this.getGroupToolbar());
        JToolBar toolbar2 = new JToolBar();
        toolbar2.setFloatable(false);
        toolbar2.add(this.getFloorToolbar());
        toolbar2.addSeparator();
        toolbar2.add(this.getGridFilterToolbar());
        toolbar2.addSeparator();
        toolbar2.add(this.getFilterToolbar());
        guiPanel topToolbar = new guiPanel();
        topToolbar.add((Component)toolbar1, "North");
        topToolbar.add(new JSeparator(0));
        topToolbar.add((Component)toolbar2, "South");
        this.d_3DTopPanel.add((Component)topToolbar, "North");
        this.d_3DPanel.add((Component)this.getStatusBar(), "South");
        this.getCreateToolbar().setOrientation(1);
        this.d_3DTopPanel.add((Component)this.getCreateToolbar(), "West");
        this.initAppearanceComboFromPrefs();
        this.d_3DPanel.validate();
        this.getRenderComponent().repaint();
        this.getRenderComponent().requestFocus();
    }

    private void clear3dPanels() {
        int m;
        Component[] comps = this.d_3DPanel.getComponents();
        for (m = 0; m < comps.length; ++m) {
            if (comps[m] == this.d_3DTopPanel) continue;
            this.d_3DPanel.remove(comps[m]);
        }
        comps = this.d_3DTopPanel.getComponents();
        for (m = 0; m < comps.length; ++m) {
            if (comps[m] == this.getRenderComponent()) continue;
            this.d_3DTopPanel.remove(comps[m]);
        }
    }

    private void initAppearanceComboFromPrefs() {
        boolean wireframe = this.getCurrentRenderOptions().get(ISceneRenderOptions.DRAW_WIREFRAME);
        boolean outline = this.getCurrentRenderOptions().get(ISceneRenderOptions.DRAW_OUTLINES);
        boolean materials = this.getCurrentRenderOptions().get(ISceneRenderOptions.DRAW_MATERIALS);
        guiAction item = !wireframe && !outline && !materials ? this.d_solidAction : (!wireframe && outline && !materials ? this.d_solidOutlinesAction : (!wireframe && !outline && materials ? this.d_realisticAction : (!wireframe && outline && materials ? this.d_realisticOutlinesAction : (wireframe && !outline && !materials ? this.d_wireframeAction : this.d_realisticOutlinesAction))));
        this.d_appearanceBox.setSelectedItem(item);
    }

    private void initDisplayManagers() {
        this.d_dispMgr = new DisplayManager(this.d_mediator, this, this.d_mainScenes.scene, this.d_mainScenes.caps, this.d_mainScenes.patch, this.d_backgroundScene, this.d_gridScene, this.d_mainScenes.noclip, this.d_mainScenes.excludedNoClip);
    }

    public DisplayManager getDisplayManager() {
        return this.d_dispMgr;
    }

    public ViewMode3D getViewMode3d() {
        return this.d_mode3d;
    }

    public ViewMode2D getViewMode2d() {
        return this.d_mode2d;
    }

    public IViewMode getCurrentViewMode() {
        return this.d_currViewMode;
    }

    public ISceneRenderOptions get3DRenderOptions() {
        return this.d_mode3d.getRenderOptions(this);
    }

    public ISceneRenderOptions get2DRenderOptions() {
        return this.d_mode2d.getRenderOptions(this);
    }

    public ISceneRenderOptions getCurrentRenderOptions() {
        return this.d_currViewMode.getRenderOptions(this);
    }

    public PyroNativeProps getNativeDrawProps() {
        return this.d_nDrawProps;
    }

    public PyroDrawProps getDrawProps() {
        return this.d_drawProps;
    }

    @Override
    public Unit[] getLengthUnits() {
        return new Unit[]{SI.METER, PyroSim.getApp().getUnitSystem().getLengthUnit()};
    }

    @Override
    public RenderComponent getRenderComp() {
        return this.d_renderComp;
    }

    @Override
    public guiStatusMessage getStatusMessage() {
        return this.d_statusMessage;
    }

    private final JToolBar createViewOptionsToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add(this.d_appearanceBox);
        Dimension maxSize = toolbar.getMaximumSize();
        this.d_appearanceBox.setMaximumSize(new Dimension(160, maxSize.height));
        Utils.noToolBarFocus(toolbar);
        return toolbar;
    }

    private final JToolBar createFloorToolbar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        tb.add(new guiLabel(Intl.intl("Show") + ": "));
        tb.add(this.d_floorBox);
        tb.add(this.getManageFloorsAction());
        int buttonHeight = tb.getComponent((int)(tb.getComponentCount() - 1)).getPreferredSize().height;
        this.d_floorBox.setMaximumSize(new Dimension(this.d_floorBox.getPreferredSize().width, buttonHeight));
        tb.add(this.d_configureBGImageAction);
        tb.add(ModelView.createToggleButton(this.d_showBackgroundImages));
        Utils.noToolBarFocus(tb);
        return tb;
    }

    private final JToolBar createClipToolbar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        for (FilterActionInfo fi : this.d_clipFilterActions) {
            tb.add(ModelView.createToggleButton(fi.action));
        }
        Utils.noToolBarFocus(tb);
        return tb;
    }

    private final JToolBar createGroupToolbar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        Dimension d = tb.getPreferredSize();
        tb.add(new guiLabel(Intl.intl("Group") + ": "));
        tb.add(this.d_groupBox);
        tb.setPreferredSize(d);
        Utils.noToolBarFocus(tb);
        return tb;
    }

    private final JToolBar createEditToolbar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        tb.add(this.d_tools.getToolbarButton(this.d_manipTool3D.tool));
        tb.add(this.d_tools.getToolbarButton(this.d_manipTool2D.tool));
        tb.addSeparator();
        tb.add(this.d_tools.getToolbarButton(this.d_orbitTool.tool));
        tb.add(this.d_tools.getToolbarButton(this.d_modGameRoamTool.tool));
        tb.add(this.d_tools.getToolbarButton(this.d_dragTool.tool));
        tb.add(this.d_tools.getToolbarButton(this.d_zoomTool.tool));
        tb.add(this.d_tools.getToolbarButton(this.d_zoomBoxTool.tool));
        tb.add(this.d_resetToAllAction);
        tb.add(this.d_resetToSelectedAction);
        tb.add(this.d_fillViewAction);
        Utils.noToolBarFocus(tb);
        return tb;
    }

    private static JToggleButton createToggleButton(SelectableAction action) {
        String shortDesc;
        JToggleButton button = new JToggleButton(action);
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon != null) {
            button.setText("");
        }
        if ((shortDesc = (String)action.getValue("ShortDescription")) == null && icon != null) {
            shortDesc = (String)action.getValue("Name");
        }
        button.setToolTipText(shortDesc);
        button.addItemListener(action);
        return button;
    }

    private final JToolBar createCreationToolbar() {
        JToolBar tb = new JToolBar();
        tb.setLayout(new GridBagLayout());
        tb.setFloatable(false);
        GridBagHelper gbc = new GridBagHelper(tb, false, 1, 1);
        gbc.addFilledRow(new JSeparator(0));
        gbc.addRow(this.d_tools.getToolbarButton(this.d_translateTool), this.d_tools.getToolbarButton(this.d_rotateTool));
        gbc.addRow(this.d_tools.getToolbarButton(this.d_mirrorTool));
        gbc.addFilledRow(new JSeparator(0));
        gbc.addRow(this.d_tools.getToolbarButton(this.d_newGridTool), this.d_tools.getToolbarButton(this.d_gridSplitterTool));
        gbc.addFilledRow(new JSeparator(0));
        gbc.addRow(this.d_tools.getToolbarButton(this.d_newSlabObstTool), this.d_tools.getToolbarButton(this.d_newSlabHoleTool));
        gbc.addRow(this.d_tools.getToolbarButton(this.d_newWallObstTool), this.d_tools.getToolbarButton(this.d_newWallHoleTool));
        gbc.addRow(this.d_tools.getToolbarButton(this.d_newGridObstTool), this.d_tools.getToolbarButton(this.d_newGridHoleTool));
        gbc.addRow(this.d_tools.getToolbarButton(this.d_newVentTool), this.d_tools.getToolbarButton(this.d_newRoomTool));
        gbc.addFilledRow(new JSeparator(0));
        gbc.addRow(this.d_tools.getToolbarButton(this.d_newZoneTool), this.d_tools.getToolbarButton(this.d_newInitTool));
        gbc.addRow(this.d_tools.getToolbarButton(this.d_newPartCloudTool), this.d_tools.getToolbarButton(this.d_newPartLocTool));
        gbc.addRow(this.d_tools.getToolbarButton(this.d_drawPlanarSliceTool), this.d_tools.getToolbarButton(this.d_newDevcTool));
        gbc.addRow(this.d_tools.getToolbarButton(this.d_draw3dSliceTool));
        gbc.addFilledRow(new JSeparator(0));
        gbc.addRow(this.d_tools.getToolbarButton(this.d_newHvacNodeTool), this.d_tools.getToolbarButton(this.d_newHvacDuctTool));
        gbc.addFilledRow(new JSeparator(0));
        gbc.addRow(this.d_tools.getToolbarButton(this.d_surfPainterTool), this.d_tools.getToolbarButton(this.d_surfPickerTool));
        gbc.addRow(this.d_tools.getToolbarButton(this.d_measureTool));
        gbc.addFilledRow(new JSeparator(0));
        JButton toolProps = new JButton(this.d_toolPropsAction);
        toolProps.setText("");
        gbc.addRow(toolProps);
        gbc.finalizeRows();
        Utils.noToolBarFocus(tb);
        return tb;
    }

    private final JToolBar createFilterToolbar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        for (FilterActionInfo filterAction : this.d_filterActions) {
            if (filterAction == null) {
                tb.addSeparator();
                continue;
            }
            tb.add(ModelView.createToggleButton(filterAction.action));
        }
        Utils.noToolBarFocus(tb);
        return tb;
    }

    public final JToolBar createGridFilterToolbar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        this.d_currViewMode.initGridFilterToolbar(this, tb);
        Utils.noToolBarFocus(tb);
        return tb;
    }

    public void setMode(ViewMode mode) {
        this.updateActiveViewMode(mode);
    }

    private void updatePrefs() {
        this.initLayouts(this.d_currViewMode);
        Stream.Builder<ModelScene> scenes = Stream.builder();
        this.d_mainScenes.getRenderScenes().forEach(scenes);
        this.d_xformScenes.getRenderScenes().forEach(scenes);
        scenes.add(this.d_manipToolScene);
        Stream.Builder<ISceneRenderOptions> options = Stream.builder();
        options.add(this.d_mode2d.getRenderOptions(this));
        options.add(this.d_mode3d.getRenderOptions(this));
        Stream<IRenderSurface> surfs = Stream.of(this.d_renderComp);
        RenderPrefs.applyPrefs(PyroPrefs.instance(), surfs, scenes.build(), options.build());
    }

    public RenderComponent getRenderComponent() {
        return this.d_renderComp;
    }

    public RenderFile getScreenshotGenerator() {
        return this.d_renderFile;
    }

    public ModelScene getMainScene() {
        return this.d_mainScenes.scene;
    }

    public ModelScene getPatchScene() {
        return this.d_mainScenes.patch;
    }

    public CutHolesAction getCutHolesAction() {
        return this.d_cutHolesAction;
    }

    @Override
    public PyroSimColors getColors() {
        return this.d_colors;
    }

    @Override
    public void colorChanged(ColorChangedEvent e) {
        this.updateColors();
        this.d_renderComp.repaint();
    }

    public void updateColors() {
        Color bgColor = this.d_colors.getColor(PyroSimColors.BACKGROUND_COLOR);
        this.d_colorLayer.setColor(bgColor);
        float[] bgColorComps = bgColor.getComponents(new float[4]);
        this.d_axes.setBackgroundColor(new Color(bgColorComps[0], bgColorComps[1], bgColorComps[2], 0.9f));
        this.d_axes.setAxisColor(this.d_colors.getColor(PyroSimColors.AXIS_COLOR));
        this.d_axes.setBoxColor(this.d_colors.getColor(PyroSimColors.AXIS_BOX_COLOR));
        this.d_axes.setTextColor(this.d_colors.getColor(PyroSimColors.AXIS_TEXT_COLOR));
        this.d_origin.setColor(this.d_colors.getColor(PyroSimColors.ORIGIN2D_COLOR));
        this.d_sketchGrid.setColors(this.d_colors.getColor(PyroSimColors.SNAP_TO_GRID_COLOR), this.d_colors.getColor(PyroSimColors.SNAP_TO_POINTS_COLOR));
        this.d_dispMgr.d_labelMan.updateColors(this.d_colors);
    }

    @Override
    public void update(Events events) {
        this.d_renderComp.pauseRender();
        this.d_nDrawProps.update(events);
        for (DrawProps props : this.d_allProps) {
            props.update(events);
        }
        EventResult result = new EventResult();
        IEventRecord<ModelComposite> cevts = events.getEvents(ModelComposite.class, new Class[0]);
        result.d_groupBoxUpdateNeeded = result.d_groupBoxUpdateNeeded | (cevts.hasAddedObjs() || cevts.hasRemovedObjs() || cevts.hasChangedObjs() && !cevts.areChangesExclusiveTo(PyroMod.EVT_SEL));
        IEventRecord<IPyroObject> allEvents = events.getEvents(IPyroObject.class, new Class[0]);
        boolean bl = result.d_selectionChanged = allEvents.hasAddedObjs() || allEvents.hasRemovedObjs() || allEvents.containsChange(PyroMod.EVT_SEL);
        if (result.d_selectionChanged) {
            int count = this.d_mediator.getSelectionModel().getSelection().size();
            if (count == 0) {
                this.d_statusSelection.setText(" ");
            }
            this.d_statusBar.togglePane(1, count > 0);
            if (count > 0) {
                this.d_statusSelection.setText(String.format(Intl.intl("Selected: %d objects"), count));
            }
        }
        result.d_floorBoxResetNeeded = result.d_floorBoxResetNeeded | !events.getAffectedChannels(Floor.class, new Class[0]).isEmpty();
        for (EventChannel<Grid> eventChannel : events.getAffectedChannels(Grid.class, new Class[0])) {
            this.d_renderComp.repaint();
            if (!eventChannel.getAddedObjs().isEmpty() && this.d_mediator.getGridManager().flatten().size() == eventChannel.getAddedObjs().size()) {
                this.setActiveSnapper(2);
            }
            if (!eventChannel.containsChange(PyroMod.EVT_VISIBILITY_CHANGED)) continue;
            this.updateSketchGridVisibility();
        }
        for (EventChannel<Cloneable> eventChannel : events.getAffectedChannels(SnapToGrid.class, new Class[0])) {
            if (!eventChannel.containsChange(PyroMod.EVT_VISIBILITY_CHANGED)) continue;
            this.updateSketchGridVisibility();
            break;
        }
        for (EventChannel<Cloneable> eventChannel : events.getAffectedChannels(PyroMod.class, new Class[0])) {
            if (eventChannel.containsChange(PyroMod.EVT_UNITSYSTEM_CHANGED)) {
                this.d_floorBox.revalidate();
            }
            if (eventChannel.containsChange(PyroMod.EVT_MODEL_CHANGED)) {
                this.updateParticleOpts();
                this.d_renderComp.repaint();
                result.d_selectionChanged = true;
                this.reset();
            }
            if (eventChannel.containsChange(PyroMod.EVT_PREFS_CHANGED)) {
                this.updatePrefs();
                this.d_renderComp.repaint();
            }
            if (!eventChannel.containsChange(PyroMod.EVT_RAST_PROPS)) continue;
            this.updateRasterizableObjs();
            this.d_renderComp.repaint();
        }
        for (EventChannel<Cloneable> eventChannel : events.getAffectedChannels(Particle.class, new Class[0])) {
            if (!eventChannel.hasRemovedObjs() && !eventChannel.hasAddedObjs()) continue;
            this.updateParticleOpts();
        }
        this.d_modelGridSnapper.processEvents(events);
        if (this.d_mediator.getGridManager().flatten().isEmpty() && this.d_currentSnapper == this.d_modelGridSnapper) {
            this.setActiveSnapper(1);
        }
        this.d_clipMgr.processEvents(events);
        this.d_dispMgr.processEvents(events, result);
        IEventRecord<Grid> gridEvts = events.getEvents(Grid.class, new Class[0]);
        if (this.isFDSPreviewEnabled() && gridEvts.isModified()) {
            if (gridEvts.hasRemovedObjs() || !gridEvts.areChangesExclusiveTo(PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED, PyroMod.EVT_PARENT_CHANGED)) {
                this.updateRasterizableObjs();
            } else if (gridEvts.hasAddedObjs()) {
                Set<Grid> set = gridEvts.getAddedObjs();
                IdentityHashSet modObjs = new IdentityHashSet();
                for (Grid grid : set) {
                    AABox box = grid.getBounds();
                    CollResult findResult = new CollResult(FDSObject.class);
                    this.d_mediator.getGeomLocator().find(new AABoxTest(box, 1.0E-6), findResult, true);
                    modObjs.addAll(findResult.coll);
                }
                if (!modObjs.isEmpty()) {
                    this.d_dispMgr.updateDisplays((Collection<?>)modObjs);
                    this.d_renderComp.repaint();
                }
            }
        }
        if (result.d_floorBoxResetNeeded) {
            this.resetFloorBox(false);
        }
        if (result.d_groupBoxUpdateNeeded) {
            this.updateGroupBox();
        }
        if (result.d_selectionChanged) {
            this.updateToolsThatTargetSelectedObjects();
        }
        this.d_cameraModifiedListener.update(events);
        this.d_renderComp.resumeRender();
    }

    public void updateParticleOpts() {
        Tool[] partTools;
        boolean partCloudEnabled = !this.d_mediator.getPartList().flatten().isEmpty();
        for (Tool tool : partTools = new Tool[]{this.d_newPartCloudTool, this.d_newPartLocTool}) {
            this.d_tools.getToolbarButton(tool).setEnabled(partCloudEnabled);
            if (partCloudEnabled || this.d_tools.getCurrentTool() != tool) continue;
            this.cancelCurrentTool();
        }
    }

    public static <T extends IPyroObject> boolean isCamResetNeeded(Composite<T> man, Collection<? extends T> addedObjs, Composite<?> ... otherMans) {
        if (!addedObjs.isEmpty() && man.flatten().size() == addedObjs.size()) {
            for (Composite<?> otherMan : otherMans) {
                if (otherMan.flatten().isEmpty()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void reset() {
        this.d_dispMgr.removeAll();
        this.d_modelGridSnapper.removeAll();
        System.gc();
        this.resetFloorBox(true);
        this.updateGroupBox();
        for (FilterActionInfo fi : this.d_clipFilterActions) {
            fi.reset();
        }
        this.d_dispMgr.addAll();
        this.d_modelGridSnapper.addAll(this.d_mediator);
        this.applyFloorToProps(this.d_allFloorsFloor);
        this.initActiveView();
        System.gc();
    }

    public boolean isFDSPreviewEnabled() {
        for (FilterActionInfo fai : this.d_filterActions) {
            if (!(fai.action instanceof FDSPreviewAction)) continue;
            return ((FDSPreviewAction)fai.action).isSelected();
        }
        return false;
    }

    private void updateSketchGridVisibility() {
        boolean visible = this.d_mainScenes.getCamera() instanceof OrthoCamera && this.d_currentSnapper == this.d_sketchGrid;
        this.d_sketchGrid.setVisibility(visible, visible);
    }

    private void updateOriginVisibility() {
        this.d_origin.setVisible(this.d_mainScenes.getCamera() instanceof OrthoCamera && this.d_showOriginAction.isSelected());
    }

    public void addCameraChangeListener(CameraChangeListener listener) {
        this.d_cameraChangeListeners.add(listener);
    }

    public void removeCameraChangeListener(CameraChangeListener listener) {
        this.d_cameraChangeListeners.remove(listener);
    }

    private void setMainCamera(Camera camera) {
        Camera oldCamera = this.getMainView().getCamera();
        this.d_backgroundScene.setCamera(camera.createCopyCam());
        this.d_gridScene.setCamera(camera.createCopyCam());
        this.d_originScene.setCamera(camera.createCopyCam());
        this.d_mainScenes.setCamera(camera);
        this.d_xformScenes.setCamera(camera);
        this.d_xformScenes.scene.setCamera(camera.createCopyCam());
        this.d_manipScene.setCamera(camera.createCopyCam());
        this.d_manipToolScene.setCamera(camera.createCopyCam());
        this.d_axes.setBaseCamera(this.d_mainScenes.getCamera());
        this.d_dispMgr.d_gridDispMan.updateDisplays(this.d_mediator.getGridManager().flatten());
        this.d_dispMgr.d_floorDispMan.updateDisplays(this.d_mediator.getFloorManager().flatten());
        this.updateSketchGridVisibility();
        this.updateOriginVisibility();
        this.updateCurrentTool();
        this.updateSnapperVis();
        this.d_clipMgr.forceSceneClippingUpdate();
        this.initLayouts(this.d_currViewMode);
        for (CameraChangeListener list : this.d_cameraChangeListeners) {
            list.cameraChanged(oldCamera, camera);
        }
    }

    public View getMainView() {
        return this.d_mainView;
    }

    public int getCurrentSnapper() {
        if (this.d_mainScenes.getCamera() instanceof OrthoCamera) {
            if (this.d_currentSnapper == null) {
                return 0;
            }
            if (this.d_currentSnapper == this.d_sketchGrid) {
                return 1;
            }
            return 2;
        }
        return -1;
    }

    public IGridSnapper getCurrentSnapperObj() {
        if (this.d_mainScenes.getCamera() instanceof OrthoCamera) {
            return this.d_currentSnapper;
        }
        return this.d_modelGridSnapper;
    }

    public void setActiveSnapper(int snapper) {
        this.setActiveSnapper(snapper, true);
    }

    private void setActiveSnapper(int snapper, boolean updateActions) {
        if (snapper == 0) {
            this.d_currentSnapper = null;
            if (updateActions) {
                this.d_noSnapperAction.setSelected(true);
            }
        } else if (snapper == 1) {
            this.d_currentSnapper = this.d_sketchGrid;
            if (updateActions) {
                this.d_sketchGridAction.setSelected(true);
            }
        } else {
            this.d_currentSnapper = this.d_modelGridSnapper;
            if (updateActions) {
                this.d_modelGridsAction.setSelected(true);
            }
        }
        this.updateSnapperVis();
        this.d_editGridSizeAction.setEnabled(this.d_currentSnapper == this.d_sketchGrid);
        this.d_dispMgr.d_gridDispMan.updateDisplays(this.d_mediator.getGridManager().flatten());
        this.updateSketchGridVisibility();
        this.updateCurrentTool();
    }

    private void updateSnapperVis() {
        IGridSnapper currSnapper = this.getCurrentSnapperObj();
        this.d_sketchGrid.setVisible(currSnapper == this.d_sketchGrid);
        this.d_modelGridSnapper.setVisible(currSnapper == this.d_modelGridSnapper);
    }

    protected void applyFloorToProps(Floor f) {
        this.d_devcProps.set(DrawProps.LOCATION, f.getElevation().add(f.getWallHeight().scale(0.5)));
        this.d_partLocProps.set(DrawProps.LOCATION, f.getElevation().add(f.getWallHeight().scale(0.5)));
        this.d_hvacNodeProps.set(DrawProps.LOCATION, f.getElevation().add(f.getWallHeight().sub(new UnitDouble(0.5, SI.METER))));
        UnitDouble gridLoc = f == this.d_allFloorsFloor ? f.getElevation() : f.getSlabBottom();
        UnitDouble gridHeight = f == this.d_allFloorsFloor ? f.getWallHeight() : f.getWallHeight().add(f.getSlabThickness());
        this.d_gridProps.set(DrawProps.LOCATION, gridLoc);
        this.d_gridProps.set(DrawProps.HEIGHT, gridHeight);
        this.d_wallProps.set(DrawProps.LOCATION, f.getElevation());
        this.d_wallProps.set(DrawProps.HEIGHT, f.getWallHeight());
        this.d_blockProps.set(DrawProps.LOCATION, f.getElevation());
        this.d_blockProps.set(DrawProps.HEIGHT, f.getWallHeight());
        this.d_slabProps.set(DrawProps.LOCATION, f.getElevation().sub(f.getSlabThickness()));
        this.d_slabProps.set(DrawProps.THICKNESS, f.getSlabThickness());
        this.d_ventProps.set(DrawProps.LOCATION, f.getElevation());
    }

    protected void setFloor(Floor f) {
        this.d_currentFloor = f;
        if (f != null) {
            this.applyFloorToProps(f);
        }
        this.d_dispMgr.d_floorDispMan.updateDisplays(this.d_mediator.getFloorManager().flatten());
        this.d_clipMgr.forceSceneClippingUpdate();
        this.d_dispMgr.d_gridDispMan.setActiveFloor(f);
        this.d_modelGridSnapper.setActiveFloor(f);
    }

    public Floor getCurrentFloor() {
        return this.d_currentFloor;
    }

    private void resetFloorBox(boolean resetSelection) {
        ActionListener[] listeners;
        Floor currentSelectedFloor = (Floor)this.d_floorBox.getSelectedItem();
        for (ActionListener l : listeners = this.d_floorBox.getActionListeners()) {
            this.d_floorBox.removeActionListener(l);
        }
        FloorManager floorMan = this.d_mediator.getFloorManager();
        this.d_floorBox.removeAllItems();
        this.d_floorBox.addItem(this.d_allFloorsFloor);
        List<Floor> floors = Util.sort(floorMan.flatten(), new Floor.CompareLevel());
        for (int i = floors.size() - 1; i >= 0; --i) {
            this.d_floorBox.addItem(floors.get(i));
        }
        if (this.d_editToolbar != null) {
            this.d_editToolbar.revalidate();
        }
        for (ActionListener l : listeners) {
            this.d_floorBox.addActionListener(l);
        }
        if (resetSelection) {
            this.d_floorBox.setSelectedItem(this.d_allFloorsFloor);
        } else {
            boolean selectedFloorExists;
            boolean bl = selectedFloorExists = currentSelectedFloor != null ? floorMan.containsDeep(currentSelectedFloor) : false;
            if (selectedFloorExists) {
                this.d_floorBox.setSelectedItem(currentSelectedFloor);
            } else {
                this.d_floorBox.setSelectedItem(this.d_allFloorsFloor);
            }
        }
        this.d_floorBox.setMaximumSize(this.d_floorBox.getPreferredSize());
    }

    private void updateGroupBox() {
        ModelComposite root = this.d_mediator.getObstructions();
        this.d_groupBox.setRoot(root);
        this.d_groupBox.setMaximumSize(this.d_groupBox.getPreferredSize());
        for (int m = 0; m < this.d_groupBox.getParent().getComponentCount(); ++m) {
            if (this.d_groupBox.getParent().getComponent(m) != this.d_groupBox) continue;
            Container parent = this.d_groupBox.getParent();
            parent.remove(m);
            parent.add((Component)this.d_groupBox, m);
            break;
        }
    }

    public AABox getModelSceneBounds() {
        return this.getModelSceneBounds(true);
    }

    public AABox getModelSceneBounds(boolean useExcluded) {
        BoundsCalculator bc = new BoundsCalculator();
        this.d_mainScenes.getBounds(bc, useExcluded);
        bc.add(this.d_backgroundScene);
        bc.add(this.d_gridScene);
        return bc.getBounds();
    }

    public void resetCurrentCamera() {
        this.d_currViewMode.resetCurrentCamera(this, this.getModelSceneBounds(false), true);
    }

    public void resetCurrentCamera(Collection<? extends Object3D> objs) {
        Object3D[] objArr = objs.toArray(new Object3D[objs.size()]);
        BoundsCalculator bc = new BoundsCalculator();
        bc.add(objArr);
        this.d_currViewMode.resetCurrentCamera(this, bc.getBounds(), false);
    }

    public void fillCamera() {
        AABox bounds = this.getModelSceneBounds(false);
        this.fillCameras(bounds, this.d_mainView.getCamera());
    }

    public void fillCameras(AABox bb, Camera ... cameras) {
        for (Camera c : cameras) {
            AABox box = new AABox(bb);
            c.ensureValidForReset(box, 5.0);
            c.fillView(box, this.d_renderComp.getWidth(), this.d_renderComp.getHeight());
        }
    }

    public void beginWaitCursor() {
        PyroSim.getApp().beginWaitCursor();
    }

    public void endWaitCursor() {
        PyroSim.getApp().endWaitCursor();
    }

    public ModelComposite getNewObstructionGroup() {
        return (ModelComposite)this.d_groupBox.getSelectedItem();
    }

    public MutuallyExclusiveAction getNoGridAction() {
        return this.d_noSnapperAction;
    }

    public MutuallyExclusiveAction getSketchGridAction() {
        return this.d_sketchGridAction;
    }

    public MutuallyExclusiveAction getModelGridsAction() {
        return this.d_modelGridsAction;
    }

    public guiStatusBar getStatusBar() {
        return this.d_statusBar;
    }

    public BooleanAction getShowGuidesAction() {
        return this.d_showGuidesAction;
    }

    public Collection<BooleanAction> getClipFilterActions() {
        return theUtil.map(Arrays.asList(this.d_clipFilterActions), ai -> ((FilterActionInfo)ai).action);
    }

    public Action getEnableSectionBoxesAction() {
        return this.d_clipFilterActions[0].action;
    }

    public Action getShowSectionBoxesAction() {
        return this.d_clipFilterActions[1].action;
    }

    public BooleanAction getShowPointerAction() {
        return this.d_showPointerAction;
    }

    public EditSnapSize getEditSnapSizeAction() {
        return this.d_editGridSizeAction;
    }

    public BooleanAction getShowOriginAction() {
        return this.d_showOriginAction;
    }

    public ManageFloorsAction getManageFloorsAction() {
        return this.d_manageFloorsAction;
    }

    public BooleanAction getShowBGImagesAction() {
        return this.d_showBackgroundImages;
    }

    public BooleanAction getUseSVNavAction() {
        return this.d_useSVNavAction;
    }

    public ResetToAllObjectsAction getResetToAllAction() {
        return this.d_resetToAllAction;
    }

    public ResetToSelectedObjectsAction getResetToSelectedAction() {
        return this.d_resetToSelectedAction;
    }

    public FillViewAction getFillViewAction() {
        return this.d_fillViewAction;
    }

    public guiAction getSolidOutlinesAction() {
        return this.d_solidOutlinesAction;
    }

    public guiAction getRealisticAction() {
        return this.d_realisticAction;
    }

    public guiAction getRealisticOutlinesAction() {
        return this.d_realisticOutlinesAction;
    }

    public BooleanAction getDrawWireframeAction() {
        return this.d_wireframeAction;
    }

    public void savePreferences() {
        PyroPrefs.set(PyroPrefs.ShowGridProp, this.d_showGridDivsAction.isSelected(), false);
        PyroPrefs.set(PyroPrefs.ShowBoundaryProp, this.d_showGridBoundaryAction.isSelected(), false);
        PyroPrefs.set(PyroPrefs.ShowBoundaryLinesProp, this.d_showGridOutlinesAction.isSelected(), false);
        PyroPrefs.set(PyroPrefs.ShowSystemMouseProp, this.getShowPointerAction().isSelected(), false);
        PyroPrefs.set(PyroPrefs.ShowGuidesProp, this.getShowGuidesAction().isSelected(), false);
        PyroPrefs.set(PyroPrefs.ShowOriginProp, this.getShowOriginAction().isSelected(), false);
        PyroPrefs.set(PyroPrefs.UseSVNavProp, this.getUseSVNavAction().isSelected(), false);
        ISceneRenderOptions ro2d = this.d_mode2d.getRenderOptions(this);
        ISceneRenderOptions ro3d = this.d_mode3d.getRenderOptions(this);
        PyroPrefs.set(PyroPrefs.DrawWireframeProp2D, ro2d.get(ISceneRenderOptions.DRAW_WIREFRAME), false);
        PyroPrefs.set(PyroPrefs.DrawWireframeProp3D, ro3d.get(ISceneRenderOptions.DRAW_WIREFRAME), false);
        PyroPrefs.set(PyroPrefs.ShowAppearancesProp2D, ro2d.get(ISceneRenderOptions.DRAW_MATERIALS), false);
        PyroPrefs.set(PyroPrefs.ShowAppearancesProp3D, ro3d.get(ISceneRenderOptions.DRAW_MATERIALS), false);
        PyroPrefs.set(PyroPrefs.ShowOutlinesProp2D, ro2d.get(ISceneRenderOptions.DRAW_OUTLINES), false);
        PyroPrefs.set(PyroPrefs.ShowOutlinesProp3D, ro3d.get(ISceneRenderOptions.DRAW_OUTLINES), false);
        PyroPrefs.set(PyroPrefs.UseSmoothLightingProp2D, ro2d.get(ISceneRenderOptions.LIGHTMODEL) == ISceneRenderOptions.LightModel.LOCAL_CAMERA, false);
        PyroPrefs.set(PyroPrefs.UseSmoothLightingProp3D, ro3d.get(ISceneRenderOptions.LIGHTMODEL) == ISceneRenderOptions.LightModel.LOCAL_CAMERA, false);
        PyroPrefs.set(PyroPrefs.PREF_CUT_HOLES, this.d_drawProps.cutHoles(), false);
    }

    public JToolBar getViewOptionsToolbar() {
        return this.d_viewOptionsToolbar;
    }

    public JToolBar getFloorToolbar() {
        return this.d_floorToolbar;
    }

    public JToolBar getClipPlanesToolbar() {
        return this.d_editClipPlanesToolbar;
    }

    public JToolBar getGroupToolbar() {
        return this.d_groupToolbar;
    }

    public JToolBar getEditToolbar() {
        return this.d_editToolbar;
    }

    public JToolBar getViewToolbar() {
        return this.d_currViewMode.getCameraToolbar(this);
    }

    public JToolBar getCreateToolbar() {
        return this.d_createToolbar;
    }

    public JToolBar getFilterToolbar() {
        return this.d_filterToolbar;
    }

    public JToolBar getGridFilterToolbar() {
        return this.createGridFilterToolbar();
    }

    private static Icon newVisIcon(Icon baseIcon, Icon decIcon) {
        return baseIcon == null ? null : new DecoratedIcon(baseIcon, decIcon, 3);
    }

    private void updateRasterizableObjs() {
        PyroSim.getApp().beginWaitCursor();
        Collection<FDSObject> fdsObjs = ((APyroObject)this.d_mediator.getObstructions()).flatten(FDSObject.class);
        boolean rasterizing = this.getDrawProps().getRasterizer() != null;
        this.d_dispMgr.d_geomDispMan.setSearchTreeEnabled(rasterizing, false);
        this.d_dispMgr.d_geomDispMan.updateDisplays(fdsObjs);
        PyroSim.getApp().endWaitCursor();
    }

    private void updateCurrentTool() {
        Tool tool = this.d_tools.getCurrentTool();
        if (tool == this.d_modGameRoamTool.tool) {
            AABox modelBounds = this.getModelSceneBounds();
            ((RoamFunc)this.d_modGameRoamTool.tool.getFunction()).setModelBounds(modelBounds);
        }
        if (tool instanceof CursorTool) {
            CursorTool ctool = (CursorTool)tool;
            ctool.setGuidesVisible(this.d_showGuidesAction.isSelected());
            ctool.setPointerVisible(this.d_showPointerAction.isSelected());
            ctool.setView(this.getMainView());
            this.d_toolLayer.clear();
            this.d_toolLayer.add(ctool);
        }
    }

    public ClippingManager getClipManager() {
        return this.d_clipMgr;
    }

    public boolean isHoleCuttingEnabled() {
        return this.d_drawProps.cutHoles();
    }

    private static String getSnappingName(int action) {
        if (action == 0) {
            return Intl.intl("Disable Grid Snapping");
        }
        if (action == 1) {
            return Intl.intl("Snap to Sketch Grid");
        }
        return Intl.intl("Snap to Model Grids");
    }

    public Action getToolPropsAction() {
        return this.d_toolPropsAction;
    }

    private static OrthoCamera newOrthoCam() {
        return new OrthoCamera(new Point3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), 0.0, 10000.0, 10.0);
    }

    @Override
    public IAnimSession getAnimSession() {
        return this.d_animSession;
    }

    @Override
    public IDeviceManager getDevices() {
        return this.d_tools.getDevices();
    }

    public ModelViewFilterProps getFilterProps() {
        return new ModelViewFilterProps(this.d_filterActions[0].getState(), this.d_filterActions[1].getState(), this.d_filterActions[2].getState(), this.d_filterActions[3].getState(), this.d_filterActions[4].getState(), this.d_filterActions[5].getState(), this.d_filterActions[6].getState(), this.d_filterActions[7].getState(), this.d_filterActions[9].getState(), this.d_filterActions[10].getState(), this.d_filterActions[11].getState(), this.d_filterActions[13].getState(), this.d_filterActions[14].getState(), this.d_filterActions[16].getState());
    }

    public void setViewFilters(ModelViewFilterProps props) {
        this.d_filterActions[0].setState(props.showFdsPreview);
        this.d_filterActions[1].setState(props.showObstructions);
        this.d_filterActions[2].setState(props.showHoles);
        this.d_filterActions[3].setState(props.showVents);
        this.d_filterActions[4].setState(props.showInit);
        this.d_filterActions[5].setState(props.showClouds);
        this.d_filterActions[6].setState(props.showDevices);
        this.d_filterActions[7].setState(props.showHvac);
        this.d_filterActions[9].setState(props.showZones);
        this.d_filterActions[10].setState(props.showStats);
        this.d_filterActions[11].setState(props.showSlices);
        this.d_filterActions[13].setState(props.showLabels);
        this.d_filterActions[14].setState(props.showCad);
        this.d_filterActions[16].setState(props.showCameras);
    }

    public void setViewFilterState(Class<?> objType, boolean state) {
        Class typeToTest = objType.isAssignableFrom(Grid.class) ? GridVis.Divisions.class : objType;
        Stream.concat(Arrays.stream(this.d_filterActions), Arrays.stream(this.d_gridFilterActions)).forEach(fInfo -> {
            if (fInfo != null && ((FilterActionInfo)fInfo).action != null && ((FilterActionInfo)fInfo).action instanceof FilterAction && ((FilterAction)((FilterActionInfo)fInfo).action).d_filterType != null && ((FilterAction)((FilterActionInfo)fInfo).action).d_filterType.isAssignableFrom(typeToTest)) {
                fInfo.setState(state);
            }
        });
    }

    public boolean isInteractive(Object queryObj) {
        return this.d_drawToolBridge.isInteractive(queryObj);
    }

    static /* synthetic */ OrthoCamera access$3100() {
        return ModelView.newOrthoCam();
    }

    public static class ModelViewFilterProps
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final boolean showFdsPreview;
        public final boolean showObstructions;
        public final boolean showHoles;
        public final boolean showVents;
        public final boolean showInit;
        public final boolean showClouds;
        public final boolean showDevices;
        public final boolean showHvac;
        public final boolean showZones;
        public final boolean showStats;
        public final boolean showSlices;
        public final boolean showLabels;
        public final boolean showCad;
        public final boolean showCameras;

        public ModelViewFilterProps() {
            this(true, true, true, true, true, true, true, false, false, true, true, true, false, false);
        }

        public ModelViewFilterProps(boolean showFdsPreview, boolean showObstructions, boolean showHoles, boolean showVents, boolean showInit, boolean showClouds, boolean showDevices, boolean showHvac, boolean showZones, boolean showStats, boolean showSlices, boolean showLabels, boolean showCad, boolean showCam) {
            this.showFdsPreview = showFdsPreview;
            this.showObstructions = showObstructions;
            this.showHoles = showHoles;
            this.showVents = showVents;
            this.showInit = showInit;
            this.showClouds = showClouds;
            this.showDevices = showDevices;
            this.showHvac = showHvac;
            this.showZones = showZones;
            this.showStats = showStats;
            this.showSlices = showSlices;
            this.showLabels = showLabels;
            this.showCad = showCad;
            this.showCameras = showCam;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ModelViewFilterProps)) {
                return false;
            }
            ModelViewFilterProps mvfObj = (ModelViewFilterProps)obj;
            return this.showFdsPreview == mvfObj.showFdsPreview && this.showObstructions == mvfObj.showObstructions && this.showHoles == mvfObj.showHoles && this.showVents == mvfObj.showVents && this.showInit == mvfObj.showInit && this.showClouds == mvfObj.showClouds && this.showDevices == mvfObj.showDevices && this.showHvac == mvfObj.showHvac && this.showZones == mvfObj.showZones && this.showStats == mvfObj.showStats && this.showSlices == mvfObj.showSlices && this.showLabels == mvfObj.showLabels && this.showCad == mvfObj.showCad && this.showCameras == mvfObj.showCameras;
        }
    }

    private class ViewModifiedListener {
        public void update(Events events) {
            if (events.getEvents(PyroMod.class, new Class[0]).hasChangedObjs(PyroMod.EVT_MODEL_CHANGED)) {
                ModelView.this.initActiveView();
            } else if (pyrosim.domain.view.View.isCamChanged(ModelView.this.d_mediator, events)) {
                ModelView.this.updateActiveView();
            }
        }
    }

    public static abstract class AChangeViewListener
    extends guiAction {
        private static final long serialVersionUID = 1L;
        private final ModelView d_mv;
        private PredefCam d_camera;

        public AChangeViewListener(ModelView mv, PredefCam c) {
            super(c.name, c.icon);
            this.d_mv = mv;
            this.d_camera = c;
        }

        protected abstract String getDescriptionString();

        protected ModelView getModelView() {
            return this.d_mv;
        }

        public PredefCam getCam() {
            return this.d_camera;
        }
    }

    public static class ViewMode2D
    extends AViewMode {
        private final Map<PredefCam, ChangeViewListener2d> d_cameraActionMap;
        private PredefCam d_currCam = PredefCam.TOP_2D;

        public ViewMode2D(ModelView mv) {
            super(ViewMode2D.createRenderOptions());
            this.d_cameraActionMap = new IdentityHashMap<PredefCam, ChangeViewListener2d>();
            for (PredefCam cam : this.getCams()) {
                ChangeViewListener2d listener = new ChangeViewListener2d(mv, cam);
                this.d_cameraActionMap.put(cam, listener);
            }
        }

        @Override
        public Camera getCamera(ModelView mv) {
            return this.d_currCam.cam;
        }

        private static SceneRenderOptions createRenderOptions() {
            SceneRenderOptions ro = new SceneRenderOptions();
            ro.setDrawWireframe(PyroPrefs.getBoolean(PyroPrefs.DrawWireframeProp2D));
            ro.setShowMaterials(PyroPrefs.getBoolean(PyroPrefs.ShowAppearancesProp2D));
            ro.setDrawOutlines(PyroPrefs.getBoolean(PyroPrefs.ShowOutlinesProp2D));
            ro.setLightModel(ISceneRenderOptions.LightModel.LOCAL_CAMERA);
            return ro;
        }

        @Override
        public void initLayout(ModelView mv, OverlayLayout layout, boolean includeRestoreLayer) {
            OverlayLayout mainLayout;
            if (includeRestoreLayer) {
                QuickSaveRestoreLayer qsrComp = ModelView.createQuickRestoreLayout();
                mainLayout = new OverlayLayout();
                qsrComp.setLayoutManager(mainLayout);
                layout.add(qsrComp);
            } else {
                mainLayout = layout;
            }
            ArrayList<ModelScene> scenes = new ArrayList<ModelScene>();
            mv.d_mainScenes.getRenderScenes(scenes);
            mv.d_xformScenes.getRenderScenes(scenes);
            scenes.add(mv.d_manipScene);
            mainLayout.add(mv.d_colorLayer);
            mainLayout.add(new SceneRenderer(mv.d_backgroundScene));
            mainLayout.add(new SceneRenderer(mv.d_gridScene.getCamera(), mv.d_gridScene, mv.d_originScene));
            mainLayout.add(new ClearableBackground(false, true));
            mainLayout.add(new SceneRenderer(mv.d_mainScenes.getCamera(), theUtil.toArray(scenes, IRenderable.class)));
            layout.add(new ClearableBackground(false, true));
            layout.add(new SceneRenderer(mv.d_manipToolScene));
            scenes.add(mv.d_manipToolScene);
            SceneRenderer zfitAll = new SceneRenderer(mv.d_mainScenes.getCamera(), theUtil.toArray(scenes, IRenderable.class));
            zfitAll.setMode(SceneRenderer.Mode.Z_FIT_ONLY);
            layout.add(zfitAll);
        }

        @Override
        public void initGridFilterToolbar(ModelView mv, JToolBar tb) {
            tb.add(ModelView.createToggleButton(mv.d_showGridOutlinesAction));
        }

        @Override
        public JToolBar createCameraToolbar(ModelView mv) {
            JToolBar toolbar = new JToolBar();
            toolbar.setFloatable(false);
            ArrayList<ChangeViewListener2d> listeners = new ArrayList<ChangeViewListener2d>();
            for (PredefCam cams : this.getCams()) {
                listeners.add(this.d_cameraActionMap.get((Object)cams));
                toolbar.getActionMap().put(cams.name, this.d_cameraActionMap.get((Object)cams));
            }
            toolbar.add(new DropDownButton(listeners){
                private static final long serialVersionUID = 1L;

                @Override
                protected Dimension getActionPreferredSize() {
                    Dimension dh = super.getActionPreferredSize();
                    Dimension dmenu = this.getMenu().getPreferredSize();
                    int width = dmenu.width - 20;
                    return new Dimension(width, dh.height);
                }
            });
            Utils.noToolBarFocus(toolbar);
            return toolbar;
        }

        @Override
        protected Tool getDefaultTool(ModelView mv) {
            return ((ModelView)mv).d_manipTool2D.tool;
        }

        @Override
        public Predicate<Tool> getToolFilter(ModelView mv) {
            return Filters.reject(((ModelView)mv).d_manipTool3D.tool, ((ModelView)mv).d_orbitTool.tool, ((ModelView)mv).d_modGameRoamTool.tool);
        }

        @Override
        public void activate(ModelView mv) {
            mv.d_dispMgr.updateMode(this);
            super.activate(mv);
            this.setCamera(mv, this.d_currCam);
        }

        @Override
        public void deactivate(ModelView mv) {
            this.setDrawingToolsEnabled(mv, true);
            super.deactivate(mv);
        }

        @Override
        public void resetAllCameras(ModelView mv, AABox bounds, boolean modelBounds) {
            ViewMode2D.resetCameras(mv, bounds, modelBounds, this.getCams());
        }

        @Override
        public void resetCurrentCamera(ModelView mv, AABox bounds, boolean modelBounds) {
            ViewMode2D.resetCameras(mv, bounds, modelBounds, this.d_currCam);
        }

        protected Collection<PredefCam> getCams() {
            return PredefCam.get(cam -> cam.is2D());
        }

        public void setCamera(ModelView mv, PredefCam cam) {
            PredefCam oldCam = this.d_currCam;
            this.d_currCam = cam;
            boolean wallSketchCamera = cam == PredefCam.TOP_2D || cam == PredefCam.BOTTOM_2D;
            this.setDrawingToolsEnabled(mv, wallSketchCamera);
            if (oldCam != cam) {
                mv.cancelCurrentTool();
            }
            mv.setMainCamera(cam.cam);
        }

        public Map<PredefCam, AChangeViewListener> getViewActionMap() {
            return Collections.unmodifiableMap(this.d_cameraActionMap);
        }

        private void setDrawingToolsEnabled(ModelView mv, boolean enabled) {
            mv.d_tools.getToolAction(mv.d_newRoomTool).setEnabled(enabled);
            mv.d_tools.getToolAction(mv.d_newWallObstTool).setEnabled(enabled);
            mv.d_tools.getToolAction(mv.d_newWallHoleTool).setEnabled(enabled);
        }

        private class ChangeViewListener2d
        extends AChangeViewListener {
            private static final long serialVersionUID = 1L;

            public ChangeViewListener2d(ModelView mv, PredefCam c) {
                super(mv, c);
                this.putValue("ShortDescription", this.getDescriptionString());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewMode2D.this.setCamera(this.getModelView(), this.getCam());
                this.getModelView().d_renderComp.repaint();
            }

            @Override
            protected String getDescriptionString() {
                return String.format(Intl.intl("Show %s View"), this.getCam().name);
            }
        }
    }

    public static class ViewMode3D
    extends AViewMode {
        private final Map<PredefCam, ChangeViewListener3d> d_cameraActionMap = new IdentityHashMap<PredefCam, ChangeViewListener3d>();

        public ViewMode3D(ModelView mv) {
            super(ViewMode3D.createRenderOptions());
            for (PredefCam cam : this.getCams()) {
                ChangeViewListener3d listner = new ChangeViewListener3d(mv, cam);
                this.d_cameraActionMap.put(cam, listner);
            }
        }

        private static SceneRenderOptions createRenderOptions() {
            SceneRenderOptions ro = new SceneRenderOptions();
            ro.setDrawWireframe(PyroPrefs.getBoolean(PyroPrefs.DrawWireframeProp3D));
            ro.setShowMaterials(PyroPrefs.getBoolean(PyroPrefs.ShowAppearancesProp3D));
            ro.setDrawOutlines(PyroPrefs.getBoolean(PyroPrefs.ShowOutlinesProp3D));
            ro.setLightModel(ISceneRenderOptions.LightModel.LOCAL_CAMERA);
            return ro;
        }

        @Override
        public Camera getCamera(ModelView mv) {
            return s_perspCam;
        }

        @Override
        protected Tool getDefaultTool(ModelView mv) {
            return ((ModelView)mv).d_manipTool3D.tool;
        }

        @Override
        public Predicate<Tool> getToolFilter(ModelView mv) {
            return Filters.reject(((ModelView)mv).d_manipTool2D.tool);
        }

        @Override
        public void activate(ModelView mv) {
            mv.setMainCamera(s_perspCam);
            mv.d_dispMgr.updateMode(this);
            super.activate(mv);
        }

        @Override
        public void deactivate(ModelView mv) {
            super.deactivate(mv);
        }

        @Override
        public void resetAllCameras(ModelView mv, AABox bounds, boolean modelBounds) {
            ViewMode3D.resetCameras(mv, bounds, modelBounds, PredefCam.TOP_3D);
        }

        @Override
        public void resetCurrentCamera(ModelView mv, AABox bounds, boolean modelBounds) {
            ViewMode3D.resetCameras(mv, bounds, modelBounds, PredefCam.TOP_3D);
        }

        @Override
        public void initLayout(ModelView mv, OverlayLayout layout, boolean includeRestoreLayer) {
            OverlayLayout mainLayout;
            if (includeRestoreLayer) {
                QuickSaveRestoreLayer qsrComp = ModelView.createQuickRestoreLayout();
                mainLayout = new OverlayLayout();
                qsrComp.setLayoutManager(mainLayout);
                layout.add(qsrComp);
            } else {
                mainLayout = layout;
            }
            ArrayList<ModelScene> scenes = new ArrayList<ModelScene>();
            mv.d_mainScenes.getRenderScenes(scenes);
            mv.d_xformScenes.getRenderScenes(scenes);
            scenes.add(mv.d_manipScene);
            mainLayout.add(mv.d_colorLayer);
            mainLayout.add(new SceneRenderer(s_perspCam, theUtil.toArray(scenes, IRenderable.class)));
            layout.add(new ClearableBackground(false, true));
            layout.add(new SceneRenderer(mv.d_manipToolScene));
            scenes.add(mv.d_manipToolScene);
            SceneRenderer zfitAll = new SceneRenderer(s_perspCam, theUtil.toArray(scenes, IRenderable.class));
            zfitAll.setMode(SceneRenderer.Mode.Z_FIT_ONLY);
            layout.add(zfitAll);
        }

        protected Collection<PredefCam> getCams() {
            return PredefCam.get(cam -> cam.is3D());
        }

        @Override
        public void initGridFilterToolbar(ModelView mv, JToolBar tb) {
            tb.add(ModelView.createToggleButton(mv.d_showGridDivsAction));
            tb.add(ModelView.createToggleButton(mv.d_showGridBoundaryAction));
            tb.add(ModelView.createToggleButton(mv.d_showGridOutlinesAction));
        }

        @Override
        public JToolBar createCameraToolbar(ModelView mv) {
            JToolBar toolbar = new JToolBar();
            toolbar.setFloatable(false);
            ArrayList<ChangeViewListener3d> listeners = new ArrayList<ChangeViewListener3d>();
            for (PredefCam cam : this.getCams()) {
                listeners.add(this.d_cameraActionMap.get((Object)cam));
                toolbar.getActionMap().put(cam.name, this.d_cameraActionMap.get((Object)cam));
            }
            DropDownButton cameraDropDown = new DropDownButton(listeners){
                private static final long serialVersionUID = 1L;

                @Override
                protected Dimension getActionPreferredSize() {
                    Dimension dh = super.getActionPreferredSize();
                    Dimension dmenu = this.getMenu().getPreferredSize();
                    int width = dmenu.width - 20;
                    return new Dimension(width, dh.height);
                }
            };
            toolbar.add(cameraDropDown);
            Utils.noToolBarFocus(toolbar);
            return toolbar;
        }

        public Map<PredefCam, AChangeViewListener> getViewActionMap() {
            return Collections.unmodifiableMap(this.d_cameraActionMap);
        }

        private class ChangeViewListener3d
        extends AChangeViewListener {
            private static final long serialVersionUID = 1L;

            public ChangeViewListener3d(ModelView mv, PredefCam c) {
                super(mv, c);
                this.putValue("ShortDescription", this.getDescriptionString());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                AABox bounds = this.getModelView().getModelSceneBounds();
                AViewMode.resetCameras(this.getModelView(), bounds, true, this.getCam());
                this.getModelView().d_renderComp.repaint();
            }

            @Override
            protected String getDescriptionString() {
                return String.format(Intl.intl("%s View"), this.getCam().name);
            }
        }
    }

    public static abstract class AViewMode
    implements IViewMode {
        private final SceneRenderOptions d_renderOptions;
        private final SceneRenderOptions d_patchRenderOptions;
        private final SceneRenderOptions d_noclipRenderOptions;
        private Tool d_lastTool = null;
        private JToolBar d_toolbar = null;
        public static final boolean USE_NEGATIVE_POLYOFFSET = false;

        public AViewMode(SceneRenderOptions renderOptions) {
            this.d_renderOptions = renderOptions;
            this.d_patchRenderOptions = this.d_renderOptions.clone();
            this.d_noclipRenderOptions = new SceneRenderOptions();
            this.d_noclipRenderOptions.setDrawOutlines(true);
            this.updateOffset();
        }

        @Override
        public ISceneRenderOptions getRenderOptions(ModelView mv) {
            return new MultiSceneRenderOptions(this.d_renderOptions, this.d_patchRenderOptions);
        }

        @Override
        public Tool getNavTool(ModelView mv) {
            if (mv.d_currViewMode == this) {
                return mv.d_tools.getRootTool();
            }
            if (this.d_lastTool == null) {
                return this.getDefaultTool(mv);
            }
            return this.d_lastTool;
        }

        @Override
        public void updateOffset() {
            this.d_renderOptions.set(ISceneRenderOptions.SOLID_POLYGON_OFFSET, new float[]{1.0f, 1.0f});
            this.d_renderOptions.set(ISceneRenderOptions.OUTLINE_POLYGON_OFFSET, new float[]{0.0f, 0.0f});
            this.d_patchRenderOptions.set(ISceneRenderOptions.SOLID_POLYGON_OFFSET, new float[]{0.5f, 0.5f});
            this.d_patchRenderOptions.set(ISceneRenderOptions.OUTLINE_POLYGON_OFFSET, new float[]{0.0f, 0.0f});
        }

        protected abstract JToolBar createCameraToolbar(ModelView var1);

        protected abstract Tool getDefaultTool(ModelView var1);

        @Override
        public void activate(ModelView mv) {
            if (this.d_lastTool == null) {
                this.d_lastTool = this.getDefaultTool(mv);
            }
            mv.d_tools.setCurrentTool(this.d_lastTool);
            for (Tool tool : theUtil.filter(mv.d_tools.getTools(), this.getToolFilter(mv).negate())) {
                mv.d_tools.getToolbarButton(tool).setVisible(false);
            }
            this.applyRenderOptions(mv, this.d_renderOptions, this.d_patchRenderOptions, this.d_noclipRenderOptions);
            this.updateOffset();
        }

        @Override
        public void deactivate(ModelView mv) {
            this.d_lastTool = mv.d_tools.getCurrentTool();
            for (Tool tool : theUtil.filter(mv.d_tools.getTools(), this.getToolFilter(mv).negate())) {
                mv.d_tools.getToolbarButton(tool).setVisible(true);
            }
        }

        private void applyRenderOptions(ModelView mv, SceneRenderOptions options, SceneRenderOptions patchOptions, SceneRenderOptions noclipOptions) {
            mv.d_xformScenes.setDrawProps(options, patchOptions, noclipOptions);
            mv.d_mainScenes.setDrawProps(options, patchOptions, noclipOptions);
            mv.d_manipScene.setDrawProps(options);
            mv.d_wireframeAction.setSelected(options.drawWireframe());
            mv.d_solidAction.setSelected(!options.drawWireframe());
        }

        @Override
        public JToolBar getCameraToolbar(ModelView mv) {
            if (this.d_toolbar == null) {
                this.d_toolbar = this.createCameraToolbar(mv);
            }
            return this.d_toolbar;
        }

        protected static void resetCameras(ModelView mv, AABox bounds, boolean modelBounds, PredefCam ... cams) {
            AViewMode.resetCameras(mv, bounds, modelBounds, Arrays.asList(cams));
        }

        protected static void resetCameras(ModelView mv, AABox bounds, boolean modelBounds, Collection<PredefCam> cams) {
            for (PredefCam c : cams) {
                AABox box = c.cam.ensureValidForReset(new AABox(bounds), 5.0);
                c.cam.reset(c.resetZ, c.resetY, box, mv.d_renderComp.getWidth(), mv.d_renderComp.getHeight());
            }
        }
    }

    public static interface IViewMode {
        public Camera getCamera(ModelView var1);

        public Tool getNavTool(ModelView var1);

        public void activate(ModelView var1);

        public void deactivate(ModelView var1);

        public void resetCurrentCamera(ModelView var1, AABox var2, boolean var3);

        public void resetAllCameras(ModelView var1, AABox var2, boolean var3);

        public ISceneRenderOptions getRenderOptions(ModelView var1);

        public JToolBar getCameraToolbar(ModelView var1);

        public void initGridFilterToolbar(ModelView var1, JToolBar var2);

        public void initLayout(ModelView var1, OverlayLayout var2, boolean var3);

        public void updateOffset();

        public Predicate<Tool> getToolFilter(ModelView var1);
    }

    public static enum PredefCam {
        TOP_3D(Intl.intl("Reset to Top"), ModelView.access$3000(), GeomConstants.VEC3D_ZNEG, GeomConstants.VEC3D_YPOS, "ViewXY.gif"),
        BOTTOM_3D(Intl.intl("Reset to Bottom"), ModelView.access$3000(), GeomConstants.VEC3D_ZPOS, GeomConstants.VEC3D_YPOS, "ViewXY2.gif"),
        FRONT_3D(Intl.intl("Reset to Front"), ModelView.access$3000(), GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZPOS, "ViewXZ.gif"),
        BACK_3D(Intl.intl("Reset to Back"), ModelView.access$3000(), GeomConstants.VEC3D_YNEG, GeomConstants.VEC3D_ZPOS, "ViewXZ2.gif"),
        LEFT_3D(Intl.intl("Reset to Left"), ModelView.access$3000(), GeomConstants.VEC3D_XPOS, GeomConstants.VEC3D_ZPOS, "ViewYZ.gif"),
        RIGHT_3D(Intl.intl("Reset to Right"), ModelView.access$3000(), GeomConstants.VEC3D_XNEG, GeomConstants.VEC3D_ZPOS, "ViewYZ2.gif"),
        TOP_2D(Intl.intl("Reset to Top"), ModelView.access$3100(), GeomConstants.VEC3D_ZNEG, GeomConstants.VEC3D_YPOS, "ViewXY.gif"),
        BOTTOM_2D(Intl.intl("Reset to Bottom"), ModelView.access$3100(), GeomConstants.VEC3D_ZPOS, GeomConstants.VEC3D_YPOS, "ViewXY2.gif"),
        FRONT_2D(Intl.intl("Reset to Front"), ModelView.access$3100(), GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZPOS, "ViewXZ.gif"),
        BACK_2D(Intl.intl("Reset to Back"), ModelView.access$3100(), GeomConstants.VEC3D_YNEG, GeomConstants.VEC3D_ZPOS, "ViewXZ2.gif"),
        LEFT_2D(Intl.intl("Reset to Left"), ModelView.access$3100(), GeomConstants.VEC3D_XPOS, GeomConstants.VEC3D_ZPOS, "ViewYZ.gif"),
        RIGHT_2D(Intl.intl("Reset to Right"), ModelView.access$3100(), GeomConstants.VEC3D_XNEG, GeomConstants.VEC3D_ZPOS, "ViewYZ2.gif");

        public final String name;
        public final Camera cam;
        public final Vector3d resetZ;
        public final Vector3d resetY;
        public final Icon icon;

        private PredefCam(String name, Camera cam, Vector3d resetZ, Vector3d resetY, String teciIcon) {
            this.name = name;
            this.cam = cam;
            this.resetZ = resetZ;
            this.resetY = resetY;
            this.icon = PyroGuiUtil.loadTeciIcon(teciIcon);
        }

        public boolean is3D() {
            return this.cam instanceof PerspectiveCamera;
        }

        public boolean is2D() {
            return this.cam instanceof OrthoCamera;
        }

        public Vector3d getResetOrientation() {
            return this.resetZ;
        }

        public static Collection<PredefCam> get(Predicate<PredefCam> filter) {
            return theUtil.filter(Arrays.asList(PredefCam.values()), filter);
        }
    }

    private static class GCListener
    extends KeyAdapter {
        private GCListener() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 123) {
                long total = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
                long freemem = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
                long inuse = total - freemem;
                System.out.printf("in use before: %d MB%n", inuse);
                System.gc();
                System.runFinalization();
                long totalnow = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
                long freenow = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
                long inusenow = totalnow - freenow;
                long delta = inuse - inusenow;
                System.out.printf("in use after: %d MB (freed %d MB)%n", inusenow, delta);
                System.out.printf("total: %d (%d) MB%n", totalnow, freenow);
            }
        }
    }

    private class ToolPropsAction
    extends AbstractAction
    implements ToolManager.ToolChangeListener {
        private static final long serialVersionUID = 1858041037199422964L;

        public ToolPropsAction() {
            super(Intl.intl("Tool Properties..."), PyroGuiUtil.loadTeciIcon("Preferences16.gif"));
            this.putValue("ShortDescription", Intl.intl("Tool Properties"));
            ModelView.this.d_tools.addToolChangeListener(this);
        }

        public void updateStatus() {
            Set<DrawProps.Prop<?>> props = this.getPropSet(ModelView.this.d_tools.getCurrentTool());
            this.setEnabled(!props.isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Tool currTool = ModelView.this.d_tools.getCurrentTool();
            Set<DrawProps.Prop<?>> propSet = this.getPropSet(currTool);
            if (!propSet.isEmpty()) {
                DrawProps props = this.getProps(currTool);
                guiDialog dlg = null;
                if (currTool instanceof ADrawTool && !(currTool instanceof MeasureTool)) {
                    ToolMeta meta = this.getMeta(currTool);
                    DrawProps.ObjType objType = meta.objCreateType;
                    Class<? extends IGeom> geomType = ((ADrawTool)currTool).getGeomType();
                    dlg = new ToolPropertiesDlg(PyroSim.getApp().getActiveFrame(), ModelView.this.d_mediator, ModelView.this.getMainView().getCamera(), DrawProps.getNameKey(objType), props.getThicknessDesc(objType, geomType), props.getSurfFilter(objType, geomType), props, propSet);
                } else if (currTool instanceof SurfacePainterTool) {
                    Predicate<Surface> surfFilter = SurfacePainterTool.getSurfFilter();
                    dlg = new ToolPropertiesDlg(PyroSim.getApp().getActiveFrame(), ModelView.this.d_mediator, ModelView.this.getMainView().getCamera(), null, null, surfFilter, props, Sets.fromArrayHS(DrawProps.SURFACE, DrawProps.COLOR, DrawProps.SPECIFY_COLOR, DrawProps.SPECIFY_SURFACE));
                } else if (currTool instanceof SurfacePickerTool) {
                    dlg = new ToolPropertiesDlg(PyroSim.getApp().getActiveFrame(), ModelView.this.d_mediator, ModelView.this.getMainView().getCamera(), null, null, Filters.acceptAll(Surface.class), props, Sets.fromArrayHS(DrawProps.SPECIFY_COLOR, DrawProps.SPECIFY_SURFACE));
                }
                if (dlg != null && dlg.doModal() == 1) {
                    ((ToolPropertiesDlg)dlg).saveProps();
                    ModelView.this.d_drawToolBridge.updateProps();
                    ModelView.this.d_renderComp.repaint();
                }
            }
        }

        @Override
        public void toolWillChanged(Tool oldTool, Tool newTool) {
            this.updateStatus();
        }

        private DrawProps getProps(Tool tool) {
            return tool instanceof IPyroTool ? ((IPyroTool)tool).getProps() : null;
        }

        private ToolMeta getMeta(Tool tool) {
            if (tool != null) {
                ToolManager.ToolProps props = ModelView.this.d_tools.getProps(tool);
                return props.meta instanceof ToolMeta ? (ToolMeta)props.meta : null;
            }
            return null;
        }

        private Set<DrawProps.Prop<?>> getPropSet(Tool currTool) {
            DrawProps props = this.getProps(currTool);
            if (props == null) {
                return Collections.EMPTY_SET;
            }
            if (currTool instanceof ADrawTool && !(currTool instanceof MeasureTool)) {
                ToolMeta meta = this.getMeta(currTool);
                DrawProps.ObjType objType = meta.objCreateType;
                Class<? extends IGeom> geomType = ((ADrawTool)currTool).getGeomType();
                Set<DrawProps.Prop<?>> results = props.getPropTypes(objType, geomType);
                if (currTool instanceof DrawGridGeomTool || currTool instanceof DrawAABoxGeomTool) {
                    results.remove(DrawProps.THICKNESS);
                }
                return results;
            }
            if (currTool instanceof SurfacePainterTool) {
                return Sets.fromArrayHS(DrawProps.SURFACE, DrawProps.COLOR, DrawProps.SPECIFY_COLOR, DrawProps.SPECIFY_SURFACE);
            }
            if (currTool instanceof SurfacePickerTool) {
                return Sets.fromArrayHS(DrawProps.SPECIFY_COLOR, DrawProps.SPECIFY_SURFACE);
            }
            return Collections.EMPTY_SET;
        }
    }

    private class FloorBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -424172468799442485L;

        private FloorBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                String desc;
                if (value == ModelView.this.d_allFloorsFloor) {
                    desc = ModelView.this.d_allFloorsFloor.getName();
                } else {
                    Floor f = (Floor)value;
                    Unit u = ((PyroSim)Application.getApp()).getUnitSystem().getLengthUnit();
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    nf.setMaximumFractionDigits(2);
                    desc = String.format("%1$s (%2$s %3$s)", f.getName(), nf.format(f.getElevation().getValue(u)), u.toString());
                }
                this.setText(desc);
            }
            return this;
        }
    }

    public static interface CameraChangeListener {
        public void cameraChanged(Camera var1, Camera var2);
    }

    public class SelectGridAction
    extends MutuallyExclusiveAction {
        private static final long serialVersionUID = -234522650277828853L;
        private final int d_grid;

        public SelectGridAction(int grid, boolean selected) {
            super(ModelView.getSnappingName(grid), selected);
            this.d_grid = grid;
        }

        @Override
        protected void stateChanged() {
            if (!this.isSelected()) {
                return;
            }
            ModelView.this.setActiveSnapper(this.d_grid, false);
            ModelView.this.getRenderComponent().repaint();
        }
    }

    public class CutHolesAction
    extends BooleanAction {
        private static final long serialVersionUID = -1761223646899256562L;

        public CutHolesAction() {
            super(Intl.intl("Cut Holes From Obstructions"), ModelView.this.d_drawProps.cutHoles());
        }

        @Override
        protected void stateChanged() {
            PyroSim.getApp().beginWaitCursor();
            ModelView.this.d_drawProps.setCutHoles(this.isSelected());
            ModelView.this.d_mediator.updateGeomSearchesEnabled(ModelView.this.isHoleCuttingEnabled());
            ((ModelView)ModelView.this).d_dispMgr.d_geomDispMan.updateAll();
            ModelView.this.d_renderComp.repaint();
            PyroSim.getApp().endWaitCursor();
        }
    }

    private class EditModelImageAction
    extends DisposableObject
    implements FloorBGImageEditor.EditBGImageAction {
        private final IntermediateGraphicsXfer d_igx = new IntermediateGraphicsXfer();

        private EditModelImageAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean editFloor(final Floor f) {
            HashMap<BGImageDlg.Colors, IPropertySet.Prop<Color>> colorMap = new HashMap<BGImageDlg.Colors, IPropertySet.Prop<Color>>();
            colorMap.put(BGImageDlg.Colors.AXIS, PyroSimColors.AXIS_COLOR);
            colorMap.put(BGImageDlg.Colors.AXIS_BOX, PyroSimColors.AXIS_BOX_COLOR);
            colorMap.put(BGImageDlg.Colors.AXIS_TEXT, PyroSimColors.AXIS_TEXT_COLOR);
            colorMap.put(BGImageDlg.Colors.BACKGROUND, PyroSimColors.BACKGROUND_COLOR);
            colorMap.put(BGImageDlg.Colors.ORIGIN, PyroSimColors.ORIGIN2D_COLOR);
            ImageLoader imgLoader = new ImageLoader();
            BGImageDlg.ImageInfo existing = null;
            if (f.getBgImage() != null) {
                ModelImage image = f.getBgImage();
                existing = new BGImageDlg.ImageInfo(image.getImage(), image.getLWTransform(), image.getOpacity());
            }
            final BGImageDlg.ImageInfo result = BGImageDlg.editImage(PyroSim.getApp().getActiveFrame(), ModelView.this.d_renderComp, PyroSim.getApp().getColorManager(), colorMap, imgLoader, PyroSim.getApp().getUnitSystem().getLengthUnit(), this.d_igx, existing);
            try {
                if (result == null) {
                    boolean bl = false;
                    return bl;
                }
                ATask tsk = new ATask(false){

                    @Override
                    public void undo() {
                    }

                    @Override
                    public void run() {
                        ModelImage newImg = new ModelImage(result.image, result.xform, result.opacity);
                        f.setBgImage(newImg);
                    }
                };
                ModelView.this.d_mediator.getTaskManager().exec(tsk, Intl.intl("Edit Background Image"));
                boolean bl = true;
                return bl;
            }
            finally {
                this.d_igx.dispose();
            }
        }

        @Override
        public void dispose() {
            this.d_igx.release();
        }
    }

    private static class ImageLoader
    implements BGImageDlg.IImageLoader {
        private static final String[] FILTERS = new String[]{"bmp", Intl.intl("BMP Files"), "gif", Intl.intl("GIF Files"), "jpg", Intl.intl("JPEG Files"), "jpeg", Intl.intl("JPEG Files"), "jif", Intl.intl("JPEG Files"), "jpe", Intl.intl("JPEG Files"), "png", Intl.intl("PNG Files"), "tif", Intl.intl("TIF Files"), "tga", Intl.intl("TARGA Files"), "targa", Intl.intl("TARGA Files")};

        private ImageLoader() {
        }

        @Override
        public File choose(Component parent, File currFile) {
            return PyroSim.getFilenames().getOpenFile((Component)PyroSim.getApp().getActiveFrame(), currFile, FILTERS);
        }

        @Override
        public Pair<Image, BGImageXform> load(File file) throws IOException {
            String filename = file.getAbsolutePath();
            try {
                IImage img = ImageManager.getImage(filename);
                if (img == null) {
                    throw new IOException(Intl.intl("Could not load image."));
                }
                return new Pair<IImage, Object>(img, null);
            }
            catch (OutOfMemoryError e) {
                throw new IOException(Intl.intl("Unable to load image file, the file is too large."));
            }
        }
    }

    private class FillViewAction
    extends guiAction {
        private static final long serialVersionUID = 4134387244026864947L;

        public FillViewAction() {
            super(Intl.intl("Fill View"), PyroGuiUtil.loadPyroSimIcon("fillview16.gif"));
            this.putValue("ShortDescription", Intl.intl("Fill view without resetting view angle"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ModelView.this.fillCamera();
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ResetToSelectedObjectsAction
    extends guiAction {
        private static final long serialVersionUID = 6747950754014970066L;

        public ResetToSelectedObjectsAction() {
            super(Intl.intl("Reset View to Selected Objects"), PyroGuiUtil.loadPyroSimIcon("ZoomSelectedObjs16.gif"));
            this.putValue("ShortDescription", Intl.intl("Reset View to Visible, Selected Objects"));
            this.putValue("AcceleratorKey", Accelerators.RESET_SELECTED);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Collection<IPyroGeomSrc> objs = ModelView.this.d_mediator.getSelectionModel().flatten(IPyroGeomSrc.class);
            ArrayList<Object3D> displays = new ArrayList<Object3D>(objs.size());
            displays.addAll(theUtil.filter(ModelView.this.d_dispMgr.getDisplayObjs(objs), Object3D.class));
            if (displays.isEmpty()) {
                return;
            }
            ModelView.this.resetCurrentCamera(displays);
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ResetToAllObjectsAction
    extends guiAction {
        private static final long serialVersionUID = 575148560236721658L;

        public ResetToAllObjectsAction() {
            super(Intl.intl("Reset View to All Objects"), PyroGuiUtil.loadTeciIcon("ZoomFit16.gif"));
            this.putValue("ShortDescription", Intl.intl("Reset View to All Visible Objects"));
            this.putValue("AcceleratorKey", Accelerators.RESET_VIEW);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ModelView.this.resetCurrentCamera();
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ManageFloorsAction
    extends guiAction {
        private static final long serialVersionUID = -7923470282395880358L;

        public ManageFloorsAction() {
            super(Intl.intl("Manage Floors..."), PyroGuiUtil.loadPyroSimIcon("managefloors16_2.gif"));
            this.putValue("ShortDescription", Intl.intl("Define Floor Locations"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditModelImageAction action = new EditModelImageAction();
            ManageFloorsDlg dlg = new ManageFloorsDlg(Application.getApp().getMainFrame(), ModelView.this.d_mediator, action);
            action.release();
            if (dlg.doModal() == 1) {
                ManageFloorsTask tsk = new ManageFloorsTask(dlg);
                ModelView.this.d_mediator.getTaskManager().exec(tsk, Intl.intl("Edit Floors"));
            }
        }
    }

    private class ConfigureBGImageAction
    extends guiAction {
        private static final long serialVersionUID = -1736108326757489690L;

        public ConfigureBGImageAction() {
            super(Intl.intl("Configure Background Image") + "...", PyroGuiUtil.loadPyroSimIcon("ConfigureBackgroundImage16.gif"));
            this.putValue("ShortDescription", Intl.intl("Configure Background Image for the Current Floor"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ModelView.this.d_currentFloor != null) {
                EditModelImageAction action = new EditModelImageAction();
                action.editFloor(ModelView.this.d_currentFloor);
                action.release();
            } else if (JOptionPane.showConfirmDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("Background images are unique to each floor.  Set background images using the Floor Manager."), Intl.intl("Configure Background Image"), 2) == 0) {
                ModelView.this.getManageFloorsAction().actionPerformed(e);
            }
        }
    }

    private class UseWireframeAction
    extends BooleanAction {
        private static final long serialVersionUID = -1071282092337624521L;
        private final boolean d_wireframe;

        public UseWireframeAction(String name, String desc, boolean selected, String iconLocation, boolean wireframe) {
            super(name, selected, new ImageIcon(ClassLoader.getSystemResource(iconLocation)));
            this.putValue("ShortDescription", desc);
            this.d_wireframe = wireframe;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_WIREFRAME, this.d_wireframe);
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_OUTLINES, false);
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_MATERIALS, false);
            ModelView.this.getCurrentViewMode().updateOffset();
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ShowRealisticOutlinesAction
    extends guiAction {
        private static final long serialVersionUID = 1L;

        public ShowRealisticOutlinesAction(boolean initValue) {
            super(Intl.intl("Realistic with Outlines"), new ImageIcon(ClassLoader.getSystemResource("pyrosim/icons/texturesOutline.png")));
            this.putValue("ShortDescription", Intl.intl("Show Objects Using Surface Appearance with Outlines"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_WIREFRAME, false);
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_OUTLINES, true);
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_MATERIALS, true);
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ShowRealisticAction
    extends guiAction {
        private static final long serialVersionUID = 1L;

        public ShowRealisticAction(boolean initValue) {
            super(Intl.intl("Realistic"), PyroGuiUtil.loadPyroSimIcon("textures.png"));
            this.putValue("ShortDescription", Intl.intl("Show Objects Using Surface Appearances"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_WIREFRAME, false);
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_OUTLINES, false);
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_MATERIALS, true);
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ShowSolidOutlinesAction
    extends guiAction {
        private static final long serialVersionUID = 1L;

        public ShowSolidOutlinesAction(boolean initValue) {
            super(Intl.intl("Solid with Outlines"), new ImageIcon(ClassLoader.getSystemResource("pyrosim/icons/outlines.png")));
            this.putValue("ShortDescription", Intl.intl("Show Objects as Solids with Outlines"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_WIREFRAME, false);
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_OUTLINES, true);
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_MATERIALS, false);
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class UseSVNavigationAction
    extends BooleanAction {
        private static final long serialVersionUID = 1969470262773663277L;

        public UseSVNavigationAction(boolean initValue) {
            super(Intl.intl("Use Smokeview-like Navigation"), initValue);
        }

        @Override
        protected void stateChanged() {
            ((SwitchingToolFunc)((ModelView)ModelView.this).d_orbitTool.tool.getFunction()).setCurrentFunc(this.isSelected() ? 1 : 0);
        }
    }

    private class ShowSystemMouseAction
    extends BooleanAction {
        private static final long serialVersionUID = -8774518959151462077L;

        public ShowSystemMouseAction(boolean initValue) {
            super(Intl.intl("Show System Mouse"), initValue);
        }

        @Override
        protected void stateChanged() {
            ModelView.this.updateCurrentTool();
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ShowGuidesAction
    extends BooleanAction {
        private static final long serialVersionUID = 5435063418982919330L;

        public ShowGuidesAction(boolean initValue) {
            super(Intl.intl("Show Cursor Guides"), initValue);
        }

        @Override
        protected void stateChanged() {
            ModelView.this.updateCurrentTool();
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class FDSPreviewAction
    extends FilterAction {
        private static final long serialVersionUID = 6411840680811353808L;

        public FDSPreviewAction() {
            super(Intl.intl("Preview FDS Blocks"), (Icon)PyroGuiUtil.loadPyroSimIcon("rasterized16.gif"), Filter.class, false);
        }

        @Override
        protected void stateChanged() {
            super.stateChanged();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FDSRasterization rasterizer = FDSPreviewAction.this.isSelected() ? ModelView.this.d_mediator.getRasterizations() : null;
                    ModelView.this.getDrawProps().setRasterizer(rasterizer);
                    ModelView.this.updateRasterizableObjs();
                    ModelView.this.getRenderComponent().repaint();
                }
            });
        }

        private final class Filter {
            private Filter() {
            }
        }
    }

    private class FilterAction<T>
    extends BooleanAction
    implements IEventObserver {
        private static final long serialVersionUID = -574190459864692128L;
        private final Class<T> d_filterType;
        private final Predicate<? super T> d_hideFilter;
        private final Predicate<? super T> d_showFilter;
        private final Icon d_visIcon;
        private final Icon d_hiddenIcon;
        private final Function<Events, Boolean> d_eventTester;

        public FilterAction(String tooltip, String label, Class<T> filterType, boolean initShow) {
            this(label, null, filterType, Predicates.alwaysFalse(), initShow);
            this.putValue("ShortDescription", tooltip);
        }

        public FilterAction(String desc, Icon baseIcon, Class<T> filterType, TypedProp<Boolean> boolPrefKey) {
            this(desc, baseIcon, filterType, PyroPrefs.getBoolean(boolPrefKey));
        }

        public FilterAction(String desc, Icon baseIcon, Class<T> filterType, boolean initShow) {
            this(desc, baseIcon, filterType, Predicates.alwaysFalse(), initShow);
        }

        public FilterAction(String desc, Icon baseIcon, Class<T> filterType, Predicate<? super T> hideFilter, boolean initShow) {
            this(desc, baseIcon, filterType, hideFilter, Predicates.alwaysTrue(), null, initShow);
        }

        public FilterAction(String desc, Icon baseIcon, Class<T> filterType, Predicate<? super T> hideFilter, Predicate<? super T> showFilter, Function<Events, Boolean> eventTester, boolean initShow) {
            super(desc, initShow, baseIcon);
            this.d_visIcon = ModelView.newVisIcon(baseIcon, s_lbOnIcon);
            this.d_hiddenIcon = ModelView.newVisIcon(baseIcon, s_lbOffIcon);
            this.d_filterType = filterType;
            this.d_hideFilter = hideFilter;
            this.d_showFilter = showFilter;
            this.d_eventTester = eventTester;
            if (this.d_eventTester != null) {
                PyroSim.getApp().getMediator().getEvents().addObserver(this);
            }
            this.updateIcon();
            this.updateState();
        }

        @Override
        public void update(Events events) {
            if (this.d_eventTester.apply(events).booleanValue()) {
                ((ModelView)ModelView.this).d_dispMgr.d_dispFilter.changed(this.d_filterType);
            }
        }

        private void updateState() {
            if (!this.isSelected()) {
                ((ModelView)ModelView.this).d_dispMgr.d_dispFilter.registerFilter(this.d_filterType, this.d_hideFilter);
            } else if (Predicates.alwaysTrue(this.d_showFilter)) {
                ((ModelView)ModelView.this).d_dispMgr.d_dispFilter.removeFilter(this.d_filterType);
            } else {
                ((ModelView)ModelView.this).d_dispMgr.d_dispFilter.registerFilter(this.d_filterType, this.d_showFilter);
            }
        }

        private void updateIcon() {
            if (this.isSelected()) {
                this.putValue("SmallIcon", this.d_visIcon);
            } else {
                this.putValue("SmallIcon", this.d_hiddenIcon);
            }
        }

        @Override
        protected void stateChanged() {
            PyroSim.getApp().beginWaitCursor();
            this.updateIcon();
            this.updateState();
            ModelView.this.getRenderComponent().repaint();
            PyroSim.getApp().endWaitCursor();
        }
    }

    private class ShowOriginAction
    extends BooleanAction {
        private static final long serialVersionUID = 2802752637431449227L;

        public ShowOriginAction(boolean initValue) {
            super(Intl.intl("Show Origin"), initValue);
        }

        @Override
        protected void stateChanged() {
            ModelView.this.updateOriginVisibility();
            ModelView.this.d_renderComp.repaint();
        }
    }

    public class EditSnapSize
    extends guiAction {
        private static final long serialVersionUID = -7765942993335129025L;

        public EditSnapSize() {
            super(Intl.intl("Set Sketch Grid Spacing") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            EditSnapToGridDlg dlg = new EditSnapToGridDlg(Application.getApp().getActiveFrame(), ModelView.this.d_sketchGrid.getSpacing());
            if (dlg.doModal() == 1) {
                ModelView.this.d_sketchGrid.setSpacing(dlg.getSpacing());
                ModelView.this.d_renderComp.repaint();
            }
        }
    }

    private static class NavToolInfo {
        public final CursorTool tool;
        public final View.NavTool type;

        public NavToolInfo(CursorTool tool, View.NavTool type) {
            this.tool = tool;
            this.type = type;
            NAV_TOOLS.add(this);
        }
    }

    private static class FilterActionInfo {
        private final BooleanAction action;
        private final boolean initState;

        public FilterActionInfo(BooleanAction action) {
            this.action = action;
            this.initState = action.isSelected();
        }

        private void reset() {
            this.action.setSelected(this.initState);
        }

        public void setState(boolean state) {
            this.action.setSelected(state);
        }

        public boolean getState() {
            return this.action.isSelected();
        }
    }

    protected static class WorkingZConstraintGen
    implements IConstraintGen {
        protected WorkingZConstraintGen() {
        }

        @Override
        public ISnapConstraint getConstraint(IPyroTool tool) {
            double z = tool.getProps().get(DrawProps.LOCATION).getValue(Geometry.LU);
            Plane3d plane = new Plane3d(0.0, 0.0, 1.0, -z);
            return new PlanarConstraint(plane);
        }
    }

    protected static class OffsetConstraintGen
    implements IConstraintGen {
        protected OffsetConstraintGen() {
        }

        @Override
        public ISnapConstraint getConstraint(IPyroTool tool) {
            double z = tool.getProps().get(DrawProps.LOCATION).getValue(Geometry.LU);
            PlanarConstraint rayConstraint = new PlanarConstraint(new Plane3d(0.0, 0.0, 1.0, -z));
            return new OffsetPointConstraint(rayConstraint, new Vector3d(0.0, 0.0, z));
        }
    }

    private static class GeomScenes {
        public final ModelScene scene = new ModelScene();
        public final ModelScene caps = new ModelScene();
        public final ModelScene patch = new ModelScene();
        public final ModelScene noclip = new ModelScene();
        public final ModelScene excludedNoClip = new ModelScene();

        private GeomScenes() {
        }

        public void setDrawProps(SceneRenderOptions sceneOpts, SceneRenderOptions patchOpts, SceneRenderOptions noclipOpts) {
            this.scene.setDrawProps(sceneOpts);
            this.patch.setDrawProps(patchOpts);
            this.caps.setDrawProps(sceneOpts);
            this.noclip.setDrawProps(noclipOpts);
            this.excludedNoClip.setDrawProps(noclipOpts);
        }

        public Collection<ModelScene> getRenderScenes() {
            ArrayList<ModelScene> scenes = new ArrayList<ModelScene>();
            this.getRenderScenes(scenes);
            return scenes;
        }

        public void getRenderScenes(Collection<? super ModelScene> scenes) {
            scenes.add(this.patch);
            scenes.add(this.caps);
            scenes.add(this.scene);
            scenes.add(this.noclip);
            scenes.add(this.excludedNoClip);
        }

        public Camera getCamera() {
            return this.scene.getCamera();
        }

        public void setCamera(Camera camera) {
            this.scene.setCamera(camera);
            this.caps.setCamera(camera.createCopyCam());
            this.patch.setCamera(camera.createCopyCam());
            this.noclip.setCamera(camera.createCopyCam());
            this.excludedNoClip.setCamera(camera.createCopyCam());
        }

        public void getBounds(BoundsCalculator bc, boolean useExcluded) {
            bc.add(this.scene);
            bc.add(this.caps);
            bc.add(this.patch);
            bc.add(this.noclip);
            if (useExcluded) {
                bc.add(this.excludedNoClip);
            }
        }
    }
}

