/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.vecmath.Point2d;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiUtil;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.Rectifier;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.AToolFunction;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.CursorTool;

public class ZoomBoxFunc
extends AToolFunction<CursorTool> {
    public static final Cursor CURSOR = guiUtil.createTeciCursor("Zoom Box", "ZoomboxCur.gif", 15, 15);
    public static final Icon ICON = guiUtil.loadTeciIcon("zoombox16.gif");

    @Override
    public Cursor getCursor(CursorTool tool) {
        return CURSOR;
    }

    @Override
    public boolean showDragGuides(CursorTool tool) {
        return true;
    }

    @Override
    public void mouseDragged(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseMoved(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mousePressed(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseEntered(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseExited(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseReleased(CursorTool tool, MouseEvent e) {
        if (tool.dragAboveTolerance(0)) {
            Point2d initialPos = tool.getP0().referenceSnapSc;
            Point2d currentPos = tool.getP1().referenceSnapSc;
            if (initialPos.x == currentPos.x || initialPos.y == currentPos.y) {
                tool.repaintSurface();
                return;
            }
            IRenderSurface surface = tool.getView().getSurface();
            Rectifier.rectify(initialPos, currentPos);
            Point2d zoomCenterSc = new Point2d();
            zoomCenterSc.add(currentPos, initialPos);
            zoomCenterSc.scale(0.5);
            double diffx = currentPos.x - initialPos.x;
            double diffy = currentPos.y - initialPos.y;
            double zoomH = (double)surface.getWidth() / diffx;
            double zoomV = (double)surface.getHeight() / diffy;
            double zoom = zoomH <= zoomV ? zoomH : zoomV;
            tool.getView().zoom(zoom, zoomCenterSc);
            tool.repaintSurface();
        }
    }
}

