/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.APlaneHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeneralPoly;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.NGon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyLine;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Quad;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Triangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.PlanarConstraint;

public class PolyUtil {
    public static IPolygon newPoly(Point3d ... points) {
        return PolyUtil.newPoly(Util3D.isConvex(1.0E-9, points), points);
    }

    public static IPolygon newPoly(boolean isConvex, Point3d ... points) {
        if (points.length == 3) {
            return new Triangle(points[0], points[1], points[2]);
        }
        if (points.length == 4 && isConvex) {
            return new Quad(points[0], points[1], points[2], points[3]);
        }
        return new NGon(points);
    }

    public static IPolygon newPoly(Point3d[] points, int[] loopOffsets) {
        if (loopOffsets.length <= 1) {
            return PolyUtil.newPoly(points);
        }
        return new GeneralPoly(points, loopOffsets);
    }

    public static IPolygon newPoly(Point3d[][] points) {
        if (points.length == 0) {
            return new NGon(new Point3d[0]);
        }
        if (points.length == 1) {
            return PolyUtil.newPoly(points[0]);
        }
        return new GeneralPoly(points);
    }

    public static boolean polysEqual(IPolygon poly1, IPolygon poly2) {
        int loopCount = poly1.getNumLoops();
        if (loopCount != poly2.getNumLoops()) {
            return false;
        }
        for (int loopix = 0; loopix < loopCount; ++loopix) {
            int m;
            int count = poly1.getNumPoints(loopix);
            if (count != poly2.getNumPoints(loopix)) {
                return false;
            }
            if (count == 0) {
                return true;
            }
            int startIx2 = -1;
            Point3d p1 = poly1.getPoint(loopix, 0);
            for (m = 0; m < count; ++m) {
                if (!p1.equals(poly2.getPoint(loopix, m))) continue;
                startIx2 = m;
                break;
            }
            if (startIx2 == -1) {
                return false;
            }
            int n = (startIx2 + 1) % count;
            for (m = 1; m < count; ++m) {
                Point3d ppoly2;
                Point3d ppoly1 = poly1.getPoint(loopix, m);
                if (!ppoly1.equals(ppoly2 = poly2.getPoint(loopix, n))) {
                    return false;
                }
                n = (n + 1) % count;
            }
        }
        return true;
    }

    public static void getBoundary(List<ICurve> boundary, IPolygon poly) {
        for (int n = 0; n < poly.getNumLoops(); ++n) {
            Point3d[] verts = new Point3d[poly.getNumPoints(n) + 1];
            for (int o = 0; o < verts.length - 1; ++o) {
                verts[o] = poly.getPoint(n, o);
            }
            verts[verts.length - 1] = verts[0];
            boundary.add(new PolyLine(verts));
        }
    }

    public static Point3d[] getAllVerts(IPolygon poly, boolean copy) {
        if (!copy && poly instanceof NGon) {
            return ((NGon)poly).points;
        }
        if (!copy && poly instanceof GeneralPoly) {
            return ((GeneralPoly)poly).points;
        }
        int numPoints = 0;
        for (int m = 0; m < poly.getNumLoops(); ++m) {
            numPoints += poly.getNumPoints(m);
        }
        int ix = 0;
        Point3d[] points = new Point3d[numPoints];
        for (int m = 0; m < poly.getNumLoops(); ++m) {
            int numVerts = poly.getNumPoints(m);
            for (int n = 0; n < numVerts; ++n) {
                points[ix++] = poly.getPoint(m, n);
            }
        }
        return points;
    }

    public static Point3d[][] getLoops(IPolygon poly, boolean copy) {
        if (!copy && poly instanceof NGon) {
            return new Point3d[][]{((NGon)poly).points};
        }
        Point3d[][] loops = new Point3d[poly.getNumLoops()][];
        for (int m = 0; m < loops.length; ++m) {
            loops[m] = PolyUtil.getLoop(poly, m, copy);
        }
        return loops;
    }

    public static int[] getLoopOffsets(IPolygon poly, boolean copy) {
        if (!copy && poly instanceof GeneralPoly) {
            return ((GeneralPoly)poly).loopOffsets;
        }
        int[] offsets = new int[poly.getNumLoops()];
        int offset = 0;
        for (int m = 0; m < offsets.length; ++m) {
            offsets[m] = offset;
            offset += poly.getNumPoints(m);
        }
        return offsets;
    }

    public static Point3d[] getLoop(IPolygon poly, int loop, boolean copy) {
        if (!copy && poly instanceof NGon) {
            assert (loop == 0);
            return ((NGon)poly).points;
        }
        int numVerts = poly.getNumPoints(loop);
        Point3d[] verts = new Point3d[numVerts];
        for (int m = 0; m < numVerts; ++m) {
            verts[m] = poly.getPoint(loop, m);
        }
        return verts;
    }

    public static boolean isConvex(IPolygon poly) {
        if (poly.getNumLoops() != 1) {
            return false;
        }
        if (poly instanceof Triangle || poly.getNumPoints(0) == 3) {
            return true;
        }
        Point3d[] verts = PolyUtil.getLoop(poly, 0, false);
        return Util3D.isConvex(1.0E-6, verts);
    }

    public static boolean intersectsBox(Object source, IPolygon poly, IIsectFilter filter, ConvexHull box) {
        block11: {
            block12: {
                block10: {
                    if (!filter.acceptGeomType(source, GeomType.FACE)) break block10;
                    if (PolyUtil.isConvex(poly)) {
                        assert (poly.getNumLoops() == 1);
                        int numVerts = poly.getNumPoints(0);
                        Point3d[] verts = new Point3d[numVerts];
                        for (int m = 0; m < numVerts; ++m) {
                            verts[m] = poly.getPoint(0, m);
                        }
                        if (box.intersectsConvexPoly(1.0E-6, verts)) {
                            return true;
                        }
                    } else {
                        Mesh tris = poly.triangulate(1.0E-6);
                        Point3d[] tri = new Point3d[3];
                        int m = 0;
                        while (m < tris.indices.length) {
                            tri[0] = tris.vertices[tris.indices[m++]];
                            tri[1] = tris.vertices[tris.indices[m++]];
                            tri[2] = tris.vertices[tris.indices[m++]];
                            if (!box.intersectsConvexPoly(1.0E-6, tri)) continue;
                            return true;
                        }
                    }
                    break block11;
                }
                if (!filter.acceptGeomType(source, GeomType.FACE_EDGE)) break block12;
                int numLoops = poly.getNumLoops();
                for (int n = 0; n < numLoops; ++n) {
                    int numVerts = poly.getNumPoints(n);
                    for (int m = 0; m < numVerts; ++m) {
                        Point3d p2;
                        Point3d p1 = poly.getPoint(n, m);
                        if (!box.intersectsLineSeg(p1, p2 = poly.getPoint(n, (m + 1) % numVerts), 1.0E-6)) continue;
                        return true;
                    }
                }
                break block11;
            }
            if (!filter.acceptGeomType(source, GeomType.FACE_VERTEX)) break block11;
            int numLoops = poly.getNumLoops();
            for (int n = 0; n < numLoops; ++n) {
                int numVerts = poly.getNumPoints(n);
                for (int m = 0; m < numVerts; ++m) {
                    if (!box.contains(poly.getPoint(n, m), 1.0E-6)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void pickPoints(IPolygon poly, IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        Point3d isect;
        if (filter.acceptGeomType(source, GeomType.FACE) && (isect = PolyUtil.getFaceIsect(poly, source, rayBegin, rayEnd, rayDirN)) != null) {
            isects.add(source, isect, GeomType.FACE, poly);
        }
        if (filter.acceptGeomType(source, GeomType.FACE_VERTEX)) {
            PolyUtil.getFaceVertices(poly, source, isects);
        }
        if (filter.acceptGeomType(source, GeomType.FACE_EDGE)) {
            PolyUtil.getClosestToEdges(poly, source, isects, rayBegin, rayEnd, rayDirN);
        }
    }

    private static void getFaceVertices(IPolygon poly, Object source, IIsectCollector isects) {
        int numLoops = poly.getNumLoops();
        for (int m = 0; m < numLoops; ++m) {
            int numVerts = poly.getNumPoints(m);
            for (int n = 0; n < numVerts; ++n) {
                Point3d p = poly.getPoint(m, n);
                isects.add(source, p, GeomType.FACE_VERTEX, poly);
            }
        }
    }

    private static void getClosestToEdges(IPolygon poly, Object source, IIsectCollector isects, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN) {
        Point3d isect = new Point3d();
        int numLoops = poly.getNumLoops();
        for (int m = 0; m < numLoops; ++m) {
            int numVerts = poly.getNumPoints(m);
            if (numVerts == 0) continue;
            Point3d p1 = poly.getPoint(m, 0);
            for (int n = 1; n <= numVerts; ++n) {
                Point3d p2 = poly.getPoint(m, n % numVerts);
                boolean nonParallel = Inter3D.lineLineSegProximity(null, isect, rayBegin, rayDirN, p1, p2);
                if (nonParallel) {
                    isects.add(source, new Point3d(isect), GeomType.FACE_EDGE, poly);
                }
                p1 = p2;
            }
        }
    }

    private static Point3d getFaceIsect(IPolygon poly, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN) {
        Plane3d plane = PolyUtil.getPlane(poly);
        if (!plane.isValid()) {
            return null;
        }
        Point3d isect = Inter3D.lineSegPlaneIntersection(rayBegin, rayEnd, plane, 1.0E-6);
        if (isect == null) {
            return null;
        }
        return poly.classify((Point3d)isect, (double)1.0E-6).positive ? isect : null;
    }

    public static Plane3d getPlane(IPolygon poly) {
        if (poly.getNumLoops() == 0 || poly.getNumPoints(0) == 0) {
            return new Plane3d(0.0, 0.0, 1.0, 0.0);
        }
        Vector3d normal = poly.getNormal();
        Point3d p = poly.getPoint(0, 0);
        return new Plane3d(normal, p);
    }

    public static IPolygon reverse(IPolygon poly) {
        int numLoops = poly.getNumLoops();
        Point3d[][] loops = new Point3d[numLoops][];
        for (int m = 0; m < numLoops; ++m) {
            int numVerts = poly.getNumPoints(m);
            Point3d[] loop = new Point3d[numVerts];
            for (int n = 0; n < numVerts; ++n) {
                loop[numVerts - 1 - n] = poly.getPoint(m, n);
            }
            loops[m] = loop;
        }
        return PolyUtil.newPoly(loops);
    }

    protected static IFace.PointClassify classify(IPolygon poly, Point3d p, double tol) {
        int numVerts;
        if (poly.getNumLoops() == 0 || poly.getNumPoints(0) == 0) {
            return IFace.PointClassify.OUTSIDE;
        }
        if (poly.getNumLoops() == 1 && (numVerts = poly.getNumPoints(0)) == 3) {
            return PolyUtil.convert(Inter3D.classifyConvexPolyPoint(tol, p, poly.getPoint(0, 0), poly.getPoint(0, 1), poly.getPoint(0, 2)));
        }
        Plane3d plane = new Plane3d(poly.getNormal(), poly.getPoint(0, 0));
        Point3d[][] loops = PolyUtil.getLoops(poly, false);
        return PolyUtil.convert(Inter3D.classifySimplePolyPoint(1.0E-6, p, plane, loops));
    }

    private static IFace.PointClassify convert(Inter3D.PointClassify pc) {
        switch (pc) {
            case INSIDE: {
                return IFace.PointClassify.INSIDE;
            }
            case ON_BOUNDARY: {
                return IFace.PointClassify.ON_BOUNDARY;
            }
        }
        return IFace.PointClassify.OUTSIDE;
    }

    public static Collection<? extends IHandle> generateManipHandles(IPolygon poly) {
        ArrayList<IHandle> handles = new ArrayList<IHandle>();
        int numLoops = poly.getNumLoops();
        for (int m = 0; m < numLoops; ++m) {
            int numVerts = poly.getNumPoints(m);
            for (int n = 0; n < numVerts; ++n) {
                handles.add(new VertHandle(poly, m, n));
            }
        }
        handles.add(new OffsetHandle(poly));
        return handles;
    }

    private static class OffsetHandle
    extends APlaneHandle<IPolygon> {
        public OffsetHandle(IPolygon geom) {
            super(geom);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && obj instanceof OffsetHandle;
        }

        @Override
        public IGeom getGeom() {
            return (IGeom)this.getManipGeom();
        }

        @Override
        protected Vector3d getPlaneNormal(IPolygon geom) {
            return geom.getNormal();
        }

        @Override
        protected IPolygon modify(IPolygon origGeom, double offset) {
            Vector3d normal = origGeom.getNormal();
            Matrix4d xform = Util.translateMat(normal.x * offset, normal.y * offset, normal.z * offset);
            return origGeom.transform(xform);
        }
    }

    private static class VertHandle
    implements IHandle {
        private IPolygon geom;
        private final int loop;
        private final int vert;
        private Point3d[][] d_loops;

        public VertHandle(IPolygon geom, int loop, int vert) {
            this.geom = geom;
            this.loop = loop;
            this.vert = vert;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof VertHandle)) {
                return false;
            }
            VertHandle handle = (VertHandle)obj;
            return handle.loop == this.loop && handle.vert == this.vert;
        }

        @Override
        public IIsectFilter getPickFilter() {
            return null;
        }

        @Override
        public IGeom getGeom() {
            return new Point(this.getLocation());
        }

        protected Point3d getLocation() {
            return this.geom.getPoint(this.loop, this.vert);
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            Plane3d editPlane = PolyUtil.getPlane(this.geom);
            return new PlanarConstraint(editPlane);
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            this.d_loops = PolyUtil.getLoops(this.geom, true);
        }

        @Override
        public IPolygon modify(Point3d newLoc) throws Exception {
            this.d_loops[this.loop][this.vert] = newLoc;
            this.geom = PolyUtil.newPoly(this.d_loops);
            return this.geom;
        }

        @Override
        public Object end() {
            this.d_loops = null;
            return this.geom;
        }
    }
}

