/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.domain.zones.Leak;
import pyrosim.legacy_2012_1.domain.zones.OuterZone;
import pyrosim.legacy_2012_1.domain.zones.Zone;
import pyrosim.legacy_2012_1.domain.zones.ZoneMgr;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class ZoneParser
extends AFDS5Parser {
    private final Map<LeakKey, Pair<FDSParseRecord, UnitDouble>> d_leaks = new HashMap<LeakKey, Pair<FDSParseRecord, UnitDouble>>();
    private final List<Zone> d_zoneList = new ArrayList<Zone>();
    private static final String BASE_NAME = Intl.intl("ZONE");

    public Zone get(int index) {
        if (index < 0 || index >= this.d_zoneList.size()) {
            return null;
        }
        return this.d_zoneList.get(index);
    }

    public ZoneParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
        OuterZone outerZone = this.getContainer().getZoneMgr().getOuter();
        this.d_zoneList.add(outerZone);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("ZONE");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitAABox box;
        String baseName = rec.getString("ID");
        if (rec.contains("XB")) {
            UnitPoint3D[] xb = ZoneParser.parseXB(rec, "ZONE", "XB", true);
            box = new UnitAABox(xb[0], xb[1]);
        } else {
            AABox bb = new AABox();
            for (PyroMod container : this.getParsingInfo().getSourceContainers()) {
                for (Grid grid : container.getGridManager().flatten()) {
                    grid.getGeom().getBoundingBox(bb);
                }
            }
            box = new UnitAABox(bb, Geometry.GEOM_LENGTH_UNIT);
        }
        Zone zone = new Zone(baseName, box);
        List leaks = rec.getList("LEAK_AREA", false);
        if (leaks != null) {
            for (int m = 0; m < leaks.size(); ++m) {
                LeakKey leakKey;
                Pair<FDSParseRecord, UnitDouble> existingLeakArea;
                UnitDouble leakArea = (UnitDouble)leaks.get(m);
                if (leakArea == null || leakArea.getValueNoUnit() == 0.0) continue;
                if (m == this.d_zoneList.size()) {
                    this.addWarning(rec, Intl.intl("Leak area specified with own ZONE."), Intl.intl("Ignoring leak area."));
                    continue;
                }
                if (leakArea.getValueNoUnit() < 0.0) {
                    this.addWarning(rec, Intl.intl("Negative leak area specified for ZONE record."), Intl.intl("Made leak area positive."));
                    leakArea = leakArea.abs();
                }
                if ((existingLeakArea = this.d_leaks.get(leakKey = new LeakKey(this.d_zoneList.size(), m))) != null) {
                    if (((UnitDouble)existingLeakArea.v2).equals(leakArea)) continue;
                    this.addWarning(rec, String.format(Intl.intl("Leak area between ZONES %d and %d already specified with a different area."), m, this.d_zoneList.size()), Intl.intl("Ignoring second leak area definition."));
                    continue;
                }
                this.d_leaks.put(leakKey, new Pair<FDSParseRecord, UnitDouble>(rec, leakArea));
            }
        }
        this.d_zoneList.add(zone);
        return true;
    }

    private void checkZoneIx(FDSParseRecord rec, int ix) throws FDSRecordFormatException {
        if (ix < 0 || ix >= this.d_zoneList.size()) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("Leak area specified for an invalid ZONE index: %d."), ix));
        }
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        for (Map.Entry<LeakKey, Pair<FDSParseRecord, UnitDouble>> entry : this.d_leaks.entrySet()) {
            LeakKey lk = entry.getKey();
            Pair<FDSParseRecord, UnitDouble> pair = entry.getValue();
            this.checkZoneIx((FDSParseRecord)pair.v1, lk.ix1);
            this.checkZoneIx((FDSParseRecord)pair.v1, lk.ix2);
        }
        int maxzoneix = this.d_zoneList.size() - 1;
        int numspaces = Integer.toString(maxzoneix).length();
        ZoneMgr mgr = this.getContainer().getZoneMgr();
        for (int m = 1; m < this.d_zoneList.size(); ++m) {
            Zone zone = this.d_zoneList.get(m);
            if (zone.getName() == null) {
                String ixformat = String.format("%0" + numspaces + "d", m);
                zone.setName(BASE_NAME + ixformat);
            }
            Util.autoRename(mgr, zone);
            mgr.add(zone);
            this.flagObjectAdded(zone);
        }
        for (Map.Entry<LeakKey, Pair<FDSParseRecord, UnitDouble>> entry : this.d_leaks.entrySet()) {
            LeakKey lk = entry.getKey();
            Pair<FDSParseRecord, UnitDouble> pair = entry.getValue();
            Zone zone1 = this.d_zoneList.get(lk.ix1);
            Zone zone2 = this.d_zoneList.get(lk.ix2);
            Leak leak = new Leak(zone1, zone2, (UnitDouble)pair.v2);
            this.getContainer().getZoneLeakMgr().add(leak);
            this.flagObjectAdded(leak);
        }
    }

    private static class LeakKey {
        private final int ix1;
        private final int ix2;

        public LeakKey(int ix1, int ix2) {
            this.ix1 = ix1;
            this.ix2 = ix2;
        }

        public int hashCode() {
            return this.ix1 + this.ix2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeakKey)) {
                return false;
            }
            LeakKey lk = (LeakKey)obj;
            return this.ix1 == lk.ix1 && this.ix2 == lk.ix2 || this.ix1 == lk.ix2 && this.ix2 == lk.ix1;
        }
    }
}

