/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.Collection;
import javax.vecmath.Matrix4d;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.tasks.TransformTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class MirrorTask
extends TransformTask {
    private final Matrix4d d_xform = new Matrix4d();

    public MirrorTask(PyroMod mediator, Collection<? extends IPyroObject> objects, int n, UnitDouble xPlane, UnitDouble yPlane, UnitDouble zPlane) {
        super(mediator, objects, n);
        this.d_xform.setIdentity();
        if (zPlane != null) {
            this.d_xform.mul(Util.mirrorMat(0.0, 0.0, 1.0, -zPlane.getValue(Geometry.LU)));
        }
        if (yPlane != null) {
            this.d_xform.mul(Util.mirrorMat(0.0, 1.0, 0.0, -yPlane.getValue(Geometry.LU)));
        }
        if (xPlane != null) {
            this.d_xform.mul(Util.mirrorMat(1.0, 0.0, 0.0, -xPlane.getValue(Geometry.LU)));
        }
    }

    @Override
    public Matrix4d getXFormForIteration(int i) {
        return this.d_xform;
    }
}

