/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.ramp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.ramp.IRampInput;
import pyrosim.legacy_2012_1.domain.ramp.SignalInput;
import pyrosim.legacy_2012_1.domain.signals.IDoubleOutPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.unitsystem.UnitSystem;
import pyrosim.legacy_2012_1.util.Util;

public class Ramp
implements Serializable,
Cloneable,
IDirectDependent {
    static final long serialVersionUID = 1L;
    private List<Entry> d_rampRecords;
    private final IRampInput d_defaultInput;
    private IRampInput d_input;
    private final int d_fUnitType;

    public Ramp(Collection<Entry> entries, IRampInput defInput, int fUnitType) {
        this(entries, defInput, defInput, fUnitType);
    }

    public Ramp(Collection<Entry> entries, IRampInput defInput, IRampInput input, int fUnitType) {
        this.d_rampRecords = new ArrayList<Entry>(entries);
        this.d_defaultInput = defInput;
        this.d_input = input;
        this.d_fUnitType = fUnitType;
    }

    public int getTUnitType() {
        return this.d_input.getUnitType();
    }

    public IRampInput getDefaultInput() {
        return this.d_defaultInput;
    }

    public IRampInput getInput() {
        return this.d_input;
    }

    public int getFUnitType() {
        return this.d_fUnitType;
    }

    public Object clone() throws CloneNotSupportedException {
        Ramp r = (Ramp)super.clone();
        r.d_rampRecords = new ArrayList<Entry>(this.d_rampRecords.size());
        for (Entry e : this.d_rampRecords) {
            r.d_rampRecords.add((Entry)e.clone());
        }
        return r;
    }

    public Task taskSetInput(IRampInput newInput) {
        return new ReplaceInputTask(newInput);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Ramp)) {
            return false;
        }
        Ramp r = (Ramp)o;
        return this.d_rampRecords.equals(r.d_rampRecords) && this.d_defaultInput.equals(r.d_defaultInput) && this.d_input.equals(r.d_input) && this.d_fUnitType == r.d_fUnitType;
    }

    public int hashCode() {
        return this.d_rampRecords.hashCode() + this.d_defaultInput.hashCode() + this.d_input.hashCode() + this.d_fUnitType;
    }

    public List<Entry> getRecords() {
        return this.d_rampRecords;
    }

    public boolean isEmpty() {
        return this.d_rampRecords.isEmpty();
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        if (this.d_input instanceof SignalInput) {
            SignalInput si = (SignalInput)this.d_input;
            deps.add(DLink.WEAK, (IPyroObject)si.input.getAttachedSource());
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        assert (this.d_input instanceof SignalInput);
        IDoubleOutPin oldPin = ((SignalInput)this.d_input).input;
        Util.removeAllNotOfType(objs, ISignalSource.class);
        Iterator<T> it = objs.iterator();
        while (it.hasNext()) {
            IDoubleOutPin replPin;
            ISignalSource src = (ISignalSource)it.next();
            if (src == null || (replPin = this.getReplacementPin(oldPin, src)) != null) continue;
            it.remove();
        }
    }

    private IDoubleOutPin getReplacementPin(IDoubleOutPin oldPin, ISignalSource src) {
        IDoubleOutPin firstDPin = null;
        for (IOutPin iOutPin : src.getOutputPins()) {
            if (!(iOutPin instanceof IDoubleOutPin)) continue;
            if (firstDPin == null) {
                firstDPin = (IDoubleOutPin)iOutPin;
            }
            if (!iOutPin.getName().equals(oldPin.getName())) continue;
            return (IDoubleOutPin)iOutPin;
        }
        return firstDPin;
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        assert ((replacement == null || replacement instanceof ISignalSource) && this.d_input instanceof SignalInput);
        SignalInput oldInput = (SignalInput)this.d_input;
        ISignalSource newSrc = (ISignalSource)replacement;
        if (newSrc == null) {
            return new ReplaceInputTask(this.getDefaultInput());
        }
        IDoubleOutPin newPin = this.getReplacementPin(oldInput.input, newSrc);
        assert (newPin != null);
        SignalInput newInput = new SignalInput(newPin);
        return new ReplaceInputTask(newInput);
    }

    private class ReplaceInputTask
    extends AUndoableTask {
        private final IRampInput d_replacement;
        private List<Entry> d_oldVals;
        private IRampInput d_oldInput;

        public ReplaceInputTask(IRampInput replacement) {
            this.d_replacement = replacement;
        }

        @Override
        public void run() {
            Unit u2;
            this.d_oldInput = Ramp.this.d_input;
            SIUS us = SIUS.getInstance();
            Unit u1 = ((Entry)((Ramp)Ramp.this).d_rampRecords.get((int)0)).t.getUnit();
            if (!UnitDouble.areCompatible(u1, u2 = ((UnitSystem)us).getUnit(this.d_replacement.getUnitType()))) {
                this.d_oldVals = Ramp.this.d_rampRecords;
                ArrayList<Entry> newRecs = new ArrayList<Entry>(Ramp.this.d_rampRecords.size());
                for (Entry oldEntry : Ramp.this.d_rampRecords) {
                    UnitDouble newT = oldEntry.t.reinterpret(u2);
                    newRecs.add(new Entry(newT, oldEntry.f));
                }
                Ramp.this.d_rampRecords = newRecs;
            } else {
                this.d_oldVals = null;
            }
            Ramp.this.d_input = this.d_replacement;
        }

        @Override
        public void undo() {
            Ramp.this.d_input = this.d_oldInput;
            if (this.d_oldVals != null) {
                Ramp.this.d_rampRecords = this.d_oldVals;
            }
        }
    }

    public static class Entry
    implements Serializable,
    Cloneable {
        static final long serialVersionUID = 1L;
        public final UnitDouble t;
        public final UnitDouble f;

        public Entry(UnitDouble t, UnitDouble f) {
            this.t = t;
            this.f = f;
        }

        public Object clone() {
            return new Entry(this.t, this.f);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)obj;
            return this.t.equals(e.t) && this.f.equals(e.f);
        }

        public int hashCode() {
            return this.t.hashCode() + this.f.hashCode();
        }
    }
}

