/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.surf.PredefSurf;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.geom.AFDSObject;
import pyrosim.legacy_2012_1.domain.geom.FDSUtil;
import pyrosim.legacy_2012_1.domain.geom.IHole;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.domain.rasterization.FaceProps;
import pyrosim.legacy_2012_1.domain.rasterization.IFDSObjProps;
import pyrosim.legacy_2012_1.domain.rasterization.IFragGenerator;
import pyrosim.legacy_2012_1.domain.rasterization.ObstFragGenerator;
import pyrosim.legacy_2012_1.domain.rasterization.RasterizationOptions;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.geom.IGeomSource;
import pyrosim.legacy_2012_1.geom.IPyroDisplayProps;
import pyrosim.legacy_2012_1.geom.TexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.BooleanOp;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.EdgeUse;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Face;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.FaceLoop;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Model;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.FlattenedProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.ITexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.UniformProps;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.util.LWArray;
import pyrosim.legacy_2012_1.util.Util;

public class Obstruction
extends AFDSObject
implements IObstruction {
    static final long serialVersionUID = 1L;
    private static final int DEF_FLAGS = -2147483556;
    private IGeom d_geom;
    private Object d_surfaces;
    private TexOrigin d_texOrigin;
    private UnitDouble d_bulkDensity;
    private static final IObjectFilter<Surface> s_surfFilter = new IObjectFilter<Surface>(){

        @Override
        public boolean shouldFilter(Surface surf) {
            return surf.getName().equals(PredefSurf.OPEN.name()) || surf.getName().equals(PredefSurf.MIRROR.name()) || surf.getName().equals(PredefSurf.HVAC.name());
        }
    };

    public Obstruction(String name, IGeom geom, Surface[] surfs) {
        super(name);
        this.d_geom = Geometry.finalize(geom, true);
        this.d_surfaces = LWArray.newArray(surfs);
        this.d_texOrigin = TexOrigin.defaultWorld();
        this.d_bulkDensity = null;
        this.setOptions(92, true);
    }

    @Override
    public Object clone() {
        Obstruction clone = (Obstruction)super.clone();
        Surface[] surfs = this.getSurfaces();
        clone.d_surfaces = LWArray.newArray(surfs);
        return clone;
    }

    @Override
    public UnitDouble getBulkDensity() {
        return this.d_bulkDensity;
    }

    @Override
    public void setBulkDensity(UnitDouble dens) {
        if (theUtil.equal(dens, this.d_bulkDensity)) {
            return;
        }
        this.d_bulkDensity = dens;
        this.changedEvt(new Object[0]);
    }

    private static int filterOptions(int options) {
        return options & 0x7F;
    }

    @Override
    public void setOptions(int options, boolean set) {
        this.setFlags(Obstruction.filterOptions(options), set, new Object[0]);
    }

    @Override
    public boolean getOptions(int options) {
        return this.testFlags(Obstruction.filterOptions(options));
    }

    @Override
    public int getSetOptions() {
        return Obstruction.filterOptions(super.getSetFlags());
    }

    @Override
    public TexOrigin getTextureOrigin() {
        return this.d_texOrigin;
    }

    @Override
    public void setTextureOrigin(TexOrigin origin) {
        if (this.d_texOrigin.equals(origin)) {
            return;
        }
        this.d_texOrigin = origin;
        this.changedEvt(new Object[0]);
    }

    @Override
    public int getNumFaces() {
        return this.getGeom().getNumPrims(1);
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return new FragGen();
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        IPyroDisplayProps pyroProps = drawProps instanceof IPyroDisplayProps ? (IPyroDisplayProps)drawProps : null;
        DisplayGeom disp = FDSUtil.getRastDisplay(pyroProps, this, this.getTextureOrigin());
        if (disp != null) {
            return disp;
        }
        disp = this.constructBaseGeom(pyroProps);
        if (this.getOptions(32)) {
            disp = GeomUtil.convertToOutline(disp);
        }
        return disp;
    }

    private DisplayGeom constructBaseGeom(IPyroDisplayProps drawProps) {
        Collection<? extends IGeomSource> nearGeom;
        IPropsSrc obstProps = this.getDisplayProps();
        TexCoordGenerator texGen = new TexCoordGenerator(this.d_geom, this.d_texOrigin);
        PyroMod domain = (PyroMod)this.getDomain();
        if (domain != null && this.getOptions(4) && (drawProps == null || drawProps.getCutHoles()) && !(nearGeom = domain.getGeomProx().getNearObjs(this)).isEmpty()) {
            IPrimProps holeProps;
            List<IGeom> obstGeoms = pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.flatten(this.d_geom);
            if (obstProps instanceof UniformProps) {
                holeProps = obstProps.get(0);
            } else {
                Surface inert = (Surface)domain.getSurfaceMgr().get(PredefSurf.INERT.name());
                holeProps = new IPrimProps.Face(null, inert, false);
            }
            ArrayList<IGeom> holeGeoms = new ArrayList<IGeom>(nearGeom.size());
            for (IGeomSource iGeomSource : nearGeom) {
                if (!(iGeomSource instanceof IHole)) continue;
                pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.flatten(((IHole)iGeomSource).getGeom(), holeGeoms);
            }
            DisplayGeom dispGeom = Obstruction.subtractHoles(texGen, obstGeoms, obstProps, holeGeoms, holeProps);
            if (dispGeom != null) {
                return dispGeom;
            }
        }
        return new DisplayGeom(this.d_geom, (ITexCoordGenerator)texGen, obstProps);
    }

    private static void toModels(IGeom geom, Map<IPrimProps, Integer> propIdMap, IPropsSrc props, int propOffset, List<Pair<Model, Boolean>> models) {
        if (geom instanceof GeomGroup) {
            GeomGroup group = (GeomGroup)geom;
            for (IGeom child : group.children) {
                Obstruction.toModels(child, propIdMap, props, propOffset, models);
                propOffset += child.getNumPrims(1);
            }
        } else {
            Model model = Obstruction.toModel(geom, propIdMap, props, propOffset);
            models.add(new Pair<Model, Boolean>(model, !geom.isShell()));
        }
    }

    private static Model toModel(IGeom geom, Map<IPrimProps, Integer> propIdMap, IPropsSrc props, int propOffset) {
        Model model = new Model();
        List faces = pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.explode(geom, IFace.class);
        for (int m = 0; m < faces.size(); ++m) {
            IFace face = (IFace)faces.get(m);
            IPrimProps prop = props.get(propOffset + m);
            Integer id = propIdMap.get(prop);
            if (id == null) {
                id = propIdMap.size();
                propIdMap.put(prop, id);
            }
            List<IPolygon> polys = GeomUtil.toPolys(face, 0.1, true);
            for (IPolygon poly : polys) {
                Point3d[] polyPoints = PolyUtil.getAllVerts(poly, false);
                model.addPolygonFace(id, PolyUtil.getPlane(poly), polyPoints);
            }
        }
        return model;
    }

    private static DisplayGeom subtractHoles(ITexCoordGenerator texGen, List<IGeom> obstGeoms, IPropsSrc obstProps, List<IGeom> holeGeoms, IPrimProps holeProps) {
        ArrayList<IPrimProps> resultProps = new ArrayList<IPrimProps>();
        ArrayList<IGeom> resultGeoms = new ArrayList<IGeom>();
        int propOffset = 0;
        for (IGeom obstGeom : obstGeoms) {
            Obstruction.subtractHoles(obstGeom, holeGeoms, obstProps, propOffset, holeProps, resultGeoms, resultProps);
            propOffset += obstGeom.getNumPrims(1);
        }
        GeomGroup resultGeom = new GeomGroup(resultGeoms);
        return new DisplayGeom((IGeom)resultGeom, texGen, resultProps.toArray(new IPrimProps[resultProps.size()]));
    }

    /*
     * WARNING - void declaration
     */
    private static void subtractHoles(IGeom obstGeom, List<IGeom> holeGeoms, IPropsSrc obstProps, int obstPropOffset, IPrimProps holeProps, List<IGeom> resultGeoms, List<IPrimProps> resultProps) {
        HashMap<IPrimProps, Integer> propIdMap = new HashMap<IPrimProps, Integer>();
        boolean modified = false;
        Model obstModel = null;
        AABox obstbb = obstGeom.getBoundingBox(new AABox());
        for (IGeom iGeom : holeGeoms) {
            boolean holeSolid;
            Model holeModel;
            boolean obstSolid;
            Model newModel;
            Containment containment = obstbb.test(iGeom.getBoundingBox(new AABox()));
            if (containment == Containment.OUTSIDE) continue;
            if (obstModel == null) {
                obstModel = Obstruction.toModel(obstGeom, propIdMap, obstProps, obstPropOffset);
            }
            if ((newModel = BooleanOp.subtract(obstModel, obstSolid = !obstGeom.isShell() && obstModel.getFaces().size() >= 4, holeModel = Obstruction.toModel(iGeom, propIdMap, new UniformProps(holeProps), 0), holeSolid = !iGeom.isShell() && holeModel.getFaces().size() >= 4)) == obstModel || newModel == null) continue;
            obstModel = newModel;
            obstbb = obstModel.getBoundingBox();
            modified = true;
        }
        if (modified) {
            assert (obstModel != null);
            IPrimProps[] props = new IPrimProps[propIdMap.size()];
            for (Map.Entry entry : propIdMap.entrySet()) {
                IPrimProps prop = (IPrimProps)entry.getKey();
                if (prop.getCullFace()) {
                    prop = new IPrimProps.Face(prop.getColor(), prop.getMaterial(), false);
                }
                props[((Integer)entry.getValue()).intValue()] = prop;
            }
            for (Face face : obstModel.getFaces()) {
                Point3d[][] verts = new Point3d[face.edgeLoops.size()][];
                for (int m = 0; m < face.edgeLoops.size(); ++m) {
                    FaceLoop loop = face.edgeLoops.get(m);
                    Point3d[] loopVerts = new Point3d[loop.edges.size()];
                    for (int n = 0; n < loop.edges.size(); ++n) {
                        EdgeUse eu = loop.edges.get(n);
                        loopVerts[n] = eu.v1().loc;
                    }
                    verts[m] = loopVerts;
                }
                int groupid = face.groups[0];
                IPrimProps prop = props[groupid];
                resultProps.add(prop);
                resultGeoms.add(PolyUtil.newPoly(verts));
            }
        } else {
            void var12_17;
            resultGeoms.add(obstGeom);
            int numFaces = obstGeom.getNumPrims(1);
            boolean bl = false;
            while (var12_17 < numFaces) {
                resultProps.add(obstProps.get((int)(var12_17 + obstPropOffset)));
                ++var12_17;
            }
        }
    }

    @Override
    public IGeom getGeom() {
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeom geom, boolean optimizeGeom) {
        if (this.d_geom == (geom = Geometry.finalize(geom, optimizeGeom))) {
            return;
        }
        assert (geom.getNumPrims(6) == 0) : "Geometry assigned to an obstruction should contain only faces.";
        this.d_geom = geom;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void setSurfaces(Surface[] surfs) {
        assert (surfs.length == 1 || surfs.length == this.d_geom.getNumPrims(1));
        this.d_surfaces = LWArray.newArray(surfs);
        this.changedEvt(new Object[0]);
    }

    @Override
    public Surface[] getSurfaces() {
        return LWArray.toArray(this.d_surfaces, Surface.class);
    }

    public IPropsSrc getDisplayProps() {
        Surface[] surfs = this.getSurfaces();
        Color[] colors = this.getColors();
        boolean cullGeom = GeomUtil.isCullGeom(this.d_geom);
        if (surfs.length == 1 && colors.length == 1) {
            IPrimProps.Face prop = new IPrimProps.Face(colors[0], surfs[0], cullGeom);
            return new UniformProps(prop);
        }
        int numProps = Math.max(surfs.length, colors.length);
        IPrimProps[] props = new IPrimProps[numProps];
        for (int m = 0; m < numProps; ++m) {
            Surface surf = surfs.length == 1 ? surfs[0] : surfs[m];
            Color color = colors.length == 1 ? colors[0] : colors[m];
            props[m] = new IPrimProps.Face(color, surf, cullGeom);
        }
        return new FlattenedProps(props);
    }

    @Override
    public IObjectFilter<Surface> getSurfFilter() {
        return s_surfFilter;
    }

    public static IObjectFilter<Surface> getSurfaceFilter() {
        return s_surfFilter;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        IPyroObject[] surfs = this.getSurfaces();
        deps.add(DLink.REQUIRED, surfs);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof Surface) {
            Util.removeAllNotOfType(objs, Surface.class);
        } else {
            super.removeInvalidReplacements(old, objs);
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
        if (!(old instanceof Surface)) {
            return super.taskReplaceDep(old, replacement);
        }
        return new AUndoableTask(){
            private int[] d_ixes = null;

            @Override
            public void undo() {
                this.setCurrentSurface((Surface)old);
                this.d_ixes = null;
            }

            @Override
            public void run() {
                if (this.d_ixes == null) {
                    ArrayList<Integer> ixes = new ArrayList<Integer>();
                    Surface[] surfs = Obstruction.this.getSurfaces();
                    for (int m = 0; m < surfs.length; ++m) {
                        if (surfs[m] != old) continue;
                        ixes.add(m);
                    }
                    this.d_ixes = theUtil.toIntArray(ixes);
                }
                this.setCurrentSurface((Surface)replacement);
            }

            private void setCurrentSurface(Surface surf) {
                Surface[] surfs = Obstruction.this.getSurfaces();
                Surface[] newSurfs = (Surface[])surfs.clone();
                for (int m = 0; m < this.d_ixes.length; ++m) {
                    newSurfs[this.d_ixes[m]] = surf;
                }
                Obstruction.this.setSurfaces(newSurfs);
            }
        };
    }

    private class FragGen
    implements IFDSObjProps {
        @Override
        public IFragGenerator getFragGenerator(RasterizationOptions rastOptions) {
            return new ObstFragGenerator(Obstruction.this, rastOptions);
        }

        @Override
        public FaceProps getFace(int ix) {
            Surface[] surfs = Obstruction.this.getSurfaces();
            Surface surf = surfs.length > 1 ? surfs[ix] : surfs[0];
            Color[] colors = Obstruction.this.getColors();
            Color color = colors.length == 1 ? colors[0] : colors[ix];
            return new FaceProps(surf, color);
        }

        @Override
        public boolean thickenEnabled() {
            return Obstruction.this.getOptions(1);
        }
    }
}

