/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.awt.Color;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.geom.AFDSObject;
import pyrosim.legacy_2012_1.domain.rasterization.IFDSObjProps;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BlockGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class InitRegion
extends AFDSObject
implements IDirectDependent {
    static final long serialVersionUID = 1L;
    private static final int ALPHA = 51;
    private static final Color DEF_COLOR = new Color(0.3f, 0.7f, 0.9f, 0.2f);
    private AABoxGeom d_geom;
    private UnitDouble d_density;
    private UnitDouble d_temperature;
    private Map<ExSpec, UnitDouble> d_specMassFrac;
    public static final Composite.IObjectProp densityProp = new Composite.AObjectProp<InitRegion, UnitDouble>(InitRegion.class){

        @Override
        public void set(InitRegion obj, UnitDouble prop) {
            obj.setDensity(prop);
        }

        @Override
        public Object get(InitRegion obj) {
            return obj.getDensity();
        }
    };
    public static final Composite.IObjectProp tempProp = new Composite.AObjectProp<InitRegion, UnitDouble>(InitRegion.class){

        @Override
        public void set(InitRegion obj, UnitDouble prop) {
            obj.setTemperature(prop);
        }

        @Override
        public Object get(InitRegion obj) {
            return obj.getTemperature();
        }
    };

    public InitRegion() {
        this(Intl.intl("Init Region"), new AABoxGeom(GeomConstants.PNT3D_ORIGIN, GeomConstants.PNT3D_ORIGIN, 0));
    }

    public InitRegion(String name, AABoxGeom geom) {
        super(name);
        this.d_geom = geom.optimize(Geometry.P3D_POOL);
        this.d_density = null;
        this.d_temperature = null;
        this.d_specMassFrac = Collections.EMPTY_MAP;
    }

    @Override
    public Object clone() {
        InitRegion init = (InitRegion)super.clone();
        if (init.d_specMassFrac != Collections.EMPTY_MAP) {
            init.d_specMassFrac = new IdentityHashMap<ExSpec, UnitDouble>(init.d_specMassFrac);
        }
        return init;
    }

    @Override
    public void setColors(Color ... c) {
    }

    @Override
    public Color[] getColors() {
        return new Color[]{DEF_COLOR};
    }

    public UnitDouble getDensity() {
        return this.d_density;
    }

    public void setDensity(UnitDouble density) {
        this.d_density = density;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getTemperature() {
        return this.d_temperature;
    }

    public void setTemperature(UnitDouble temp) {
        this.d_temperature = temp;
        this.changedEvt(new Object[0]);
    }

    public Map<ExSpec, UnitDouble> getExtraSpecies() {
        return Collections.unmodifiableMap(this.d_specMassFrac);
    }

    public void setExtraSpecies(Map<ExSpec, UnitDouble> specs) {
        this.d_specMassFrac = specs.isEmpty() ? Collections.EMPTY_MAP : specs;
        this.changedEvt(new Object[0]);
    }

    public void setSpecMF(ExSpec spec, UnitDouble value) {
        if (value == null || value.getValueNoUnit() == 0.0) {
            if (this.d_specMassFrac.containsKey(spec)) {
                this.d_specMassFrac.remove(spec);
                if (this.d_specMassFrac.isEmpty()) {
                    this.d_specMassFrac = Collections.EMPTY_MAP;
                }
                this.changedEvt(new Object[0]);
            }
        } else {
            if (this.d_specMassFrac == Collections.EMPTY_MAP) {
                this.d_specMassFrac = new IdentityHashMap<ExSpec, UnitDouble>();
            }
            this.d_specMassFrac.put(spec, value);
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return null;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        deps.add(DLink.WEAK, this.d_specMassFrac.keySet());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof ExSpec) {
            Util.removeAllNotOfType(objs, ExSpec.class);
        } else {
            super.removeInvalidReplacements(old, objs);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (!(old instanceof ExSpec)) {
            return super.taskReplaceDep(old, replacement);
        }
        final ExSpec specOld = (ExSpec)old;
        final ExSpec specRepl = (ExSpec)replacement;
        return new AUndoableTask(){
            private UnitDouble d_oldVal;
            private UnitDouble d_replVal;

            @Override
            public void run() {
                assert (InitRegion.this.d_specMassFrac.containsKey(specOld));
                this.d_oldVal = (UnitDouble)InitRegion.this.d_specMassFrac.remove(specOld);
                if (specRepl != null) {
                    if (InitRegion.this.d_specMassFrac.containsKey(specRepl)) {
                        this.d_replVal = (UnitDouble)InitRegion.this.d_specMassFrac.get(specRepl);
                        InitRegion.this.d_specMassFrac.put(specRepl, this.d_replVal.add(this.d_oldVal));
                    } else {
                        this.d_replVal = null;
                        InitRegion.this.d_specMassFrac.put(specRepl, this.d_oldVal);
                    }
                } else if (InitRegion.this.d_specMassFrac.isEmpty()) {
                    InitRegion.this.d_specMassFrac = Collections.EMPTY_MAP;
                }
                InitRegion.this.changedEvt(new Object[0]);
            }

            @Override
            public void undo() {
                if (InitRegion.this.d_specMassFrac == Collections.EMPTY_MAP) {
                    InitRegion.this.d_specMassFrac = new IdentityHashMap();
                }
                InitRegion.this.d_specMassFrac.put(specOld, this.d_oldVal);
                if (specRepl != null) {
                    if (this.d_replVal == null) {
                        InitRegion.this.d_specMassFrac.remove(specRepl);
                    } else {
                        InitRegion.this.d_specMassFrac.put(specRepl, this.d_replVal);
                    }
                }
                InitRegion.this.changedEvt(new Object[0]);
            }
        };
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        Color[] colors = this.getColors();
        return new DisplayGeom((IGeom)this.getGeom(), (IPrimProps)new IPrimProps.Face(colors[0], null, true));
    }

    @Override
    public AABoxGeom getGeom() {
        return this.d_geom instanceof BlockGeom ? this.d_geom : new BlockGeom(this.d_geom.min, this.d_geom.max, 0);
    }

    @Override
    public void setGeom(IGeom geom, boolean optimizeGeom) {
        if ((geom = Geometry.finalize(geom, optimizeGeom)) instanceof AABoxGeom) {
            this.d_geom = (AABoxGeom)geom;
            this.changedEvt(new Object[0]);
        }
    }

    public static class SpecMFProp
    extends Composite.AObjectProp<InitRegion, UnitDouble> {
        public ExSpec currSpec;

        public SpecMFProp() {
            super(InitRegion.class);
        }

        @Override
        public void set(InitRegion obj, UnitDouble prop) {
            obj.setSpecMF(this.currSpec, prop);
        }

        @Override
        public Object get(InitRegion obj) {
            UnitDouble val = (UnitDouble)obj.d_specMassFrac.get(this.currSpec);
            return val == null ? SIUS.newud(0.0, 18) : val;
        }
    }
}

