/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import pyrosim.legacy_2012_1.domain.TimeBasedValue;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.io.PyroSimObjectInputStream;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class HeatRelease
implements Serializable {
    static final long serialVersionUID = 1L;
    public final Type d_type;
    public final UnitDouble d_extingCoeff;

    public HeatRelease() {
        this(new HRRType(), new UnitDouble(0.0, SIUS.unit(21)));
    }

    public HeatRelease(Type type, UnitDouble extingCoeff) {
        this.d_type = type;
        this.d_extingCoeff = extingCoeff;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (stream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)stream).getVersion() < 34) {
            double val = this.d_extingCoeff.getValueNoUnit();
            UnitDouble ecNew = new UnitDouble(val, SIUS.unit(21));
            try {
                Util.assignFinalField(this, "d_extingCoeff", ecNew);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public boolean invokesMixFrac() {
        return this.d_type.invokesMixFrac();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HeatRelease)) {
            return false;
        }
        HeatRelease hr = (HeatRelease)obj;
        return this.d_type.equals(hr.d_type) && this.d_extingCoeff.equals(hr.d_extingCoeff);
    }

    public static class MLRType
    extends Type {
        static final long serialVersionUID = 6552285593797687956L;

        public MLRType() {
            this(new UnitDouble(0.0, SIUS.unit(44)), TimeFunction.newDefault());
        }

        public MLRType(UnitDouble value, TimeFunction func) {
            super(value, func);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof MLRType && super.equals(obj);
        }

        @Override
        public boolean invokesMixFrac() {
            return ((UnitDouble)this.val).getValueNoUnit() > 0.0;
        }
    }

    public static class HRRType
    extends Type {
        static final long serialVersionUID = -2937414973907714621L;

        public HRRType() {
            this(new UnitDouble(500.0, SIUS.unit(22)), TimeFunction.newDefault());
        }

        public HRRType(UnitDouble value, TimeFunction func) {
            super(value, func);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof HRRType && super.equals(obj);
        }

        @Override
        public boolean invokesMixFrac() {
            return ((UnitDouble)this.val).getValueNoUnit() > 0.0;
        }
    }

    public static abstract class Type
    extends TimeBasedValue<UnitDouble> {
        static final long serialVersionUID = 1L;

        public Type(UnitDouble value, TimeFunction func) {
            super(value, func);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Type && super.equals(obj);
        }

        public abstract boolean invokesMixFrac();
    }
}

