/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSeg3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Edge;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.EdgeUse;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Face;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.FaceLoop;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Model;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.NmtUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;

public class GridMergeUtil {
    public static final int GRIDFACE_MINX = 0;
    public static final int GRIDFACE_MAXX = 1;
    public static final int GRIDFACE_MINY = 2;
    public static final int GRIDFACE_MAXY = 3;
    public static final int GRIDFACE_MINZ = 4;
    public static final int GRIDFACE_MAXZ = 5;
    private static final int VENT_GROUPID = Integer.MAX_VALUE;

    public static MergeResult mergeGrids(Collection<? extends Grid> grids, Collection<? extends IPyroGeomSrc> vents) {
        ArrayList<Grid> gridsList = new ArrayList<Grid>(grids);
        ArrayList<AABox> boxes = new ArrayList<AABox>(grids.size());
        for (int m = 0; m < grids.size(); ++m) {
            Grid g = (Grid)gridsList.get(m);
            boxes.add(new AABox(g.getMinPoint().getPoint3dValue(Geometry.LU), g.getMaxPoint().getPoint3dValue(Geometry.LU)));
        }
        Model model = GridMergeUtil.mergeBoxes(boxes, vents);
        return new MergeResult(model, GridMergeUtil.getGridBoundary(gridsList, model));
    }

    public static Model mergeBoxes(List<AABox> gridBBs, Collection<? extends IPyroGeomSrc> vents) {
        Model mergeModel = null;
        ArrayList<Face> delFaces = new ArrayList<Face>();
        for (int m = 0; m < gridBBs.size(); ++m) {
            Model model2 = GridMergeUtil.modelFromGrid(gridBBs.get(m), m);
            if (m == 0) {
                mergeModel = model2;
                continue;
            }
            Model model1 = (Model)mergeModel.clone();
            mergeModel.merge(model2);
            delFaces.clear();
            for (Face face : mergeModel.getFaces()) {
                if (!GridMergeUtil.isMergeDeleteFace(model1, model2, m, mergeModel, face)) continue;
                delFaces.add(face);
            }
            for (Face delFace : delFaces) {
                mergeModel.deleteFace(delFace, true, true);
            }
        }
        if (mergeModel != null) {
            GridMergeUtil.deleteVents(mergeModel, vents);
        }
        if (mergeModel == null) {
            mergeModel = new Model();
        }
        return mergeModel;
    }

    private static void deleteVents(Model model, Collection<? extends IPyroGeomSrc> vents) {
        for (IPyroGeomSrc iPyroGeomSrc : vents) {
            List<IFace> faces = pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.explode(iPyroGeomSrc.getGeom(), IFace.class);
            for (IFace face : faces) {
                List<IPolygon> polys = GeomUtil.toPolys(face, 0.1, true);
                for (IPolygon poly : polys) {
                    Point3d[] verts = PolyUtil.getAllVerts(poly, false);
                    model.addPolygonFace(Integer.MAX_VALUE, PolyUtil.getPlane(poly), verts);
                }
            }
        }
        ArrayList<Face> delFaces = new ArrayList<Face>(vents.size());
        for (Face face : model.getFaces()) {
            if (!face.partOfGroup(Integer.MAX_VALUE)) continue;
            delFaces.add(face);
        }
        for (Face delFace : delFaces) {
            model.deleteFace(delFace, false, false);
        }
        for (Face delFace : delFaces) {
            for (FaceLoop loop : delFace.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    if (!eu.edge.faces.isEmpty() || eu.edge.partOfGroup(Integer.MAX_VALUE) && eu.edge.groups.length != 1) continue;
                    model.deleteEdge(eu.edge, true);
                }
            }
        }
    }

    public static int encodeModelId(int gridid, int faceid) {
        assert (faceid < 6 && faceid >= 0);
        assert (gridid < (int)Math.pow(2.0, 29.0) && gridid >= 0);
        int id = faceid << 29;
        return id |= gridid;
    }

    public static int[] extractGridFaceId(int encodedModelId) {
        int gridid = 0x1FFFFFFF & encodedModelId;
        int faceid = encodedModelId >>> 29;
        return new int[]{gridid, faceid};
    }

    private static Model modelFromGrid(AABox grid, int gridid) {
        Model model = new Model();
        int[] faceids = new int[]{0, 1, 2, 3, 4, 5};
        Point3d[][] faces = grid.getFaces();
        assert (faces.length == faceids.length);
        for (int m = 0; m < 6; ++m) {
            Point3d[] face = faces[m];
            Plane3d plane = new Plane3d(face);
            int id = GridMergeUtil.encodeModelId(gridid, faceids[m]);
            model.addPolygonFace(id, plane, face);
        }
        return model;
    }

    private static boolean isMergeDeleteFace(Model model1, Model model2, int mod2Id, Model mergeModel, Face mergeFace) {
        boolean partOfMod1;
        boolean partOfMod2 = false;
        for (int groupid : mergeFace.groups) {
            if (GridMergeUtil.extractGridFaceId(groupid)[0] != mod2Id) continue;
            partOfMod2 = true;
            break;
        }
        boolean bl = partOfMod1 = !partOfMod2 || mergeFace.groups.length > 1;
        if (partOfMod1 && !partOfMod2 && NmtUtil.faceInSolid(model2, mergeModel, mergeFace) || !partOfMod1 && partOfMod2 && NmtUtil.faceInSolid(model1, mergeModel, mergeFace)) {
            return true;
        }
        if (partOfMod2 && partOfMod1) {
            Vector3d normal;
            Point3d pInFace = mergeModel.findPointInFace(mergeFace);
            Point3d testPoint1 = GridMergeUtil.findTestPoint(mergeModel, mergeFace, pInFace, normal = mergeFace.plane.getNormal());
            if (testPoint1 == null) {
                return false;
            }
            normal.negate();
            Point3d testPoint2 = GridMergeUtil.findTestPoint(mergeModel, mergeFace, pInFace, normal);
            if (testPoint2 == null) {
                return false;
            }
            return model1.contains(testPoint1) && model2.contains(testPoint2) || model1.contains(testPoint2) && model2.contains(testPoint1);
        }
        return false;
    }

    private static Point3d findTestPoint(Model model, Face ignoreFace, Point3d raysrc, Vector3d raydir) {
        AABox bb = model.getBoundingBox();
        double extents = bb.getMin().distance(bb.getMax()) * 2.0;
        Vector3d scaledDir = Util3D.scale(raydir, extents);
        Point3d p2 = Util3D.add(raysrc, (Tuple3d)scaledDir);
        LineSeg3D testCurve = new LineSeg3D(raysrc, p2);
        double neart = Double.MAX_VALUE;
        for (Face face : model.getFaces()) {
            double[] isects;
            if (face == ignoreFace || (isects = model.isect(testCurve, face)) == null || isects.length <= 0 || !(isects[0] < neart)) continue;
            neart = isects[0];
        }
        return testCurve.get(neart * 0.5);
    }

    public static List<Face> getGridFaces(Model mergedGrids, int gridid) {
        ArrayList<Face> faces = new ArrayList<Face>();
        block0: for (Face face : mergedGrids.getFaces()) {
            for (int groupid : face.groups) {
                if (GridMergeUtil.extractGridFaceId(groupid)[0] != gridid) continue;
                faces.add(face);
                continue block0;
            }
        }
        return faces;
    }

    public static Map<Grid, BoundaryInfo> getGridBoundary(List<Grid> grids, Model mergedGrids) {
        ArrayList<BoundaryInfo> faces = new ArrayList<BoundaryInfo>();
        for (int m = 0; m < grids.size(); ++m) {
            faces.add(new BoundaryInfo(new ArrayList<Face>(0), new ArrayList<Edge>(0)));
        }
        for (Face face : mergedGrids.getFaces()) {
            for (int groupid : face.groups) {
                int grid = GridMergeUtil.extractGridFaceId(groupid)[0];
                assert (grid >= 0 && grid < grids.size());
                ((BoundaryInfo)faces.get((int)grid)).faces.add(face);
            }
        }
        for (Edge edge : mergedGrids.getEdges()) {
            Plane3d plane2;
            Plane3d plane1;
            boolean isBoundary = true;
            if (!edge.partOfGroup(Integer.MAX_VALUE) && edge.faces.size() == 2 && ((plane1 = edge.faces.get((int)0).plane).epsilonEquals(plane2 = edge.faces.get((int)1).plane, 1.0E-6) || new Plane3d(plane1).negate().epsilonEquals(plane2, 1.0E-6))) {
                isBoundary = false;
            }
            if (!isBoundary) continue;
            for (int groupid : edge.groups) {
                if (groupid == Integer.MAX_VALUE) continue;
                int grid = GridMergeUtil.extractGridFaceId(groupid)[0];
                ((BoundaryInfo)faces.get((int)grid)).boundaryEdges.add(edge);
            }
            Object object = edge.faces.iterator();
            while (object.hasNext()) {
                Face attachedFace = (Face)object.next();
                for (int groupid : attachedFace.groups) {
                    int grid = GridMergeUtil.extractGridFaceId(groupid)[0];
                    ((BoundaryInfo)faces.get((int)grid)).boundaryEdges.add(edge);
                }
            }
        }
        IdentityHashMap<Grid, BoundaryInfo> gridFaces = new IdentityHashMap<Grid, BoundaryInfo>(grids.size());
        for (int m = 0; m < grids.size(); ++m) {
            gridFaces.put(grids.get(m), (BoundaryInfo)faces.get(m));
        }
        return gridFaces;
    }

    public static class BoundaryInfo {
        public final List<Face> faces;
        public final List<Edge> boundaryEdges;

        public BoundaryInfo(List<Face> faces, List<Edge> bedges) {
            this.faces = faces;
            this.boundaryEdges = bedges;
        }
    }

    public static class MergeResult {
        public final Model model;
        public final Map<Grid, BoundaryInfo> faces;

        public MergeResult(Model model, Map<Grid, BoundaryInfo> faces) {
            this.model = model;
            this.faces = faces;
        }
    }
}

