/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import java.util.Observable;
import java.util.Stack;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import thunderheadeng.gui.Application;

public class TaskManager
extends Observable {
    private final Stack<Task> d_undo = new Stack();
    private final Stack<Task> d_redo = new Stack();

    public void clearHistory() {
        this.d_undo.clear();
        this.d_redo.clear();
    }

    public void clearRedoHistory() {
        this.d_redo.clear();
    }

    public void clearUndoHistory() {
        this.d_undo.clear();
    }

    public void exec(Task tsk) {
        this.exec(tsk, false);
    }

    private void exec(Task tsk, boolean isRedo) {
        if (!isRedo) {
            this.d_redo.clear();
        }
        if (tsk.canUndo()) {
            this.d_undo.push(tsk);
        } else {
            this.d_undo.clear();
        }
        switch (tsk.getEst()) {
            case 0: {
                this.runShort(tsk);
                break;
            }
            case 1: {
                this.runMed(tsk);
                break;
            }
            case 2: {
                this.runLong(tsk);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    private void runShort(Task tsk) {
        tsk.run();
    }

    private void runMed(Task tsk) {
        Application.getApp().beginWaitCursor();
        tsk.run();
        Application.getApp().endWaitCursor();
    }

    private void runLong(Task tsk) {
        tsk.run();
    }

    private void undoShort(Task tsk) {
        tsk.undo();
    }

    private void undoMed(Task tsk) {
        Application.getApp().beginWaitCursor();
        tsk.undo();
        Application.getApp().endWaitCursor();
    }

    private void undoLong(Task tsk) {
        tsk.undo();
    }

    public boolean canUndo() {
        return !this.d_undo.empty();
    }

    public void undo() {
        assert (this.canUndo());
        Task tsk = this.d_undo.pop();
        assert (tsk.canUndo());
        this.d_redo.push(tsk);
        switch (tsk.getEst()) {
            case 0: {
                this.undoShort(tsk);
                break;
            }
            case 1: {
                this.undoMed(tsk);
                break;
            }
            case 2: {
                this.undoLong(tsk);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public boolean canRedo() {
        return !this.d_redo.empty();
    }

    public void redo() {
        assert (this.canRedo());
        Task tsk = this.d_redo.pop();
        this.exec(tsk, true);
    }
}

