/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.gui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainListener;

public abstract class Mediator {
    private static final boolean MERGE_EVENTS = true;
    private boolean d_printDebugStatements = System.getProperty("debug") != null;
    private int d_pauseUpdatesCounter = 0;
    private final Stack<List<IDomainEvent>> d_eventStack = new Stack();
    private final HashSet<IDomainListener> d_listeners;
    private boolean d_listening = true;
    private int d_lastListeningPos = 0;
    private static final Stack<ListenerResponse> s_eventResponses = new Stack();
    private static final DecimalFormat s_timeFormat = (DecimalFormat)DecimalFormat.getInstance(Locale.US);

    public Mediator() {
        this.d_eventStack.push(new ArrayList());
        this.d_listeners = new HashSet();
    }

    public boolean isListening() {
        return this.d_listening;
    }

    public void setDebugPrintingEnabled(boolean enabled) {
        this.d_printDebugStatements = enabled;
    }

    public void addListener(IDomainListener listener) {
        this.d_listeners.add(listener);
    }

    public void removeListener(IDomainListener listener) {
        this.d_listeners.remove(listener);
    }

    public Set<IDomainListener> getAllListeners() {
        return new HashSet<IDomainListener>(this.d_listeners);
    }

    public boolean fireDomainEvent(IDomainEvent event) {
        if (!this.d_listening) {
            return false;
        }
        this.d_eventStack.peek().add(event);
        if (this.d_pauseUpdatesCounter > 0) {
            return false;
        }
        this.fireEvents(new Vector<IDomainEvent>((Collection)this.d_eventStack.peek()));
        return true;
    }

    public void pauseUpdates() {
        this.pauseUpdates(true);
    }

    public void pauseUpdates(boolean listenToEvents) {
        ++this.d_pauseUpdatesCounter;
        if (!this.d_listening) {
            return;
        }
        this.d_listening = listenToEvents;
        if (this.d_listening) {
            this.d_eventStack.push(new ArrayList());
            this.d_lastListeningPos = this.d_pauseUpdatesCounter;
        }
    }

    public boolean resumeUpdates(IDomainEvent evt) {
        this.resumeUpdates(false);
        return this.fireDomainEvent(evt);
    }

    public int resumeUpdates() {
        return this.resumeUpdates(true);
    }

    private int resumeUpdates(boolean rememberQueuedEvents) {
        assert (this.d_pauseUpdatesCounter > 0);
        if (this.d_pauseUpdatesCounter > this.d_lastListeningPos) {
            --this.d_pauseUpdatesCounter;
            if (this.d_pauseUpdatesCounter == this.d_lastListeningPos) {
                this.d_listening = true;
            }
            return 0;
        }
        List<IDomainEvent> pausedEvents = this.d_eventStack.pop();
        if (rememberQueuedEvents) {
            List<IDomainEvent> currentEvents = this.d_eventStack.peek();
            currentEvents.addAll(pausedEvents);
        }
        --this.d_pauseUpdatesCounter;
        --this.d_lastListeningPos;
        if (this.d_pauseUpdatesCounter > 0) {
            return pausedEvents.size();
        }
        return this.mergeAndFireEvents();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected List<IDomainEvent> mergeEvents(List<IDomainEvent> events) {
        IDomainEvent[] eventsArr = events.toArray(new IDomainEvent[events.size()]);
        int m = eventsArr.length - 1;
        while (true) {
            block13: {
                IDomainEvent nextEvent;
                block14: {
                    block12: {
                        if (m < 0) break block12;
                        nextEvent = eventsArr[m];
                        if (nextEvent == null) break block13;
                        break block14;
                    }
                    ArrayList<IDomainEvent> mergedEvents = new ArrayList<IDomainEvent>();
                    IDomainEvent[] iDomainEventArray = eventsArr;
                    int n = iDomainEventArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return mergedEvents;
                        }
                        IDomainEvent evt = iDomainEventArray[n2];
                        if (evt != null) {
                            mergedEvents.add(evt);
                        }
                        ++n2;
                    }
                }
                block9: for (int n = m - 1; n >= 0; --n) {
                    IDomainEvent currentEvent = eventsArr[n];
                    if (currentEvent == null) continue;
                    IDomainEvent.MergeResult result = currentEvent.merge(nextEvent);
                    switch (result.Action) {
                        case 0: {
                            eventsArr[m] = null;
                            break;
                        }
                        case 1: {
                            eventsArr[n] = null;
                            break;
                        }
                        case 3: {
                            eventsArr[n] = null;
                            eventsArr[m] = null;
                            break;
                        }
                        case 4: {
                            eventsArr[n] = result.Replacement;
                            eventsArr[m] = null;
                            break;
                        }
                        case 2: {
                            continue block9;
                        }
                    }
                    if (eventsArr[m] == null) break;
                }
            }
            --m;
        }
    }

    private int mergeAndFireEvents() {
        assert (this.d_pauseUpdatesCounter == 0);
        assert (this.d_eventStack.size() == 1);
        List<IDomainEvent> events = this.d_eventStack.peek();
        if (events.size() == 0) {
            return 0;
        }
        long timeMergeStarted = System.nanoTime();
        if (System.getProperty("debug") != null) {
            System.out.println("Merging events");
        }
        List<IDomainEvent> mergedEvents = this.mergeEvents(events);
        if (System.getProperty("debug") != null) {
            long timeMergeEnded = System.nanoTime();
            double timeElapsed = (double)(timeMergeEnded - timeMergeStarted) * 1.0E-9;
            System.out.println("Done merging events: " + s_timeFormat.format(timeElapsed) + " s");
        }
        this.fireEvents(mergedEvents);
        return mergedEvents.size();
    }

    protected void fireEvents(List<IDomainEvent> events) {
        this.d_eventStack.peek().clear();
        if (events.size() == 0) {
            return;
        }
        this.debugPrintDispatchedEvents(events);
        for (IDomainListener listener : this.d_listeners) {
            listener.domainChanged(events, this);
        }
        for (IDomainEvent evt : events) {
            evt.eventDispatched();
        }
    }

    private void debugPrintDispatchedEvents(List<IDomainEvent> events) {
        if (!this.d_printDebugStatements) {
            return;
        }
        String message = "";
        for (IDomainEvent evt : events) {
            String evtMessage = evt.toString();
            if (evtMessage.length() <= 0) continue;
            message = message + "->Firing Event " + events.hashCode() + ": " + evtMessage + "\n";
        }
        if (message.length() != 0) {
            System.out.print(message);
            System.out.flush();
        }
    }

    public static void debugResponseStarted(IDomainListener listener, List<IDomainEvent> events) {
        if (System.getProperty("debug") == null) {
            return;
        }
        ListenerResponse lr = new ListenerResponse(listener, events);
        s_eventResponses.push(lr);
        lr.startResponse();
    }

    public static void debugResponseEnded() {
        if (System.getProperty("debug") == null) {
            return;
        }
        assert (!s_eventResponses.isEmpty());
        ListenerResponse lr = s_eventResponses.pop();
        lr.endResponse();
    }

    public static void debugPrintEvents(String sourceDesc, List<IDomainEvent> events) {
        if (System.getProperty("debug") == null) {
            return;
        }
        System.out.println("----" + sourceDesc + " Responding to event " + events.hashCode() + "...");
        System.out.flush();
    }

    public static void debugPrintElapsedTimeForEvents(String sourceDesc, List<IDomainEvent> events, double timeElapsed) {
        if (System.getProperty("debug") == null) {
            return;
        }
        String timeElapsedStr = s_timeFormat.format(timeElapsed);
        System.out.println("----" + sourceDesc + " Response to event " + events.hashCode() + " took " + timeElapsedStr + " sec.");
        System.out.flush();
    }

    static {
        s_timeFormat.applyPattern("0.0000");
    }

    private static class ListenerResponse {
        protected long d_timeStarted;
        protected final IDomainListener d_listener;
        protected final List<IDomainEvent> d_events;

        public ListenerResponse(IDomainListener listener, List<IDomainEvent> events) {
            this.d_listener = listener;
            this.d_events = events;
        }

        public void startResponse() {
            this.d_timeStarted = System.nanoTime();
            Mediator.debugPrintEvents(this.d_listener.getClass().getSimpleName(), this.d_events);
        }

        public void endResponse() {
            long timeEnded = System.nanoTime();
            double timeElapsed = (double)(timeEnded - this.d_timeStarted) * 1.0E-9;
            Mediator.debugPrintElapsedTimeForEvents(this.d_listener.getClass().getSimpleName(), this.d_events, timeElapsed);
        }
    }
}

