/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.geometry;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import pyrosim.legacy_2006_2.thunderheadeng.geometry.Util;

public class Intersections {
    public static final double DBL_EPSILON = 1.0E-9;
    public static final Vector3d VEC_ZERO = new Vector3d(0.0, 0.0, 0.0);
    public static final Point3d PNT_ZERO = new Point3d(0.0, 0.0, 0.0);

    public static int compare(double d1, double d2) {
        if (Math.abs(d1 - d2) < 1.0E-9) {
            return 0;
        }
        return Double.compare(d1, d2);
    }

    public static boolean linePlaneIntersection(Point3d intersection, Point3d l1, Point3d l2, Vector4d plane) {
        Vector3d lineDir = new Vector3d();
        lineDir.sub(l2, l1);
        return Intersections.linePlaneIntersection(intersection, l1, lineDir, plane);
    }

    public static boolean linePlaneIntersection(Point3d intersection, Point3d pointOnLine, Vector3d lineDir, Vector4d plane) {
        double dot = lineDir.x * plane.x + lineDir.y * plane.y + lineDir.z * plane.z;
        if (Intersections.compare(dot, 0.0) == 0) {
            return false;
        }
        double t = -(plane.w + plane.x * pointOnLine.x + plane.y * pointOnLine.y + plane.z * pointOnLine.z) / dot;
        intersection.x = pointOnLine.x + lineDir.x * t;
        intersection.y = pointOnLine.y + lineDir.y * t;
        intersection.z = pointOnLine.z + lineDir.z * t;
        return true;
    }

    public static boolean lineSegPolyIntersection(Point3d intersection, Point3d l1, Point3d l2, Vector3d lineDir, Vector4d polyPlane, Point3d ... polyPoints) {
        assert (polyPoints.length >= 3);
        double l1Side = Util.distance(l1, polyPlane);
        double l2Side = Util.distance(l2, polyPlane);
        int l1Comp = Intersections.compare(l1Side, 0.0);
        int l2Comp = Intersections.compare(l2Side, 0.0);
        if (l1Comp >= 0 && l2Comp >= 0 || l1Comp < 0 && l2Comp < 0) {
            return false;
        }
        return Intersections.linePolyIntersection(intersection, l1, lineDir, polyPlane, polyPoints);
    }

    public static boolean linePolyIntersection(Point3d intersection, Point3d l1, Vector3d lineDir, Vector4d polyPlane, Point3d ... polyPoints) {
        assert (polyPoints.length >= 3);
        if (!Intersections.linePlaneIntersection(intersection, l1, lineDir, polyPlane)) {
            return false;
        }
        Vector3d vp = new Vector3d();
        Vector3d vt = new Vector3d();
        Vector3d currentCross = new Vector3d();
        Vector3d lastCross = new Vector3d();
        vp.sub(intersection, polyPoints[0]);
        vt.sub(polyPoints[1], polyPoints[0]);
        lastCross.cross(vt, vp);
        if (Intersections.isVecZero(lastCross)) {
            return false;
        }
        for (int m = 1; m < polyPoints.length; ++m) {
            int nextix = (m + 1) % polyPoints.length;
            vp.sub(intersection, polyPoints[m]);
            vt.sub(polyPoints[nextix], polyPoints[m]);
            currentCross.cross(vt, vp);
            if (Intersections.isVecZero(currentCross) || Intersections.compare(lastCross.dot(currentCross), 0.0) < 0) {
                return false;
            }
            lastCross.set(currentCross);
        }
        return true;
    }

    private static boolean isVecZero(Vector3d vec) {
        return vec.epsilonEquals(VEC_ZERO, 1.0E-9);
    }

    public static boolean linePointIntersect(Point3d l1, Vector3d lineDir, Point3d p, double tolSq) {
        Point3d pOnLine = Intersections.linePointProximity(l1, lineDir, p);
        Vector3d vec = new Vector3d();
        vec.sub(p, pOnLine);
        double lengthSq = vec.lengthSquared();
        return lengthSq <= tolSq;
    }

    public static Point3d linePointProximity(Point3d l1, Vector3d lineDir, Point3d p) {
        Vector3d dir = new Vector3d(lineDir);
        Vector3d pvec = new Vector3d();
        pvec.sub(p, l1);
        double dot = dir.dot(pvec);
        dir.scale(dot);
        Point3d pOnLine = new Point3d();
        pOnLine.add(l1, dir);
        return pOnLine;
    }

    public static Point3d lineLineSegIntersection(Point3d l1a, Vector3d line1Dir, Point3d l2a, Point3d l2b, Vector3d line2Dir, double tolSq) {
        Point3d p1 = new Point3d();
        Point3d p2 = new Point3d();
        boolean prox = Intersections.lineLineSegProximity(p1, p2, l1a, line1Dir, l2a, l2b, line2Dir);
        if (!prox) {
            return null;
        }
        Vector3d diff = new Vector3d();
        diff.sub(p2, p1);
        double lengthSq = diff.lengthSquared();
        if (lengthSq <= tolSq) {
            return p1;
        }
        return null;
    }

    public static boolean lineLineSegProximity(Point3d closestOnLine1, Point3d closestOnLine2, Point3d l1a, Vector3d line1Dir, Point3d l2a, Point3d l2b, Vector3d line2Dir) {
        if (!Intersections.lineLineProximity(closestOnLine1, closestOnLine2, l1a, line1Dir, l2a, line2Dir)) {
            return false;
        }
        if (closestOnLine2 != null) {
            Intersections.constrainPoint(closestOnLine2, l2a, l2b, line2Dir);
        }
        return true;
    }

    public static boolean lineLineProximity(Point3d closestOnLine1, Point3d closestOnLine2, Point3d l1a, Vector3d line1Dir, Point3d l2a, Vector3d line2Dir) {
        Vector3d cross = new Vector3d();
        cross.cross(line1Dir, line2Dir);
        if (Intersections.compare(cross.dot(cross), 0.0) == 0) {
            return false;
        }
        if (closestOnLine1 != null) {
            Vector3d normal2 = new Vector3d();
            normal2.cross(cross, line2Dir);
            normal2.normalize();
            Vector4d p2 = Util.getPlane(normal2, l2a);
            Intersections.linePlaneIntersection(closestOnLine1, l1a, line1Dir, p2);
        }
        if (closestOnLine2 != null) {
            Vector3d normal1 = new Vector3d();
            normal1.cross(cross, line1Dir);
            normal1.normalize();
            Vector4d p1 = Util.getPlane(normal1, l1a);
            Intersections.linePlaneIntersection(closestOnLine2, l2a, line2Dir, p1);
        }
        return true;
    }

    private static double dot(Vector3d v, Point3d p) {
        return v.x * p.x + v.y * p.y + v.z * p.z;
    }

    public static void constrainPoint(Point3d point, Point3d la, Point3d lb, Vector3d lineDir) {
        double testDot = Intersections.dot(lineDir, point);
        double p1Dot = Intersections.dot(lineDir, la);
        double p2Dot = Intersections.dot(lineDir, lb);
        if (testDot < p1Dot && testDot < p2Dot) {
            if (p1Dot - testDot < p2Dot - testDot) {
                point.set(la);
            } else {
                point.set(lb);
            }
        } else if (testDot > p1Dot && testDot > p2Dot) {
            if (testDot - p2Dot < testDot - p1Dot) {
                point.set(lb);
            } else {
                point.set(la);
            }
        }
    }
}

