/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Hashtable;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.domain.PartRecord;
import pyrosim.legacy_2006_2.domain.SprkRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.EventParser;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;

public class SprkProcessor
extends AFDSRecordProcessor {
    private Hashtable d_allSprks = new Hashtable();

    public SprkProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "SPRK";
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        FDSRecordFormatException caughtExc;
        boolean err;
        block19: {
            err = false;
            caughtExc = null;
            if (!rec.getType().equals("SPRK")) {
                return false;
            }
            try {
                String label = null;
                label = (String)rec.getValue("LABEL");
                String make = null;
                make = (String)rec.getValue("MAKE");
                String partID = (String)rec.getValue("PART_ID");
                Vector orient = (Vector)rec.getValue("ORIENTATION");
                Double rotation = (Double)rec.getValue("ROTATION");
                Vector xyz = (Vector)rec.getValue("XYZ");
                if (make != null && xyz != null) {
                    Unit angleUnit = FdsSISystem.getInstance().getAngleUnit();
                    Unit lengthUnit = FdsSISystem.getInstance().getLengthUnit();
                    if (label == null || label.equals("")) {
                        label = "Sprinkler";
                    } else if (this.getContainer().getSprkList().contains(label)) {
                        throw new FDSRecordFormatException(rec, "The sprinkler, \"" + label + ",\" already exists in the model.");
                    }
                    SprkRecord sprkRec = new SprkRecord(label);
                    sprkRec.setMake(make);
                    if (partID == null) {
                        partID = "";
                    }
                    if (!partID.equals("")) {
                        PartRecord part = this.getResource(partID, PartRecord.class);
                        if (part != null) {
                            sprkRec.getSetParticleTask(partID).run();
                        } else {
                            throw new FDSRecordFormatException(rec, "The particle '" + partID + "' specified in the SPRK record(s) does not exist in the file.");
                        }
                    }
                    if (orient != null) {
                        sprkRec.setOrientation((Double)orient.elementAt(0), (Double)orient.elementAt(1), (Double)orient.elementAt(2));
                    }
                    if (rotation != null) {
                        sprkRec.setRotation(rotation, angleUnit);
                    }
                    sprkRec.setXYZ((Double)xyz.elementAt(0), (Double)xyz.elementAt(1), (Double)xyz.elementAt(2), lengthUnit);
                    SprkRecord correctSprk = (SprkRecord)EventParser.getCorrectObject(this.d_allSprks, sprkRec);
                    boolean usingExisting = correctSprk != sprkRec;
                    sprkRec = correctSprk;
                    String[] activateStrings = new String[]{"T_ACTIVATE"};
                    String[] deactivateStrings = new String[]{"T_DEACTIVATE"};
                    EventParser.parseEvents(this, sprkRec, rec, activateStrings, deactivateStrings, null, null, null);
                    if (!usingExisting) {
                        this.getContainer().getSprkList().taskAdd(sprkRec).run();
                        this.flagPyroTypeAffected(SprkRecord.class);
                        this.d_allSprks.put(sprkRec.getPropertyHashString(), sprkRec);
                    }
                    break block19;
                }
                throw new FDSRecordFormatException(rec, "Sprinkler records must contain a label, make, and xyz coordinates, at a minimum.");
            }
            catch (FDSRecordFormatException e) {
                e.printStackTrace();
                caughtExc = e;
                err = true;
            }
            catch (ClassCastException e2) {
                e2.printStackTrace();
                err = true;
            }
            catch (ArrayIndexOutOfBoundsException e3) {
                e3.printStackTrace();
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                err = true;
            }
        }
        if (err) {
            if (caughtExc != null) {
                throw caughtExc;
            }
            throw new FDSRecordFormatException(rec);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

