/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.TreeSet;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.BNDFList;
import pyrosim.legacy_2006_2.domain.BNDFRecord;
import pyrosim.legacy_2006_2.domain.SolidPhaseQuantitiesList;
import pyrosim.legacy_2006_2.domain.SolidPhaseQuantity;
import pyrosim.legacy_2006_2.domain.SolidPhaseQuantityParam;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;

public class BNDFProcessor
extends AFDSRecordProcessor {
    private TreeSet<UnitDouble> d_sortedDTSams = new TreeSet();

    public BNDFProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
        for (PyroMod mod : this.getSourceContainers()) {
            for (BNDFRecord rec : mod.getBNDFList()) {
                if (rec.getDTSam() == null) continue;
                this.d_sortedDTSams.add(rec.getDTSam());
            }
        }
    }

    @Override
    public String getFDSTypeParsed() {
        return "BNDF";
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        boolean err = false;
        FDSRecordFormatException caughtExc = null;
        if (!"BNDF".equals(rec.getType())) {
            return false;
        }
        try {
            Object quantityObj;
            FdsSISystem si = FdsSISystem.getInstance();
            UnitDouble dtsam = rec.extractDouble("DTSAM", si.getTimeUnit(), null, (UnitDoubleValueRange)BNDFRecord.getValueRange("DTSAM"));
            if (dtsam != null) {
                this.d_sortedDTSams.add(dtsam);
            }
            if ((quantityObj = rec.getValue("QUANTITY")) == null) {
                throw new FDSRecordFormatException(rec, "The BNDF record requires that a quantity be specified.");
            }
            if (!(quantityObj instanceof String)) {
                throw new FDSRecordFormatException(rec, "QUANTITY must be a String.");
            }
            SolidPhaseQuantitiesList quantitiesList = new SolidPhaseQuantitiesList();
            String quantity = (String)quantityObj;
            if (!quantitiesList.contains(quantity) || quantity.equals(SolidPhaseQuantitiesList.INSIDE_WALL_TEMPERATURE.getName())) {
                throw new FDSRecordFormatException(rec, quantity + " is not a valid BNDF quantity.");
            }
            BNDFRecord bndfRec = new BNDFRecord(null, quantity);
            SolidPhaseQuantity[] quantities = quantitiesList.getAllQuantities();
            for (int m = 0; m < quantities.length; ++m) {
                String quantityName = quantities[m].getName();
                if (!quantity.equals(quantityName)) continue;
                SolidPhaseQuantityParam[] params = quantities[m].getParams();
                for (int n = 0; n < params.length; ++n) {
                    Object extraParamValueObj = rec.getValue(params[n].getName());
                    if (extraParamValueObj == null) continue;
                    if (!(extraParamValueObj instanceof Double)) {
                        throw new FDSRecordFormatException(rec, params[n].getName() + " must a Real number.");
                    }
                    Double extraParamValue = (Double)extraParamValueObj;
                    bndfRec.setExtraParam(params[n].getName(), new UnitDouble(extraParamValue, si.getUnit(params[n].getUnitType())), params[n].getUnitType());
                }
                break;
            }
            this.getContainer().getBNDFList().taskAdd(bndfRec).run();
            this.getContainer().getBNDFList().setOutputEnabled(true);
            this.flagPyroTypeAffected(BNDFRecord.class);
        }
        catch (FDSRecordFormatException e) {
            caughtExc = e;
            err = true;
        }
        catch (Exception e) {
            err = true;
        }
        if (err) {
            if (caughtExc != null) {
                throw caughtExc;
            }
            throw new FDSRecordFormatException(rec, "An unknown error occured.");
        }
        return true;
    }

    @Override
    public void done() {
        BNDFRecord gaugeHF;
        BNDFList bndfs = this.getContainer().getBNDFList();
        BNDFRecord pressureCoeff = bndfs.get(SolidPhaseQuantitiesList.PRESSURE_COEFFICIENT.getName());
        if (pressureCoeff != null) {
            UnitDouble charVel = this.getContainer().getMiscManager().getMiscRecord().getCharVel();
            pressureCoeff.setExtraParam("CHARACTERISTIC_VELOCITY", charVel, 8);
        }
        if ((gaugeHF = bndfs.get(SolidPhaseQuantitiesList.GAUGE_HEAT_FLUX.getName())) != null) {
            UnitDouble gaugeTemp = this.getContainer().getMiscManager().getMiscRecord().getGaugeTemp();
            gaugeHF.setExtraParam("GAUGE_TEMPERATURE", gaugeTemp, 1);
        }
        if (this.d_sortedDTSams.size() > 0) {
            UnitDouble minDTSam = this.d_sortedDTSams.first();
            for (BNDFRecord rec : bndfs) {
                rec.setDTSam(minDTSam);
            }
        }
    }
}

