/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.geom;

import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector4d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class Util {
    public static Vector4d planeFromQuad(Quad q) {
        Matrix3d a = new Matrix3d(1.0, q.getPoint((int)0).y, q.getPoint((int)0).z, 1.0, q.getPoint((int)1).y, q.getPoint((int)1).z, 1.0, q.getPoint((int)2).y, q.getPoint((int)2).z);
        Matrix3d b = new Matrix3d(q.getPoint((int)0).x, 1.0, q.getPoint((int)0).z, q.getPoint((int)1).x, 1.0, q.getPoint((int)1).z, q.getPoint((int)2).x, 1.0, q.getPoint((int)2).z);
        Matrix3d c = new Matrix3d(q.getPoint((int)0).x, q.getPoint((int)0).y, 1.0, q.getPoint((int)1).x, q.getPoint((int)1).y, 1.0, q.getPoint((int)2).x, q.getPoint((int)2).y, 1.0);
        Matrix3d d = new Matrix3d(q.getPoint((int)0).x, q.getPoint((int)0).y, q.getPoint((int)0).z, q.getPoint((int)1).x, q.getPoint((int)1).y, q.getPoint((int)1).z, q.getPoint((int)2).x, q.getPoint((int)2).y, q.getPoint((int)2).z);
        Vector4d plane = new Vector4d(a.determinant(), b.determinant(), c.determinant(), -d.determinant());
        return plane;
    }

    public static Point3d convertPoint(Point3D teciPoint) {
        return new Point3d(teciPoint.x, teciPoint.y, teciPoint.z);
    }

    public static double[] convertArray(UnitDouble[] src, Unit desiredUnit) {
        double[] dest = new double[src.length];
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = src[i].getValue(desiredUnit);
        }
        return dest;
    }

    public static Point3d[] convertArray(Unit desiredUnit, UnitPoint3D ... src) {
        Point3d[] dest = new Point3d[src.length];
        for (int m = 0; m < dest.length; ++m) {
            dest[m] = src[m].getPoint3dValue(desiredUnit);
        }
        return dest;
    }

    public static UnitPoint3D[] convertArray(Unit srcUnit, Point3d ... src) {
        UnitPoint3D[] dest = new UnitPoint3D[src.length];
        for (int m = 0; m < dest.length; ++m) {
            dest[m] = new UnitPoint3D(src[m], srcUnit);
        }
        return dest;
    }
}

