/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.ASetNameTask;
import pyrosim.legacy_2006_2.domain.DisplayablePointObject;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.domain.ModelImage;
import pyrosim.legacy_2006_2.events.FloorDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.WeakHashSet;

public class Floor
implements Serializable,
IPyroObject {
    static final long serialVersionUID = 1L;
    private String d_name;
    private UnitDouble d_bottom;
    private UnitDouble d_top;
    private ModelImage d_bgImage;
    public static final int OUTSIDE = 0;
    public static final int INSIDE = 1;
    public static final int PART_INSIDE = 2;
    public static final int FLOOR = 3;
    private transient Set<FDSObject> d_roomObjs = new WeakHashSet<FDSObject>();
    private transient Set<FDSObject> d_floorObjs = new WeakHashSet<FDSObject>();
    private transient Set<DisplayablePointObject> d_pointObjs = new WeakHashSet<DisplayablePointObject>();
    private transient ADomainObject<PyroMod> d_domainHelper = new ADomainObject();

    public Floor(String name, double bottom, double top, Unit lenghtUnit, ModelImage bgImage) {
        this(name, new UnitDouble(bottom, lenghtUnit), new UnitDouble(top, lenghtUnit), bgImage);
    }

    public Floor(String name, UnitDouble bottom, UnitDouble top, ModelImage bgImage) {
        this.set(name, bottom, top, bgImage);
    }

    @Override
    public Object clone() {
        try {
            Floor clone = (Floor)super.clone();
            clone.d_bottom = (UnitDouble)this.d_bottom.clone();
            clone.d_top = (UnitDouble)this.d_top.clone();
            clone.d_bgImage = (ModelImage)this.d_bgImage.clone();
            clone.d_domainHelper = new ADomainObject();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.d_roomObjs = new WeakHashSet<FDSObject>();
        this.d_floorObjs = new WeakHashSet<FDSObject>();
        this.d_pointObjs = new WeakHashSet<DisplayablePointObject>();
        this.d_domainHelper = new ADomainObject();
    }

    public String getName() {
        return this.d_name;
    }

    private void setName(String name) {
        this.d_name = name;
        this.d_domainHelper.fireDomainEvent(new FloorDomainEvent(this, 5));
    }

    public Task taskSetName(String name) {
        return new ASetNameTask(name){

            @Override
            public void setName(String newName) {
                Floor.this.setName(newName);
            }

            @Override
            protected String getName() {
                return Floor.this.getName();
            }
        };
    }

    public UnitDouble getBottom() {
        return this.d_bottom;
    }

    public UnitDouble getTop() {
        return this.d_top;
    }

    public ModelImage getBgImage() {
        return this.d_bgImage;
    }

    public void set(String name, UnitDouble bottom, UnitDouble top, ModelImage bgImage) {
        this.d_domainHelper.pauseUpdates(false);
        this.d_name = name;
        if (!bottom.equals(this.d_bottom)) {
            this.d_bottom = bottom;
        }
        if (!top.equals(this.d_top)) {
            this.d_top = top;
        }
        this.setBgImage(bgImage);
        this.d_domainHelper.resumeUpdates(new FloorDomainEvent(this, 5));
    }

    public void setBgImage(ModelImage bgImage) {
        this.d_bgImage = bgImage;
        if (this.d_bgImage != null) {
            this.d_bgImage.setZLocationModel(this.getBottom());
        }
        this.d_domainHelper.fireDomainEvent(new FloorDomainEvent(this, 5));
    }

    public void clearCachedPointObjects() {
        this.d_pointObjs.clear();
    }

    public void clearCachedFDSObjects() {
        this.d_roomObjs.clear();
        this.d_floorObjs.clear();
    }

    public void clearAllCachedObjects() {
        this.clearCachedPointObjects();
        this.clearCachedFDSObjects();
    }

    public void filterObjects(Collection<? extends FDSObject> objs) {
        for (FDSObject fDSObject : objs) {
            if (fDSObject instanceof FDSComposite) {
                FDSComposite c = (FDSComposite)fDSObject;
                this.filterObjects(c.toCollection());
                continue;
            }
            int location = this.whereIs(fDSObject);
            if (location == 1 || location == 2) {
                this.d_floorObjs.remove(fDSObject);
                this.d_roomObjs.add(fDSObject);
                continue;
            }
            if (location == 3) {
                this.d_roomObjs.remove(fDSObject);
                this.d_floorObjs.add(fDSObject);
                continue;
            }
            if (location != 0) continue;
            this.d_floorObjs.remove(fDSObject);
            this.d_roomObjs.remove(fDSObject);
        }
    }

    public void filterPointObjects(Collection<? extends DisplayablePointObject> points) {
        for (DisplayablePointObject displayablePointObject : points) {
            int location = this.whereIs(displayablePointObject);
            if (location == 1) {
                this.d_pointObjs.add(displayablePointObject);
                continue;
            }
            this.d_pointObjs.remove(displayablePointObject);
        }
    }

    public void removeFilteredPointObjects(Collection<? extends DisplayablePointObject> points) {
        this.d_pointObjs.removeAll(points);
    }

    public void removeFilteredObjects(Collection<? extends FDSObject> objs) {
        for (FDSObject fDSObject : objs) {
            if (fDSObject instanceof FDSComposite) {
                FDSComposite c = (FDSComposite)fDSObject;
                this.removeFilteredObjects(c.toCollection());
                continue;
            }
            this.d_floorObjs.remove(fDSObject);
            this.d_roomObjs.remove(fDSObject);
        }
    }

    public int whereIs(FDSObject obj) {
        UnitDouble minZ = obj.getMinPoint().zu();
        UnitDouble maxZ = obj.getMaxPoint().zu();
        int minWithTop = minZ.compareTo(this.d_top);
        if (minWithTop >= 0) {
            return 0;
        }
        int maxWithBottom = maxZ.compareTo(this.d_bottom);
        if (maxWithBottom < 0) {
            return 0;
        }
        if (maxWithBottom == 0) {
            return 3;
        }
        if (maxZ.compareTo(this.d_top) > 0 || minZ.compareTo(this.d_bottom) < 0) {
            return 2;
        }
        return 1;
    }

    public int whereIs(DisplayablePointObject obj) {
        UnitDouble z = obj.getLocation().zu();
        if (z.compareTo(this.d_top) >= 0 || z.compareTo(this.d_bottom) < 0) {
            return 0;
        }
        return 1;
    }

    public Set<FDSObject> getFloorObstructions() {
        return this.d_floorObjs;
    }

    public Set<FDSObject> getRoomItems() {
        return this.d_roomObjs;
    }

    public Set<DisplayablePointObject> getPointObjects() {
        return this.d_pointObjs;
    }

    @Override
    public boolean equals(Object f2) {
        if (!(f2 instanceof Floor)) {
            return false;
        }
        Floor floor2 = (Floor)f2;
        boolean equal = (floor2.d_bgImage == null ? this.d_bgImage == null : floor2.d_bgImage.equals(this.d_bgImage)) && floor2.d_bottom.equals(this.d_bottom) && floor2.d_top.equals(this.d_top) && floor2.d_name.equals(this.d_name);
        return equal;
    }

    public static void sortByName(Floor[] floors) {
        Arrays.sort(floors, new CompareName());
    }

    public static void sortByLevel(Floor[] floors) {
        Arrays.sort(floors, new CompareLevel());
    }

    @Override
    public void addDomain(PyroMod owner) {
        this.d_domainHelper.addDomain(owner);
    }

    @Override
    public void removeDomain(PyroMod owner) {
        this.d_domainHelper.removeDomain(owner);
    }

    @Override
    public Set<PyroMod> getDomains() {
        return this.d_domainHelper.getDomains();
    }

    @Override
    public String getTypeDescription() {
        return "Floor";
    }

    static class CompareLevel
    implements Comparator {
        CompareLevel() {
        }

        public int compare(Object o1, Object o2) {
            BaseUnit u = SI.METER;
            return Double.compare(((Floor)o1).d_bottom.getValue(u), ((Floor)o2).d_bottom.getValue(u));
        }
    }

    static class CompareName
    implements Comparator {
        CompareName() {
        }

        public int compare(Object o1, Object o2) {
            String str1 = ((Floor)o1).d_name;
            String str2 = ((Floor)o2).d_name;
            return str1.compareToIgnoreCase(str2);
        }
    }
}

