/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AImprintTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddAtIndexTask;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.APyroManReplaceTask;
import pyrosim.legacy_2006_2.domain.ARemoveAtIndexTask;
import pyrosim.legacy_2006_2.domain.ASetNameTask;
import pyrosim.legacy_2006_2.domain.AbstractActivationEventList;
import pyrosim.legacy_2006_2.domain.ActivationEvent;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.AlignedBlock;
import pyrosim.legacy_2006_2.domain.DeepFDSObjectIterator;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FDSObjectCollection;
import pyrosim.legacy_2006_2.domain.FDSObjectIterator;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.domain.Slab;
import pyrosim.legacy_2006_2.domain.Wall;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.KeyableObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class FDSComposite
extends KeyableObject
implements FDSObject,
Serializable,
Cloneable,
IPyroManager<Integer, FDSObject> {
    static final long serialVersionUID = 1L;
    private String d_name;
    private List<FDSObject> d_members;
    private Set<FDSObject> d_obstSet;
    private Set<FDSComposite> d_compSet;
    private transient boolean d_selected;
    private transient ADomainObject<PyroMod> d_domainHelper = new ADomainObject();
    private transient Map<FDSObject, Integer> d_objIndexMap;
    private FDSComposite d_parent = null;

    public FDSComposite() {
        this("Group");
    }

    public FDSComposite(String name) {
        this.d_members = new ArrayList<FDSObject>();
        this.d_obstSet = new HashSet<FDSObject>();
        this.d_compSet = new HashSet<FDSComposite>();
        this.d_name = name;
    }

    @Override
    public Collection<? extends FDSObject> toCollection() {
        return new PyroCollection<Integer, FDSObject>(this);
    }

    public <T extends FDSObject> Collection<T> toCollection(Class<T> type, boolean deep) {
        return new FDSObjectCollection<T>(Arrays.asList(this), deep, type);
    }

    public static FDSObjectCollection<FDSObject> toCollection(Collection<? extends FDSObject> objs) {
        return FDSComposite.toCollection(objs, true);
    }

    public static FDSObjectCollection<FDSObject> toCollection(Collection<? extends FDSObject> objs, boolean deep) {
        return new FDSObjectCollection<FDSObject>(objs, deep, FDSObject.class);
    }

    public static FDSObjectCollection<FDSObject> toCollection(FDSObject ... objs) {
        return FDSComposite.toCollection(Arrays.asList(objs));
    }

    public static FDSObjectCollection<FDSObject> toCollection(boolean deep, FDSObject ... objs) {
        return FDSComposite.toCollection(Arrays.asList(objs), deep);
    }

    @Override
    public Object clone() {
        FDSComposite theClone = (FDSComposite)super.clone();
        theClone.d_domainHelper = new ADomainObject();
        theClone.d_selected = false;
        theClone.d_members = new Vector<FDSObject>(this.d_members.size());
        theClone.d_obstSet = new HashSet<FDSObject>(this.d_obstSet.size());
        theClone.d_compSet = new HashSet<FDSComposite>(this.d_compSet.size());
        for (FDSObject member : this.d_members) {
            FDSObject objClone = (FDSObject)member.clone();
            objClone.setParent(theClone);
            theClone.d_members.add(objClone);
            if (objClone instanceof FDSComposite) {
                theClone.d_compSet.add((FDSComposite)objClone);
                continue;
            }
            theClone.d_obstSet.add(objClone);
        }
        theClone.clearIndexCache();
        return theClone;
    }

    private void imprint(FDSComposite comp) {
        this.d_domainHelper.pauseUpdates();
        this.setName(comp.d_name);
        Vector<FDSObject> objsToRemove = new Vector<FDSObject>(this.size());
        objsToRemove.addAll(this.toCollection());
        this.taskRemoveAll((List<FDSObject>)objsToRemove, (List<FDSObject>)null).run();
        for (FDSObject fDSObject : comp.toCollection()) {
            FDSObject childClone = (FDSObject)fDSObject.clone();
            childClone.setParent(this);
            this.taskAdd(childClone).run();
        }
        this.d_domainHelper.resumeUpdates();
    }

    @Override
    public Task taskImprint(Object baseObject) {
        if (!(baseObject instanceof FDSComposite)) {
            return null;
        }
        return new AImprintTask<FDSComposite>(this, (FDSComposite)baseObject, FDSComposite.class){

            @Override
            protected void imprint(FDSComposite objToImprint, FDSComposite baseObject) {
                objToImprint.imprint(baseObject);
            }
        };
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FDSComposite)) {
            return false;
        }
        FDSComposite c = (FDSComposite)obj;
        return c.d_members.equals(this.d_members);
    }

    @Override
    public FDSComposite getParent() {
        return this.d_parent;
    }

    @Override
    public void setParent(FDSComposite parent) {
        this.d_parent = parent;
    }

    @Override
    public Task taskTranslateObject(final UnitPoint3D delta) {
        return new CompositeTask<PyroMod>(this.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                for (FDSObject o : FDSComposite.this.d_members) {
                    this.addTask(o.taskTranslateObject(delta));
                }
            }
        };
    }

    @Override
    public Task taskMirrorObject(final int plane, final UnitDouble value) {
        return new CompositeTask<PyroMod>(this.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                for (FDSObject o : FDSComposite.this.d_members) {
                    this.addTask(o.taskMirrorObject(plane, value));
                }
            }
        };
    }

    @Override
    public Task taskScaleObject(final UnitPoint3D base, final Tuple3d scale) {
        return new CompositeTask<PyroMod>(this.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                for (FDSObject o : FDSComposite.this.d_members) {
                    this.addTask(o.taskScaleObject(base, scale));
                }
            }
        };
    }

    @Override
    public Task taskRotateObject(final UnitPoint3D base, final Vector3d rotAxis, final UnitDouble amount) {
        return new CompositeTask<PyroMod>(this.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                for (FDSObject o : FDSComposite.this.d_members) {
                    this.addTask(o.taskRotateObject(base, rotAxis, amount));
                }
            }
        };
    }

    private boolean add(FDSObject member) {
        return this.add(member, this.size());
    }

    private boolean add(FDSObject member, int iIndex) {
        if (member instanceof FDSComposite) {
            if (member == this || ((FDSComposite)member).isDecendent(this)) {
                return false;
            }
            this.d_compSet.add((FDSComposite)member);
        } else {
            this.d_obstSet.add(member);
        }
        this.d_members.add(iIndex, member);
        member.setParent(this);
        ADomainObject.addDomains(member, this.getDomains());
        this.clearIndexCache();
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, member, 3));
        if (member instanceof FDSComposite) {
            ((FDSComposite)member).propagateEvent(3);
        }
        return true;
    }

    private FDSObject remove(int index) {
        FDSObject member = this.d_members.get(index);
        if (member == null) {
            return null;
        }
        this.d_members.remove(index);
        this.d_obstSet.remove(member);
        this.d_compSet.remove(member);
        this.clearIndexCache();
        if (member.getParent() == this) {
            member.setParent(null);
        } else {
            System.err.println("Can't remove parent because parent was different " + this + " " + member.getParent());
        }
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, member, 4));
        if (member instanceof FDSComposite) {
            ((FDSComposite)member).propagateEvent(4);
        }
        ADomainObject.removeDomains(member, this.getDomains());
        return member;
    }

    private boolean remove(FDSObject member) {
        int index = this.indexOfUncached(member);
        if (index < 0) {
            return false;
        }
        return this.remove(index) != null;
    }

    private void propagateEvent(int eventType) {
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, this.d_members, eventType));
        for (FDSComposite compObj : this.d_compSet) {
            compObj.propagateEvent(eventType);
        }
    }

    private boolean removeAll(Collection<? extends FDSObject> objs) {
        boolean result = true;
        for (FDSObject fDSObject : objs) {
            if (this.remove(fDSObject)) continue;
            result = false;
        }
        return result;
    }

    @Override
    public boolean contains(FDSObject obj) {
        if (obj instanceof FDSComposite) {
            return this.d_compSet.contains(obj);
        }
        return this.d_obstSet.contains(obj);
    }

    @Override
    public boolean contains(Integer key) {
        return key < this.d_members.size() && key >= 0;
    }

    @Override
    public boolean containsAll(Collection<? extends Integer> keys) {
        return APyroDomainManager.containsAll(this, keys);
    }

    @Override
    public boolean isEmpty() {
        return this.d_members.isEmpty();
    }

    public FDSObject[] toArray() {
        return this.toArray(new FDSObject[this.size()]);
    }

    public FDSObject[] toArray(FDSObject[] array) {
        return this.d_members.toArray(array);
    }

    @Override
    public Iterator<FDSObject> iterator() {
        return new FDSObjectIterator(this, false);
    }

    @Override
    public int size() {
        return this.d_members.size();
    }

    @Override
    public FDSObject get(Integer index) {
        return this.d_members.get(index);
    }

    private void clearIndexCache() {
        this.d_objIndexMap = null;
    }

    private void buildIndexCache() {
        if (this.d_objIndexMap == null) {
            this.d_objIndexMap = new HashMap<FDSObject, Integer>(this.d_members.size());
            for (int m = 0; m < this.d_members.size(); ++m) {
                this.d_objIndexMap.put(this.d_members.get(m), m);
            }
        }
    }

    public int indexOf(FDSObject member) {
        this.buildIndexCache();
        Integer index = this.d_objIndexMap.get(member);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public int indexOfUncached(FDSObject member) {
        for (int m = 0; m < this.d_members.size(); ++m) {
            if (this.d_members.get(m) != member) continue;
            return m;
        }
        return -1;
    }

    public boolean isDecendent(FDSObject obj) {
        if (this.contains(obj)) {
            return true;
        }
        for (FDSComposite comp : this.d_compSet) {
            if (!comp.isDecendent(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getFDSType() {
        return "";
    }

    public Collection<FDSInputRecord> getInputRecords() {
        ArrayList<FDSInputRecord> recs = new ArrayList<FDSInputRecord>(1);
        this.getInputRecords(recs);
        return recs;
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        for (FDSObject o : this.d_members) {
            o.getInputRecords(recs);
        }
    }

    @Override
    public void getGeometry(Geometry g) {
        Geometry memberGeometry = new Geometry();
        for (FDSObject o : this.d_members) {
            if (!o.isVisible()) continue;
            o.getGeometry(memberGeometry);
        }
        g.addGeometry(memberGeometry);
    }

    @Override
    public UnitPoint3D getMinPoint() {
        return FDSComposite.getMinPoint(new FDSObjectIterator(this, false));
    }

    public static UnitPoint3D getMinPoint(Iterator<? extends FDSObject> objIter) {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        BaseUnit u = SI.METER;
        if (objIter.hasNext()) {
            minX = Double.MAX_VALUE;
            minY = Double.MAX_VALUE;
            minZ = Double.MAX_VALUE;
            while (objIter.hasNext()) {
                UnitPoint3D curr = objIter.next().getMinPoint();
                if (curr.x(u) < minX) {
                    minX = curr.x(u);
                }
                if (curr.y(u) < minY) {
                    minY = curr.y(u);
                }
                if (!(curr.z(u) < minZ)) continue;
                minZ = curr.z(u);
            }
        }
        return new UnitPoint3D(minX, minY, minZ, u);
    }

    @Override
    public UnitPoint3D getMaxPoint() {
        return FDSComposite.getMaxPoint(new FDSObjectIterator(this, false));
    }

    public static UnitPoint3D getMaxPoint(Iterator<? extends FDSObject> objIter) {
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        BaseUnit u = SI.METER;
        if (objIter.hasNext()) {
            maxX = -1.7976931348623157E308;
            maxY = -1.7976931348623157E308;
            maxZ = -1.7976931348623157E308;
            while (objIter.hasNext()) {
                UnitPoint3D curr = objIter.next().getMaxPoint();
                if (curr.x(u) > maxX) {
                    maxX = curr.x(u);
                }
                if (curr.y(u) > maxY) {
                    maxY = curr.y(u);
                }
                if (!(curr.z(u) > maxZ)) continue;
                maxZ = curr.z(u);
            }
        }
        return new UnitPoint3D(maxX, maxY, maxZ, u);
    }

    @Override
    public String getName() {
        return this.d_name;
    }

    private void setName(String desc) {
        this.d_name = desc;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Task taskSetName(String name) {
        return new ASetNameTask(name){

            @Override
            protected void setName(String name) {
                FDSComposite.this.setName(name);
            }

            @Override
            protected String getName() {
                return FDSComposite.this.getName();
            }
        };
    }

    @Override
    public boolean isSelected() {
        return this.d_selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.d_selected = selected;
        ADomainObject.pauseUpdates(this);
        for (FDSObject member : this.d_members) {
            member.setSelected(selected);
        }
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 0));
        ADomainObject.resumeUpdates(this);
    }

    @Override
    public void setVisible(boolean visible) {
        ADomainObject.pauseUpdates(this, false);
        for (FDSObject member : this.d_members) {
            member.setVisible(visible);
        }
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 1));
    }

    @Override
    public boolean isVisible() {
        if (this.size() < 1) {
            return true;
        }
        for (FDSObject member : this.d_members) {
            if (!member.isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getNumFaces() {
        assert (false) : "Warning!! -- unimplemented";
        return 0;
    }

    @Override
    public IFace getFace(int index) {
        assert (false) : "Warning!! -- unimplemented";
        return null;
    }

    private static void pauseUpdates(Set<PyroMod> domains) {
        for (PyroMod domain : domains) {
            domain.pauseUpdates();
        }
    }

    private static void resumeUpdates(Set<PyroMod> domains) {
        for (PyroMod domain : domains) {
            domain.resumeUpdates();
        }
    }

    @Override
    public void setMaterial(Material mat) {
        FDSComposite.setMaterial(mat, new FDSObjectIterator(this, false), this.getDomains());
    }

    public static void setMaterial(Material mat, FDSObjectIterator objIter, Set<PyroMod> domains) {
        FDSComposite.pauseUpdates(domains);
        while (objIter.hasNext()) {
            objIter.next().setMaterial(mat);
        }
        FDSComposite.resumeUpdates(domains);
    }

    @Override
    public void setMaterial(int faceIndex, Material mat) {
        FDSComposite.setMaterial(faceIndex, mat, new FDSObjectIterator(this, false), this.getDomains());
    }

    public static void setMaterial(int faceIndex, Material mat, FDSObjectIterator objIter, Set<PyroMod> domains) {
        FDSComposite.pauseUpdates(domains);
        while (objIter.hasNext()) {
            objIter.next().setMaterial(faceIndex, mat);
        }
        FDSComposite.resumeUpdates(domains);
    }

    @Override
    public Material getMaterial() {
        return FDSComposite.getMaterial(this.d_members);
    }

    public static Material getMaterial(Collection<? extends FDSObject> shallowObjs) {
        if (FDSComposite.isUniformMaterial(shallowObjs.iterator())) {
            if (shallowObjs.size() < 1) {
                return null;
            }
            for (FDSObject fDSObject : shallowObjs) {
                Material mat = fDSObject.getMaterial();
                if (mat == null) continue;
                return mat;
            }
            return null;
        }
        return null;
    }

    @Override
    public void setColor(Color c) {
        FDSComposite.setColor(c, new FDSObjectIterator(this, false), this.getDomains());
    }

    public static void setColor(Color c, FDSObjectIterator objIter, Set<PyroMod> domains) {
        FDSComposite.pauseUpdates(domains);
        while (objIter.hasNext()) {
            objIter.next().setColor(c);
        }
        FDSComposite.resumeUpdates(domains);
    }

    @Override
    public Color getColor() {
        return FDSComposite.getColor(new DeepFDSObjectIterator(this));
    }

    public static Color getColor(Iterator<? extends FDSObject> deepIter) {
        if (!deepIter.hasNext()) {
            return null;
        }
        return deepIter.next().getColor();
    }

    public boolean isUniformColor() {
        return FDSComposite.isUniformColor(new DeepFDSObjectIterator(this));
    }

    public static boolean isUniformColor(Iterator<? extends FDSObject> deepIter) {
        if (!deepIter.hasNext()) {
            return true;
        }
        Color color = deepIter.next().getColor();
        while (deepIter.hasNext()) {
            Color c = deepIter.next().getColor();
            boolean equal = color == null ? c == null : color.equals(c);
            if (equal) continue;
            return false;
        }
        return true;
    }

    public void setIsSawtoothed(boolean sawtoothed) {
        FDSComposite.setIsSawtoothed(sawtoothed, new DeepFDSObjectIterator(this), this.getDomains());
    }

    public static void setIsSawtoothed(boolean sawtoothed, Iterator<? extends FDSObject> deepIter, Set<PyroMod> domains) {
        FDSComposite.pauseUpdates(domains);
        while (deepIter.hasNext()) {
            FDSObject curr = deepIter.next();
            if (curr instanceof Wall) {
                ((Wall)curr).setIsSawtoothed(sawtoothed);
                continue;
            }
            if (curr instanceof AlignedBlock) {
                ((AlignedBlock)curr).setIsSawtoothed(sawtoothed);
                continue;
            }
            if (!(curr instanceof Slab)) continue;
            ((Slab)curr).setIsSawtoothed(sawtoothed);
        }
        FDSComposite.resumeUpdates(domains);
    }

    public boolean isSawtoothed() {
        DeepFDSObjectIterator objIter = new DeepFDSObjectIterator(this);
        return FDSComposite.isSawtoothed(objIter);
    }

    public static boolean isSawtoothed(Iterator<? extends FDSObject> deepIter) {
        while (deepIter.hasNext()) {
            FDSObject curr = deepIter.next();
            if (curr instanceof Wall) {
                return ((Wall)curr).isSawtoothed();
            }
            if (curr instanceof AlignedBlock) {
                return ((AlignedBlock)curr).isSawtoothed();
            }
            if (!(curr instanceof Slab)) continue;
            return ((Slab)curr).isSawtoothed();
        }
        return false;
    }

    public boolean isUniformSawtoothed() {
        DeepFDSObjectIterator objIter = new DeepFDSObjectIterator(this);
        return FDSComposite.isUniformSawtoothed(objIter);
    }

    public static boolean isUniformSawtoothed(Iterator<? extends FDSObject> deepIter) {
        boolean baseSawtoothValue = false;
        boolean baseValueSet = false;
        while (deepIter.hasNext()) {
            FDSObject curr = deepIter.next();
            if (curr instanceof Wall) {
                if (!baseValueSet) {
                    baseSawtoothValue = ((Wall)curr).isSawtoothed();
                    baseValueSet = true;
                    continue;
                }
                if (((Wall)curr).isSawtoothed() == baseSawtoothValue) continue;
                return false;
            }
            if (curr instanceof AlignedBlock) {
                if (!baseValueSet) {
                    baseSawtoothValue = ((AlignedBlock)curr).isSawtoothed();
                    baseValueSet = true;
                    continue;
                }
                if (((AlignedBlock)curr).isSawtoothed() == baseSawtoothValue) continue;
                return false;
            }
            if (!(curr instanceof Slab)) continue;
            if (!baseValueSet) {
                baseSawtoothValue = ((Slab)curr).isSawtoothed();
                baseValueSet = true;
                continue;
            }
            if (((Slab)curr).isSawtoothed() == baseSawtoothValue) continue;
            return false;
        }
        return true;
    }

    public void setIsThickened(boolean thicken) {
        FDSComposite.setIsThickened(thicken, new DeepFDSObjectIterator(this), this.getDomains());
    }

    public static void setIsThickened(boolean thicken, Iterator<? extends FDSObject> deepIt, Set<PyroMod> domains) {
        FDSComposite.pauseUpdates(domains);
        while (deepIt.hasNext()) {
            FDSObject curr = deepIt.next();
            if (curr instanceof Wall) {
                ((Wall)curr).setIsThickened(thicken);
                continue;
            }
            if (curr instanceof AlignedBlock) {
                ((AlignedBlock)curr).setIsThickened(thicken);
                continue;
            }
            if (!(curr instanceof Slab)) continue;
            ((Slab)curr).setIsThickened(thicken);
        }
        FDSComposite.resumeUpdates(domains);
    }

    public boolean isThickened() {
        DeepFDSObjectIterator objIter = new DeepFDSObjectIterator(this);
        return FDSComposite.isThickened(objIter);
    }

    public static boolean isThickened(Iterator<? extends FDSObject> deepIter) {
        while (deepIter.hasNext()) {
            FDSObject curr = deepIter.next();
            if (curr instanceof Wall) {
                return ((Wall)curr).isThickened();
            }
            if (curr instanceof AlignedBlock) {
                return ((AlignedBlock)curr).isThickened();
            }
            if (!(curr instanceof Slab)) continue;
            return ((Slab)curr).isThickened();
        }
        return false;
    }

    public boolean isUniformThickened() {
        DeepFDSObjectIterator objIter = new DeepFDSObjectIterator(this);
        return FDSComposite.isUniformThickened(objIter);
    }

    public static boolean isUniformThickened(Iterator<? extends FDSObject> deepIter) {
        boolean baseValue = false;
        boolean baseValueSet = false;
        while (deepIter.hasNext()) {
            FDSObject curr = deepIter.next();
            if (curr instanceof Wall) {
                if (!baseValueSet) {
                    baseValue = ((Wall)curr).isThickened();
                    baseValueSet = true;
                    continue;
                }
                if (((Wall)curr).isThickened() == baseValue) continue;
                return false;
            }
            if (curr instanceof AlignedBlock) {
                if (!baseValueSet) {
                    baseValue = ((AlignedBlock)curr).isThickened();
                    baseValueSet = true;
                    continue;
                }
                if (((AlignedBlock)curr).isThickened() == baseValue) continue;
                return false;
            }
            if (!(curr instanceof Slab)) continue;
            if (!baseValueSet) {
                baseValue = ((Slab)curr).isThickened();
                baseValueSet = true;
                continue;
            }
            if (((Slab)curr).isThickened() == baseValue) continue;
            return false;
        }
        return true;
    }

    public void setPermitsHole(boolean value) {
        FDSComposite.setPermitsHole(value, new DeepFDSObjectIterator(this), this.getDomains());
    }

    public static void setPermitsHole(boolean value, Iterator<? extends FDSObject> deepIter, Set<PyroMod> domains) {
        FDSComposite.pauseUpdates(domains);
        while (deepIter.hasNext()) {
            FDSObject curr = deepIter.next();
            if (curr instanceof Wall) {
                ((Wall)curr).setPermitsHole(value);
                continue;
            }
            if (curr instanceof AlignedBlock) {
                ((AlignedBlock)curr).setPermitsHole(value);
                continue;
            }
            if (!(curr instanceof Slab)) continue;
            ((Slab)curr).setPermitsHole(value);
        }
        FDSComposite.resumeUpdates(domains);
    }

    public boolean permitsHole() {
        DeepFDSObjectIterator objIter = new DeepFDSObjectIterator(this);
        return FDSComposite.permitsHole(objIter);
    }

    public static boolean permitsHole(Iterator<? extends FDSObject> deepIter) {
        while (deepIter.hasNext()) {
            FDSObject curr = deepIter.next();
            if (curr instanceof Wall) {
                return ((Wall)curr).permitsHole();
            }
            if (curr instanceof AlignedBlock) {
                return ((AlignedBlock)curr).permitsHole();
            }
            if (!(curr instanceof Slab)) continue;
            return ((Slab)curr).permitsHole();
        }
        return false;
    }

    public boolean isUniformPermitsHole() {
        DeepFDSObjectIterator objIter = new DeepFDSObjectIterator(this);
        return FDSComposite.isUniformPermitsHole(objIter);
    }

    public static boolean isUniformPermitsHole(Iterator<? extends FDSObject> deepIter) {
        boolean baseValue = false;
        boolean baseValueSet = false;
        while (deepIter.hasNext()) {
            FDSObject curr = deepIter.next();
            if (curr instanceof Wall) {
                if (!baseValueSet) {
                    baseValue = ((Wall)curr).permitsHole();
                    baseValueSet = true;
                    continue;
                }
                if (((Wall)curr).permitsHole() == baseValue) continue;
                return false;
            }
            if (curr instanceof AlignedBlock) {
                if (!baseValueSet) {
                    baseValue = ((AlignedBlock)curr).permitsHole();
                    baseValueSet = true;
                    continue;
                }
                if (((AlignedBlock)curr).permitsHole() == baseValue) continue;
                return false;
            }
            if (!(curr instanceof Slab)) continue;
            if (!baseValueSet) {
                baseValue = ((Slab)curr).permitsHole();
                baseValueSet = true;
                continue;
            }
            if (((Slab)curr).permitsHole() == baseValue) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUniformMaterial() {
        return FDSComposite.isUniformMaterial(new FDSObjectIterator(this, false));
    }

    @Override
    public Material getMaterial(int faceIndex) {
        return FDSComposite.getMaterial(new DeepFDSObjectIterator(this), faceIndex);
    }

    public static Material getMaterial(Iterator<? extends FDSObject> deepIter, int faceIndex) {
        Material m;
        if (!deepIter.hasNext()) {
            return null;
        }
        FDSObject curr = deepIter.next();
        Material currM = m = faceIndex <= curr.getNumFaces() ? curr.getMaterial(faceIndex) : null;
        while (deepIter.hasNext()) {
            curr = deepIter.next();
            if (faceIndex >= curr.getNumFaces() || (currM = curr.getMaterial(faceIndex)) == m) continue;
            return null;
        }
        return m;
    }

    public static boolean isUniformMaterial(Iterator<? extends FDSObject> objIter) {
        Material m = null;
        Material currM = null;
        while (objIter.hasNext()) {
            FDSObject curr = objIter.next();
            if (!curr.isUniformMaterial()) {
                return false;
            }
            currM = curr.getMaterial();
            if (m == null) {
                m = currM;
                continue;
            }
            if (currM == m || currM == null) continue;
            return false;
        }
        return true;
    }

    public static FDSComposite getCommonParentFromRoot(FDSObject[] nodes, FDSComposite root) {
        return FDSComposite.getCommonParentFromRoot(Arrays.asList(nodes), root);
    }

    public static FDSComposite getCommonParentFromRoot(Collection<? extends FDSObject> nodes, FDSComposite root) {
        if (nodes.isEmpty()) {
            return root;
        }
        Iterator<? extends FDSObject> it = nodes.iterator();
        FDSComposite[] path = FDSComposite.getPath(it.next(), root);
        if (path == null) {
            return root;
        }
        int best = path.length - 1;
        while (it.hasNext()) {
            FDSObject node = it.next();
            if (node == root) {
                return root;
            }
            while (!path[best].isDecendent(node)) {
                --best;
            }
        }
        return path[best];
    }

    public static FDSComposite getParentFromRoot(FDSObject child, FDSComposite root) {
        if (root.contains(child)) {
            return root;
        }
        for (FDSComposite compChild : root.d_compSet) {
            FDSComposite recursiveResult = FDSComposite.getParentFromRoot(child, compChild);
            if (recursiveResult == null) continue;
            return recursiveResult;
        }
        return null;
    }

    public static FDSComposite[] getPath(FDSObject child, FDSComposite root) {
        LinkedList<FDSComposite> pathList = new LinkedList<FDSComposite>();
        FDSComposite.getPath(child, pathList);
        if (pathList.isEmpty() || pathList.getFirst() != root) {
            return null;
        }
        return pathList.toArray(new FDSComposite[pathList.size()]);
    }

    private static void getPath(FDSObject child, LinkedList<FDSComposite> path) {
        FDSComposite parent = child.getParent();
        if (parent != null) {
            path.addFirst(parent);
            FDSComposite.getPath((FDSObject)parent, path);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.d_domainHelper == null) {
            this.d_domainHelper = new ADomainObject();
        }
        this.clearIndexCache();
        if (stream instanceof PyroSimObjectInputStream) {
            PyroSimObjectInputStream str = (PyroSimObjectInputStream)stream;
            if (str.getVersion() < 15) {
                this.ensureKeyed();
                this.d_compSet = new HashSet<FDSComposite>();
                this.d_obstSet = new HashSet<FDSObject>();
                for (FDSObject o : this.d_members) {
                    if (o instanceof FDSComposite) {
                        this.d_compSet.add((FDSComposite)o);
                        continue;
                    }
                    this.d_obstSet.add(o);
                }
            }
            if (str.getVersion() < 19) {
                for (FDSObject child : this.d_members) {
                    child.setParent(this);
                }
            }
        }
    }

    @Override
    public boolean addEvent(ActivationEvent evt) {
        return true;
    }

    @Override
    public boolean removeEvent(ActivationEvent evt) {
        return true;
    }

    @Override
    public void removeAllEvents() {
    }

    @Override
    public void removeEvents(int type) {
    }

    @Override
    public ActivationEventList getEventsOfType(int type) {
        return AbstractActivationEventList.createNewList(type, this.getDomains());
    }

    @Override
    public ActivationEvent[] getAllEvents() {
        return new ActivationEvent[0];
    }

    @Override
    public Vector getEventsSeparatedByType() {
        return new Vector(0);
    }

    @Override
    public void setCanBeTriggeredByAnyHeatDetector(boolean canBeTriggeredByAny, int action) {
    }

    @Override
    public boolean getCanBeTriggeredByAnyHeatDetector(int action) {
        return false;
    }

    @Override
    public String getPropertyHashString() {
        return "";
    }

    @Override
    public Map getEventInputRecordMap(int eventType) {
        return new TreeMap();
    }

    @Override
    public Collection getEventInputRecords(FDSInputRecord baseRecord) {
        return new Vector(0);
    }

    public void sortMembers() {
        FDSObject[] objArr = new FDSObject[this.d_members.size()];
        this.d_members.toArray(objArr);
        Arrays.sort(objArr, new FDSObjectComparator());
        this.d_members.clear();
        for (int i = 0; i < objArr.length; ++i) {
            this.d_members.add(objArr[i]);
        }
        this.clearIndexCache();
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 2));
    }

    @Override
    public String getTypeDescription() {
        return "FDS Object Group";
    }

    @Override
    public void getObjectsDependedOn(Set<IDependedOn> dependencies, Class<IDependedOn> type) {
        for (FDSObject o : this.d_members) {
            o.getObjectsDependedOn(dependencies, type);
        }
    }

    @Override
    public boolean dependsOnObject(IDependedOn depOn) {
        for (FDSObject o : this.d_members) {
            if (!o.dependsOnObject(depOn)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Task taskUpdateAfterDependedOnReplaced(final IDependedOn old, final IDependedOn replacement) {
        return new CompositeTask<PyroMod>(this.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                for (FDSObject o : FDSComposite.this.d_members) {
                    this.addTask(o.taskUpdateAfterDependedOnReplaced(old, replacement));
                }
            }
        };
    }

    @Override
    public Task taskUpdateBeforeDependedOnRenamed(final IDependedOn dep, final String newID) {
        return new CompositeTask<PyroMod>(this.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                for (FDSObject o : FDSComposite.this.d_members) {
                    this.addTask(o.taskUpdateBeforeDependedOnRenamed(dep, newID));
                }
            }
        };
    }

    @Override
    public Task taskUpdateAfterDependedOnChanged(final IDependedOn dep, final Object info) {
        return new CompositeTask<PyroMod>(this.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                for (FDSObject o : FDSComposite.this.d_members) {
                    this.addTask(o.taskUpdateAfterDependedOnChanged(dep, info));
                }
            }
        };
    }

    @Override
    public Class<FDSObject> getVClass() {
        return FDSObject.class;
    }

    @Override
    public Class<Integer> getKClass() {
        return Integer.class;
    }

    @Override
    public boolean canMakeUnique(FDSObject pyroObject) {
        return false;
    }

    public boolean willReplaceIfAdded(FDSObject pyroObject) {
        return false;
    }

    @Override
    public String describeObject(FDSObject pyroObject) {
        return pyroObject.getName();
    }

    @Override
    public FDSObject get(FDSObject pyroObject) {
        return null;
    }

    @Override
    public Task taskMakeUnique(FDSObject pyroObject) {
        return null;
    }

    public Task taskAdd(FDSObject pyroObject, int index) {
        return this.taskAddAll(Arrays.asList(pyroObject), index);
    }

    public Task taskAddAll(Collection<? extends FDSObject> objs, int index) {
        return new APyroManAddAtIndexTask<Integer, FDSObject>((IPyroManager)this, objs, index){

            @Override
            public void removeAll(Collection<? extends FDSObject> objs) {
                FDSComposite.this.removeAll(objs);
            }

            @Override
            public boolean add(FDSObject obj, int index) {
                return FDSComposite.this.add(obj, index);
            }
        };
    }

    @Override
    public Task taskAdd(FDSObject pyroObject) {
        return this.taskAddAll((Collection<? extends FDSObject>)Arrays.asList(pyroObject));
    }

    @Override
    public Task taskAddAll(Collection<? extends FDSObject> pyroObjects) {
        return new APyroManAddTask<Integer, FDSObject>((IPyroManager)this, pyroObjects){

            @Override
            public boolean add(FDSObject obj) {
                return FDSComposite.this.add(obj);
            }

            @Override
            public boolean remove(FDSObject obj) {
                return FDSComposite.this.remove(obj);
            }
        };
    }

    @Override
    public Task taskRemove(FDSObject pyroObject, FDSObject replacement) {
        return this.taskRemoveAll(Arrays.asList(pyroObject), Arrays.asList(replacement));
    }

    @Override
    public Task taskRemoveAll(List<FDSObject> pyroObjects, List<FDSObject> replacements) {
        return new APyroManReplaceTask<Integer, FDSObject>((IPyroManager)this, pyroObjects, replacements){

            @Override
            public boolean add(FDSObject obj) {
                return FDSComposite.this.add(obj);
            }

            @Override
            public boolean remove(FDSObject obj) {
                return FDSComposite.this.remove(obj);
            }
        };
    }

    public Task taskRemove(int index) {
        return this.taskRemoveAll(Arrays.asList(index));
    }

    public Task taskRemoveAll(Collection<Integer> indexes) {
        return new ARemoveAtIndexTask<Integer, FDSObject>((IPyroManager)this, indexes){

            @Override
            public FDSObject remove(int index) {
                return FDSComposite.this.remove(index);
            }

            @Override
            public void add(FDSObject obj, int index) {
                FDSComposite.this.add(obj, index);
            }
        };
    }

    @Override
    public void addDomain(PyroMod owner) {
        this.d_domainHelper.addDomain(owner);
        for (FDSObject obj : this) {
            obj.addDomain(owner);
        }
    }

    @Override
    public void removeDomain(PyroMod owner) {
        this.d_domainHelper.removeDomain(owner);
        for (FDSObject obj : this) {
            obj.removeDomain(owner);
        }
    }

    @Override
    public Set<PyroMod> getDomains() {
        return this.d_domainHelper.getDomains();
    }

    public static Collection<FDSObject> collectAllObjects(Collection<? extends FDSObject> objs) {
        HashSet<FDSObject> allObjs = new HashSet<FDSObject>(objs.size());
        FDSComposite.collectAllObjects(objs, allObjs);
        return allObjs;
    }

    public static void collectAllObjects(Collection<? extends FDSObject> objs, Collection<FDSObject> allObjs) {
        for (FDSObject fDSObject : objs) {
            allObjs.add(fDSObject);
            if (!(fDSObject instanceof FDSComposite)) continue;
            FDSComposite.collectAllObjects(((FDSComposite)fDSObject).toCollection(), allObjs);
        }
    }

    @Override
    public boolean isRasterizable() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }

    private class FDSObjectComparator
    implements Comparator {
        private FDSObjectComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            assert (obj1 instanceof FDSObject);
            assert (obj2 instanceof FDSObject);
            if (obj1 instanceof FDSComposite && !(obj2 instanceof FDSComposite)) {
                return -1;
            }
            if (!(obj1 instanceof FDSComposite) && obj2 instanceof FDSComposite) {
                return 1;
            }
            return ((FDSObject)obj1).getName().compareToIgnoreCase(((FDSObject)obj2).getName());
        }
    }

    private static class OrderedObject {
        public Integer d_index;
        public FDSObject d_obj;

        public OrderedObject(FDSObject obj, Integer index) {
            this.d_index = index;
            this.d_obj = obj;
        }
    }
}

