/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.Obstruction;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDSObjParser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.MoveParser;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.SolidGeom;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.io.LEDataInputStream;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Pair;

public class GeomParser
extends AFDSObjParser {
    private final Map<String, Pair<IGeomNode, Surface[]>> d_components = new LinkedHashMap<String, Pair<IGeomNode, Surface[]>>();
    private final MoveParser d_move;
    private Double d_meshDx;

    public GeomParser(FDS6ParsingInfo parsingInfo, MoveParser move) {
        super(parsingInfo);
        this.d_move = move;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("GEOM");
        types.add("MESH");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        if (rec.getType().equals("MESH")) {
            UnitPoint3D[] xb = GeomParser.parseXB(rec, "MESH", "XB", true);
            FDSArray ijk = rec.getArray("IJK", true);
            this.d_meshDx = (xb[1].x() - xb[0].x()) / (double)((Integer)ijk.get(0)).intValue();
            return true;
        }
        String id = rec.getString("ID");
        if (id == null) {
            id = "Geom";
        }
        IGeom geom = EmptyGeom.INSTANCE;
        Surface[] surfs = new Surface[]{};
        if (rec.contains("BINARY_FILE")) {
            Pair<IGeom, Surface[]> binResult = this.parseBinaryFile(rec);
            geom = (IGeom)binResult.v1;
            surfs = (Surface[])binResult.v2;
        } else if (GeomParser.isBlock(rec)) {
            Pair<IGeom, Surface[]> blockResult = this.parseBlock(rec);
            geom = (IGeom)blockResult.v1;
            surfs = (Surface[])blockResult.v2;
        } else if (GeomParser.isSphere(rec)) {
            Pair<IGeom, Surface[]> sphereResult = this.parseSphere(rec);
            geom = (IGeom)sphereResult.v1;
            surfs = (Surface[])sphereResult.v2;
        } else if (GeomParser.isCylinder(rec)) {
            Pair<IGeom, Surface[]> cylinderResult = this.parseCylinder(rec);
            geom = (IGeom)cylinderResult.v1;
            surfs = (Surface[])cylinderResult.v2;
        } else if (GeomParser.isExtrudedPoly(rec)) {
            Pair<IGeom, Surface[]> extrudedPolyResult = this.parseExtrudedPolygon(rec);
            geom = (IGeom)extrudedPolyResult.v1;
            surfs = (Surface[])extrudedPolyResult.v2;
        } else {
            Pair<IGeom, Surface[]> unstructuredSolid = this.parseUnstructuredSolid(rec);
            geom = (IGeom)unstructuredSolid.v1;
            surfs = (Surface[])unstructuredSolid.v2;
        }
        ITransform xform = TransformUtil.IDENTITY;
        String idMove = rec.getString("MOVE_ID");
        if (idMove != null && (xform = this.d_move.getTransform(idMove)) == null) {
            this.addWarning(new FDSParseWarning(rec, String.format(Intl.intl("The MOVE record, %s, does not exist."), idMove), String.format(Intl.intl("Ignoring unrecognized MOVE record for GEOM, %s."), id)));
        }
        GeomNodeLeaf geomNode = GeomNodeUtil.newNode(xform, geom, Elements.NONE);
        surfs = GeomUtil.optimize(surfs);
        this.d_components.put(id, new Pair<GeomNodeLeaf, Surface[]>(geomNode, surfs));
        Obstruction obst = new Obstruction(id, geomNode, surfs);
        obst.setOptions(128, true);
        this.parseCustomFDSProps(obst, rec);
        this.addObject(obst);
        return true;
    }

    private static void InitSphere2(int nLat, int nLong, List<Double> sphereVert, List<Integer> sphereFaces) {
        int iLong;
        int i;
        ArrayList<Double> cosLat = new ArrayList<Double>();
        ArrayList<Double> sinLat = new ArrayList<Double>();
        ArrayList<Double> cosLong = new ArrayList<Double>();
        ArrayList<Double> sinLong = new ArrayList<Double>();
        for (i = 1; i <= nLat; ++i) {
            double lat = 1.5707963267948966 - Math.PI * (double)(i - 1) / (double)(nLat - 1);
            cosLat.add(Math.cos(lat));
            sinLat.add(Math.sin(lat));
        }
        for (i = 1; i <= nLong; ++i) {
            double longitude = -Math.PI + Math.PI * 2 * (double)(i - 1) / (double)nLong;
            cosLong.add(Math.cos(longitude));
            sinLong.add(Math.sin(longitude));
        }
        sphereVert.add(0.0);
        sphereVert.add(0.0);
        sphereVert.add(1.0);
        for (i = 1; i < nLat - 1; ++i) {
            for (int j = 0; j < nLong; ++j) {
                sphereVert.add((Double)cosLong.get(j) * (Double)cosLat.get(i));
                sphereVert.add((Double)sinLong.get(j) * (Double)cosLat.get(i));
                sphereVert.add((Double)sinLat.get(i));
            }
        }
        sphereVert.add(0.0);
        sphereVert.add(0.0);
        sphereVert.add(-1.0);
        for (iLong = 0; iLong < nLong; ++iLong) {
            int I11 = iLong + 1;
            int I12 = iLong + 2;
            int I22 = 0;
            sphereFaces.add(I22);
            sphereFaces.add(I11);
            sphereFaces.add(iLong == nLong - 1 ? 1 : iLong + 2);
        }
        for (int iLat = 1; iLat < nLat - 2; ++iLat) {
            for (int iLong2 = 0; iLong2 < nLong; ++iLong2) {
                int i11 = 1 + iLong2 + nLong * iLat;
                int i21 = i11 + 1;
                int i12 = 1 + iLong2 + nLong * (iLat - 1);
                int i22 = i12 + 1;
                if (iLong2 == nLong - 1) {
                    i21 = 1 + nLong * iLat;
                    i22 = 1 + nLong * (iLat - 1);
                }
                sphereFaces.add(i12);
                sphereFaces.add(i11);
                sphereFaces.add(i22);
                sphereFaces.add(i22);
                sphereFaces.add(i11);
                sphereFaces.add(i21);
            }
        }
        for (iLong = 0; iLong < nLong; ++iLong) {
            int i11 = iLong + 1 + nLong * (nLat - 3);
            int i12 = iLong == nLong - 1 ? 1 + nLong * (nLat - 3) : i11 + 1;
            int i22 = nLong * (nLat - 2) + 1;
            sphereFaces.add(i11);
            sphereFaces.add(i22);
            sphereFaces.add(i12);
        }
    }

    private static void InitSphere(int nLevels, int maxFaces, int maxVerts, List<Double> sphereVerts, List<Integer> sphereFaces) {
        double ARG;
        int i;
        vertsAndFaces vf = new vertsAndFaces();
        sphereVerts.add(0.0);
        sphereVerts.add(0.0);
        sphereVerts.add(1.0);
        double[] VERT = new double[]{0.0, 0.0, 0.0};
        int[] FACE_LIST = new int[]{0, 1, 2, 0, 2, 3, 0, 3, 4, 0, 4, 5, 0, 5, 1, 1, 6, 2, 2, 6, 7, 2, 7, 3, 3, 7, 8, 3, 8, 4, 4, 8, 9, 4, 9, 5, 5, 9, 10, 5, 10, 1, 1, 10, 6, 11, 7, 6, 11, 8, 7, 11, 9, 8, 11, 10, 9, 11, 6, 10};
        for (i = 2; i <= 6; ++i) {
            ARG = (i - 2) * 72;
            ARG = Math.PI * 2 * ARG / 360.0;
            VERT[0] = Math.cos(ARG);
            VERT[1] = Math.sin(ARG);
            VERT[2] = 1.0 / Math.sqrt(5.0);
            double NormVert = GeomParser.norm2(VERT);
            sphereVerts.add(VERT[0] / NormVert);
            sphereVerts.add(VERT[1] / NormVert);
            sphereVerts.add(VERT[2] / NormVert);
        }
        for (i = 7; i <= 11; ++i) {
            ARG = 36.0 + (double)(i - 7) * 72.0;
            ARG = Math.PI * 2 * ARG / 360.0;
            VERT[0] = Math.cos(ARG);
            VERT[1] = Math.sin(ARG);
            VERT[2] = -1.0 / Math.sqrt(5.0);
            double NormVert2 = GeomParser.norm2(VERT);
            sphereVerts.add(VERT[0] / NormVert2);
            sphereVerts.add(VERT[1] / NormVert2);
            sphereVerts.add(VERT[2] / NormVert2);
        }
        sphereVerts.add(0.0);
        sphereVerts.add(0.0);
        sphereVerts.add(-1.0);
        for (int face : FACE_LIST) {
            sphereFaces.add(face);
        }
        for (int i2 = 0; i2 < 20; ++i2) {
            GeomParser.refineFace(nLevels, i2, maxFaces, maxVerts, vf, sphereVerts, sphereFaces);
        }
    }

    private static void refineFace(int nLevels, int IFace2, int maxFaces, int maxVerts, vertsAndFaces vf, List<Double> sphereVerts, List<Integer> sphereFaces) {
        if (nLevels == 0 || vf.getFaces() + 3 > maxFaces || vf.getVerts() + 3 > maxVerts) {
            return;
        }
        int[] face1 = new int[]{sphereFaces.get(3 * IFace2), sphereFaces.get(3 * IFace2 + 1), sphereFaces.get(3 * IFace2 + 2)};
        double[] v1 = new double[]{sphereVerts.get(3 * face1[0]), sphereVerts.get(3 * face1[0] + 1), sphereVerts.get(3 * face1[0] + 2)};
        double[] v2 = new double[]{sphereVerts.get(3 * face1[1]), sphereVerts.get(3 * face1[1] + 1), sphereVerts.get(3 * face1[1] + 2)};
        double[] v3 = new double[]{sphereVerts.get(3 * face1[2]), sphereVerts.get(3 * face1[2] + 1), sphereVerts.get(3 * face1[2] + 2)};
        double[] v12 = new double[]{(v1[0] + v2[0]) / 2.0, (v1[1] + v2[1]) / 2.0, (v1[2] + v2[2]) / 2.0};
        double[] v13 = new double[]{(v1[0] + v3[0]) / 2.0, (v1[1] + v3[1]) / 2.0, (v1[2] + v3[2]) / 2.0};
        double[] v23 = new double[]{(v2[0] + v3[0]) / 2.0, (v2[1] + v3[1]) / 2.0, (v2[2] + v3[2]) / 2.0};
        double norm2V12 = GeomParser.norm2(v12);
        double norm2V13 = GeomParser.norm2(v13);
        double norm2V23 = GeomParser.norm2(v23);
        int i = 0;
        while (i < 3) {
            int n = i;
            v12[n] = v12[n] / norm2V12;
            int n2 = i;
            v13[n2] = v13[n2] / norm2V13;
            int n3 = i++;
            v23[n3] = v23[n3] / norm2V23;
        }
        sphereVerts.add(v12[0]);
        sphereVerts.add(v12[1]);
        sphereVerts.add(v12[2]);
        sphereVerts.add(v13[0]);
        sphereVerts.add(v13[1]);
        sphereVerts.add(v13[2]);
        sphereVerts.add(v23[0]);
        sphereVerts.add(v23[1]);
        sphereVerts.add(v23[2]);
        int[] face2 = new int[]{vf.getVerts(), face1[1], vf.getVerts() + 2};
        int[] face3 = new int[]{vf.getVerts(), vf.getVerts() + 2, vf.getVerts() + 1};
        int[] face4 = new int[]{vf.getVerts() + 1, vf.getVerts() + 2, face1[2]};
        sphereFaces.set(3 * IFace2, face1[0]);
        sphereFaces.set(3 * IFace2 + 1, vf.getVerts());
        sphereFaces.set(3 * IFace2 + 2, vf.getVerts() + 1);
        sphereFaces.add(face2[0]);
        sphereFaces.add(face2[1]);
        sphereFaces.add(face2[2]);
        sphereFaces.add(face3[0]);
        sphereFaces.add(face3[1]);
        sphereFaces.add(face3[2]);
        sphereFaces.add(face4[0]);
        sphereFaces.add(face4[1]);
        sphereFaces.add(face4[2]);
        int n1 = IFace2;
        int n2 = vf.getFaces();
        int n3 = vf.getFaces() + 1;
        int n4 = vf.getFaces() + 2;
        vf.setFaces(vf.getFaces() + 3);
        vf.setVerts(vf.getVerts() + 3);
        if (nLevels == 1) {
            return;
        }
        GeomParser.refineFace(nLevels - 1, n1, maxFaces, maxVerts, vf, sphereVerts, sphereFaces);
        GeomParser.refineFace(nLevels - 1, n2, maxFaces, maxVerts, vf, sphereVerts, sphereFaces);
        GeomParser.refineFace(nLevels - 1, n3, maxFaces, maxVerts, vf, sphereVerts, sphereFaces);
        GeomParser.refineFace(nLevels - 1, n4, maxFaces, maxVerts, vf, sphereVerts, sphereFaces);
    }

    /*
     * Unable to fully structure code
     */
    private static void defineCylinder(FDSArray<Double> cylinderAxis, double cylinderLength, Integer cylinderNsegAxis, Integer cylinderNsegTheta, List<Double> verts, List<Integer> faces, int[][] surfaceList, UnitDouble cylinderRadius, UnitPoint3D cylinderOrigin) {
        block18: {
            block19: {
                block17: {
                    ex = new double[]{1.0, 0.0, 0.0};
                    e1 = new double[3];
                    e2 = new double[3];
                    e3 = new double[3];
                    twoEpsilonEB = 9.9E-324;
                    v0 = new int[]{1};
                    if (!(Math.abs(cylinderAxis.get(v0)) < twoEpsilonEB)) break block17;
                    v1 = new int[]{2};
                    if (!(Math.abs(cylinderAxis.get(v1)) < twoEpsilonEB)) break block17;
                    e1 = (double[])ex.clone();
                    e2[0] = 0.0;
                    e2[1] = 1.0;
                    e2[2] = 0.0;
                    e3[0] = 0.0;
                    e3[1] = 0.0;
                    e3[2] = 1.0;
                    break block18;
                }
                v2 = new int[]{2};
                if (!(Math.abs(cylinderAxis.get(v2)) < twoEpsilonEB)) break block19;
                v3 = new int[]{0};
                if (!(Math.abs(cylinderAxis.get(v3)) < twoEpsilonEB)) break block19;
                e3 = (double[])ex.clone();
                e1[0] = 0.0;
                e1[1] = 1.0;
                e1[2] = 0.0;
                e2[0] = 0.0;
                e2[1] = 0.0;
                e2[2] = 1.0;
                break block18;
            }
            v4 = new int[]{0};
            if (!(Math.abs(cylinderAxis.get(v4)) < twoEpsilonEB)) ** GOTO lbl-1000
            v5 = new int[]{1};
            if (Math.abs(cylinderAxis.get(v5)) < twoEpsilonEB) {
                e2 = (double[])ex.clone();
                e3[0] = 0.0;
                e3[1] = 1.0;
                e3[2] = 0.0;
                e1[0] = 0.0;
                e1[1] = 0.0;
                e1[2] = 1.0;
            } else lbl-1000:
            // 2 sources

            {
                norm = GeomParser.norm3(cylinderAxis);
                e1[0] = cylinderAxis.get(new int[]{0}) / norm;
                e1[1] = cylinderAxis.get(new int[]{1}) / norm;
                e1[2] = cylinderAxis.get(new int[]{2}) / norm;
                e2 = GeomParser.crossProduct(ex, e1);
                norm = GeomParser.norm3(e2);
                for (i = 0; i < 3; ++i) {
                    e2[i] = e2[i] / norm;
                }
                e3 = GeomParser.crossProduct(e1, e2);
            }
        }
        tgl = new double[3][3];
        for (i = 0; i < 3; ++i) {
            tgl[i][0] = e1[i];
            tgl[i][1] = e2[i];
            tgl[i][2] = e3[i];
        }
        npL = cylinderNsegAxis + 1;
        npT = cylinderNsegTheta;
        deltaL = cylinderLength / Double.valueOf(cylinderNsegAxis.intValue());
        deltaT = 6.283185307179586 / Double.valueOf(cylinderNsegTheta.intValue());
        pos1 = -cylinderLength / 2.0;
        pos2 = 0.0;
        pos3 = 0.0;
        verts.add(pos1);
        verts.add(pos2);
        verts.add(pos3);
        for (i = 1; i <= npL; ++i) {
            pos1 = -cylinderLength / 2.0 + (double)(i - 1) * deltaL;
            for (j = 1; j <= npT; ++j) {
                theta = (double)(j - 1) * deltaT;
                pos2 = cylinderRadius.getValue(SI.METER) * Math.cos(theta);
                pos3 = cylinderRadius.getValue(SI.METER) * Math.sin(theta);
                verts.add(pos1);
                verts.add(pos2);
                verts.add(pos3);
            }
        }
        pos1 = cylinderLength / 2.0;
        pos2 = 0.0;
        pos3 = 0.0;
        verts.add(pos1);
        verts.add(pos2);
        verts.add(pos3);
        nVerts = verts.size();
        iVert = 1;
        counter = 0;
        surfaceList[0][0] = counter + 1;
        for (i = 1; i <= npT; ++i) {
            if (i < npT) {
                I1 = 1 + i + 1;
                I2 = 1 + i;
                I3 = iVert;
            } else {
                I1 = iVert + 1;
                I2 = i + 1;
                I3 = iVert;
            }
            faces.add(I1 - 1);
            faces.add(I2 - 1);
            faces.add(I3 - 1);
            ++counter;
        }
        surfaceList[1][0] = counter;
        surfaceList[0][1] = counter + 1;
        for (i = 2; i <= npL; ++i) {
            for (j = 1; j <= npT; ++j) {
                if (j < npT) {
                    I1 = (i - 1) * npT + 1 + j - 1;
                    I2 = (i - 1) * npT + 1 + j + 1 - 1;
                    I3 = (i - 2) * npT + 1 + j - 1;
                    I4 = (i - 2) * npT + 1 + j + 1 - 1;
                } else {
                    I1 = (i - 1) * npT + 1 + j - 1;
                    I2 = (i - 1) * npT + 1 + 1 - 1;
                    I3 = (i - 2) * npT + 1 + j - 1;
                    I4 = (i - 2) * npT + 1 + 1 - 1;
                }
                faces.add(I1);
                faces.add(I3);
                faces.add(I2);
                faces.add(I3);
                faces.add(I4);
                faces.add(I2);
                counter += 2;
            }
        }
        surfaceList[1][1] = counter;
        surfaceList[0][2] = counter + 1;
        iVert = nVerts / 3;
        for (i = 1; i <= npT; ++i) {
            if (i < npT) {
                I1 = (npL - 1) * npT + 1 + i;
                I2 = (npL - 1) * npT + 1 + i + 1;
                I3 = iVert;
            } else {
                I1 = (npL - 1) * npT + 1 + i;
                I2 = (npL - 1) * npT + 1 + 1;
                I3 = iVert;
            }
            faces.add(I1 - 1);
            faces.add(I2 - 1);
            faces.add(I3 - 1);
            ++counter;
        }
        surfaceList[1][2] = counter;
        v = new double[3];
        r = new double[3];
        for (i = 0; i < nVerts; i += 3) {
            v[0] = verts.get(i);
            v[1] = verts.get(i + 1);
            v[2] = verts.get(i + 2);
            r = GeomParser.matrixVectorTransform(tgl, v);
            verts.set(i, r[0] + cylinderOrigin.x(SI.METER));
            verts.set(i + 1, r[1] + cylinderOrigin.y(SI.METER));
            verts.set(i + 2, r[2] + cylinderOrigin.z(SI.METER));
        }
    }

    private void defineExtrudedPoly(List<Integer> poly, List<Double> verts, UnitDouble extrude) throws FDSRecordFormatException {
        int i;
        int i2;
        ArrayList<Double> xyzCgen = new ArrayList<Double>();
        double geomeps = 1.0E-12;
        double[][] minMaxPos = new double[2][3];
        ArrayList<Double> pVerts = new ArrayList<Double>();
        double twoEpsilonEB = 9.9E-324;
        for (i2 = 0; i2 < 3; ++i2) {
            minMaxPos[0][i2] = 1.0 / geomeps;
            minMaxPos[1][i2] = -1.0 / geomeps;
        }
        for (i2 = 0; i2 < poly.size(); ++i2) {
            pVerts.add(verts.get(poly.get(3 * i2)));
            pVerts.add(verts.get(poly.get(3 * i2 + 1)));
            pVerts.add(verts.get(poly.get(3 * i2 + 2)));
            minMaxPos[0][0] = Math.min(minMaxPos[0][0], (Double)pVerts.get(3 * i2));
            minMaxPos[0][0] = Math.min(minMaxPos[0][1], (Double)pVerts.get(3 * i2 + 1));
            minMaxPos[0][0] = Math.min(minMaxPos[0][2], (Double)pVerts.get(3 * i2 + 2));
            minMaxPos[0][0] = Math.max(minMaxPos[1][0], (Double)pVerts.get(3 * i2));
            minMaxPos[0][0] = Math.max(minMaxPos[1][1], (Double)pVerts.get(3 * i2 + 1));
            minMaxPos[0][0] = Math.max(minMaxPos[1][2], (Double)pVerts.get(3 * i2 + 2));
        }
        for (i2 = 0; i2 < 3; ++i2) {
            pVerts.add((Double)pVerts.get(i2));
            xyzCgen.add(0.0);
        }
        for (i2 = 0; i2 < poly.size(); ++i2) {
            xyzCgen.set(0, (Double)xyzCgen.get(0) + (Double)pVerts.get(3 * i2));
            xyzCgen.set(1, (Double)xyzCgen.get(1) + (Double)pVerts.get(3 * i2 + 1));
            xyzCgen.set(2, (Double)xyzCgen.get(2) + (Double)pVerts.get(3 * i2 + 2));
        }
        for (i2 = 0; i2 < xyzCgen.size(); ++i2) {
            xyzCgen.set(i2, (Double)xyzCgen.get(i2) / (double)poly.size());
        }
        double[] nVec = new double[]{0.0, 0.0, 0.0};
        for (int i3 = 0; i3 < poly.size(); ++i3) {
        }
        double[] dv1 = new double[3];
        double[] dv2 = new double[3];
        for (int i4 = 0; i4 < poly.size(); ++i4) {
            int j;
            for (j = 0; j < 3; ++j) {
                dv1[j] = (Double)pVerts.get(3 * i4 + j) - (Double)xyzCgen.get(j);
            }
            for (j = 0; j < 3; ++j) {
                dv2[j] = dv1[i4] - this.dotProduct(dv1, nVec);
            }
            double[] n = GeomParser.crossProduct(dv1, dv2);
            for (int j2 = 0; j2 < 3; ++j2) {
                int n2 = j2;
                nVec[n2] = nVec[n2] + n[j2];
            }
        }
        double nVecNorm = GeomParser.norm3(nVec);
        if (nVecNorm > twoEpsilonEB) {
            int i5 = 0;
            while (i5 < 3) {
                int n = i5++;
                nVec[n] = nVec[n] / nVecNorm;
            }
        }
        double bbLen = Math.sqrt(minMaxPos[1][0] - minMaxPos[0][0] * minMaxPos[0][0] + minMaxPos[1][1] - minMaxPos[0][1] * minMaxPos[0][1] + minMaxPos[1][2] - minMaxPos[0][2] * minMaxPos[0][2]);
        double thLen = 0.05 * bbLen;
        for (i = 0; i < poly.size(); ++i) {
            for (int j = 0; j < 3; ++j) {
                dv1[i] = (Double)pVerts.get(3 * i + j) - (Double)xyzCgen.get(i);
            }
            if (!(Math.abs(this.dotProduct(dv1, nVec)) > thLen)) continue;
            throw new FDSRecordFormatException("Extruded polygon GEOM: Node (" + poly.get(i) + " not in the plane of the polygon. Check VERTS");
        }
        for (i = 0; i < poly.size(); ++i) {
            for (int j = 0; j < 3; ++j) {
                dv1[i] = (Double)pVerts.get(3 * i + j) - (Double)xyzCgen.get(i);
            }
            double dotProduct = this.dotProduct(dv1, nVec);
            for (int j = 0; j < 3; ++j) {
                dv2[j] = dv1[j] - dotProduct * nVec[j];
                pVerts.add((Double)xyzCgen.get(j) + dv2[j]);
            }
        }
        double[] pVec = new double[3];
        if (Math.abs(nVec[0]) > twoEpsilonEB || Math.abs(nVec[1]) > twoEpsilonEB) {
            pVec = new double[]{nVec[1], -nVec[0], 0.0};
        }
        if (Math.abs(nVec[0]) < twoEpsilonEB && Math.abs(nVec[1]) < twoEpsilonEB) {
            pVec = new double[]{nVec[2], 0.0, -nVec[0]};
        }
        double pVecNorm = GeomParser.norm3(pVec);
        int i6 = 0;
        while (i6 < 3) {
            int n = i6++;
            pVec[n] = pVec[n] / pVecNorm;
        }
        for (i6 = poly.size(); i6 < 2 * poly.size(); ++i6) {
            int ip1 = i6 + 1;
            if (i6 != 2 * poly.size() - 1) continue;
            ip1 = poly.size();
        }
    }

    private static double norm2(double[] verts) {
        return Math.sqrt(verts[0] * verts[0] + verts[1] * verts[1] + verts[2] * verts[2]);
    }

    private static double norm3(FDSArray<Double> axis) {
        return Math.sqrt(axis.get(0) * axis.get(0) + axis.get(1) * axis.get(1) + axis.get(2) * axis.get(2));
    }

    private static double norm3(double[] axis) {
        return Math.sqrt(axis[0] * axis[0] + axis[1] * axis[1] + axis[2] * axis[2]);
    }

    private static double[] crossProduct(double[] v1, double[] v2) {
        Vector3d t1 = new Vector3d(v1);
        Vector3d t2 = new Vector3d(v2);
        t1.cross(t1, t2);
        double[] result = new double[]{t1.x, t1.y, t1.z};
        return result;
    }

    private double dotProduct(double[] v1, double[] v2) {
        double sum = 0.0;
        for (int i = 0; i < 3; ++i) {
            sum += v1[i] * v2[i];
        }
        return sum;
    }

    private static double[] matrixVectorTransform(double[][] tgl, double[] v) {
        double[] result = new double[3];
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 3; ++k) {
                int n = j;
                result[n] = result[n] + tgl[j][k] * v[k];
            }
        }
        return result;
    }

    private Pair<IGeom, Surface[]> parseBinaryFile(FDSParseRecord rec) throws FDSRecordFormatException {
        String fdsFilename = super.getParsingInfo().getParsingFile();
        File dirPath = new File(fdsFilename).getParentFile();
        File bingeom = new File(dirPath, rec.getString("BINARY_FILE"));
        Point3d[] verts = null;
        int[] faceIndices = null;
        int[] surfIndices = null;
        try (LEDataInputStream ds = new LEDataInputStream(new FileInputStream(bingeom));){
            int i;
            ds.skipBytes(4);
            int geomType = ds.readInt();
            ds.skipBytes(8);
            int nVerts = ds.readInt();
            int nFaces = ds.readInt();
            ds.skipBytes(8);
            ds.skipBytes(8);
            verts = new Point3d[nVerts];
            for (int i2 = 0; i2 < nVerts; ++i2) {
                double x = ds.readDouble();
                double y = ds.readDouble();
                double z = ds.readDouble();
                verts[i2] = new Point3d(x, y, z);
            }
            ds.skipBytes(8);
            faceIndices = new int[3 * nFaces];
            int faceIndiceIter = 0;
            for (i = 0; i < nFaces; ++i) {
                faceIndices[faceIndiceIter++] = ds.readInt() - 1;
                faceIndices[faceIndiceIter++] = ds.readInt() - 1;
                faceIndices[faceIndiceIter++] = ds.readInt() - 1;
            }
            ds.skipBytes(8);
            surfIndices = new int[nFaces];
            for (i = 0; i < nFaces; ++i) {
                surfIndices[i] = ds.readInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("The %s record cannot be read."), "BINARY_FILE"));
        }
        SolidGeom geom = new SolidGeom(new Mesh(verts, faceIndices, 2));
        Surface[] surfs = this.getSurfArray(this.getUniqueSurfs(rec), surfIndices);
        return new Pair<IGeom, Surface[]>(geom, surfs);
    }

    private List<Surface> getUniqueSurfs(FDSParseRecord rec) throws FDSRecordFormatException {
        List names = rec.getList("SURF_ID", true);
        Predicate<Surface> filter = Obstruction.getSurfaceFilter();
        ArrayList<Surface> uniqueSurfs = new ArrayList<Surface>(names.size());
        for (String name : names) {
            uniqueSurfs.add(this.getSurfaceSafe(rec, name, filter));
        }
        return uniqueSurfs;
    }

    private Surface[] getSurfArray(List<Surface> uniqueSurfs, int[] surfIxs) {
        Surface[] surfs = new Surface[surfIxs.length];
        for (int i = 0; i < surfIxs.length; ++i) {
            surfs[i] = surfIxs[i] == 0 ? this.getDefaultMat() : uniqueSurfs.get(surfIxs[i] - 1);
        }
        return surfs;
    }

    private Pair<IGeom, Surface[]> parseBlock(FDSParseRecord rec) throws FDSRecordFormatException {
        AABoxGeom geom = GeomParser.parseXBGeom(rec, "GEOM", "XB", true);
        Surface[] surfs = this.getSurfs(rec);
        return new Pair<IGeom, Surface[]>(geom, surfs);
    }

    private Surface[] getSurfs(FDSParseRecord rec) throws FDSRecordFormatException {
        FDSArray surfIDs;
        Predicate<Surface> surfFilter = Obstruction.getSurfaceFilter();
        Surface[] surfs = null;
        if (rec.contains("SURF_ID")) {
            List names = rec.getList("SURF_ID", true);
            Surface surf = this.getSurfaceSafe(rec, (String)names.get(0), surfFilter);
            surfs = new Surface[]{surf};
        } else if (rec.contains("SURF_IDS")) {
            surfIDs = rec.getArray("SURF_IDS", false);
            surfs = new Surface[]{this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(2), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(0), surfFilter)};
        } else if (rec.contains("SURF_ID6")) {
            surfIDs = rec.getArray("SURF_ID6", false);
            surfs = new Surface[]{this.getSurfaceSafe(rec, (String)surfIDs.get(0), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(2), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(3), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(4), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(5), surfFilter)};
        } else {
            Surface defSurf = this.getDefaultMat();
            surfs = new Surface[]{defSurf};
        }
        if (surfs.length > 1 && GeomUtil.isUniform(surfs)) {
            surfs = new Surface[]{surfs[0]};
        }
        if (surfs.length == 1) {
            return surfs;
        }
        Surface[] finalSurfs = new Surface[]{surfs[0], surfs[1], surfs[2], surfs[3], surfs[4], surfs[5]};
        return finalSurfs;
    }

    private Pair<IGeom, Surface[]> parseSphere(FDSParseRecord rec) throws FDSRecordFormatException {
        int sphereType;
        Surface[] surfs = null;
        if (rec.contains("SURF_IDS") || rec.contains("SURF_ID6")) {
            String errorRec = rec.contains("SURF_IDS") ? "SURF_IDS" : "SURF_ID6";
            this.addWarning(rec, String.format(Intl.intl("Spherical GEOM records do not support %s."), errorRec), String.format(Intl.intl("%s dropped from record."), errorRec));
            surfs = new Surface[]{this.getDefaultMat()};
        } else if (rec.contains("SURF_ID")) {
            Predicate<Surface> surfFilter = Obstruction.getSurfaceFilter();
            List names = rec.getList("SURF_ID", true);
            Surface surf = this.getSurfaceSafe(rec, (String)names.get(0), surfFilter);
            surfs = new Surface[]{surf};
        }
        UnitPoint3D sphereOrigin = GeomParser.parseLoc(rec, "GEOM", "SPHERE_ORIGIN", true);
        UnitDouble sphereRadius = rec.getUnitDouble("SPHERE_RADIUS");
        if (sphereRadius == null) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("%s is missing in a geom record."), "SPHERE_RADIUS"));
        }
        Integer nLevels = rec.getInteger("N_LEVELS");
        Integer nLat = rec.getInteger("N_LAT");
        Integer nLong = rec.getInteger("N_LONG");
        if (nLevels == null && (nLat == null || nLong == null)) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("Either a %s or a combination of %s and %s is missing in a geom record."), "N_LEVELS", "N_LAT", "N_LONG"));
        }
        int nFaces = 0;
        int n = sphereType = nLevels == null && nLat > 0 && nLong > 0 ? 2 : 1;
        if (sphereType == 1) {
            if (nLevels == -1) {
                nLevels = (int)(Math.log(Math.PI * 2 * sphereRadius.getValue(SI.METER) / (5.0 * this.d_meshDx)) / Math.log(2.0));
            }
            nLevels = Math.min(7, Math.max(0, nLevels));
            nFaces = (int)(20.0 * (Math.pow(4.0, nLevels.intValue()) + 1.0));
        } else {
            if (nLong < 6) {
                nLong = Math.max(6, (int)(Math.PI * 2 * sphereRadius.getValue(SI.METER) / this.d_meshDx) + 1);
            }
            if (nLat < 3) {
                nLat = Math.max(3, (int)(Math.PI * sphereRadius.getValue(SI.METER) / this.d_meshDx) + 1);
            }
            nFaces = 2 * nLat * nLong;
        }
        ArrayList<Double> sphereVerts = new ArrayList<Double>();
        ArrayList<Integer> sphereFaces = new ArrayList<Integer>();
        int maxFaces = nFaces;
        maxFaces = Math.max(maxFaces, 24000);
        int maxVerts = Math.max(24000, 3 * maxFaces);
        if (sphereType == 1) {
            GeomParser.InitSphere(nLevels, maxFaces, maxVerts, sphereVerts, sphereFaces);
        } else {
            GeomParser.InitSphere2(nLat, nLong, sphereVerts, sphereFaces);
        }
        double sphere_radius = sphereRadius.getValue(SI.METER);
        Point3d origin = sphereOrigin.getValue(SI.METER);
        Point3d[] verts = new Point3d[sphereVerts.size() / 3];
        int m = 0;
        while (m < sphereVerts.size()) {
            int vix = m / 3;
            verts[vix] = new Point3d(origin.x + sphere_radius * (Double)sphereVerts.get(m++), origin.y + sphere_radius * (Double)sphereVerts.get(m++), origin.z + sphere_radius * (Double)sphereVerts.get(m++));
        }
        int[] indicies = new int[sphereFaces.size()];
        for (int i = 0; i < sphereFaces.size(); ++i) {
            indicies[i] = (Integer)sphereFaces.get(i);
        }
        SolidGeom geom = new SolidGeom(new Mesh(verts, indicies, 2));
        return new Pair<IGeom, Surface[]>(geom, surfs);
    }

    private Pair<IGeom, Surface[]> parseCylinder(FDSParseRecord rec) throws FDSRecordFormatException {
        Surface[] surfs = null;
        Predicate<Surface> surfFilter = Obstruction.getSurfaceFilter();
        ArrayList<Surface> surfList = new ArrayList<Surface>();
        int[][] surfaceList = new int[2][3];
        UnitDouble cylinderLength = rec.getUnitDouble("CYLINDER_LENGTH");
        UnitDouble cylinderRadius = rec.getUnitDouble("CYLINDER_RADIUS");
        UnitPoint3D cylinderOrigin = GeomParser.parseLoc(rec, "GEOM", "CYLINDER_ORIGIN", true);
        FDSArray<Double> cylinderAxis = rec.getArray("CYLINDER_AXIS", true);
        Integer cylinderNsegTheta = rec.getInteger("CYLINDER_NSEG_THETA");
        Integer cylinderNsegAxis = rec.getInteger("CYLINDER_NSEG_AXIS");
        if (cylinderNsegAxis == null) {
            cylinderNsegAxis = 1;
        }
        if (cylinderNsegTheta == null) {
            cylinderNsegTheta = 8;
        }
        ArrayList<Double> verts = new ArrayList<Double>();
        ArrayList<Integer> faces = new ArrayList<Integer>();
        GeomParser.defineCylinder(cylinderAxis, cylinderLength.getValue(SI.METER), cylinderNsegAxis, cylinderNsegTheta, verts, faces, surfaceList, cylinderRadius, cylinderOrigin);
        if (rec.contains("SURF_ID6")) {
            this.addWarning(rec, String.format(Intl.intl("Cylindrical GEOM records do not support %s."), "SURF_ID6"), String.format(Intl.intl("%s dropped from record."), "SURF_ID6"));
            surfs = new Surface[]{this.getDefaultMat()};
        } else if (rec.contains("SURF_ID")) {
            List names = rec.getList("SURF_ID", true);
            Surface surf = this.getSurfaceSafe(rec, (String)names.get(0), surfFilter);
            surfs = new Surface[]{surf};
        } else if (rec.contains("SURF_IDS")) {
            int i;
            FDSArray surfIDs = rec.getArray("SURF_IDS", false);
            for (i = 1; i <= surfaceList[1][0]; ++i) {
                surfList.add(this.getSurfaceSafe(rec, (String)surfIDs.get(2), surfFilter));
            }
            for (i = surfaceList[0][1]; i <= surfaceList[1][1]; ++i) {
                surfList.add(this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter));
            }
            for (i = surfaceList[0][2]; i <= surfaceList[1][2]; ++i) {
                surfList.add(this.getSurfaceSafe(rec, (String)surfIDs.get(0), surfFilter));
            }
            surfs = new Surface[surfList.size()];
            for (i = 0; i < surfList.size(); ++i) {
                surfs[i] = (Surface)surfList.get(i);
            }
        }
        int[] indicies = new int[faces.size()];
        for (int i = 0; i < faces.size(); ++i) {
            indicies[i] = (Integer)faces.get(i);
        }
        Point3d[] verts3d = new Point3d[verts.size() / 3];
        int m = 0;
        while (m < verts.size()) {
            int vix = m / 3;
            verts3d[vix] = new Point3d((Double)verts.get(m++), (Double)verts.get(m++), (Double)verts.get(m++));
        }
        SolidGeom geom = new SolidGeom(new Mesh(verts3d, indicies, 2));
        return new Pair<IGeom, Surface[]>(geom, surfs);
    }

    private Pair<IGeom, Surface[]> parseExtrudedPolygon(FDSParseRecord rec) throws FDSRecordFormatException {
        int i;
        double geomEPS = 1.0E-12;
        UnitDouble extrude = rec.getUnitDouble("EXTRUDE");
        List poly = rec.getList("POLY", true);
        List verts = rec.getList("VERTS", true);
        Surface[] surfs = new Surface[]{this.getDefaultMat()};
        Predicate<Surface> surfFilter = Obstruction.getSurfaceFilter();
        if (rec.contains("SURF_ID6")) {
            this.addWarning(rec, String.format(Intl.intl("Extruded polygon GEOM records do not support %s."), "SURF_ID6"), String.format(Intl.intl("%s dropped from record."), "SURF_ID6"));
            surfs = new Surface[]{this.getDefaultMat()};
        } else if (rec.contains("SURF_ID")) {
            List names = rec.getList("SURF_ID", true);
            Surface surf = this.getSurfaceSafe(rec, (String)names.get(0), surfFilter);
            surfs = new Surface[]{surf};
        } else if (rec.contains("SURF_IDS")) {
            FDSArray surfIDs = rec.getArray("SURF_IDS", false);
            if (surfIDs.getTotalLength() != 3) {
                this.addWarning(rec, String.format(Intl.intl("%s only supports 3 elements."), "SURF_IDS"), String.format(Intl.intl("%s dropped from record."), "SURF_IDS"));
                surfs = new Surface[]{this.getDefaultMat()};
            } else {
                surfs = new Surface[poly.size() + 2];
                surfs[0] = this.getSurfaceSafe(rec, (String)surfIDs.get(0), surfFilter);
                surfs[1] = this.getSurfaceSafe(rec, (String)surfIDs.get(2), surfFilter);
                Surface rest = this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter);
                for (i = 2; i < surfs.length; ++i) {
                    surfs[i] = rest;
                }
            }
        }
        ArrayList<Point3d> vertPoints = new ArrayList<Point3d>();
        for (int i2 = 0; i2 < verts.size(); i2 += 3) {
            vertPoints.add(new Point3d((Double)verts.get(i2), (Double)verts.get(i2 + 1), (Double)verts.get(i2 + 2)));
        }
        if (Math.abs(extrude.get(SI.METER)) < geomEPS) {
            throw new FDSRecordFormatException("Extruded polygon GEOM: Extrusion distance in EXTRUDE field not defined or zero. Define EXTRUDE value in &GEOM.");
        }
        if (poly.size() > vertPoints.size()) {
            throw new FDSRecordFormatException("Extruded polygon GEOM: Number of POLY indexes (" + poly.size() + ") is greater than the number of VERTS (" + verts.size() + ").");
        }
        for (int j = 0; j < poly.size(); ++j) {
            for (i = j + 1; i < poly.size(); ++i) {
                if (poly.get(i) == poly.get(j)) {
                    throw new FDSRecordFormatException("Extruded polygon GEOM: Repeated vertex " + poly.get(i) + " in Polyline");
                }
                Vector3d v1 = Util3D.vector((Point3d)vertPoints.get((Integer)poly.get(i) - 1), (Point3d)vertPoints.get((Integer)poly.get(j) - 1));
                if (!(v1.length() < geomEPS)) continue;
                throw new FDSRecordFormatException("Extruded polygon GEOM: Vertices " + poly.get(i) + " and " + poly.get(j) + " have the same position");
            }
        }
        Point3d[] vertPointsArray = new Point3d[vertPoints.size()];
        for (i = 0; i < poly.size(); ++i) {
            vertPointsArray[i] = (Point3d)vertPoints.get((Integer)poly.get(i) - 1);
        }
        if (!Util3D.areCoplanar(0.001, vertPointsArray)) {
            throw new FDSRecordFormatException("Extruded polygon GEOM: not all verticies are on the same plane");
        }
        Plane3d polyPlane = Util3D.simplePolygonPlane(vertPoints, false, 0.001);
        if (polyPlane == null) {
            throw new FDSRecordFormatException("Extruded polygon GEOM: Issue with verts, check their definition");
        }
        IPolygon polyObj = PolyUtil.newPoly(vertPointsArray);
        Vector3d extrudeVec = polyPlane.getNormal();
        extrudeVec.scale(extrude.get(SI.METER));
        ExtrudedPoly extPoly = new ExtrudedPoly(polyObj, extrudeVec);
        return new Pair<IGeom, Surface[]>(extPoly, surfs);
    }

    private Pair<IGeom, Surface[]> parseUnstructuredSolid(FDSParseRecord rec) throws FDSRecordFormatException {
        List faces = rec.getList("FACES", true);
        List vertComps = rec.getList("VERTS", true);
        IGeom geom = EmptyGeom.INSTANCE;
        Surface[] surfs = new Surface[]{};
        List<Object> uniqueSurfs = new ArrayList();
        if (!faces.isEmpty() && !vertComps.isEmpty()) {
            int i;
            FDSArray surfIDs;
            if (rec.contains("SURF_ID")) {
                uniqueSurfs = this.getUniqueSurfs(rec);
            } else if (rec.contains("SURF_IDS")) {
                surfIDs = rec.getArray("SURF_IDS", false);
                i = 0;
                while (i < 3) {
                    uniqueSurfs.add(this.getSurfaceSafe(rec, (String)surfIDs.get(i++), Obstruction.getSurfaceFilter()));
                }
            } else if (rec.contains("SURF_ID6")) {
                surfIDs = rec.getArray("SURF_ID6", false);
                i = 0;
                while (i < 6) {
                    uniqueSurfs.add(this.getSurfaceSafe(rec, (String)surfIDs.get(i++), Obstruction.getSurfaceFilter()));
                }
            }
            Point3d[] verts = new Point3d[vertComps.size() / 3];
            int m = 0;
            while (m < vertComps.size()) {
                int vix = m / 3;
                verts[vix] = new Point3d((Double)vertComps.get(m++), (Double)vertComps.get(m++), (Double)vertComps.get(m++));
            }
            int nfaces = faces.size() / 4;
            surfs = new Surface[nfaces];
            int soffset = 0;
            int[] indices = new int[nfaces * 3];
            int ioffset = 0;
            int m2 = 0;
            while (m2 < faces.size()) {
                indices[ioffset++] = (Integer)faces.get(m2++) - 1;
                indices[ioffset++] = (Integer)faces.get(m2++) - 1;
                indices[ioffset++] = (Integer)faces.get(m2++) - 1;
                int isurf = (Integer)faces.get(m2++);
                surfs[soffset++] = isurf == 0 ? this.getDefaultMat() : (Surface)uniqueSurfs.get(isurf - 1);
            }
            geom = new SolidGeom(new Mesh(verts, indices, 2));
        }
        return new Pair<IGeom, Surface[]>(geom, surfs);
    }

    private static boolean isBlock(FDSParseRecord rec) {
        return rec.contains("XB");
    }

    private static boolean isSphere(FDSParseRecord rec) {
        return rec.contains("SPHERE_ORIGIN");
    }

    private static boolean isCylinder(FDSParseRecord rec) {
        return rec.contains("CYLINDER_LENGTH");
    }

    private static boolean isExtrudedPoly(FDSParseRecord rec) {
        return rec.contains("EXTRUDE");
    }

    private static class vertsAndFaces {
        private int nVerts = 12;
        private int nFaces = 20;

        private vertsAndFaces() {
        }

        public int getVerts() {
            return this.nVerts;
        }

        public int getFaces() {
            return this.nFaces;
        }

        public void setVerts(int v) {
            this.nVerts = v;
        }

        public void setFaces(int f) {
            this.nFaces = f;
        }
    }
}

