/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.controls.LatchCtrl;
import pyrosim.domain.controls.NotOp;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreezable;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.devices.detectors.HeatDetector;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.IDetector;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLink;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.hvac.DuctDevice;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.devices.hvac.NodeDevice;
import pyrosim.domain.devices.measurers.AABoxMeasurer;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.GaugeHeatFluxMeasurer;
import pyrosim.domain.devices.measurers.InnerTempMeasurer;
import pyrosim.domain.devices.measurers.LayerMeasurer;
import pyrosim.domain.devices.measurers.PathObscurationMeasurer;
import pyrosim.domain.devices.measurers.PressureCoeffMeasurer;
import pyrosim.domain.devices.measurers.SolidDensityMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.devices.sprayers.ASprayer;
import pyrosim.domain.devices.sprayers.Nozzle;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.Util;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.common.GeomUtil;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import pyrosim.io.fds.v6.parsers.PropParser;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitLineSeg3D;
import thunderheadeng.units.UnitPoint3D;

public class DeviceParser
extends AFDS6Parser {
    private final PinConnParser d_pinConns;
    private final PropParser d_propParser;
    private final List<FDSParseRecord> d_aspSamplerRecs = new ArrayList<FDSParseRecord>();
    private final Map<FDSParseRecord, Set<IDevice>> d_parsedDevices = new LinkedHashMap<FDSParseRecord, Set<IDevice>>();

    public DeviceParser(FDS6ParsingInfo parsingInfo, PinConnParser pinConns, PropParser propParser) {
        super(parsingInfo);
        this.d_pinConns = pinConns;
        this.d_propParser = propParser;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("DEVC");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        DeviceParser.getUnsupported(type, unsupportedFields);
    }

    public static void getUnsupported(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("CONVERSION_FACTOR", "UNSUPPORTED");
        unsupportedFields.put("COORD_FACTOR", "UNSUPPORTED");
        unsupportedFields.put("DRY", "UNSUPPORTED");
        unsupportedFields.put("EVACUATION", "UNSUPPORTED");
        unsupportedFields.put("HIDE_COORDINATES", "UNSUPPORTED");
        unsupportedFields.put("INIT_ID", "UNSUPPORTED");
        unsupportedFields.put("OUTPUT", "UNSUPPORTED");
        unsupportedFields.put("PIPE_INDEX", "UNSUPPORTED");
        unsupportedFields.put("QUANTITY2", "UNSUPPORTED");
        unsupportedFields.put("SMOOTHING_FACTOR", "UNSUPPORTED");
        unsupportedFields.put("STATISTICS_START", "UNSUPPORTED");
        unsupportedFields.put("TIME_AVERAGED", "UNSUPPORTED");
        unsupportedFields.put("UNITS", "UNSUPPORTED");
        unsupportedFields.put("VELO_INDEX", "UNSUPPORTED");
        unsupportedFields.put("X_ID", "UNSUPPORTED");
        unsupportedFields.put("Y_ID", "UNSUPPORTED");
        unsupportedFields.put("Z_ID", "UNSUPPORTED");
        unsupportedFields.put("CABLE_MASS_PER_LENGTH", "UNSUPPORTED");
        unsupportedFields.put("CABLE_DIAMETER", "UNSUPPORTED");
        unsupportedFields.put("CABLE_FAILURE_TEMPERATURE", "UNSUPPORTED");
        unsupportedFields.put("CABLE_JACKET_THICKNESS", "UNSUPPORTED");
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        return this.processDevc(rec);
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        for (FDSParseRecord rec : this.d_aspSamplerRecs) {
            String aspID = (String)rec.get("DEVC_ID");
            if (aspID == null) continue;
            String samplerID = (String)rec.get("ID");
            UnitDouble flowrate = (UnitDouble)rec.get("FLOWRATE", true);
            UnitDouble delay = (UnitDouble)rec.get("DELAY", true);
            AspiratorSampler sampler = (AspiratorSampler)this.getContainer().getDevices().get(samplerID);
            Aspirator asp = (Aspirator)this.getContainer().getDevices().get(aspID);
            if (asp == null) {
                throw new FDSRecordFormatException(rec, String.format(Intl.intl("Could not find aspirator: %s"), aspID));
            }
            asp.setSamplerLine(new Aspirator.SamplerLine(sampler, flowrate, delay));
        }
    }

    private IQuantity parseQuantity(FDSParseRecord devcRec, FDSParseRecord propRec, String failAction, boolean quantityRequired, boolean throwError) throws FDSRecordFormatException {
        String nodeIdKey;
        String ductIdKey;
        String matlIdKey;
        String specIdKey;
        String partIdKey;
        String quantKey;
        FDSParseRecord quantitySource = devcRec;
        String deviceType = (String)devcRec.get("QUANTITY", false);
        if (deviceType == null) {
            quantitySource = propRec;
            deviceType = (String)propRec.get("QUANTITY", false);
            if (deviceType == null) {
                return null;
            }
        }
        if (quantitySource.getType().equals("DEVC")) {
            quantKey = "QUANTITY";
            partIdKey = "PART_ID";
            specIdKey = "SPEC_ID";
            matlIdKey = "MATL_ID";
            ductIdKey = "DUCT_ID";
            nodeIdKey = "NODE_ID";
        } else {
            quantKey = "QUANTITY";
            partIdKey = "PART_ID";
            specIdKey = "SPEC_ID";
            matlIdKey = null;
            ductIdKey = null;
            nodeIdKey = null;
        }
        return this.parseQuantity(quantitySource, quantKey, partIdKey, specIdKey, matlIdKey, ductIdKey, nodeIdKey, 0L, failAction, quantityRequired, throwError, true);
    }

    protected boolean processDevc(FDSParseRecord devcRec) throws FDSRecordFormatException {
        FDSParseRecord propRec;
        String propID;
        String spacialStat = (String)devcRec.get("SPATIAL_STATISTIC", false);
        String temporalStat = (String)devcRec.get("TEMPORAL_STATISTIC", false);
        String legacyStat = (String)devcRec.get("STATISTICS", false);
        if (spacialStat != null || temporalStat != null || legacyStat != null) {
            return true;
        }
        Integer points = devcRec.getInteger("POINTS", false);
        boolean isTimeHistory = devcRec.getOptional("TIME_HISTORY").orElse(false);
        if (points != null && !isTimeHistory) {
            return true;
        }
        boolean idFab = false;
        String id = (String)devcRec.get("ID");
        if (id == null || id.trim().equals("")) {
            id = this.getNames(IDevice.class).generateName();
            idFab = true;
        }
        if ((propID = (String)devcRec.get("PROP_ID")) == null) {
            propRec = PropParser.getDefaultProp();
        } else {
            propRec = this.d_propParser.getProp(propID);
            if (propRec == null) {
                throw new FDSRecordFormatException(devcRec, String.format(Intl.intl("PROP record, %s, could not be found."), propID));
            }
        }
        String deviceType = (String)devcRec.get("QUANTITY", false);
        if (deviceType == null && (deviceType = (String)propRec.get("QUANTITY", false)) == null) {
            this.addWarning(devcRec, Intl.intl("The device type could not be determined from the DEVC or PROP record."), Intl.intl("Adding device to additional records section."));
            return false;
        }
        IDevice device = null;
        if (propRec.contains("PART_ID")) {
            device = this.parseSprayer(devcRec, propRec, id, deviceType);
        } else if (deviceType.equals("SPRINKLER LINK TEMPERATURE")) {
            device = this.parseSprinklerLink(devcRec, propRec, id);
        } else if (deviceType.equals("LINK TEMPERATURE")) {
            device = this.parseHeatDetector(devcRec, propRec, id);
        } else if (deviceType.equals("spot obscuration") || deviceType.equals("CHAMBER OBSCURATION")) {
            device = this.parseSmokeDetector(devcRec, propRec, id);
        } else if (deviceType.equalsIgnoreCase("ASPIRATION")) {
            device = this.parseAspirator(devcRec, propRec, id);
        } else if (deviceType.equals("CABLE TEMPERATURE")) {
            device = null;
        } else if (deviceType.startsWith("MASS FLOW") || deviceType.startsWith("HEAT FLOW") || deviceType.startsWith("VOLUME FLOW")) {
            device = this.parseFlowMeasurer(devcRec, propRec, id, deviceType);
        } else {
            IQuantity msr = this.parseQuantity(devcRec, propRec, Intl.intl("Adding to additional records section."), true, false);
            if (msr == null) {
                return false;
            }
            Quantity quant = msr.get();
            if (msr.equals(Quantity.SPEC_DENSITY.create(ExSpecList.getPredefinedSpecies("SOOT")))) {
                device = this.parseSootDensityDevice(devcRec, propRec, id);
            } else if (quant.equals((Object)Quantity.PATH_OBSCURATION)) {
                device = this.parsePathObscurationMeasurer(devcRec, propRec, id);
            } else if (quant.equals((Object)Quantity.LAYER_HEIGHT)) {
                device = this.parseLayerInfoMeasurer(devcRec, propRec, id, true, false, false);
            } else if (quant.equals((Object)Quantity.UPPER_TEMPERATURE)) {
                device = this.parseLayerInfoMeasurer(devcRec, propRec, id, false, true, false);
            } else if (quant.equals((Object)Quantity.LOWER_TEMPERATURE)) {
                device = this.parseLayerInfoMeasurer(devcRec, propRec, id, false, false, true);
            } else if (quant.equals((Object)Quantity.TIME)) {
                device = this.parseClock(devcRec, propRec, id);
            } else if (GasPointMeasurer.getQuantityFilter().test(msr.get())) {
                device = this.parseGasPointMeasurer(devcRec, propRec, id, msr);
            } else if (SolidPointMeasurer.getQuantityFilter().test(msr.get())) {
                device = this.parseSolidPointMeasurer(devcRec, propRec, id, msr);
            } else if (AABoxMeasurer.getQuantityFilter().test(msr.get())) {
                device = this.parseAABoxMeasurer(devcRec, propRec, id, msr);
            } else if (HvacDevice.isValidQuantity(msr)) {
                device = this.parseHvacDevc(deviceType, devcRec, msr, id);
            }
        }
        if (device == null) {
            this.addWarning(devcRec, Intl.intl("Unknown device type encountered."), Intl.intl("Adding device to additional records section."));
            return false;
        }
        boolean addSourceConnections = false;
        if (!idFab && device instanceof ISignalSource) {
            addSourceConnections = true;
        }
        boolean addSinkConnections = false;
        if (device == Clock.INSTANCE) {
            this.d_pinConns.addOutputName(Clock.INSTANCE.getMsrInfo().getPin(), id);
        } else {
            int exists;
            if (!(device instanceof Timer) && device instanceof ISignalSink) {
                addSinkConnections = true;
            }
            this.parseCustomFDSProps(device, devcRec);
            if (propID != null && !propRec.empty() && this.getResult().unparsedRecords.contains(propRec) && !this.d_propParser.parseCustomFDSProps(device, propRec)) {
                HashMap<String, String> aprops = new HashMap<String, String>(device.getCustomFDSProps("DEVC").getProps());
                aprops.put("PROP_ID", "'" + propID + "'");
                device.setCustomFDSProps("DEVC", CustomFDSProps.get(aprops));
            }
            if ((exists = this.existsStatus(devcRec, device, IDevice.class)) != 0) {
                return this.convertToReturn(exists);
            }
            ArrayList<IDevice> devices = new ArrayList<IDevice>();
            Integer numPoints = devcRec.getInteger("POINTS", false);
            if (numPoints != null && numPoints > 1 && devcRec.contains("XB")) {
                UnitLineSeg3D line = DeviceParser.parseLineSeg3D(devcRec, "DEVC", "XB", true);
                List<UnitPoint3D> discretePositions = DeviceParser.splitLineSeg(line, numPoints);
                for (int i = 0; i < numPoints; ++i) {
                    IDevice devcClone = (IDevice)device.clone();
                    devcClone.setGeom(GeomNodeUtil.newNode(new Point(discretePositions.get(i).getPoint3dValue(Geometry.LU))));
                    devcClone.setName(DeviceParser.formatLinearDeviceArrayName(id, i + 1));
                    if (addSourceConnections) {
                        DeviceParser.markSignalSource(devcClone, this.d_pinConns);
                    }
                    if (addSinkConnections) {
                        DeviceParser.markSignalSink(devcRec, devcClone, this.d_pinConns);
                    }
                    devices.add(devcClone);
                }
            } else {
                if (addSourceConnections) {
                    DeviceParser.markSignalSource(device, this.d_pinConns);
                }
                if (addSinkConnections) {
                    DeviceParser.markSignalSink(devcRec, device, this.d_pinConns);
                }
                devices.add(device);
            }
            for (IDevice devc : devices) {
                this.getContainer().getDevices().add(devc);
                this.flagObjectAdded(devc);
                Set devcContainer = this.d_parsedDevices.getOrDefault(devcRec, new HashSet());
                devcContainer.add(devc);
                this.d_parsedDevices.put(devcRec, devcContainer);
            }
        }
        return true;
    }

    private static List<UnitPoint3D> splitLineSeg(UnitLineSeg3D line, int numPoints) {
        UnitPoint3D diff = line.getP1().sub(line.getP2());
        Point3d scaledUnitlessDiff = diff.getValue(Geometry.LU);
        scaledUnitlessDiff.scale(1.0 / (double)(numPoints - 1));
        ArrayList<UnitPoint3D> discretePoints = new ArrayList<UnitPoint3D>(numPoints);
        discretePoints.add(line.getP2());
        UnitPoint3D prevPoint = line.getP2();
        for (int i = 1; i < numPoints - 1; ++i) {
            UnitPoint3D currPoint = new UnitPoint3D(prevPoint.x() + scaledUnitlessDiff.x, prevPoint.y() + scaledUnitlessDiff.y, prevPoint.z() + scaledUnitlessDiff.z, prevPoint.getUnit());
            discretePoints.add(currPoint);
            prevPoint = currPoint;
        }
        discretePoints.add(line.getP1());
        return discretePoints;
    }

    private static String formatLinearDeviceArrayName(String baseName, int ix) {
        String formattedName = baseName + "-";
        if (ix <= 9) {
            formattedName = formattedName + "0";
        }
        formattedName = formattedName + ix;
        return formattedName;
    }

    private static void markSignalSource(IDevice devc, PinConnParser pinConns) {
        ISignalSource source = (ISignalSource)((Object)devc);
        Iterator<? extends IOutPin> iterator = source.getOutputPins().iterator();
        while (iterator.hasNext()) {
            IOutPin pin;
            IOutPin finalPin = pin = iterator.next();
            pinConns.addOutputName(finalPin, devc.getName());
        }
        if (devc instanceof Timer) {
            pinConns.addOutputName(Clock.INSTANCE.getMsrInfo().getPin(), devc.getName());
        }
    }

    private static void markSignalSink(FDSParseRecord devcRec, IDevice devc, PinConnParser pinConns) {
        String cid;
        String did;
        if (devc instanceof IFreezable) {
            did = "NO_UPDATE_DEVC_ID";
            cid = "NO_UPDATE_CTRL_ID";
        } else {
            did = "DEVC_ID";
            cid = "CTRL_ID";
        }
        DeviceParser.markSingleInputForRetrieval(devcRec, (ISignalSink)((Object)devc), pinConns, did, cid);
    }

    private IOutPin parseLatch(FDSParseRecord rec, IOutPin existing) {
        boolean latch = rec.getBoolean("LATCH", true);
        if (latch) {
            LatchCtrl ctrl = new LatchCtrl();
            if (!ctrl.getInputPin().canConnect(existing)) {
                return existing;
            }
            ctrl.getInputPin().connect(existing);
            return ctrl.getOutputPins().get(0);
        }
        return existing;
    }

    private IOutPin parseInvert(FDSParseRecord rec, IOutPin existing) {
        boolean initState = rec.getBoolean("INITIAL_STATE", true);
        if (initState) {
            NotOp op = new NotOp();
            if (!op.getInputPin().canConnect(existing)) {
                return existing;
            }
            op.getInputPin().connect(existing);
            return op.getOutputPins().get(0);
        }
        return existing;
    }

    private IDevice parseAABoxMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, IQuantity msr) throws FDSRecordFormatException {
        UnitAABox box = DeviceParser.parseAABox(devcRec, "DEVC", "XB", true);
        AABoxMeasurer msrr = new AABoxMeasurer(id, msr, box);
        msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
        return msrr;
    }

    private FlowMeasurer parseFlowMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, String deviceType) throws FDSRecordFormatException {
        Integer ior;
        String quantity;
        int flowDir;
        String trimmed = deviceType.trim();
        char lastChar = trimmed.charAt(trimmed.length() - 1);
        switch (lastChar) {
            case '-': {
                flowDir = 1;
                quantity = trimmed.substring(0, trimmed.length() - 1).trim();
                break;
            }
            case '+': {
                flowDir = 0;
                quantity = trimmed.substring(0, trimmed.length() - 1).trim();
                break;
            }
            default: {
                flowDir = 2;
                quantity = trimmed;
            }
        }
        Quantity quant = this.getQuantityMap().getQuantity(quantity);
        if (quant == null || !FlowMeasurer.getQuantityFilter().test(quant)) {
            throw new FDSRecordFormatException(devcRec, Intl.intl("Invalid flow direction specified."));
        }
        if (quant.quantityType == QuantityType.SOLID && (ior = (Integer)devcRec.get("IOR")) != null) {
            switch (ior) {
                case 0: {
                    flowDir = 2;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    flowDir = 1;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    flowDir = 0;
                }
            }
        }
        AARectangle rect = this.parseAARectangle(devcRec);
        FlowMeasurer msrr = new FlowMeasurer(id, quant.create(), rect, flowDir);
        msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
        return msrr;
    }

    private IDevice parseLayerInfoMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, boolean height, boolean upperTemp, boolean lowerTemp) throws FDSRecordFormatException {
        UnitLineSeg3D beam = DeviceParser.parseLineSeg3D(devcRec, "DEVC", "XB", true);
        LayerMeasurer msrr = new LayerMeasurer(id, height, upperTemp, lowerTemp, beam);
        if (height) {
            msrr.getHeightInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getHeightInfo().getPin()));
        }
        if (upperTemp) {
            msrr.getUpperTempInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getUpperTempInfo().getPin()));
        }
        if (lowerTemp) {
            msrr.getLowerTempInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getLowerTempInfo().getPin()));
        }
        return msrr;
    }

    private PathObscurationMeasurer parsePathObscurationMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        UnitLineSeg3D beam = DeviceParser.parseLineSeg3D(devcRec, "DEVC", "XB", true);
        PathObscurationMeasurer obj = new PathObscurationMeasurer(id, beam);
        obj.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, obj.getQuantity().get()));
        return obj;
    }

    private static AlarmInfo parseAlarm(FDSParseRecord devcRec, IDoubleOutPin pin) {
        return DeviceParser.parseAlarm(devcRec, pin.getUnitType());
    }

    private static AlarmInfo parseAlarm(FDSParseRecord devcRec, Quantity msr) {
        return DeviceParser.parseAlarm(devcRec, msr.unitType);
    }

    private static AlarmInfo parseAlarm(FDSParseRecord devcRec, int unitType) {
        Double val = devcRec.getDouble("SETPOINT", false);
        if (val == null) {
            return null;
        }
        Unit unit = SIUS.unit(unitType);
        UnitDouble setpoint = new UnitDouble(val, unit);
        return new AlarmInfo(setpoint, DeviceParser.parseTripFlags(devcRec));
    }

    private static int parseTripFlags(FDSParseRecord devcRec) {
        int tripFlags = 0;
        if (devcRec.getBoolean("INITIAL_STATE", true).booleanValue()) {
            tripFlags |= 2;
        }
        if (devcRec.getBoolean("LATCH", true).booleanValue()) {
            tripFlags |= 1;
        }
        return tripFlags;
    }

    private Aspirator parseAspirator(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        UnitDouble bypassFlowrate = (UnitDouble)devcRec.get("BYPASS_FLOWRATE", true);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        Aspirator asp = new Aspirator(id, bypassFlowrate, loc);
        asp.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, asp.getQuantity().get()));
        return asp;
    }

    private AspiratorSampler parseAspiratorSampler(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        AspiratorSampler sampler = new AspiratorSampler(id, loc);
        sampler.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, sampler.getQuantity().get()));
        this.d_aspSamplerRecs.add(devcRec);
        return sampler;
    }

    private IDevice parseSootDensityDevice(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        if (devcRec.contains("FLOWRATE") || devcRec.contains("DELAY") || devcRec.contains("DEVC_ID")) {
            return this.parseAspiratorSampler(devcRec, propRec, id);
        }
        return this.parseGasPointMeasurer(devcRec, propRec, id, Quantity.SPEC_DENSITY.create(ExSpecList.getPredefinedSpecies("SOOT")));
    }

    private IDevice parseClock(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        AlarmInfo ai = DeviceParser.parseAlarm(devcRec, Quantity.TIME);
        CustomFDSProps cprops = this.getCustomVals(devcRec);
        if (cprops == CustomFDSProps.EMPTY && PropParser.isDefaultProp(propRec) && devcRec.getString("NO_UPDATE_CTRL_ID") == null && devcRec.getString("NO_UPDATE_DEVC_ID") == null) {
            if (ai == null) {
                return Clock.INSTANCE;
            }
            Timer timer = new Timer(id, ai.setpoint, TripFlags.initiallyOn(ai.tripFlags));
            return timer;
        }
        return this.parseGasPointMeasurer(devcRec, propRec, id, Quantity.TIME.create());
    }

    private void consumeProps(IDevice devc, FDSParseRecord propRec) {
        if (!PropParser.isDefaultProp(propRec)) {
            boolean supported = this.d_propParser.parseCustomFDSProps(devc, propRec);
            assert (supported);
            this.getResult().unparsedRecords.remove(propRec);
        }
    }

    private IDevice parseGasPointMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, IQuantity msr) throws FDSRecordFormatException {
        if (devcRec.get("IOR") != null) {
            this.addWarning(new FDSParseWarning(devcRec, String.format(Intl.intl("IOR is only used with devices attached to a solid surface. DEVC ID: %s"), id), Intl.intl("Ignoring IOR for Gas Point Measurer")));
        }
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        if (msr.get().equals((Object)Quantity.THERMOCOUPLE)) {
            Thermocouple msrr = new Thermocouple(id, propRec.getUnitDouble("BEAD_DIAMETER", true), propRec.getDouble("BEAD_EMISSIVITY", true), propRec.getUnitDouble("BEAD_DENSITY", true), propRec.getUnitDouble("BEAD_SPECIFIC_HEAT", true), loc);
            msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
            this.consumeProps(msrr, propRec);
            return msrr;
        }
        GasPointMeasurer msrr = new GasPointMeasurer(id, msr, loc);
        msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
        return msrr;
    }

    private IDevice parseSolidPointMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, IQuantity msr) throws FDSRecordFormatException {
        SolidPointMeasurer msrr;
        AttachedPointLoc loc = this.parseAttachedPointLoc(devcRec);
        if (msr.get().equals((Object)Quantity.INSIDE_WALL_TEMPERATURE)) {
            msrr = new InnerTempMeasurer(id, devcRec.getUnitDouble("DEPTH", true), loc);
        } else if (msr.get().equals((Object)Quantity.PRESSURE_COEFFICIENT)) {
            msrr = new PressureCoeffMeasurer(id, propRec.getUnitDouble("CHARACTERISTIC_VELOCITY", true), loc);
            this.consumeProps(msrr, propRec);
        } else if (msr.get().equals((Object)Quantity.GAUGE_HEAT_FLUX)) {
            msrr = new GaugeHeatFluxMeasurer(id, propRec.getUnitDouble("GAUGE_TEMPERATURE", true), propRec.getDouble("GAUGE_EMISSIVITY", true), loc);
            this.consumeProps(msrr, propRec);
        } else {
            msrr = SolidDensityMeasurer.getQuantityFilter().test(msr.get()) ? new SolidDensityMeasurer(id, (ObjectQuantity)msr, devcRec.getUnitDouble("DEPTH", true), loc) : new SolidPointMeasurer(id, msr, loc);
        }
        msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
        return msrr;
    }

    private ASprayer parseSprayer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, String quantity) throws FDSRecordFormatException {
        if (quantity.equals("SPRINKLER LINK TEMPERATURE")) {
            return this.parseSprinkler(devcRec, propRec, id);
        }
        if (quantity.equals("CONTROL")) {
            return this.parseGenericNozzle(devcRec, propRec, id);
        }
        return this.parseMeasuringNozzle(devcRec, propRec, id);
    }

    private Sprinkler parseSprinkler(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        SprinklerLinkModel linkModel = this.d_propParser.parseSprinklerLinkModel(propRec);
        SprayModel sprayModel = this.d_propParser.parseSprayModel(propRec);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        Sprinkler.TraditionalModel linkMod = new Sprinkler.TraditionalModel(linkModel, devcRec.getBoolean("INITIAL_STATE", true), devcRec.getBoolean("LATCH", true));
        Sprinkler sprinkler = new Sprinkler(id, sprayModel, linkMod, loc);
        return sprinkler;
    }

    private Nozzle parseGenericNozzle(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        SprayModel sprayModel = this.d_propParser.parseSprayModel(propRec);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        return new Nozzle(id, sprayModel, loc);
    }

    private ASprayer parseMeasuringNozzle(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        SprayModel sprayModel = this.d_propParser.parseSprayModel(propRec);
        IQuantity msr = this.parseQuantity(devcRec, propRec, "", false, false);
        if (msr == null || !Sprinkler.QuantityModel.getQuantityFilter().test(msr.get())) {
            return null;
        }
        Double setPoint = (Double)devcRec.get("SETPOINT", true);
        if (setPoint == null) {
            return null;
        }
        UnitDouble setPointU = new UnitDouble(setPoint, SIUS.unit(msr.get().unitType));
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        Sprinkler.QuantityModel linkMod = new Sprinkler.QuantityModel(msr, setPointU, devcRec.getBoolean("INITIAL_STATE", true), devcRec.getBoolean("LATCH", true));
        Sprinkler sprk = new Sprinkler(id, sprayModel, linkMod, loc);
        return sprk;
    }

    private SprinklerLink parseSprinklerLink(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        SprinklerLinkModel model = this.d_propParser.parseSprinklerLinkModel(propRec);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        SprinklerLink link = new SprinklerLink(id, model, loc);
        link.setTripFlags(DeviceParser.parseTripFlags(devcRec));
        return link;
    }

    private IDetector parseSmokeDetector(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        SmokeLinkModel model = this.d_propParser.parseSmokeLinkModel(propRec);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        SmokeDetector det = new SmokeDetector(id, model, loc);
        det.setTripFlags(DeviceParser.parseTripFlags(devcRec));
        return det;
    }

    private IDetector parseHeatDetector(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        HeatLinkModel model = this.d_propParser.parseHeatLinkModel(propRec);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        HeatDetector det = new HeatDetector(id, model, loc);
        det.setTripFlags(DeviceParser.parseTripFlags(devcRec));
        return det;
    }

    private IDevice parseHvacDevc(String quantity, FDSParseRecord devcRec, IQuantity msr, String devcId) throws FDSRecordFormatException {
        boolean isDuctQuantity = false;
        boolean isNodeQuantity = false;
        for (Class<? extends IPyroObject> type : msr.get().requiredTypes) {
            if (HvacDuct.class.isAssignableFrom(type)) {
                isDuctQuantity = true;
            }
            if (!HvacNode.class.isAssignableFrom(type)) continue;
            isNodeQuantity = true;
        }
        if (isDuctQuantity) {
            return new DuctDevice(devcId, msr);
        }
        if (isNodeQuantity) {
            return new NodeDevice(devcId, msr);
        }
        return null;
    }

    private AARectangle parseAARectangle(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitPoint3D[] xb = DeviceParser.parseXB(rec, "DEVC", "XB", true);
        if (xb[0].x() == xb[1].x()) {
            return new AARectangle(0, xb[0].x(), xb[0].y(), xb[0].z(), xb[1].y(), xb[1].z(), false);
        }
        if (xb[0].y() == xb[1].y()) {
            return new AARectangle(1, xb[0].y(), xb[0].x(), xb[0].z(), xb[1].x(), xb[1].z(), false);
        }
        if (xb[0].z() == xb[1].z()) {
            return new AARectangle(2, xb[0].z(), xb[0].x(), xb[0].y(), xb[1].x(), xb[1].y(), false);
        }
        throw new FDSRecordFormatException(rec, Intl.intl("XB must specify a plane."));
    }

    private FreePointLoc parseFreePointLoc(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitPoint3D loc = DeviceParser.parseLoc(rec, "DEVC", "XYZ", false, false);
        if (loc == null) {
            loc = DeviceParser.parseLineSeg3D(rec, "DEVC", "XB", true).getP1();
        }
        Point geom = new Point(loc.getPoint3dValue(Geometry.LU));
        UnitDouble rot = (UnitDouble)rec.get("ROTATION", true);
        FDSArray orientArr = rec.getArray("ORIENTATION", true);
        Vector3d orient = new Vector3d((Double)orientArr.get(0), (Double)orientArr.get(1), (Double)orientArr.get(2));
        return new FreePointLoc(geom, orient, rot);
    }

    private AttachedPointLoc parseAttachedPointLoc(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitPoint3D loc = DeviceParser.parseLoc(rec, "DEVC", "XYZ", true);
        UnitDouble rot = (UnitDouble)rec.get("ROTATION", true);
        Integer ior = (Integer)rec.get("IOR");
        Vector3d angle = null;
        if (ior == null) {
            FDSArray orientArr = rec.getArray("ORIENTATION", true);
            angle = new Vector3d((Double)orientArr.get(0), (Double)orientArr.get(1), (Double)orientArr.get(2));
        } else {
            angle = GeomUtil.toWorldVec(ior);
        }
        return new AttachedPointLoc(loc, angle, rot);
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
        for (Map.Entry<FDSParseRecord, Set<IDevice>> kvPair : this.d_parsedDevices.entrySet()) {
            FDSParseRecord rec = kvPair.getKey();
            for (IDevice devc : kvPair.getValue()) {
                if (!(devc instanceof ISignalSink) || !Util.isCycle((ISignalSink)((Object)devc))) continue;
                this.addWarning(new FDSParseWarning(rec, Intl.intl("Device activation includes a cyclic definition."), String.format(Intl.intl("Activation inputs removed from device %s."), devc.getName())));
                ((ISignalSink)((Object)devc)).getInputPin().disconnectAll();
            }
        }
    }
}

