/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.extloader;

import java.awt.Color;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jscience.physics.units.SI;
import pyroloader.IPyroSurface;
import pyroloader.PyroTexture;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.io.extloader.DataStore;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;

public class SurfWrapper
implements IPyroSurface {
    private final DataStore d_store;
    private final Surface d_surf;
    private final Map<Texture, PyroTexture> d_texMap;
    private static final Map<IPyroSurface.Prop, IMatAttrs.MatProp> s_propMap = SurfWrapper.constructMap(BUMP, IMatAttrs.BUMP, BUMP_SCALE, IMatAttrs.BUMP_SCALE, AMBIENT_COLOR, IMatAttrs.AMBIENT_COLOR, AMBIENT_TEXTURE, IMatAttrs.AMBIENT_TEXTURE, AMBIENT_FADE, IMatAttrs.AMBIENT_FADE, DIFFUSE_COLOR, IMatAttrs.DIFFUSE_COLOR, DIFFUSE_TEXTURE, IMatAttrs.DIFFUSE_TEXTURE, DIFFUSE_FADE, IMatAttrs.DIFFUSE_FADE, EMISSIVE_COLOR, IMatAttrs.EMISSIVE_COLOR, EMISSIVE_TEXTURE, IMatAttrs.EMISSIVE_TEXTURE, EMISSIVE_FADE, IMatAttrs.EMISSIVE_FADE, NORMAL, IMatAttrs.NORMAL, OPACITY_COLOR, IMatAttrs.OPACITY_COLOR, OPACITY_TEXTURE, IMatAttrs.OPACITY_TEXTURE, OPACITY_FADE, IMatAttrs.OPACITY_FADE, REFLECTION_COLOR, IMatAttrs.REFLECTION_COLOR, REFLECTION_TEXTURE, IMatAttrs.REFLECTION_TEXTURE, REFLECTION_FADE, IMatAttrs.REFLECTION_FADE, SPECULAR_COLOR, IMatAttrs.SPECULAR_COLOR, SPECULAR_TEXTURE, IMatAttrs.SPECULAR_TEXTURE, SPECULAR_FADE, IMatAttrs.SPECULAR_FADE, SHININESS, IMatAttrs.SHININESS, SHININESS_TEXTURE, IMatAttrs.SHININESS_TEXTURE, OPTIONS, IMatAttrs.OPTIONS);

    private static <K, V> Map<K, V> constructMap(Object ... vals) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (int m = 0; m < vals.length; m += 2) {
            result.put(vals[m + 0], vals[m + 1]);
        }
        return result;
    }

    public SurfWrapper(DataStore store, Surface surf) {
        this.d_store = store;
        this.d_surf = surf;
        this.d_texMap = new IdentityHashMap<Texture, PyroTexture>();
    }

    public String getName() {
        return this.d_surf.getName();
    }

    public Color getColor() {
        Material ti = this.d_surf.getAppearance();
        if (ti == null) {
            return this.d_surf.getColor();
        }
        Color c = ti.getAttributes().getColor(MatChannel.DIFFUSE);
        if (c != null) {
            return ti.getAttributes().getDiffuseColorWithOpacity();
        }
        return this.d_surf.getColor();
    }

    public double[] getDimensions() {
        Material ti = this.d_surf.getAppearance();
        if (ti == null || ti.getAttributes().getTexture(MatChannel.DIFFUSE) == null) {
            return new double[]{1.0, 1.0};
        }
        return new double[]{ti.getWidth().getValue(SI.METER), ti.getHeight().getValue(SI.METER)};
    }

    public synchronized PyroTexture getDiffuseTexture() {
        return (PyroTexture)this.getAttribute(DIFFUSE_TEXTURE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAttribute(IPyroSurface.Prop<T> prop) {
        IMatAttrs.MatProp nprop = s_propMap.get(prop);
        Object nresult = this.d_surf.getAttributes().get(nprop);
        if (nresult instanceof Texture) {
            Map<Texture, PyroTexture> map = this.d_texMap;
            synchronized (map) {
                Texture tex = (Texture)nresult;
                return (T)this.d_texMap.computeIfAbsent(tex, this::getUncachedTexture);
            }
        }
        return nresult;
    }

    private PyroTexture getUncachedTexture(Texture tex) {
        if (tex == null) {
            return null;
        }
        return this.d_store.getTexture(tex);
    }
}

