/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.grid.CreateGridPanel;
import pyrosim.gui.grid.GridCreator;
import pyrosim.gui.grid.MeshmakerGridCreatorFDS;
import pyrosim.gui.grid.RegularGridCreator;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class GridPanel
extends CreateGridPanel {
    private static final long serialVersionUID = -8187637114237843941L;
    private GridCreator[] d_creators;
    ValueField<UnitDouble> d_minX;
    ValueField<UnitDouble> d_minY;
    ValueField<UnitDouble> d_minZ;
    ValueField<UnitDouble> d_maxX;
    ValueField<UnitDouble> d_maxY;
    ValueField<UnitDouble> d_maxZ;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;

    public GridPanel(Integer ... creators) {
        assert (creators != null && creators.length > 0);
        this.d_minX = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_minY = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_minZ = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_maxX = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_maxY = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_maxZ = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_creators = new GridCreator[creators.length];
        block4: for (int i = 0; i < creators.length; ++i) {
            switch (creators[i]) {
                case 0: {
                    this.d_creators[i] = new RegularGridCreator(this);
                    continue block4;
                }
                case 1: {
                    this.d_creators[i] = new MeshmakerGridCreatorFDS(this);
                    continue block4;
                }
                default: {
                    assert (false);
                    continue block4;
                }
            }
        }
        guiPanel[] panels = new guiPanel[creators.length];
        String[] names = new String[creators.length];
        for (int i = 0; i < creators.length; ++i) {
            panels[i] = this.d_creators[i].getPanel();
            names[i] = this.d_creators[i].getPanelName();
        }
        this.setPanels(panels, this.getHeaderPanel(), names);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (((UnitDouble)this.d_minX.getValue()).ge((UnitDouble)this.d_maxX.getValue(), 1.0E-6)) {
            return PyroGuiUtil.invalidateFld((Component)this, showWarn, allowModify, this.d_minX, Intl.intl("Min X must be less than Max X."));
        }
        if (((UnitDouble)this.d_minY.getValue()).ge((UnitDouble)this.d_maxY.getValue(), 1.0E-6)) {
            return PyroGuiUtil.invalidateFld((Component)this, showWarn, allowModify, this.d_minY, Intl.intl("Min Y must be less than Max Y."));
        }
        if (((UnitDouble)this.d_minZ.getValue()).ge((UnitDouble)this.d_maxZ.getValue(), 1.0E-6)) {
            return PyroGuiUtil.invalidateFld((Component)this, showWarn, allowModify, this.d_minZ, Intl.intl("Min Z must be less than Max Z."));
        }
        return this.d_creators[super.getSelection()].validateData(showWarn, allowModify);
    }

    public Grid getGrid() {
        UnitPoint3D minPt = new UnitPoint3D((UnitDouble)this.d_minX.getValue(), (UnitDouble)this.d_minY.getValue(), (UnitDouble)this.d_minZ.getValue());
        UnitPoint3D maxPt = new UnitPoint3D((UnitDouble)this.d_maxX.getValue(), (UnitDouble)this.d_maxY.getValue(), (UnitDouble)this.d_maxZ.getValue());
        return this.d_creators[super.getSelection()].createGrid(minPt, maxPt);
    }

    public void setValues(Grid g) {
        if (g != null) {
            if (RegularGridCreator.isGridRegular(g)) {
                super.setSelection(0);
            } else {
                super.setSelection(1);
            }
            this.d_minX.setValue(g.getMinPoint().xu());
            this.d_minY.setValue(g.getMinPoint().yu());
            this.d_minZ.setValue(g.getMinPoint().zu());
            this.d_maxX.setValue(g.getMaxPoint().xu());
            this.d_maxY.setValue(g.getMaxPoint().yu());
            this.d_maxZ.setValue(g.getMaxPoint().zu());
        } else {
            Unit u = UnitSystem.getSource(0).getUnit();
            super.setSelection(0);
            this.d_minX.setValue(new UnitDouble(0.0, u));
            this.d_minY.setValue(new UnitDouble(0.0, u));
            this.d_minZ.setValue(new UnitDouble(0.0, u));
            this.d_maxX.setValue(new UnitDouble(1.0, u));
            this.d_maxY.setValue(new UnitDouble(1.0, u));
            this.d_maxZ.setValue(new UnitDouble(1.0, u));
        }
        this.d_creators[super.getSelection()].setValues(g);
        for (int m = 0; m < this.d_creators.length; ++m) {
            if (m == super.getSelection()) continue;
            this.d_creators[m].setValues(null);
        }
    }

    public void addBoundsValueChangeListener(PropertyChangeListener listener) {
        this.d_minX.addValueChangeListener(listener);
        this.d_minY.addValueChangeListener(listener);
        this.d_minZ.addValueChangeListener(listener);
        this.d_maxX.addValueChangeListener(listener);
        this.d_maxY.addValueChangeListener(listener);
        this.d_maxZ.addValueChangeListener(listener);
    }

    private guiPanel getHeaderPanel() {
        guiPanel panel = new guiPanel(new MigLayout("insets 0, gapx 12, gapy 6"));
        panel.setFocusTraversalPolicy(new CoordsFocusTP());
        panel.setFocusTraversalPolicyProvider(true);
        panel.add((Component)new guiLabel(Intl.intl("Mesh Boundary:")), "span, wrap 12");
        panel.add(Box.createHorizontalGlue());
        panel.add(new guiLabel(Intl.intl("Min X") + ":"));
        panel.add(this.d_minX);
        panel.add(new guiLabel(Intl.intl("Min Y") + ":"));
        panel.add(this.d_minY);
        panel.add(new guiLabel(Intl.intl("Min Z") + ":"));
        panel.add(this.d_minZ, "wrap");
        panel.add(Box.createHorizontalGlue());
        panel.add(new guiLabel(Intl.intl("Max X") + ":"));
        panel.add(this.d_maxX);
        panel.add(new guiLabel(Intl.intl("Max Y") + ":"));
        panel.add(this.d_maxY);
        panel.add(new guiLabel(Intl.intl("Max Z") + ":"));
        panel.add(this.d_maxZ, "wrap");
        return panel;
    }

    public Unit getUnit() {
        return PyroSim.getApp().getUnitSystem().getLengthUnit();
    }

    private UnitDouble tryGetVal(ValueField<UnitDouble> field) {
        if (!field.validateData(false, false)) {
            return null;
        }
        return (UnitDouble)field.getValue();
    }

    public UnitDouble tryGetMinX() {
        return this.tryGetVal(this.d_minX);
    }

    public UnitDouble tryGetMinY() {
        return this.tryGetVal(this.d_minY);
    }

    public UnitDouble tryGetMinZ() {
        return this.tryGetVal(this.d_minZ);
    }

    public UnitDouble tryGetMaxX() {
        return this.tryGetVal(this.d_maxX);
    }

    public UnitDouble tryGetMaxY() {
        return this.tryGetVal(this.d_maxY);
    }

    public UnitDouble tryGetMaxZ() {
        return this.tryGetVal(this.d_maxZ);
    }

    public UnitDouble getMin(int axis) {
        switch (axis) {
            case 0: {
                return (UnitDouble)this.d_minX.getValue();
            }
            case 1: {
                return (UnitDouble)this.d_minY.getValue();
            }
            case 2: {
                return (UnitDouble)this.d_minZ.getValue();
            }
        }
        return new UnitDouble(Double.POSITIVE_INFINITY, UnitSystem.getSource(0).getUnit());
    }

    public UnitDouble getMax(int axis) {
        switch (axis) {
            case 0: {
                return (UnitDouble)this.d_maxX.getValue();
            }
            case 1: {
                return (UnitDouble)this.d_maxY.getValue();
            }
            case 2: {
                return (UnitDouble)this.d_maxZ.getValue();
            }
        }
        return new UnitDouble(Double.NEGATIVE_INFINITY, UnitSystem.getSource(0).getUnit());
    }

    public void giveFocus() {
        this.d_minX.requestFocusInWindow();
    }

    private class CoordsFocusTP
    extends FocusTraversalPolicy {
        private CoordsFocusTP() {
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(GridPanel.this.d_minX)) {
                return GridPanel.this.d_maxX;
            }
            if (aComponent.equals(GridPanel.this.d_maxX)) {
                return GridPanel.this.d_minY;
            }
            if (aComponent.equals(GridPanel.this.d_minY)) {
                return GridPanel.this.d_maxY;
            }
            if (aComponent.equals(GridPanel.this.d_maxY)) {
                return GridPanel.this.d_minZ;
            }
            if (aComponent.equals(GridPanel.this.d_minZ)) {
                return GridPanel.this.d_maxZ;
            }
            if (aComponent.equals(GridPanel.this.d_maxZ)) {
                return null;
            }
            return GridPanel.this.d_minX;
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(GridPanel.this.d_minX)) {
                return null;
            }
            if (aComponent.equals(GridPanel.this.d_maxX)) {
                return GridPanel.this.d_minX;
            }
            if (aComponent.equals(GridPanel.this.d_minY)) {
                return GridPanel.this.d_maxX;
            }
            if (aComponent.equals(GridPanel.this.d_maxY)) {
                return GridPanel.this.d_minY;
            }
            if (aComponent.equals(GridPanel.this.d_minZ)) {
                return GridPanel.this.d_maxY;
            }
            if (aComponent.equals(GridPanel.this.d_maxZ)) {
                return GridPanel.this.d_minZ;
            }
            return GridPanel.this.d_minX;
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return GridPanel.this.d_minX;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return GridPanel.this.d_maxZ;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return GridPanel.this.d_minX;
        }
    }
}

