/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.Vent;
import pyrosim.gui.TimeFunctionEditor;
import pyrosim.gui.comboboxes.SurfaceComboBox;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.geom.EvacPanel;
import pyrosim.gui.geom.ModelDialogsUtil;
import pyrosim.gui.geom.ModelObjectDialog;
import pyrosim.gui.geom.Point3DPanel;
import pyrosim.gui.geom.TexMapperPnl;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertyUtil;
import thunderheadeng.util.theUtil;

public class VentEditor
implements ModelObjectDialog.IEditor<Vent> {
    private static final String OPEN_PROPS_TAB = Intl.intl("Open Properties");
    private static final String HVAC_PROPS_TAB = Intl.intl("HVAC Properties");
    private static final String BURNER_PROPS_TAB = Intl.intl("Fire Spread Properties");
    private final ModelObjectDialog d_parent;
    private final guiMultiStateCheckBox d_outlineCB;
    private final SurfaceComboBox d_surfCB;
    private final TexMapperPnl d_texOriginPanel;
    private final FireSpreadPnl d_fireSpreadPnl;
    private final OpenPropsPnl d_openPropsPnl;
    private ControlSelPnl d_controlPnl;
    private final EvacPanel d_evacPanel;
    private final HvacPnl d_hvacPanel;
    private Collection<? extends Vent> d_loadedVents;
    private boolean d_burnerSurfLoaded = false;
    private boolean d_openSurfLoaded = false;
    private boolean d_hvacSurfLoaded = false;
    private boolean d_ctrlSurfLoaded = false;
    private static final PropertyUtil.IProp<Vent, UnitDouble> s_extTempProp = new PropertyUtil.AProp<Vent, UnitDouble>(Vent.class){

        @Override
        public Object get(Vent obj) {
            return obj.getOpenProps() != null ? obj.getOpenProps().temp : Vent.OpenProps.DEFAULT.temp;
        }

        @Override
        public void set(Vent obj, UnitDouble prop) {
            Vent.OpenProps props = obj.getOpenProps();
            Vent.OpenProps newProps = new Vent.OpenProps(prop, props.pressure);
            obj.setOpenProps(newProps);
        }
    };
    private static final PropertyUtil.IProp<Vent, TimeBasedValue<UnitDouble>> s_pressureProp = new PropertyUtil.AProp<Vent, TimeBasedValue<UnitDouble>>(Vent.class){

        @Override
        public Object get(Vent obj) {
            return obj.getOpenProps() != null ? obj.getOpenProps().pressure : Vent.OpenProps.DEFAULT.pressure;
        }

        @Override
        public void set(Vent obj, TimeBasedValue<UnitDouble> prop) {
            Vent.OpenProps props = obj.getOpenProps();
            Vent.OpenProps newProps = new Vent.OpenProps(props.temp, prop);
            obj.setOpenProps(newProps);
        }
    };

    public VentEditor(ModelObjectDialog parent, PyroMod domain) {
        this.d_parent = parent;
        this.d_loadedVents = Collections.emptyList();
        this.d_texOriginPanel = new TexMapperPnl();
        this.d_openPropsPnl = new OpenPropsPnl();
        this.d_surfCB = new SurfaceComboBox(domain.getSurfaceMgr(), domain.getDefaultSurface());
        this.d_fireSpreadPnl = new FireSpreadPnl(this.d_surfCB);
        this.d_surfCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VentEditor.this.updateSelSurf();
            }
        });
        this.d_outlineCB = new guiMultiStateCheckBox(Intl.intl("Display as Outline"));
        this.d_evacPanel = domain.getFdsEvacEnabled() ? new EvacPanel() : null;
        this.d_hvacPanel = new HvacPnl();
    }

    @Override
    public Class<Vent> getType() {
        return Vent.class;
    }

    @Override
    public String getDialogTitle() {
        return Intl.intl("Vent Properties");
    }

    @Override
    public boolean validateData(Component parent, Collection<? extends Vent> objs, boolean showWarn, boolean allowModify) {
        String msg;
        int option;
        return !showWarn || !this.d_surfCB.isModified() || this.d_surfCB.getSelectedItem() == null || !((Surface)this.d_surfCB.getSelectedItem()).isPredefined(PredefSurf.HVAC) || (option = JOptionPane.showConfirmDialog(parent, msg = Intl.intl("WARNING: Once a vent is assigned to an HVAC surface, it\ncannot be changed to another surface type."), Intl.intl("HVAC Surface"), 2, 2)) == 0;
    }

    @Override
    public void add(ModelObjectDialog dlg, GridBagHelper gb) {
        this.d_controlPnl = dlg.getControlPanel();
        dlg.addControlInput(gb);
        gb.addRow(Intl.intl("Surface:"), this.d_surfCB);
        dlg.addColor(gb);
        gb.addRow(this.d_outlineCB, 0);
        gb.addRow(this.d_texOriginPanel, 1.0, 0);
    }

    @Override
    public boolean isControllable(Vent obj) {
        Surface surf = (Surface)this.d_surfCB.getSelectedItem();
        if (surf == null) {
            return obj.isControllable();
        }
        return Vent.isControllableSurf(surf);
    }

    private void updateSelSurf() {
        Surface surf = (Surface)this.d_surfCB.getSelectedItem();
        if (this.d_controlPnl != null) {
            boolean controllableSurf = false;
            for (Vent vent : this.d_loadedVents) {
                if (!this.isControllable(vent)) continue;
                controllableSurf = true;
                break;
            }
            this.d_controlPnl.setEnabled(controllableSurf);
            if (!controllableSurf) {
                this.d_controlPnl.selectAlwaysOn();
            }
        }
        if (surf == null && this.d_burnerSurfLoaded || surf != null && Vent.isValidFireSpreadSurf(surf)) {
            this.d_parent.addExtraTab(BURNER_PROPS_TAB, this.d_fireSpreadPnl);
        } else {
            this.d_parent.removeExtraTab(BURNER_PROPS_TAB);
        }
        if (surf == null && this.d_openSurfLoaded || surf != null && surf.isPredefined(PredefSurf.OPEN)) {
            this.d_parent.addExtraTab(OPEN_PROPS_TAB, this.d_openPropsPnl);
        } else {
            this.d_parent.removeExtraTab(OPEN_PROPS_TAB);
        }
        if (surf == null && this.d_hvacSurfLoaded || surf != null && surf.isPredefined(PredefSurf.HVAC)) {
            this.d_parent.addExtraTab(HVAC_PROPS_TAB, this.d_hvacPanel);
        } else {
            this.d_parent.removeExtraTab(HVAC_PROPS_TAB);
        }
    }

    @Override
    public List<Pair<String, guiPanel>> getExtraTabs() {
        ArrayList<Pair<String, guiPanel>> tabs = new ArrayList<Pair<String, guiPanel>>();
        tabs.add(new Pair<String, OpenPropsPnl>(OPEN_PROPS_TAB, this.d_openPropsPnl));
        tabs.add(new Pair<String, HvacPnl>(HVAC_PROPS_TAB, this.d_hvacPanel));
        tabs.add(new Pair<String, FireSpreadPnl>(BURNER_PROPS_TAB, this.d_fireSpreadPnl));
        if (this.d_evacPanel != null) {
            tabs.add(new Pair<String, EvacPanel>(Intl.intl("Evac"), this.d_evacPanel));
        }
        return tabs;
    }

    @Override
    public void load(PyroMod domain, Collection<? extends Vent> objs) {
        this.d_loadedVents = new ArrayList<Vent>(objs);
        HashSet<Predicate<Surface>> uniqueFilters = new HashSet<Predicate<Surface>>();
        for (Vent vent : objs) {
            uniqueFilters.add(vent.getSurfFilter());
        }
        Predicate<Surface> surfFilter = uniqueFilters.isEmpty() ? Vent.getSurfaceFilter() : Predicates.and(theUtil.toArray(uniqueFilters, Predicate.class));
        this.d_surfCB.setFilter(surfFilter);
        Object object = Composite.getProperty(Vent.surfProp, objs);
        if (!(object instanceof Surface)) {
            this.d_surfCB.setSelectedItem(null);
        } else {
            this.d_surfCB.setSelectedItem((Surface)object);
        }
        this.d_texOriginPanel.load(objs);
        this.d_fireSpreadPnl.load(objs);
        ModelDialogsUtil.loadBoolean(objs, this.d_outlineCB, new Vent.OptionProp(1));
        this.d_burnerSurfLoaded = false;
        this.d_openSurfLoaded = false;
        this.d_ctrlSurfLoaded = false;
        this.d_hvacSurfLoaded = false;
        if (this.d_surfCB.getSelectedItem() == null) {
            for (Vent vent : objs) {
                Surface surf = vent.getSurface();
                if (Vent.isValidFireSpreadSurf(surf)) {
                    this.d_burnerSurfLoaded = true;
                } else if (surf.isPredefined(PredefSurf.OPEN)) {
                    this.d_openSurfLoaded = true;
                } else if (surf.isPredefined(PredefSurf.HVAC)) {
                    this.d_hvacSurfLoaded = true;
                }
                this.d_ctrlSurfLoaded |= this.isControllable(vent);
                if (!this.d_openSurfLoaded || !this.d_ctrlSurfLoaded || !this.d_hvacSurfLoaded || !this.d_burnerSurfLoaded) continue;
                break;
            }
        }
        this.updateSelSurf();
        this.d_openPropsPnl.load(domain, objs);
        this.d_hvacPanel.load(objs);
        if (this.d_evacPanel != null) {
            this.d_evacPanel.load(domain, objs);
        }
    }

    @Override
    public void save(PyroMod domain, Collection<? extends Vent> objs) {
        Surface surf = (Surface)this.d_surfCB.getSelectedItem();
        if (surf != null) {
            Composite.setProperty(Vent.surfProp, surf, objs);
        }
        this.d_texOriginPanel.save(domain, objs);
        this.d_fireSpreadPnl.save(domain, objs);
        ModelDialogsUtil.saveBoolean(domain, objs, this.d_outlineCB, new Vent.OptionProp(1));
        this.d_openPropsPnl.save(domain, objs);
        this.d_hvacPanel.save(objs);
        if (this.d_evacPanel != null) {
            this.d_evacPanel.save(domain, objs);
        }
    }

    private static class OpenPropsPnl
    extends guiPanel {
        private static final long serialVersionUID = 7403210301008526754L;
        private final ValueField<UnitDouble> d_tempFld = ValueFields.udFld(UnitSystem.getSource(1));
        private final ValueField<UnitDouble> d_pressureFld;
        private final TimeFunctionEditor d_pressureFuncEditor;
        private static final UnitDouble TMPA = new UnitDouble(Double.POSITIVE_INFINITY, SI.CELSIUS);

        public OpenPropsPnl() {
            super(new GridBagLayout());
            ValueFields.getFormat(this.d_tempFld).alias(TMPA, "TMPA");
            this.d_tempFld.setNullAllowed(true);
            this.d_pressureFld = ValueFields.udFld(UnitSystem.getSource(39));
            this.d_pressureFuncEditor = new TimeFunctionEditor(Intl.intl("Pressure Ramp"), 17);
            this.d_pressureFld.setNullAllowed(true);
            guiLabel tempLbl = new guiLabel(Intl.intl("Exterior Temperature") + ":");
            guiLabel pressLbl = new guiLabel(Intl.intl("Dynamic Pressure") + ":");
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(tempLbl, this.d_tempFld);
            gb.addRow(pressLbl, this.d_pressureFld);
            gb.addRow(this.d_pressureFuncEditor.getLabel(), this.d_pressureFuncEditor.getCombo(), this.d_pressureFuncEditor.getEditor());
            gb.finalizeRows();
        }

        public void load(PyroMod domain, Collection<? extends Vent> vents) {
            if ((vents = theUtil.filter(vents, new PredefSurfFilter(PredefSurf.OPEN))).isEmpty()) {
                Vent.OpenProps props = Vent.OpenProps.DEFAULT;
                this.d_tempFld.setValue(TMPA);
                this.d_pressureFld.setValue(props.pressure.val);
                this.d_pressureFuncEditor.loadFunction(props.pressure.func);
                return;
            }
            Object temp = PropertyUtil.getProperty(s_extTempProp, vents);
            if (temp == PropertyUtil.NON_UNIFORM || temp == PropertyUtil.NOT_SUPPORTED) {
                temp = null;
            } else if (temp == null) {
                temp = TMPA;
            }
            this.d_tempFld.setValue((UnitDouble)temp);
            Object press = PropertyUtil.getProperty(s_pressureProp, vents);
            if (!(press instanceof TimeBasedValue)) {
                press = null;
            }
            UnitDouble pressVal = press == null ? null : (UnitDouble)((TimeBasedValue)press).val;
            TimeFunction func = press == null ? null : ((TimeBasedValue)press).func;
            this.d_pressureFld.setValue(pressVal);
            this.d_pressureFuncEditor.loadFunction(func);
        }

        public void save(PyroMod domain, Collection<? extends Vent> vents) {
            for (Vent vent : vents) {
                if (!vent.getSurface().isPredefined(PredefSurf.OPEN)) {
                    vent.setOpenProps(null);
                    continue;
                }
                if (vent.getOpenProps() != null) continue;
                vent.setOpenProps(Vent.OpenProps.DEFAULT);
            }
            vents = theUtil.filter(vents, new PredefSurfFilter(PredefSurf.OPEN));
            UnitDouble temp = (UnitDouble)this.d_tempFld.getValue();
            if (temp != null) {
                if (temp == TMPA) {
                    temp = null;
                }
                PropertyUtil.setProperty(s_extTempProp, temp, vents);
            }
            UnitDouble unitDouble = (UnitDouble)this.d_pressureFld.getValue();
            TimeFunction<?> pressFunc = this.d_pressureFuncEditor.saveFunction();
            if (unitDouble != null && pressFunc != null) {
                TimeBasedValue<UnitDouble> pressVal = new TimeBasedValue<UnitDouble>(unitDouble, pressFunc);
                PropertyUtil.setProperty(s_pressureProp, pressVal, vents);
            }
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return super.validateData(showWarn, allowModify) && this.d_pressureFuncEditor.validateData(showWarn, allowModify);
        }
    }

    private static class FireSpreadPnl
    extends guiPanel {
        private static final long serialVersionUID = 5522134974656300231L;
        private final guiMultiStateCheckBox d_enableFireSpread;
        private final ValueField<UnitDouble> d_spreadRateFld;
        private final guiLabel d_spreadRateLbl;
        private final Composite.IObjectProp rateProp = new Composite.AObjectProp<Vent, UnitDouble>(Vent.class){

            @Override
            public void set(Vent obj, UnitDouble prop) {
                obj.setFireSpreadRate(prop);
            }

            @Override
            public Object get(Vent obj) {
                return obj.getFireSpreadRate();
            }
        };

        public FireSpreadPnl(SurfaceComboBox surfCB) {
            super(new GridBagLayout());
            this.d_enableFireSpread = new guiMultiStateCheckBox(Intl.intl("Enable Fire Spread"));
            guiLabel note = new guiLabel(Intl.intl("Fire spreads from the Center Point defined on the Geometry tab."));
            note.setFont(note.getFont().deriveFont(2));
            this.d_spreadRateFld = ValueFields.udFld(DoubleVR.above(0.0, true), SIUS.unit(8), UnitSystem.getSource(8));
            this.d_spreadRateFld.setNullAllowed(true);
            this.d_enableFireSpread.addActionListener(e -> {
                if (this.d_spreadRateFld.isEmpty()) {
                    this.d_spreadRateFld.setValue(SIUS.newud(0.0, 8));
                    this.d_spreadRateFld.requestFocusInWindow();
                }
            });
            this.d_spreadRateLbl = new guiLabel(Intl.intl("Spread Rate:"));
            LinkStatus.link((AbstractButton)this.d_enableFireSpread, this.d_spreadRateLbl, this.d_spreadRateFld);
            GridBagUtil.add(this, this.d_enableFireSpread, 0, 0, 4, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, note, 0, 1, 3, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_spreadRateLbl, 0, 2, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_spreadRateFld, 1, 2, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void load(Collection<? extends Vent> vents) {
            Object ratep = Composite.getProperty(this.rateProp, vents);
            if (ratep == null) {
                this.d_enableFireSpread.setState(0);
                this.d_spreadRateFld.setValue(ratep);
            } else if (ratep instanceof UnitDouble) {
                this.d_enableFireSpread.setState(1);
                this.d_spreadRateFld.setValue(ratep);
            } else {
                this.d_enableFireSpread.setState(2);
                this.d_spreadRateFld.setValue(null);
            }
            boolean enabled = this.d_enableFireSpread.getState() == 1;
            this.d_spreadRateLbl.setEnabled(enabled);
            this.d_spreadRateFld.setEnabled(enabled);
        }

        public void save(PyroMod domain, Collection<? extends Vent> vents) {
            UnitDouble rate = (UnitDouble)this.d_spreadRateFld.getValue();
            int cbState = this.d_enableFireSpread.getState();
            if (rate != null && cbState == 1) {
                Composite.setProperty(this.rateProp, rate, vents);
            } else if (cbState == 0) {
                Composite.setProperty(this.rateProp, null, vents);
            }
        }
    }

    private static class PredefSurfFilter
    implements Predicate<Vent> {
        private final PredefSurf d_surf;

        public PredefSurfFilter(PredefSurf surf) {
            this.d_surf = surf;
        }

        @Override
        public boolean test(Vent o) {
            return o.getSurface().isPredefined(this.d_surf);
        }
    }

    private static class HvacPnl
    extends guiPanel {
        private static final long serialVersionUID = 4252489330431369486L;
        private final guiMultiStateCheckBox d_louverCB;
        private final Point3DPanel d_louverPnl;
        private final Composite.IObjectProp louverProp = new Composite.AObjectProp<Vent, Vector3d>(Vent.class){

            @Override
            public void set(Vent obj, Vector3d prop) {
                obj.setLouver(prop);
            }

            @Override
            public Object get(Vent obj) {
                Vector3d louver = obj.getLouver();
                return louver == null ? GeomConstants.VEC3D_ZERO : louver;
            }
        };
        private final Composite.IObjectProp louverSpecProp = new Composite.AObjectProp<Vent, Boolean>(Vent.class){

            @Override
            public void set(Vent obj, Boolean prop) {
            }

            @Override
            public Object get(Vent obj) {
                return obj.getLouver() != null;
            }
        };

        public HvacPnl() {
            this.d_louverCB = new guiMultiStateCheckBox(Intl.intl("Louver:"));
            this.d_louverPnl = new Point3DPanel(null, true, 28, true, true);
            LinkStatus.link((AbstractButton)this.d_louverCB, this.d_louverPnl);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_louverCB, this.d_louverPnl, 1.0, 0);
            gb.finalizeRows();
        }

        public void load(Collection<? extends Vent> vents) {
            if ((vents = theUtil.filter(vents, new PredefSurfFilter(PredefSurf.HVAC))).isEmpty()) {
                this.d_louverCB.setSelected(false);
                this.d_louverPnl.load(new UnitPoint3D(0.0, 0.0, 0.0, Unit.ONE));
                return;
            }
            Object louverSpec = Composite.getProperty(this.louverSpecProp, vents);
            if (louverSpec instanceof Boolean) {
                this.d_louverCB.setSelected((Boolean)louverSpec);
            } else {
                this.d_louverCB.setState(2);
            }
            Object louver = Composite.getProperty(this.louverProp, vents);
            if (louver instanceof Vector3d) {
                Vector3d v = (Vector3d)louver;
                this.d_louverPnl.load(new UnitPoint3D(v.x, v.y, v.z, Unit.ONE));
            } else {
                this.d_louverPnl.load(null);
            }
        }

        public void save(Collection<? extends Vent> vents) {
            PredefSurfFilter hvacFilter = new PredefSurfFilter(PredefSurf.HVAC);
            for (Vent vent : vents) {
                if (hvacFilter.test(vent)) continue;
                vent.setLouver(null);
            }
            vents = theUtil.filter(vents, hvacFilter);
            if (this.d_louverCB.getState() != 2) {
                if (this.d_louverCB.isSelected()) {
                    UnitPoint3D p = this.d_louverPnl.save();
                    if (p != null) {
                        Composite.setProperty(this.louverProp, p.getVector3dValue(Unit.ONE), vents);
                    }
                } else {
                    Composite.setProperty(this.louverProp, null, vents);
                }
            }
        }
    }
}

