/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.vecmath.Point2d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.IObstruction;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.SurfaceComboBox;
import pyrosim.gui.geom.EvacPanel;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.ModelDialogsUtil;
import pyrosim.gui.geom.ModelObjectDialog;
import pyrosim.gui.geom.TexMapperPnl;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.elem.ElementBuilder;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertyUtil;
import thunderheadeng.util.theUtil;

public class ObstructionEditor
implements ModelObjectDialog.IEditor<IObstruction>,
Observer {
    private final OptionProp[] d_optionProps;
    private final TexMapperPnl d_texOriginPanel;
    private final guiMultiStateCheckBox d_densityCB;
    private final ValueField<UnitDouble> d_densityFld;
    private final SurfPnl d_surfPnl;
    private final IGeomEditor d_geomEditor;
    private final EvacPanel d_evacPanel;
    private Predicate<IObstruction> d_validatedGEOM = Predicates.alwaysTrue();

    public ObstructionEditor(PyroMod domain, IGeomEditor geomEditor) {
        this.d_geomEditor = geomEditor;
        if (this.d_geomEditor != null) {
            this.d_geomEditor.getPanel().addObserver(this);
        }
        ArrayList<OptionProp> options = new ArrayList<OptionProp>();
        options.addAll(Arrays.asList(new OptionProp(Intl.intl("Thicken"), 1), new OptionProp(Intl.intl("Record BNDF"), 16), new OptionProp(Intl.intl("Permit Holes"), 4), new OptionProp(Intl.intl("Allow Vents"), 8), new OptionProp(Intl.intl("Removable"), 64), new OptionProp(Intl.intl("Display as Outline"), 32)));
        if (PyroSim.FDS7) {
            options.add(new OptionProp(Intl.intl("Write as GEOM"), 128));
        }
        this.d_optionProps = (OptionProp[])theUtil.toArray(options);
        this.d_densityCB = new guiMultiStateCheckBox(Intl.intl("Bulk Density") + ":");
        this.d_densityFld = ValueFields.udFld(DoubleVR.above(0.0, false), SIUS.unit(4), UnitSystem.getSource(4));
        this.d_densityCB.setToolTipText(Intl.intl("Override density properties from surface."));
        LinkStatus.link((AbstractButton)this.d_densityCB, this.d_densityFld);
        this.d_texOriginPanel = new TexMapperPnl();
        this.d_surfPnl = new SurfPnl(domain);
        this.d_evacPanel = domain.getFdsEvacEnabled() ? new EvacPanel() : null;
    }

    private int getOption(int option) {
        return Stream.of(this.d_optionProps).filter(o -> o.optionFlag == option).findFirst().map(o -> o.cb.getState()).orElse(0);
    }

    @Override
    public void add(ModelObjectDialog dlg, GridBagHelper gb) {
        dlg.addControlInput(gb);
        dlg.addColor(gb);
        gb.addFilledRow(this.d_texOriginPanel);
        TitleSeparator optionsLbl = new TitleSeparator(Intl.intl("Obstruction Properties"));
        gb.addFilledRow(optionsLbl);
        int numCols = 3;
        gb.indent();
        for (int m = 0; m < this.d_optionProps.length; ++m) {
            OptionProp prop = this.d_optionProps[m];
            if (m >= numCols && m % numCols == 0) {
                gb.nextRow();
            }
            gb.addCol((Component)prop.cb, new Object[0]);
        }
        gb.nextRow();
        gb.unindent();
        gb.addRow(this.d_densityCB, this.d_densityFld, 0);
    }

    @Override
    public List<Pair<String, guiPanel>> getExtraTabs() {
        ArrayList<Pair<String, guiPanel>> tabs = new ArrayList<Pair<String, guiPanel>>();
        tabs.add(new Pair<String, SurfPnl>(Intl.intl("Surfaces"), this.d_surfPnl));
        if (this.d_evacPanel != null) {
            tabs.add(new Pair<String, EvacPanel>(Intl.intl("Evac"), this.d_evacPanel));
        }
        return tabs;
    }

    @Override
    public String getDialogTitle() {
        return Intl.intl("Obstruction Properties");
    }

    @Override
    public Class<IObstruction> getType() {
        return IObstruction.class;
    }

    @Override
    public void update(Observable o, Object arg) {
        assert (this.d_geomEditor != null);
        this.syncFaceCount();
    }

    private void syncFaceCount() {
        if (this.d_geomEditor == null) {
            return;
        }
        int newNumFaces = this.d_geomEditor.getNumFaces();
        if (newNumFaces == -1) {
            this.d_surfPnl.resetSurfs();
            return;
        }
        if (newNumFaces == this.d_surfPnl.d_model.d_surfaces.length) {
            return;
        }
        Surface[] newSurfs = ObstructionEditor.matchPrimCount(PyroSim.getApp().getMediator(), this.d_surfPnl.d_model.d_surfaces, newNumFaces);
        this.d_surfPnl.d_model.load(newSurfs, this.d_geomEditor.getFaceNames());
    }

    private static Surface[] matchPrimCount(PyroMod domain, Surface[] oldSurfs, int newSize) {
        int m;
        if (newSize == oldSurfs.length) {
            return oldSurfs;
        }
        Surface[] newSurfs = new Surface[newSize];
        for (m = 0; m < Math.min(newSize, oldSurfs.length); ++m) {
            newSurfs[m] = oldSurfs[m];
        }
        Surface inert = domain.getSurfaceMgr().get(PredefSurf.INERT);
        while (m < newSize) {
            newSurfs[m] = inert;
            ++m;
        }
        return newSurfs;
    }

    /*
     * WARNING - void declaration
     */
    private static IGeomNode matchElementPrimCount(IGeomNode node) {
        IElemSource<Object> newElems;
        int numPrims = node.getLocalGeom().getNumPrims(7);
        IPropertySet elements = node.getLocalElements();
        IPropertySet newElements = null;
        for (Elements.ElemProp<?> prop : Elements.FIXED) {
            IElemSource defVal;
            IElemSource iElemSource = (IElemSource)elements.get(prop);
            newElems = ObstructionEditor.matchElementPrimCount((IElemSource)prop.defVal, iElemSource, numPrims, defVal = (IElemSource)prop.defVal);
            if (newElems == iElemSource) continue;
            if (newElements == null) {
                newElements = Elements.copyOf(elements);
            }
            newElements.setIfNotDefault(prop, newElems);
        }
        ListMap<String, IElemSource<Point2d>> newuv = null;
        for (Map.Entry entry : elements.get(Elements.UV).entrySet()) {
            IElemSource elems = (IElemSource)entry.getValue();
            newElems = ObstructionEditor.matchElementPrimCount(Elements.NO_UV, elems, numPrims, FDSUtil.getDefaultTexMapper());
            if (newElems == elems) continue;
            if (newuv == null) {
                newuv = new ListMap<String, IElemSource<Point2d>>(elements.get(Elements.UV));
            }
            newuv.put((String)entry.getKey(), (IElemSource<Point2d>)newElems);
        }
        if (newuv != null) {
            if (newElements == null) {
                newElements = Elements.copyOf(elements);
            }
            newElements.setIfNotDefault(Elements.UV, newuv);
        }
        ArrayList<? extends IGeomNode> newChildren = null;
        boolean bl = false;
        Collection<? extends IGeomNode> children = node.getChildren();
        for (IGeomNode iGeomNode : children) {
            void var6_10;
            IGeomNode newChild = ObstructionEditor.matchElementPrimCount(iGeomNode);
            if (newChild != iGeomNode) {
                if (newChildren == null) {
                    newChildren = new ArrayList<IGeomNode>(children);
                }
                newChildren.set((int)var6_10, newChild);
            }
            ++var6_10;
        }
        if (newChildren == null && newElements == null) {
            return node;
        }
        if (newElements != null) {
            elements = Elements.finalizeElements(newElements);
        }
        if (newChildren != null) {
            children = newChildren;
        }
        return GeomNodeUtil.newNode(node.getLocalTransform(), node.getLocalGeom(), elements, children);
    }

    private static <T> IElemSource<T> matchElementPrimCount(IElemSource<T> propDefVal, IElemSource<T> src, int numPrims, IElemSource<T> defVal) {
        int m;
        if (src.isUnbounded() || src.getNumPrims() == numPrims) {
            return src;
        }
        ElementBuilder<T> builder = new ElementBuilder<T>(propDefVal);
        Iterator<IElemSource<T>> elemit = src.getPrimIterator();
        for (m = 0; m < numPrims && elemit.hasNext(); ++m) {
            builder.add(elemit.next(), 1);
        }
        if (m >= numPrims && !elemit.hasNext()) {
            return src;
        }
        while (m < numPrims) {
            builder.add(defVal, 1);
            ++m;
        }
        return builder.finish();
    }

    @Override
    public boolean validateData(Component parent, Collection<? extends IObstruction> objs, boolean showWarn, boolean allowModify) {
        this.d_validatedGEOM = Predicates.alwaysTrue();
        if (this.getOption(128) == 1) {
            IFilteredCollection<IObstruction> obsts = theUtil.filter(objs, IObstruction.class, o -> !o.getOptions(128));
            if (showWarn) {
                Collection<IObstruction> validObst = Actions.validateGEOM(SwingUtilities.getWindowAncestor(parent), obsts);
                Predicate<Object> predicate = this.d_validatedGEOM = validObst == null || validObst.size() == obsts.size() ? Predicates.alwaysTrue() : Filters.accept(new IdentityHashSet<IObstruction>(validObst));
                if (validObst == null) {
                    return false;
                }
            }
        }
        return true;
    }

    private void loadBulkDensity(Collection<? extends IObstruction> objs) {
        Object density = Composite.getProperty(IObstruction.bulkDensityProp, objs);
        if (density == Composite.NON_UNIFORM || density == Composite.NOT_SUPPORTED) {
            this.d_densityCB.setState(2);
        } else if (density == null) {
            this.d_densityCB.setSelected(false);
        } else {
            this.d_densityCB.setSelected(true);
            this.d_densityFld.setValue((UnitDouble)density);
        }
    }

    private void saveBulkDensity(Collection<? extends IObstruction> objs) {
        if (this.d_densityCB.getState() != 2) {
            UnitDouble val = this.d_densityCB.isSelected() ? (UnitDouble)this.d_densityFld.getValue() : null;
            Composite.setProperty(IObstruction.bulkDensityProp, val, objs);
        }
    }

    @Override
    public boolean isControllable(IObstruction obj) {
        return obj.isControllable();
    }

    @Override
    public void load(PyroMod domain, Collection<? extends IObstruction> deepObjs) {
        for (OptionProp prop : this.d_optionProps) {
            prop.load(deepObjs);
        }
        ObstructionEditor.loadObstTextureOrigin(deepObjs, this.d_texOriginPanel);
        this.loadBulkDensity(deepObjs);
        this.d_surfPnl.load(domain, deepObjs, this.d_geomEditor);
        if (this.d_evacPanel != null) {
            this.d_evacPanel.load(domain, deepObjs);
        }
    }

    @Override
    public void save(PyroMod domain, Collection<? extends IObstruction> deepObjs) {
        for (OptionProp prop : this.d_optionProps) {
            prop.save(domain, deepObjs);
        }
        ObstructionEditor.saveObstTexOrigin(domain, deepObjs, this.d_texOriginPanel);
        this.saveBulkDensity(deepObjs);
        this.d_surfPnl.save(domain, deepObjs, this.d_geomEditor);
        if (this.d_evacPanel != null) {
            this.d_evacPanel.save(domain, deepObjs);
        }
    }

    private static void loadObstTextureOrigin(Collection<? extends IObstruction> objs, TexMapperPnl panel) {
        panel.load(objs);
    }

    private static void saveObstTexOrigin(PyroMod mediator, Collection<? extends IObstruction> objs, TexMapperPnl panel) {
        panel.save(mediator, objs);
    }

    private static Collection<Surface> getAllowableSurfs(PyroMod domain) {
        List<Surface> surfs = Util.sort(domain.getSurfaceMgr());
        surfs.remove(domain.getSurfaceMgr().get(PredefSurf.OPEN));
        surfs.remove(domain.getSurfaceMgr().get(PredefSurf.MIRROR));
        surfs.remove(domain.getSurfaceMgr().get(PredefSurf.HVAC));
        surfs.remove(domain.getSurfaceMgr().get(PredefSurf.PERIODIC));
        return surfs;
    }

    private static SurfaceComboBox createSurfCombo(PyroMod domain) {
        final Collection<Surface> allowableSurfs = ObstructionEditor.getAllowableSurfs(domain);
        SurfaceComboBox cb = new SurfaceComboBox(domain.getSurfaceMgr(), domain.getSurfaceMgr().get(PredefSurf.INERT));
        cb.setFilter(new Predicate<Surface>(){

            @Override
            public boolean test(Surface o) {
                return allowableSurfs.contains(o);
            }
        });
        return cb;
    }

    private static String[] getNames(Collection<Surface> surfs) {
        String[] names = new String[surfs.size()];
        int ix = 0;
        for (Surface surf : surfs) {
            names[ix++] = surf.getName();
        }
        return names;
    }

    private static class SurfPnl
    extends guiPanel {
        private static final long serialVersionUID = -8087558908276601923L;
        private final SurfaceComboBox d_allFaces;
        private final guiRadioButton d_allSame;
        private final guiRadioButton d_eachFace;
        private final TableModel d_model;
        private final guiTable d_table;
        private Surface[] d_origSurfs = new Surface[0];
        private String[] d_origNames = new String[0];
        private final PropertyUtil.IProp<IPyroGeomSrc, Integer> numFacesProp = new PropertyUtil.AProp<IPyroGeomSrc, Integer>(IPyroGeomSrc.class){

            @Override
            public Object get(IPyroGeomSrc obj) {
                return obj.getGeom().getNumPrims(1);
            }

            @Override
            public void set(IPyroGeomSrc obj, Integer prop) {
            }
        };

        public SurfPnl(PyroMod domain) {
            super(new GridBagLayout());
            this.d_allSame = new guiRadioButton(Intl.intl("Single"));
            this.d_eachFace = new guiRadioButton(Intl.intl("Multiple"));
            this.d_allFaces = ObstructionEditor.createSurfCombo(domain);
            this.d_model = new TableModel();
            this.d_table = new guiTable((javax.swing.table.TableModel)this.d_model, 0);
            this.d_table.setPreferredScrollableViewportSize(new Dimension(150, 100));
            JScrollPane tablesp = new JScrollPane(this.d_table);
            this.d_table.setColumnOptions(1, ObstructionEditor.getNames(ObstructionEditor.getAllowableSurfs(domain)));
            new guiButtonGroup(this.d_allSame, this.d_eachFace);
            LinkStatus.link((AbstractButton)this.d_allSame, this.d_allFaces);
            LinkStatus.link((AbstractButton)this.d_eachFace, tablesp);
            GridBagUtil.add(this, this.d_allSame, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_allFaces, 1, 1, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_eachFace, 0, 2, 1, 1, 6, 0, 0, 0, 0, 0.0, 0.0, 18);
            GridBagUtil.add(this, tablesp, 1, 2, 1, 1, 6, 6, 0, 0, 1, 1.0, 1.0, 17);
            GridBagUtil.addGlue(this);
        }

        protected void addListener(final ItemListener listener) {
            this.d_allSame.addItemListener(listener);
            this.d_eachFace.addItemListener(listener);
            this.d_allFaces.addItemListener(listener);
            this.d_model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    listener.itemStateChanged(null);
                }
            });
        }

        protected boolean isBurnAway() {
            if (this.d_allSame.isSelected()) {
                return this.isBurnAway(this.d_allFaces);
            }
            for (Surface surf : this.d_model.d_surfaces) {
                if (!this.isBurnAway(surf)) continue;
                return true;
            }
            return false;
        }

        private boolean isBurnAway(SurfaceComboBox box) {
            Surface surf = (Surface)box.getSelectedItem();
            return this.isBurnAway(surf);
        }

        private boolean isBurnAway(Surface surf) {
            if (surf != null && surf.getSurfDesc() instanceof LayeredSurfDesc) {
                LayeredSurfDesc desc = (LayeredSurfDesc)surf.getSurfDesc();
                return desc.d_burnAway;
            }
            return false;
        }

        public void resetSurfs() {
            this.d_model.load(this.d_origSurfs, this.d_origNames);
        }

        private static Map<IObstruction, int[]> getFaceOrders(Collection<? extends IObstruction> deepObjs, IGeomEditor geomEditor) {
            if (geomEditor == null) {
                return Collections.emptyMap();
            }
            IdentityHashMap<IObstruction, int[]> result = new IdentityHashMap<IObstruction, int[]>();
            for (IObstruction iObstruction : deepObjs) {
                int[] order = geomEditor.getFaceOrder(iObstruction.getGeom());
                if (order == null) continue;
                result.put(iObstruction, order);
            }
            return result;
        }

        public void load(PyroMod domain, Collection<? extends IObstruction> deepObjs, IGeomEditor geomEditor) {
            String[] names;
            this.d_model.load(new Surface[0], new String[0]);
            if (deepObjs.isEmpty()) {
                return;
            }
            if (geomEditor != null && geomEditor.getNumFaces() > 0) {
                names = geomEditor.getFaceNames();
            } else {
                Object numFaces = PropertyUtil.getProperty(this.numFacesProp, deepObjs);
                if (!(numFaces instanceof Integer)) {
                    this.d_allSame.setSelected(false);
                    this.d_eachFace.setSelected(false);
                    return;
                }
                names = new String[((Integer)numFaces).intValue()];
                for (int m = 0; m < names.length; ++m) {
                    names[m] = String.format(Intl.intl("Face %d"), m + 1);
                }
            }
            Map<IObstruction, int[]> faceOrders = SurfPnl.getFaceOrders(deepObjs, geomEditor);
            SurfProp surfProp = new SurfProp(faceOrders);
            Surface[] surfs = new Surface[names.length];
            for (int m = 0; m < surfs.length; ++m) {
                surfProp.ix = m;
                Object surf = PropertyUtil.getProperty(surfProp, deepObjs);
                if (!(surf instanceof Surface)) {
                    surf = null;
                }
                surfs[m] = (Surface)surf;
            }
            this.d_origSurfs = surfs;
            this.d_origNames = names;
            this.d_model.load(surfs, names);
            if (GeomUtil.isUniform(surfs) && surfs[0] != null) {
                this.d_allSame.setSelected(true);
                this.d_allFaces.setSelectedItem(surfs[0]);
            } else {
                this.d_eachFace.setSelected(true);
                this.d_allFaces.setSelectedItem(null);
            }
        }

        public void save(PyroMod domain, Collection<? extends IObstruction> deepObjs, IGeomEditor geomEditor) {
            block10: {
                block9: {
                    for (IObstruction iObstruction : deepObjs) {
                        int numFaces = iObstruction.getGeom().getNumPrims(1);
                        Surface[] surfaceArray = iObstruction.getSurfaces();
                        if (surfaceArray.length != 1 && numFaces != surfaceArray.length) {
                            Surface[] surfaceArray2 = ObstructionEditor.matchPrimCount(domain, surfaceArray, numFaces);
                            iObstruction.setSurfaces(surfaceArray2);
                        }
                        IGeomNode iGeomNode = ObstructionEditor.matchElementPrimCount(iObstruction.getGeom());
                        iObstruction.setGeom(iGeomNode);
                    }
                    if (!this.d_allSame.isSelected()) break block9;
                    Surface surf = (Surface)this.d_allFaces.getSelectedItem();
                    if (surf == null) break block10;
                    Set<String> set = surf.getAttributes().getUVSets();
                    Surface[] surfs = new Surface[]{surf};
                    for (IObstruction iObstruction : deepObjs) {
                        Surface[] oldSurfs = iObstruction.getSurfaces();
                        HashSet<Integer> modIxes = new HashSet<Integer>();
                        int numFaces = iObstruction.getNumFaces();
                        for (int m = 0; m < numFaces; ++m) {
                            Surface oldSurf;
                            Surface surface = oldSurf = oldSurfs.length == 1 ? oldSurfs[0] : oldSurfs[m];
                            if (oldSurf == surf) continue;
                            modIxes.add(m);
                        }
                        if (modIxes.size() <= 0) continue;
                        iObstruction.setSurfaces(surfs);
                        IGeomNode newNode = iObstruction.getGeom();
                        for (String uvSet : set) {
                            newNode = newNode.applyUVElements(uvSet, (ix, oldEl) -> modIxes.contains(ix) ? FDSUtil.getDefaultTexMapper() : oldEl);
                        }
                        iObstruction.setGeom(newNode);
                    }
                    break block10;
                }
                if (this.d_eachFace.isSelected()) {
                    if (this.d_model.d_surfaces.length == 0) {
                        return;
                    }
                    Map<IObstruction, int[]> faceOrders = SurfPnl.getFaceOrders(deepObjs, geomEditor);
                    SurfProp surfProp = new SurfProp(faceOrders);
                    for (int m = 0; m < this.d_model.d_surfaces.length; ++m) {
                        Surface surface = this.d_model.d_surfaces[m];
                        if (surface == null) continue;
                        surfProp.ix = m;
                        PropertyUtil.setProperty(surfProp, surface, deepObjs);
                    }
                    for (IObstruction iObstruction : deepObjs) {
                        surfProp.apply(iObstruction);
                    }
                }
            }
        }

        private static class TableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 4777606949118088408L;
            private String[] d_faceNames = new String[0];
            private Surface[] d_surfaces = new Surface[0];

            private TableModel() {
            }

            public void load(Surface[] surfs, String[] faceNames) {
                this.d_faceNames = faceNames;
                this.d_surfaces = surfs;
                this.fireTableDataChanged();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return String.class;
                }
                return String.class;
            }

            @Override
            public String getColumnName(int columnIndex) {
                if (columnIndex == 0) {
                    return Intl.intl("Face");
                }
                return Intl.intl("Surface");
            }

            @Override
            public int getRowCount() {
                return this.d_surfaces.length;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return this.d_faceNames[rowIndex];
                    }
                    case 1: {
                        return this.d_surfaces[rowIndex] == null ? null : this.d_surfaces[rowIndex].getName();
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 1: {
                        Surface surf;
                        this.d_surfaces[rowIndex] = value == null ? null : (surf = (Surface)PyroSim.getApp().getMediator().getSurfaceMgr().get((String)value));
                        this.fireTableCellUpdated(rowIndex, columnIndex);
                    }
                }
            }
        }

        private static class SurfProp
        extends PropertyUtil.AProp<IObstruction, Surface> {
            private final Map<IObstruction, int[]> d_faceOrder;
            private final Set<IObstruction> d_modObjs = new IdentityHashSet<IObstruction>();
            private int ix;
            private Map<IObstruction, Map<Integer, Surface>> d_newSurfaces = new LinkedIdentityHashMap<IObstruction, Map<Integer, Surface>>();

            public SurfProp(Map<IObstruction, int[]> faceOrder) {
                super(IObstruction.class);
                this.d_faceOrder = faceOrder;
                this.ix = 0;
            }

            @Override
            public Object get(IObstruction obj) {
                Surface[] surfs = obj.getSurfaces();
                if (surfs.length == 1) {
                    return surfs[0];
                }
                int[] forder = this.d_faceOrder.get(obj);
                assert (forder == null || forder.length == surfs.length);
                int lix = forder == null ? this.ix : forder[this.ix];
                return surfs[lix];
            }

            @Override
            public void set(IObstruction obj, Surface prop) {
                Surface oldSurf;
                int lix;
                Surface[] surfs = obj.getSurfaces();
                int[] faceOrder = this.d_faceOrder.get(obj);
                assert (faceOrder == null || faceOrder.length == surfs.length);
                int n = lix = faceOrder == null ? this.ix : faceOrder[this.ix];
                assert (surfs.length == 1 || lix >= 0 && lix < surfs.length);
                Surface surface = oldSurf = surfs.length == 1 ? surfs[0] : surfs[lix];
                if (oldSurf != prop) {
                    Map newObjSurfs = this.d_newSurfaces.computeIfAbsent(obj, o -> new LinkedIdentityHashMap());
                    newObjSurfs.put(lix, prop);
                }
            }

            public boolean apply(IObstruction obj) {
                Map<Integer, Surface> newSurfs = this.d_newSurfaces.get(obj);
                if (newSurfs == null) {
                    Surface[] surfs = obj.getSurfaces();
                    surfs = GeomUtil.optimize(surfs);
                    obj.setSurfaces(surfs);
                    return false;
                }
                Surface[] surfs = GeomUtil.matchPrimCount(obj.getGeom(), 1, obj.getSurfaces(), Surface.class, true);
                for (Map.Entry<Integer, Surface> entry : newSurfs.entrySet()) {
                    surfs[entry.getKey().intValue()] = entry.getValue();
                }
                obj.setSurfaces(GeomUtil.optimize(surfs));
                LinkedIdentityHashMap<String, Set> uvsetIxMap = new LinkedIdentityHashMap<String, Set>();
                Function<String, Set> newIxSet = uvset -> new HashSet();
                IdentityHashMap<Surface, Set> uvsetsCache = new IdentityHashMap<Surface, Set>();
                Function<Surface, Set> getUVSets = s -> s.getAttributes().getUVSets();
                for (Map.Entry<Integer, Surface> entry : newSurfs.entrySet()) {
                    for (String uvset2 : uvsetsCache.computeIfAbsent(entry.getValue(), getUVSets)) {
                        Set ixes = uvsetIxMap.computeIfAbsent(uvset2, newIxSet);
                        ixes.add(entry.getKey());
                    }
                }
                IGeomNode newNode = obj.getGeom();
                IElemSource<Point2d> defUV = FDSUtil.getDefaultTexMapper();
                for (Map.Entry entry : uvsetIxMap.entrySet()) {
                    String uvset3 = (String)entry.getKey();
                    Set toReplace = (Set)entry.getValue();
                    newNode = newNode.applyUVElements(uvset3, (ix, oldEl) -> toReplace.contains(ix) ? defUV : oldEl);
                }
                obj.setGeom(newNode);
                return true;
            }
        }
    }

    private class OptionProp {
        public final int optionFlag;
        public final guiMultiStateCheckBox cb;

        public OptionProp(String name, int optionFlag) {
            this.cb = new guiMultiStateCheckBox(name);
            this.optionFlag = optionFlag;
        }

        public OptionProp(String name, int optionFlag, ItemListener listener) {
            this(name, optionFlag);
            this.cb.addItemListener(listener);
        }

        public void save(PyroMod domain, Collection<? extends IObstruction> obsts) {
            if (this.optionFlag == 128 && !Predicates.alwaysTrue(ObstructionEditor.this.d_validatedGEOM) && this.cb.isSelected()) {
                obsts = new ArrayList<IObstruction>(obsts);
                obsts.removeIf(ObstructionEditor.this.d_validatedGEOM.negate());
            }
            ModelDialogsUtil.saveBoolean(domain, obsts, this.cb, new IObstruction.OptionProp(this.optionFlag));
        }

        public void load(Collection<? extends IObstruction> obsts) {
            ModelDialogsUtil.loadBoolean(obsts, this.cb, new IObstruction.OptionProp(this.optionFlag));
        }
    }
}

