/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.Point3DPanel;
import pyrosim.gui.geom.PolygonEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.PropertyUtil;

public class ExtrudedPolyEditor
extends guiPanel
implements IGeomEditor<ExtrudedPoly> {
    private static final long serialVersionUID = 8020246006014903489L;
    private final NormalPanel d_normalPnl;
    private final PolygonEditor d_polyEditor;
    private final PropertyUtil.IProp<IPyroGeomSrc, Vector3d> extrusionProp = new PropertyUtil.AProp<IPyroGeomSrc, Vector3d>(IPyroGeomSrc.class){

        @Override
        public Object get(IPyroGeomSrc obj) {
            return ((ExtrudedPoly)obj.getGeom().getLocalGeom()).extrusion;
        }

        @Override
        public void set(IPyroGeomSrc obj, Vector3d prop) {
            ExtrudedPoly ep = (ExtrudedPoly)obj.getGeom().getLocalGeom();
            obj.setGeom(obj.getGeom().applyLocalGeom(new ExtrudedPoly(ep.poly, prop)));
        }
    };
    private final PropertyUtil.IProp<IPyroGeomSrc, IPolygon> polyExtractorProp = new PropertyUtil.AProp<IPyroGeomSrc, IPolygon>(IPyroGeomSrc.class){

        @Override
        public Object get(IPyroGeomSrc obj) {
            return ((ExtrudedPoly)obj.getGeom().getLocalGeom()).poly;
        }

        @Override
        public void set(IPyroGeomSrc obj, IPolygon prop) {
            ExtrudedPoly ep = (ExtrudedPoly)obj.getGeom().getLocalGeom();
            obj.setGeom(obj.getGeom().applyLocalGeom(new ExtrudedPoly(prop, ep.extrusion)));
        }

        @Override
        public boolean equal(IPolygon obj1, IPolygon obj2) {
            return PolyUtil.polysEqual(obj1, obj2);
        }
    };

    public ExtrudedPolyEditor() {
        super(new GridBagLayout());
        this.d_normalPnl = new NormalPanel();
        this.d_polyEditor = new PolygonEditor();
        TitleSeparator title = new TitleSeparator(Intl.intl("Base Polygon"));
        int row = 0;
        GridBagUtil.add(this, this.d_normalPnl, 0, row, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, title, 0, ++row, 1, 1, 6, 0, 0, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, this.d_polyEditor, 0, ++row, 1, 1, 6, 12, 0, 0, 1, 1.0, 1.0, 17);
    }

    @Override
    public String[] getFaceNames() {
        int numFaces = this.getNumFaces();
        if (numFaces < 1) {
            return new String[0];
        }
        assert (numFaces >= 2);
        String[] names = new String[this.getNumFaces()];
        names[0] = String.format(Intl.intl("Face %d"), 1);
        names[1] = String.format(Intl.intl("Face %d"), 2);
        for (int m = 2; m < names.length; ++m) {
            names[m] = String.format(Intl.intl("Side %d"), m - 1);
        }
        return names;
    }

    @Override
    public int getNumFaces() {
        int numSides = this.d_polyEditor.getNumSides();
        if (numSides == 0) {
            return -1;
        }
        return numSides + 2;
    }

    @Override
    public int[] getFaceOrder(IGeomNode geom) {
        return null;
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Slab");
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> geoms) {
        Object extrusion;
        Object poly = PropertyUtil.getProperty(this.polyExtractorProp, geoms);
        if (!(poly instanceof IPolygon)) {
            poly = null;
        }
        if (!((extrusion = PropertyUtil.getProperty(this.extrusionProp, geoms)) instanceof Vector3d)) {
            extrusion = null;
        }
        this.d_normalPnl.load((IPolygon)poly, (Vector3d)extrusion);
        this.d_polyEditor.load((IPolygon)poly);
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> geoms) {
        IPolygon poly = this.d_polyEditor.save();
        if (poly == null) {
            for (IPyroGeomSrc iPyroGeomSrc : geoms) {
                poly = ((ExtrudedPoly)iPyroGeomSrc.getGeom().getLocalGeom()).poly;
                Vector3d ext = this.d_normalPnl.save(poly);
                if (ext == null) continue;
                PropertyUtil.setProperty(this.extrusionProp, ext, geoms);
            }
        } else {
            Vector3d ext = this.d_normalPnl.save(poly);
            if (poly != null) {
                PropertyUtil.setProperty(this.polyExtractorProp, poly, geoms);
            }
            if (ext != null) {
                PropertyUtil.setProperty(this.extrusionProp, ext, geoms);
            }
        }
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> geoms, boolean showWarn, boolean allowModify) {
        return this.d_polyEditor.validateData(geoms, showWarn, allowModify);
    }

    private static class NormalPanel
    extends guiPanel {
        private static final long serialVersionUID = -3707401587607321934L;
        private final guiRadioButton d_normalRB = new guiRadioButton(Intl.intl("Normal to Polygon"));
        private final ValueField<UnitDouble> d_distFld;
        private final guiRadioButton d_dirRB = new guiRadioButton(Intl.intl("Custom Direction") + ":");
        private final Point3DPanel d_dirPnl;

        public NormalPanel() {
            super(new GridBagLayout());
            new guiButtonGroup(this.d_normalRB, this.d_dirRB);
            this.d_distFld = ValueFields.udFld(0.2, (Unit)SI.METER, UnitSystem.getSource(0));
            guiLabel distLbl = new guiLabel(Intl.intl("Distance"));
            this.d_dirPnl = new Point3DPanel(null, true);
            LinkStatus.link((AbstractButton)this.d_normalRB, distLbl, this.d_distFld);
            LinkStatus.link((AbstractButton)this.d_dirRB, this.d_dirPnl);
            TitleSeparator title = new TitleSeparator(Intl.intl("Extrusion Path"));
            int row = 0;
            GridBagUtil.add(this, title, 0, row, 10, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, this.d_normalRB, 0, ++row, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, distLbl, 1, row, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_distFld, 2, row, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_dirRB, 0, ++row, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_dirPnl, 1, row, 5, 1, 6, 6, 0, 0, 0, 0.0, 0.0, 17);
        }

        public void load(IPolygon poly, Vector3d extrusion) {
            if (extrusion == null || poly == null) {
                this.d_normalRB.setSelected(false);
                this.d_dirRB.setSelected(false);
                return;
            }
            Vector3d normal = poly.getNormal(true);
            Vector3d normalizedExt = Util3D.normalize(extrusion);
            if (normalizedExt.epsilonEquals(normal, 1.0E-6) || Util3D.negate(normalizedExt).epsilonEquals(normal, 1.0E-6)) {
                this.d_normalRB.setSelected(true);
                double dist = extrusion.length();
                if (!normalizedExt.epsilonEquals(normal, 1.0E-6)) {
                    dist = -dist;
                }
                this.d_distFld.setValue(UnitDouble.from(dist, Geometry.LU, PyroSim.getApp().getUnitSystem().getLengthUnit()));
            } else {
                this.d_dirRB.setSelected(true);
                this.d_dirPnl.load(new UnitPoint3D(extrusion, Geometry.LU));
            }
        }

        public Vector3d save(IPolygon poly) {
            if (!this.d_normalRB.isSelected() && !this.d_dirRB.isSelected()) {
                return null;
            }
            if (this.d_dirRB.isSelected()) {
                return this.d_dirPnl.save().getVector3dValue(Geometry.LU);
            }
            if (poly == null) {
                return null;
            }
            Vector3d extrusion = new Vector3d(poly.getNormal(true));
            extrusion.scale(((UnitDouble)this.d_distFld.getValue()).getValue(Geometry.LU));
            return extrusion;
        }
    }
}

