/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.hvac.DuctDevice;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.devices.hvac.NodeDevice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;

public class HvacDevcEditor
extends ADevcEditor<HvacDevice> {
    public static final int DUCT = 0;
    public static final int NODE = 1;
    private final String d_desc;
    private final String d_defName;
    private final HvacDevcDataPanel d_dataPanel;
    private final IDevcEditor.Mode d_mode;
    private int d_type;

    public HvacDevcEditor(PyroMod pymod, IDevcEditor.Mode mode, int type) {
        this(pymod, Intl.intl("HVAC Device"), Intl.intl("HVAC"), mode, type);
    }

    public HvacDevcEditor(PyroMod pyMod, String desc, String defName, IDevcEditor.Mode mode, int type) {
        this.d_desc = desc;
        this.d_defName = defName;
        this.d_type = type;
        this.d_mode = mode;
        this.d_dataPanel = new HvacDevcDataPanel(pyMod);
    }

    @Override
    public HvacDevice create() {
        IQuantity meas = (IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem();
        if (this.d_type == 0) {
            return new DuctDevice("", meas);
        }
        if (this.d_type == 1) {
            return new NodeDevice("", meas);
        }
        return null;
    }

    @Override
    public void save(HvacDevice obj) {
        if (obj == null) {
            this.create();
        } else {
            this.d_dataPanel.save(obj);
        }
    }

    @Override
    public void load(HvacDevice obj) {
        this.d_dataPanel.load(obj);
    }

    @Override
    public String getDesc() {
        return this.d_desc;
    }

    @Override
    public String getDefName() {
        return this.d_defName;
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public IGeomEditor createGeomEditor() {
        return null;
    }

    @Override
    public boolean validateData(Component parent, HvacDevice loadedObj, boolean showWarn, boolean allowModify) {
        return this.d_dataPanel.validateData(false, false);
    }

    private class HvacDevcDataPanel
    extends guiPanel {
        private static final long serialVersionUID = 5620527752378853409L;
        QuantityComboBox d_measCombo;
        PyroMod d_pyMod;

        public HvacDevcDataPanel(PyroMod pyMod) {
            this.d_pyMod = pyMod;
            this.setLayout(new GridBagLayout());
            guiLabel quantity = new guiLabel(Intl.intl("Quantity: "));
            this.d_measCombo = new QuantityComboBox();
            this.updateDlg();
            GridBagUtil.add(this, quantity, 0, 1, 1, 1, 15, 0, 0, 0);
            GridBagUtil.add(this, this.d_measCombo, 1, 1, 1, 1, 11, 0, 0, 0);
        }

        private void updateDlg() {
            QuantityUtil.TypeFilter filter = null;
            filter = HvacDevcEditor.this.d_type == 0 ? new QuantityUtil.TypeFilter(0L, QuantityType.HVAC_DUCT) : new QuantityUtil.TypeFilter(0L, QuantityType.HVAC_NODE);
            this.d_measCombo.setFilter(filter);
        }

        public void load(HvacDevice obj) {
            if (obj instanceof DuctDevice && HvacDevcEditor.this.d_type != 0) {
                HvacDevcEditor.this.d_type = 0;
                this.updateDlg();
            }
            if (obj instanceof NodeDevice && HvacDevcEditor.this.d_type != 1) {
                HvacDevcEditor.this.d_type = 1;
                this.updateDlg();
            }
            if (obj != null && obj.getQuantity() != null) {
                this.d_measCombo.setSelectedItem(obj.getQuantity());
            }
        }

        public void save(HvacDevice obj) {
            IQuantity msr = (IQuantity)this.d_measCombo.getSelectedItem();
            obj.setQuantity(msr);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            return this.d_measCombo.getSelectedItem() != null;
        }
    }
}

