/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.gui.actions.ARunFDSValidation;
import pyrosim.gui.actions.AspiratorSamplerValidation;
import pyrosim.gui.actions.ExposedOverlapValidation;
import pyrosim.gui.actions.FlameConditionValidation;
import pyrosim.gui.actions.MPIProcessConflictValidation;
import pyrosim.gui.actions.VentCollapseValidation;
import pyrosim.io.fds.FDSRenderer;

public class FdsIoUtil {
    public static final int FDSFILE_INPUT = 0;
    public static final int FDSFILE_OUTPUT = 1;
    public static final int FDSFILE_SMOKEVIEW = 2;
    public static final int FDSFILE_HRR = 3;
    public static final int FDSFILE_DEVC = 4;
    public static final int FDSFILE_CTRL = 5;

    public static boolean validateModel(PyroSim app, PyroMod pyMod, FDSRenderer.RENDER_ORIGIN callFrom) {
        ArrayList<ARunFDSValidation> validationRules = new ArrayList<ARunFDSValidation>();
        validationRules.add(new ExposedOverlapValidation(app, pyMod));
        validationRules.add(new FlameConditionValidation(app, pyMod));
        validationRules.add(new VentCollapseValidation(app, pyMod));
        validationRules.add(new AspiratorSamplerValidation(app, pyMod));
        validationRules.add(new MPIProcessConflictValidation(app, pyMod, callFrom));
        for (ARunFDSValidation v : validationRules) {
            ARunFDSValidation.Prompt dlg;
            int userSelection;
            boolean ignoreWarning;
            Collection<IPyroObject> warnFor = v.validateModel();
            if (warnFor.isEmpty() || (ignoreWarning = v.getResponse(userSelection = (dlg = v.getPrompt(app.getMainFrame(), warnFor.size())).doModal(), warnFor).get().booleanValue())) continue;
            return false;
        }
        return true;
    }

    public static File getDefaultFDSInputFile(PyroMod pyMod, File psmFile) {
        String chid = FDSRenderer.generateChid(psmFile.getName(), FDSRenderer.getDefaultScenarioNameForChid(pyMod.getScenarios()));
        return FdsIoUtil.getDefaultFDSInputFile(psmFile, chid);
    }

    public static File getDefaultFDSInputFile(File psmFile, String chid) {
        return new File(new File(psmFile.getParentFile(), chid), chid + ".fds");
    }

    public static File[] getFDSFiles(File fdsFile) {
        return new File[]{fdsFile, new File(fdsFile.getParentFile(), fdsFile.getName() + ".out"), new File(fdsFile.getParentFile(), fdsFile.getName() + ".smv"), new File(fdsFile.getParentFile(), fdsFile.getName() + "_hrr.csv"), new File(fdsFile.getParentFile(), fdsFile.getName() + "_devc.csv"), new File(fdsFile.getParentFile(), fdsFile.getName() + "_ctrl.csv")};
    }
}

