/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import pyrosim.gui.CloudFDSDlg;

public class CloudFDSUtil {
    private static final CloseableHttpClient HTTP_CLIENT = HttpClients.createDefault();
    private static final Logger LOGGER = Logger.getLogger(CloudFDSUtil.class.getName());

    public static FDS_FEA_STATUS getStatusForErrorCode(int code) {
        for (FDS_FEA_STATUS status : FDS_FEA_STATUS.values()) {
            if (status.code != code) continue;
            return status;
        }
        assert (false);
        return null;
    }

    public static String getFolderName(File outfile) {
        return outfile.getName() + '_' + System.currentTimeMillis();
    }

    public static String getUploadLocation(File outfile, String CFDFEAFolder, CloudFDSDlg.CFD_FEA_Params params) {
        HttpPost getFolderPost = new HttpPost(params.uri + "/api/v1/storage/upload/url");
        getFolderPost.addHeader("Content-Type", "application/json");
        getFolderPost.addHeader("Accept", "application/json");
        getFolderPost.addHeader("api-key", params.apiKey);
        JSONObject data = new JSONObject();
        data.put("dirname", CFDFEAFolder);
        data.put("basename", outfile.getName());
        data.put("contentType", "application/octet-stream");
        JSONObject payload = new JSONObject();
        payload.put("data", data);
        try {
            StringEntity jsonEntity = new StringEntity(payload.toString());
            getFolderPost.setEntity(jsonEntity);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
        }
        String GCFolder = "";
        try {
            CloseableHttpResponse getFolderRes = HTTP_CLIENT.execute(getFolderPost);
            if (getFolderRes.getStatusLine().getStatusCode() != 200) {
                throw new HttpException(EntityUtils.toString(getFolderRes.getEntity()));
            }
            JSONParser parser = new JSONParser();
            JSONObject jsonRes = (JSONObject)parser.parse(EntityUtils.toString(getFolderRes.getEntity()));
            GCFolder = jsonRes.get("url").toString();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
        }
        return GCFolder;
    }

    public static void uploadFile(String gfcFolder, File outFile) {
        HttpPut uploadFilePut = new HttpPut(gfcFolder);
        uploadFilePut.addHeader("Content-Type", "application/octet-stream");
        uploadFilePut.setEntity(new FileEntity(outFile));
        try {
            CloseableHttpResponse uploadFileRes = HTTP_CLIENT.execute(uploadFilePut);
            if (uploadFileRes.getStatusLine().getStatusCode() != 200) {
                throw new HttpException(EntityUtils.toString(uploadFileRes.getEntity()));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
        }
    }

    public static void downloadFile(CloudFDSDlg.CFD_FEA_Params params, int id, String resultsFolder) {
        HttpGet downloadFileGet = new HttpGet(params.uri + "/api/v1/simulation/" + id + "/download/file");
        downloadFileGet.addHeader("Content-Type", "application/json");
        downloadFileGet.addHeader("Accept", "application/json");
        downloadFileGet.addHeader("api-key", params.apiKey);
        try {
            FileOutputStream fos;
            InputStream inputStream;
            CloseableHttpResponse downloadFileRes = HTTP_CLIENT.execute(downloadFileGet);
            if (downloadFileRes.getStatusLine().getStatusCode() != 200) {
                throw new HttpException(EntityUtils.toString(downloadFileRes.getEntity()));
            }
            HttpEntity entity = downloadFileRes.getEntity();
            if (entity != null) {
                int inByte;
                inputStream = entity.getContent();
                String filePath = resultsFolder + "\\FDS.tar.gz";
                fos = new FileOutputStream(new File(filePath));
                while ((inByte = inputStream.read()) != -1) {
                    fos.write(inByte);
                }
            } else {
                throw new HttpException("Unable to write Cloud Results archive");
            }
            inputStream.close();
            fos.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
        }
    }

    private static JSONObject getSimulationData(CloudFDSDlg.CFD_FEA_Params params, int id) throws IOException, HttpException, ParseException {
        HttpGet get = new HttpGet(params.uri + "/api/v1/simulation/" + id);
        get.addHeader("Accept", "application/json");
        get.addHeader("api-key", params.apiKey);
        CloseableHttpResponse getResponse = HTTP_CLIENT.execute(get);
        if (getResponse.getStatusLine().getStatusCode() != 200) {
            throw new HttpException(EntityUtils.toString(getResponse.getEntity()));
        }
        String responseString = EntityUtils.toString(getResponse.getEntity());
        JSONParser jsonParser = new JSONParser();
        return (JSONObject)jsonParser.parse(responseString);
    }

    public static String queryLogData(CloudFDSDlg.CFD_FEA_Params params, int id) {
        try {
            JSONObject json = CloudFDSUtil.getSimulationData(params, id);
            return (String)json.get("output");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
            return "";
        }
    }

    public static FDS_FEA_STATUS queryStatus(CloudFDSDlg.CFD_FEA_Params params, int id) {
        try {
            JSONObject json = CloudFDSUtil.getSimulationData(params, id);
            return CloudFDSUtil.getStatusForErrorCode(((Long)json.get("status")).intValue());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public static HttpResponse startSim(String CFDFEAFolder, CloudFDSDlg.CFD_FEA_Params params) throws IOException {
        HttpPost simPost = new HttpPost(params.uri + "/api/v1/simulation");
        simPost.addHeader("Content-Type", "application/json");
        simPost.addHeader("Accept", "application/json");
        simPost.addHeader("api-key", params.apiKey.trim());
        JSONObject data = new JSONObject();
        data.put("cpu", String.valueOf(params.numCores));
        data.put("ram", params.ramOpts.value);
        data.put("folder", CFDFEAFolder);
        data.put("script", params.version.value);
        data.put("source", "pyrosim_" + "2021.2.0525".replace(".", "-"));
        JSONObject payload = new JSONObject();
        payload.put("data", data);
        try {
            StringEntity jsonEntity = new StringEntity(payload.toJSONString());
            simPost.setEntity(jsonEntity);
            CloseableHttpResponse simResponse = HTTP_CLIENT.execute(simPost);
            return simResponse;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
            throw e;
        }
    }

    public static void stopSim(CloudFDSDlg.CFD_FEA_Params params, int id, boolean force) {
        HttpPut stopPut = new HttpPut(params.uri + "/api/v1/simulation/" + id + "/stop");
        stopPut.addHeader("Content-Type", "application/json");
        stopPut.addHeader("Accept", "application/json");
        stopPut.addHeader("api-key", params.apiKey);
        JSONObject data = new JSONObject();
        if (force) {
            data.put("signal", "SIGINT");
        } else {
            data.put("signal", "SIGTSTP");
        }
        JSONObject payload = new JSONObject();
        payload.put("data", data);
        try {
            StringEntity jsonEntity = new StringEntity(payload.toJSONString());
            stopPut.setEntity(jsonEntity);
            CloseableHttpResponse stopResponse = HTTP_CLIENT.execute(stopPut);
            if (stopResponse.getStatusLine().getStatusCode() != 200) {
                throw new HttpException(EntityUtils.toString(stopResponse.getEntity()));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
        }
    }

    public static enum FDS_FEA_STATUS {
        COMPLETED(10),
        ERROR(60),
        PENDING(20),
        RUNNING(30),
        STOPPING(40),
        STOPPED(50);

        public final int code;

        private FDS_FEA_STATUS(int code) {
            this.code = code;
        }
    }
}

